use ExtUtils::MakeMaker;

my %Store =
  (
   'Mysql' => 
   {
    param =>
    {
     'name' => 'Mysql',
     'DataSource' => 'dbi:Pg:dbname=mydb',
     'UserName'   => '?',
     'Password'   => '?',
    },
    'require'   => 
    [
     'DBD::mysql',
    ],
   },

   'Oracle' => 
   {
    param =>
    {
     'name' => 'Oracle',
     'DataSource' => '?',
     'UserName'   => '?',
     'Password'   => '?',
    },
    'require'   => 
    [
     'DBD::Oracle',
    ],
   },
   'Sybase' =>
   {
    param =>
    {
     name => 'Sybase',
     'DataSource' => '?',
     'UserName'   => '?',
     'Password'   => '?',
    },
    'require'   => 
    [
     'DBD::Sybase',
    ],
   },
   'Pg' => 
   {
    param =>
    {
     name => 'Postgres',
     'DataSource' => '?',
     'UserName'   => '?',
     'Password'   => '?',
    },
    'require'   => 
    [
     'DBD::Pg',
    ],
   },
  ) ;

## ----------------------------------------------------------------------------

sub GetString
  {
    my ($prompt, $default) = @_ ;

    printf ("%s [%s]", $prompt, $default) ;
    chop ($_ = <STDIN>) ;
    #$_ = prompt ($prompt, $default) ;
    if (!/^\s*$/) {
      return $_ ;
    } else {
      if ($_ eq "") {
	return $default ;
      } else {
	return "" ;
      }
	
    }
  }

## ----------------------------------------------------------------------------

sub GetYesNo
  {
    my ($prompt, $default) = @_ ;
    my ($value) ;

    do
      {
	$value = lc (GetString ($prompt . "(y/n)", ($default?"y":"n"))) ;
      }
	until (($value cmp "j") == 0 || ($value cmp "y") == 0 || ($value cmp "n" ) == 0) ;

    return ($value cmp "n") != 0 ;
  }


# --------------------------------------------------------------------------- 

print "\nChecking configuration...\n" ;

my @avail;
store:
foreach my $store (sort keys %Store) {
  my $data = $Store{$store} ;
	
  foreach my $require (@{$data -> {'require'}}) {
    eval "require $require" ;
    if ($@) {
      print "$data->{param}{name}\tis unavailable because $require is not installed on your system\n" ;
      next store ;
    }
  }

  push @avail, $store ;
}

print "\nThe following ways to build/test SQL::Catalog are available on your system:\n" ;

foreach my $store (@avail) {
  printf (" - %-20s (%s)\n", $store, $Store{$store}{param}{name});
}


eval { require 'lib/SQL/Catalog/Config.pm' ; } ;


if (keys %SQL::Catalog::Config::param) {
  %param = %SQL::Catalog::Config::param ;
  @conf  = @SQL::Catalog::Config::confs ;
  $input = GetYesNo ("Found previous configuration. Modify it", 0) ;
} else {
  %param = map { $_ => {} } @avail ;
  $input = 1 ;
}


if ($input) {
  @conf = () ;
  print "\n" ;
  print "You can now specify the configuration parameters for every storage.\n" ;
  print "SQL::Catalog uses this for testing your system and stores it for later\n" ;
  print "use in your application. You can override these default parameters anytime\n" ;
  print "at runtime. You can change them by rerunning Makefile.PL.\n" ;
  print "\nIf you don't plan to use different storages for session, \nonly say Yes to the one storage you want to use.\n" ;

  foreach $store (@avail) {
    print "\n" ;
    $data = $Store{$store} ;
    $info = $data -> {param}{Info} ;
    if (GetYesNo("Would you like to configure $data->{param}{name}", $param{$store}?1:0)) {
      push @conf, $store ;
      $param{$store} = { %{$data->{param}} } if (!keys %{$param{$store}}) ;
      while (($param, $value) = each (%{$data->{param}})) {
	if ($value eq '?') {
	  $value = GetString ($param, $param{$store}{$param} eq '?'?'':$param{$store}{$param}) ;
	  $param{$store}{$param} = $value ;
	}
      }
    }
  }

  print "\n" ;
  $i = 1 ;
  foreach $store (@conf) {
    $data = $Store{$store} ;
    $info = $data -> {param}{Info} ;
    print " $i: $info ($store)\n" ;
    $def = $i if ($SQL::Catalog::Config::default eq $store) ;
    $i++ ;
  }

  $i--  ;
  if (not $i) {
    die "no other configuration available. exiting";
  } elsif ($i == 1) {
    $default = 0 ;
  } else {
    $default = GetString ("Which of the above should be your default store (1-$i)", $def || '') ;
    $default-- ;
  }
}

print "Using $conf[$default] as default\n" ;

my $f = 'lib/SQL/Catalog/Config.pm';

open FH, ">$f" or die "Cannot open $f for writing ($!)" ;
print FH qq{
#
# SQL::Catalog configuration
#
# Autogenerated by Makefile.PL, do not edit!
#

    package SQL::Catalog::Config;

    \$default = '$conf[$default]' ;

    \@confs   = ('} ;

print FH join ("','", @conf) ;

print FH qq{') ; 
    \%param   =
	(
     } ;

foreach $store (@conf) {
  $p = $param{$store} ;
  print FH "    '$store' => \n" ;
  print FH "        {\n" ;
  while (($param, $value) = each (%$p)) {
    print FH "         '$param' => '$value',\n" ;
  }
  print FH "        },\n" ;
}

print FH qq{
	) ;

    \$defaultparam = \$param{'$conf[$default]'} ;

    1 ;

} ;

close FH ;

# --------------------------------------------------------------------------- 

WriteMakefile(
	      'NAME'		=> 'SQL::Catalog',
	      'VERSION_FROM'	=> 'lib/SQL/Catalog.pm', # finds $VERSION
	      'PREREQ_PM'		=> {
					    SQL::Statement => 0.1,
					    DBIx::AnyDBD => 1.94,
					    DBI => 1.19,
					    Cache::Cache => 0.99
					   }, # e.g., Module::Name => 1.1
	     );
