package Number::ZipCode::JP::Table::Company;

use strict;
use warnings;

our $VERSION = '0.20110930';

# Table last modified: 2011-09-30
our %ZIP_TABLE = (
    '001' => '(?:8(?:5(?:[02]1|88)|612))',
    '002' => '(?:850[1-4])',
    '003' => '(?:8(?:5(?:58|8[0-258]|0[1-5]|3[01]|1[0159]|7[07]|6[67])|6(?:01|40|68|3[019]|1[02])|70[125]))',
    '004' => '(?:8(?:5(?:77|2[23]|8[58]|5[058]|3[013]|1[0258]|6[07]|0[235])|6(?:[34]1|29|0[23]|1[0-368])))',
    '005' => '(?:8(?:5(?:[58]5|01|43)|6(?:12|0[12])|798))',
    '006' => '(?:8(?:5(?:[23]0|[58]5|61)|612))',
    '007' => '(?:8(?:50[13578]|632))',
    '010' => '(?:(?:8(?:5(?:43|6[04]|3[03]|2[025]|8[058]|0[12457]|1[58]|5[08]|7[0247])|6(?:[01]1|22|33|55|68|7[78])|794)|0(?:49[2-4]|[15]95)|1(?:49[2-4]|292)))',
    '011' => '(?:8(?:5(?:[58]5|01|20|77|1[01])|6(?:05|11|86)))',
    '012' => '(?:8(?:5(?:11|0[12])|6(?:51|0[14])))',
    '013' => '(?:(?:8(?:5(?:92|0[1-4])|6(?:10|0[129]))|0498))',
    '014' => '(?:(?:0(?:39[2-4]|[25]92)|1(?:192|298)|86[01]1))',
    '015' => '(?:(?:8(?:5(?:30|43|67|85|1[015]|5[58]|0[15])|6(?:[24]2|11|30|66|0[12]|8[68]))|0295))',
    '016' => '(?:8(?:5(?:01|55)|60[12]))',
    '017' => '(?:(?:8(?:5(?:10|67|85|5[05])|686)|029[23]))',
    '018' => '(?:(?:1(?:39[23]|59[56]|79[23]|692)|3(?:59[2356]|39[23]|192)|4(?:39[2-5]|69[23]|494)|0(?:49[23]|[16]92|795)|5(?:79[23]|292)|2498))',
    '019' => '(?:(?:1(?:397|692)|079[23]|2[16]92))',
    '020' => '(?:(?:8(?:5(?:3[0-3]|8[04-68]|0[12578]|1[0-358]|2[0-25]|6[0167]|7[0357]|4[034]|5[013578])|6(?:33|41|5[045]|7[278]|2[02]|6[167]|1[0-2]|8[68]|0[1256])|794)|0(?:1(?:9[23568]|8[0-578])|59[2356]|49[356])))',
    '021' => '(?:8(?:5(?:11|44|55|77|0[1-46]|6[67])|6(?:04|11|33|87)))',
    '022' => '(?:8(?:5(?:12|0[1-578])|602))',
    '023' => '(?:(?:049[23]|850[12]|1192))',
    '024' => '(?:(?:8(?:5(?:20|0[157]|1[0138])|650)|0(?:19[2-5]|392)))',
    '025' => '(?:(?:039[2-5]|860[12]))',
    '026' => '(?:8(?:5(?:50|67)|686))',
    '027' => '(?:(?:850[1-3]|0595))',
    '028' => '(?:(?:8(?:0(?:4[02]|3[01])|392|696)|7(?:39[2-6]|[15]92|995)|4(?:39[358]|19[35])|(?:0[135]|1[13])92|6(?:19[23568]|892)|3(?:69[247]|392)|5495))',
    '029' => '(?:(?:4(?:19[245]|29[23]|59[23])|2(?:29[23]|396)|(?:01|56)92))',
    '030' => '(?:(?:8(?:5(?:3[03]|7[047]|[14][0135]|0[35]|6[067]|2[0-4]|8[05]|5[02-68])|6(?:04|22|33|49|55|77|86|6[78]|1[01]))|01(?:9[26]|8[013-68])|1(?:49[26]|393|798)))',
    '031' => '(?:8(?:5(?:20|4[3-5]|3[38]|5[0158]|7[07]|8[58]|0[1457]|1[01])|6(?:55|86|1[127]|0[18])))',
    '033' => '(?:86(?:04|66|88))',
    '034' => '(?:(?:8(?:6(?:05|28|1[358])|5(?:65|78))|039[238]))',
    '035' => '(?:8686)',
    '036' => '(?:(?:8(?:5(?:11|22|45|77|0[1-3]|6[0-47]|5[0158]|8[58]|3[038])|6(?:01|42|55|66|8[689])|788)|1(?:59[23]|393|492)|039[26]))',
    '037' => '(?:(?:86(?:55|86)|0392))',
    '038' => '(?:(?:3(?:19[2-6]|39[2-4]|[68]92|595)|85(?:[08]5|60|5[05])|0(?:19[24]|292)|2(?:79[23]|892)|1392))',
    '039' => '(?:(?:2(?:2(?:9[23]|8[0-35-79])|59[2-578]|39[23]|49[23]|79[23]|192|696)|0(?:19[58]|[28]92|595)|11(?:8[015]|9[237])|4(?:29[23]|495|692)|3393))',
    '040' => '(?:8(?:5(?:77|3[03]|4[13]|5[0-258]|2[02]|8[0158]|0[12]|6[0167]|1[0-2])|6(?:55|4[02]|7[07]|[68][068]|3[12]|0[1-359]|1[016])|7(?:[12][07])))',
    '041' => '(?:(?:8(?:5(?:01|33|40|77|2[23]|8[89]|1[0-25]|6[07]|5[1-8])|6(?:[23]3|48|55|80|1[01])|711)|1(?:19[2-6]|49[6-8]|[36]92)))',
    '042' => '(?:8(?:5(?:[01]1|67|8[58]|5[05])|6(?:39|42|78)))',
    '043' => '(?:(?:8(?:5(?:58|60)|6(?:09|51))|0[45]95|1498))',
    '044' => '(?:(?:85(?:44|88)|029[256]))',
    '045' => '(?:8(?:555|609))',
    '046' => '(?:(?:0(?:59[2-4]|19[24]|292)|8(?:5(?:46|55)|686)))',
    '047' => '(?:(?:8(?:5(?:19|20|85|0[1-3]|6[07]|5[58])|6(?:11|77|86|0[19]|6[036])|794)|0(?:29[28]|192)))',
    '048' => '(?:(?:1(?:39[2-6]|59[25])|2(?:49[23]|292)|0192))',
    '049' => '(?:(?:0(?:69[23578]|19[23])|4(?:39[37]|59[25])|1(?:59[2-4]|392)|2(?:39[2-4]|192)|3(?:19[278]|592)|5[468]92))',
    '050' => '(?:85(?:70|1[018]|5[05]|8[258]))',
    '051' => '(?:8(?:5(?:24|30|46|5[058]|8[58]|1[12]|0[15])|6[56]0))',
    '052' => '(?:8(?:5(?:11|50|8[56])|6(?:[68]6|50)))',
    '053' => '(?:8(?:5(?:22|33|55|70|8[58]|1[12]|4[01]|0[56])|6(?:09|48|66|1[19]|5[34])|7(?:11|22)))',
    '054' => '(?:8660)',
    '055' => '(?:019[235])',
    '056' => '(?:8650)',
    '057' => '(?:85(?:11|58))',
    '058' => '(?:(?:0292|8501))',
    '059' => '(?:(?:1(?:39[2-6]|59[2-6]|69[23]|292)|0(?:59[2568]|99[3578]|49[236])|2(?:[14]92|598)|8[67]01|3195))',
    '060' => '(?:8(?:5(?:7[02-46-9]|[458]\d|[12][0-79]|0[1-35689]|3[0-36-9]|6[013568])|6(?:[12]\d|5[14-68]|7[016-8]|6[16-8]|0[1-57-9]|4[0-46-9]|3[013-9])|7(?:11|67|2[015]|9[25-7]|0[35-7])))',
    '061' => '(?:(?:1(?:49[236-8]|19[2356]|39[2356])|0(?:29[2356]|59[25]|692)|3(?:29[2-6]|197|692)|2292))',
    '062' => '(?:8(?:6(?:55|86|0[1-357-9]|3[0135]|2[24]|4[12]|1[0278]|6[68])|5(?:01|20|7[025]|1[013467]|5[58]|3[029])))',
    '063' => '(?:8(?:5(?:58|0[17]|[18][05])|6(?:41|0[1-36-8]|1[12])))',
    '064' => '(?:8(?:5(?:1[0-2569]|6[0-7]|2[0-68]|7[0157]|5[0-24-8]|3[0235-7]|0[1-3569]|8[14-79]|4[0-6])|6(?:68|86|2[0-2489]|0[159]|1[01]|4[124589]|3[039])|798))',
    '065' => '(?:8(?:5(?:[34]3|22|67|78|1[018]|5[058]|0[18])|6(?:86|3[39]|0[19]|1[0-2])))',
    '066' => '(?:8(?:5(?:20|33|1[025]|7[07]|6[67]|8[58]|5[0578]|0[1248])|6(?:01|22|49|55|86|3[379]|6[068]|1[01])|7(?:11|65|87)))',
    '067' => '(?:8(?:5(?:[05]1|47|85|6[45])|674))',
    '068' => '(?:(?:8(?:6(?:[03]9|42|50|6[06]|8[68])|5(?:88|5[058]))|1(?:19[2-5]|292)|0(?:194|492)|219[2-4]))',
    '069' => '(?:(?:1(?:29[235-8]|39[2-5])|85(?:[01]1|[58]5|33)|029[23]))',
    '070' => '(?:8(?:6(?:[02]1|6[06]|1[0-26]|5[0135]|8[068]|3[069]|4[0-24]|7[06-8])|5(?:[35]0|1[015]|0[2357]|6[07]|2[05]|4[01])|7(?:01|2[02]|1[01])))',
    '071' => '(?:(?:0(?:19[28]|29[28]|59[67]|79[58])|1(?:49[2-7]|29[2358]|59[236])))',
    '072' => '(?:8660)',
    '073' => '(?:(?:8(?:5(?:85|0[12]|1[01])|68[68])|0(?:19[256]|[24]92)))',
    '074' => '(?:(?:8(?:6(?:50|86)|585)|049[2-5]))',
    '075' => '(?:8(?:50|71)1)',
    '076' => '(?:8(?:5(?:11|55)|6(?:09|66)|765))',
    '077' => '(?:(?:8(?:5(?:[01]1|85)|6(?:01|60|86))|029[235-7]))',
    '078' => '(?:(?:1(?:79[235-7]|49[235]|39[35])|85(?:55|0[1-6]|1[013])|4(?:19[3468]|492)|3(?:39[2-4]|792)|2(?:19[23]|692)|039[27]))',
    '079' => '(?:(?:8(?:5(?:1[0134689]|0[1-357-9]|8[58]|5[05])|6(?:1[0-3]|5[0-356]))|0(?:39[2-47]|19[278]|59[235])|1(?:39[367]|192)))',
    '080' => '(?:(?:8(?:5(?:[67]0|0[1-3]|1[018]|8[58]|5[05]|3[18])|6(?:23|39|42|55|6[06]|0[19]|7[07]|8[068])|7(?:[01][18]))|249[235-8]|019[6-8]|149[23]))',
    '081' => '(?:(?:029[2-5]|8501))',
    '082' => '(?:865[01])',
    '083' => '(?:8(?:585|650))',
    '084' => '(?:8(?:5(?:[01]1|55|67)|6(?:01|70|86)))',
    '085' => '(?:(?:8(?:5(?:1[025]|3[35]|2[27]|5[01578]|8[01568]|0[125])|6(?:[34]9|77|5[05]|6[08]))|029[23]))',
    '086' => '(?:1(?:89[23]|197))',
    '087' => '(?:(?:8(?:5(?:55|88)|6(?:09|86)|711)|0192))',
    '088' => '(?:(?:0(?:39[2-5]|59[258]|19[23]|692)|1(?:19[2-6]|592)|3(?:292|395)|259[23]))',
    '089' => '(?:(?:1(?:19[28]|39[25]|59[25]|795)|0(?:19[258]|59[258]|69[23])|2(?:69[235-7]|195|492)|5(?:39[23]|69[25])|3(?:392|797)))',
    '090' => '(?:8(?:5(?:40|3[23]|[58][058]|6[07]|1[189]|0[1-379])|6(?:[18]0|42|66|5[025])|7(?:2[239]|1[01])))',
    '091' => '(?:(?:019[2-4]|8666))',
    '092' => '(?:(?:8(?:65[01]|501)|0292))',
    '093' => '(?:(?:8(?:6(?:[01]9|[57]0|8[06])|5(?:[58]5|44)|7(?:28|1[01]))|0(?:59[2-4]|292)))',
    '094' => '(?:8(?:7(?:0[1-9]|1[02-7])|6(?:4[1-6]|0[1-59])|5(?:81|5[1-4])))',
    '095' => '(?:(?:86(?:09|86)|0492))',
    '096' => '(?:8(?:5(?:11|8[45]|5[58]|0[18])|6(?:[68]6|09|41)))',
    '097' => '(?:8(?:5(?:10|85|5[58]|2[57])|6(?:[03]9|[68]6)))',
    '098' => '(?:(?:5(?:[78]92|298|595)|(?:28|62|0[13])92|1(?:69[23]|792)|339[23568]))',
    '099' => '(?:(?:2(?:19[2-8]|49[235]|392)|1(?:49[2568]|19[78]|595)|3(?:29[23]|69[78])|4(?:19[256]|492)|(?:56|65)92|049[245]))',
    '100' => '(?:(?:8(?:9(?:4[015]|8[0-35-79]|6[0-25-9]|7[0-2457-9]|2[0-24-79]|9[46]|3[0137]|1[02-9]|0[1-579]|5[0-3569])|1(?:3[01589]|6\d|0[2358]|4[0149]|5[016-8]|8[0-26-9]|7[1-37]|1[01357-9]|2[0-3568])|6(?:55|86|2[019]|1[057]|3[0-29]|7[067]|6[3568]|0[268]|4[049])|3(?:66|70|5[015]|0[2378]|4[158]|2[1245]|3[138]|1[01]|8[038])|2(?:46|70|6[02578]|2[78]|8[2358]|0[13]|1[014-69]|3[2-4])|5(?:11|4[03]|5[058]|2[02]|6[07]|8[58]|7[57]|0[35-7])|4(?:02|56|1[015]|2[0147]|3[09]|4[048]|8[48])|0(?:19|66|7[07-9]|8[68]|5[01])|79[158])|6(?:1(?:62|7[0-578]|5[0-2])|2(?:55|77|6[02])|0(?:66|80)|75[1-6])|149[28]|3131))',
    '101' => '(?:8(?:3(?:3[135]|0[1257-9]|8[01358]|6[02356]|7[0158]|5[0-689]|2[1-8]|1[013-7]|4[56])|5(?:6[0-2568]|5[289]|4[2-5]|8[1568]|7[6-9]|0[1-46-9]|3[0-5]|1[0-24-69]|2[0-3568])|4(?:7[05-7]|8[13]|0[57-9]|3[0379]|4[13-9]|6[04-9]|5[0-46-9]|2[125]|1[0-25689])|6(?:8[28]|0[5-79]|6[2578]|3[0346-8]|5[14-6]|4[1-3568]|1[0-479]|7[026]|2[0-24-9])|9(?:[019]1|35|50|7[0-37]|4[16]|8[036])|7(?:0[137]|1[0-25-8])|0(?:11|50|77|0[12])|20[1-4]|101))',
    '102' => '(?:8(?:4(?:5[0-2569]|8[13489]|6[0-24-68]|4[057]|2[014679]|0[125-7]|1[014579]|7[0478]|3[0-3578])|1(?:1[0-278]|5[0-25]|3[0-289]|7[0-25-8]|8[0-24-8]|2[02358]|0[1-359]|4[0-24]|6[016])|6(?:3[0-3579]|4[245]|2[016-8]|8[0589]|7[17-9]|0[1-479]|1[0-47-9]|5[016]|6[06-8])|5(?:5[024-9]|2[0289]|6[079]|3[0139]|4[013]|8[0458]|1[01568]|7[013578]|0[2-68])|3(?:4[19]|1[0134]|3[1-356]|8[1-38]|7[0237]|5[035-7]|6[248]|0[1-359]|2[0-24])|2(?:88|5[015]|1[158]|7[257]|2[2568]|3[0-2468]|0[15]|6[0245]|4[016])|0(?:08|77|8[0-35]|1[125689])|79[58]))',
    '103' => '(?:8(?:2(?:0[1-6]|1[0-2478]|3[0-35-9]|6[0135]|4[0-35-8]|7[02358]|8[457]|2[124589]|5[0-25689])|4(?:7[0-3]|2[2-7]|0[1-57]|6[0-256]|3[0-57-9]|1[0-79]|8[01467]|5[016]|4[3489])|5(?:0[1-367]|4[2358]|8[4-689]|[12][0-25]|5[24-68]|3[013-8]|6[067]|7[0157])|3(?:7[03]|5[0-2458]|0[136-8]|8[0348]|2[01348]|4[15-7]|1[0137]|6[036]|3[01357-9])|6(?:7[05-7]|6[0568]|3[0-269]|8[0469]|5[0-36]|4[014])|0[01]1))',
    '104' => '(?:(?:8(?:1(?:2[2-589]|3[0-58]|0[124-689]|5[158]|8[0139]|1[124-8]|4[25]|6[1-8]|7[0-25-8])|4(?:1[01589]|2[0-2459]|4[03-578]|8[168]|0[1-8]|[67][068]|5[0156]|3[013-68])|5(?:1[028]|4[0468]|3[03589]|5[0134689]|7[02]|2[0138]|6[036-8]|0[1256]|8[014578])|3(?:6[015]|4[04]|1[0-3579]|2[01458]|5[167]|7[27]|3[02358]|8[038]|0[2-59])|2(?:4[03]|1[0-258]|3[38]|2[28]|0[568]|5[0-35-7]|7[07]|6[026]|8[0-24589])|6(?:50|6[0158]|8[05]|7[08])|0(?:55|77|1[01]|0[1347]))|6241))',
    '105' => '(?:(?:8(?:4(?:3[24-79]|0[124578]|8[02-8]|1[0-24-689]|5[0-35-8]|2[0247-9]|7[0-39]|4[014-9]|6[01457])|5(?:2[0-357-9]|1[0-2578]|8[0-2457-9]|5[02-8]|0[579]|7[4-9]|4[35689]|6[0378]|3[0457])|6(?:54|6[0568]|1[01348]|4[02]|7[078]|3[014]|8[05-9]|2[1346]|0[3468])|0(?:55|0[12578]|7[07]|8[58]|1[0-2])|3(?:01|22|33|1[0-3])|7(?:0[127]|1[1267]))|7444))',
    '106' => '(?:(?:8(?:5(?:08|4[134]|6[0-35-79]|7[136-8]|3[25]|1[458]|2[12]|5[0-35689]|8[0157-9])|6(?:77|6[158]|5[25]|1[168]|0[18]|2[0256]|8[15]|3[069]|4[0-24589])|0(?:[01]1|39)|7(?:11|97)|401)|6(?:1(?:61|88)|06[06])))',
    '107' => '(?:8(?:5(?:8[13589]|2[0-24578]|5[0-26-8]|4[356]|3[023]|0[258]|7[0579]|6[0357]|1[15])|6(?:42|8[06]|6[78]|2[023578]|1[15-79]|0[14]|7[46]|3[0-3689]|5[05])|4(?:20|34|56|77|0[134]|8[24]|6[067]|1[04679]|4[08])|3(?:55|4[028]|7[013]|3[1568]|2[0346]|8[08])|0(?:06|77)))',
    '108' => '(?:(?:8(?:5(?:7[01358]|3[02369]|6[124-8]|4[03-578]|5[0-35-9]|0[1-3569]|2[035]|1[0258]|8[013568])|3(?:3[13489]|1[137]|6[0168]|0[357]|7[0-37-9]|5[0158]|8[134689]|4[15]|2[0-35689])|4(?:0[347]|8[45]|6[67]|5[16]|7[478]|2[013-5]|3[029]|1[0-24-7]|4[48])|2(?:7[05-8]|4[128]|8[02]|0[1-38]|3[0-4]|5[05]|1[01]|2[0-28])|6(?:50|1[0-2568]|4[0-2468]|0[126-8]|3[235-8]|2[0-28])|0(?:[25]0|11|8[08]|7[01]|0[15])|7(?:23|1[03]|0[1-37])|117)|63(?:50|63)))',
    '109' => '(?:8792)',
    '110' => '(?:8(?:5(?:6[0-25-7]|5[03589]|4[0134689]|0[1-357-9]|7[35-9]|3[0-79]|1[0-3578]|2[0-478]|8[02-468])|6(?:97|0[2359]|2[0-24-68]|6[0-259]|5[34]|4[245]|1[03-57-9]|3[058]|7[135-8]|8[015-8])|7(?:8[027]|5[057]|1[2-6]|0[168]|4[05]|3[36]|2[1-35])|80[78]|408))',
    '111' => '(?:8(?:6(?:3[01379]|5[056]|[12][0-258]|7[6-8]|8[1368]|4[02]|0[2568]|6[16])|5(?:43|1[0-258]|8[058]|5[568]|3[0-49]|7[57]|6[0167]|2[125]|0[125-8])|7(?:[56]5|[89]8|21|0[178]|1[01])|081))',
    '112' => '(?:8(?:6(?:90|0[167]|2[02579]|4[24]|7[0178]|8[0-57]|3[02-5]|1[0-28]|6[02-478]|5[0-2457])|5(?:8[025]|4[018]|6[02369]|3[138]|2[248]|0[1-35689]|5[015-8]|1[0-24-6]|7[02-6])|7(?:10|33|0[12])|0(?:[01]1|88)))',
    '113' => '(?:8(?:4(?:8[348]|4[148]|7[1479]|2[0-3]|1[0-358]|6[2-6]|3[13-5]|5[0169]|0[1248])|5(?:70|86|0[13-579]|6[0-46]|4[1369]|2[014-6]|3[04-6]|1[039]|5[1356])|6(?:6[0-3]|3[38]|5[04-8]|8[167]|1[0-2]|0[1-48])|7(?:01|1[129])|311))',
    '114' => '(?:8(?:5(?:95|0[1-35-8]|8[013-58]|6[0-25]|4[013-5]|1[02-57-9]|7[147]|2[0-2468]|5[02-57]|3[0-24589])|6(?:11|86|0[2-6])))',
    '115' => '(?:8(?:5(?:[06]7|55|8[568]|1[01]|2[49])|(?:60|71)1))',
    '116' => '(?:8(?:5(?:71|6[127]|2[1-4]|5[0-26]|8[014-8]|4[013689]|0[1-3578]|3[237])|611))',
    '120' => '(?:8(?:5(?:44|81|7[057]|0[178]|1[02]|2[068]|3[0469]|5[03568])|60[12]))',
    '121' => '(?:8(?:5(?:33|40|0[245]|2[0-4]|8[58]|5[05]|1[01])|6(?:[02]1|3[39]|8[0-2]|1[016])|7(?:01|29|1[01])|080))',
    '123' => '(?:85(?:40|8[58]|1[147]|0[135689]))',
    '124' => '(?:8(?:5(?:77|6[06]|1[018]|3[3589]|0[1-39]|8[58]|5[05]|2[024])|070))',
    '125' => '(?:8(?:5(?:55|88|1[1-57]|0[3-8]|2[026])|60[12]))',
    '130' => '(?:8(?:5(?:6[5-7]|8[03-58]|7[057]|3[013-589]|4[358]|5[4-8]|0[13-9]|1[0-8]|2[0258])|6(?:25|86|0[1-589]|7[17]|4[02]|3[67]|5[05]|6[068]|1[15])|7(?:[12]0|0[16])))',
    '131' => '(?:8(?:5(?:40|65|1[0-389]|3[03]|2[0467]|8[458]|5[05]|0[13-9])|711))',
    '132' => '(?:8(?:5(?:33|85|5[015]|0[137]|6[27])|6(?:01|74|[68][68])|7(?:3[029]|1[15])))',
    '133' => '(?:8(?:5(?:[01]1|8[05]|5[238])|70[46]))',
    '134' => '(?:8(?:6(?:22|78|86|[14][02]|0[1-39]|3[01])|5(?:[15]5|20|33|7[05-7]|8[568]|0[237])|702))',
    '135' => '(?:8(?:5(?:3[0-35]|5\d|7[03-57-9]|8[125-7]|6[035-7]|0[1458]|4[08]|2[1-358]|1[0-478])|4(?:22|4[0358]|0[24]|7[0137]|5[18]|8[0-2]|6[014]|1[15]|3[026])|6(?:02|41|86|2[0-25]|6[168]|3[0-29]|7[0178]|5[059]|1[146-9])|3(?:50|8[3-578]|7[025]|0[13]|2[02]|6[0236]|3[01]|1[0-28])|7(?:3[0-38]|2[0-3]|0[17]|1[0178])|11[0-4]))',
    '136' => '(?:8(?:5(?:4[03]|1[2357]|3[13]|7[057]|5[058]|6[07]|8[0189]|0[1257]|2[1-35])|6(?:[68]6|3[057]|0[357]|7[0157]|2[0267]|4[08]|1[125])|7(?:[23]3|11)|405|880|908))',
    '137' => '(?:8(?:6(?:23|50|86)|08[18]|581))',
    '140' => '(?:8(?:5(?:[89]0|7[1-36]|4[0-37-9]|2[01359]|3[013689]|6[0367]|0[125-8]|5[0-28]|1[1256])|6(?:4[04]|0[17]|6[0168]|1[13-79]|7[0578]|2[13568]|8[078]|3[01479]|5[03568])|7(?:88|1[015-7]|2[12]|0[279])))',
    '141' => '(?:8(?:6(?:3[0137-9]|2[01389]|4[0-36-8]|0[2-6]|7[0-36]|1[01568]|8[0136-8]|5[035-8]|6[024-68])|5(?:2[0-2569]|0[13-578]|4[045]|1[024579]|3[03-5]|5[05-79]|6[015-8]|7[1256]|8[02-68])|4(?:2[0-3]|1[1-9])|7(?:0[127]|1[05])|001))',
    '142' => '(?:8(?:5(?:[01]1|22|33|40|67|5[058]|8[58])|6(?:11|39|66)))',
    '143' => '(?:(?:85(?:28|70|3[13589]|8[05]|6[04578]|0[4-8]|4[014]|5[0258]|1[145])|6501))',
    '144' => '(?:8(?:5(?:25|44|5[015]|3[0-356]|7[057]|1[01356]|8[08]|0[56])|6(?:02|35|2[1-3]|5[056]|7[78]|1[014]|6[01])))',
    '145' => '(?:85(?:[23]3|01|58|66|1[15]))',
    '146' => '(?:8(?:5(?:[03]1|22|67|8[058]|7[67]|1[0-2]|5[15]|4[034])|6(?:[03]1|10|2[03]|5[056]|7[78]|6[68])))',
    '150' => '(?:8(?:5(?:45|3[03]|0[23578]|8[5-7]|2[25]|1[124-7]|6[379]|5[05]|7[57])|3(?:19|4[03]|7[37]|8[45]|2[24-8]|0[1367]|5[05]|6[036]|3[038])|4(?:12|36|0[289]|8[28]|5[15]|4[08])|9(?:02|11|40|55|2[35]|3[258])|0(?:[08]1|1[059])|6(?:88|7[237])))',
    '151' => '(?:8(?:5(?:3\d|8[3-7]|2[1-589]|1[016-9]|6[1-35-9]|4[0-57-9]|5[24589]|7[0-46-8]|9[01]|0[2-579])|6(?:00|7[1-7])|40[14]))',
    '152' => '(?:8(?:5(?:61|4[149]|2[0-257]|0[36-8]|7[08]|1[01]|5[0-28]|3[1-35])|9(?:1[03]|0[24579])|6[02]1))',
    '153' => '(?:8(?:5(?:6[05-7]|2[0-356]|5[0-68]|4[0135]|8[0-25-79]|3[0169]|7[01378]|1[02568]|0[1-689])|6(?:01|20|8[78]|4[01458]|7[07]|6[025689]|5[02-57]|3[013568])|9(?:1[134]|0[246]|2[2357]|3[034679])))',
    '154' => '(?:8(?:5(?:8[0-245]|0[3-6]|4[3-5]|2[0135]|3[0-369]|6[5-8]|5[1-5]|1[0156]|7[017])|7(?:03|32)))',
    '155' => '(?:86(?:10|26|33|55|6[38]))',
    '156' => '(?:8(?:5(?:22|33|55|8[578]|0[126]|1[01])|6(?:66|78)))',
    '157' => '(?:85(?:01|43|50|6[1-35-7]|3[05]|2[0-2]|1[01]|7[035]))',
    '158' => '(?:8(?:5(?:0[12589]|5[0-2578]|3[013]|1[0-48]|6[67]|4[349]|2[0235]|7[578]|8[03568])|6(?:28|40|66|1[015]|3[0-3]|0[12])|7[07]1))',
    '160' => '(?:8(?:3(?:8[39]|4[13]|0[14689]|1[169]|6[1689]|5[1578]|2[1457]|3[013-68]|7[457])|5(?:30|1[0-259]|4[379]|8[0-35-9]|2[0-249]|6[05]|5[57]|7[157]|0[15])|4(?:44|[15][015]|3[13]|7[27]|2[0-39]|0[1-378]|8[457-9])|(?:68|91)0|0(?:01|70)))',
    '161' => '(?:8(?:5(?:08|3[19]|6[057]|5[1-46-8]|2[0158]|7[05]|4[0156]|1[01])|710))',
    '162' => '(?:8(?:6(?:80|3[0368]|5[045]|1[124-6]|6[689]|7[026]|4[046]|0[1248]|2[0246-9])|5(?:8[057]|1[25]|4[013]|7[57]|2[279]|5[16-8]|3[035]|6[0258]|0[1-35])|4(?:33|64|5[015]|0[1257-9]|7[1368]|8[048]|2[12]|4[05689]|1[125])|8(?:30|53|0[1-7]|6[01])|7(?:1[016-8]|0[1578])|0(?:01|22|55)|953))',
    '163' => '(?:(?:0(?:6(?:88|7[5-7]|5[59]|6[3579])|5(?:5[37-9]|6[069]|7[56])|4(?:56|6[067]|7[08])|7(?:77|2[79]|3[013])|8(?:50|67|3[136])|9(?:43|3[589])|2(?:78|6[89]))|1(?:3(?:50|6[38]|8[28]|7[18]|4[589])|4(?:55|70|6[29]|8[08])|0(?:71|5[35]|6[56])|5(?:55|88|3[37]))|8(?:6(?:[18]0|02|26|54|7[127]|3[89]|6[0136])|0(?:0[13]|8[0-2]|1[29])|5(?:35|48)|339)))',
    '164' => '(?:8(?:5(?:[12]2|[67]7|41|8[58]|5[05]|0[13-5])|6(?:[25]0|[37]8|66|8[26]|1[17]|4[24])|7(?:01|25)))',
    '165' => '(?:8(?:555|780))',
    '166' => '(?:8(?:5(?:20|55|3[13589]|6[5-7]|4[025]|0[1-36]|8[58]|7[078])|6(?:01|10)))',
    '167' => '(?:8(?:5(?:[24]0|85|7[78]|3[34]|6[07]|0[167]|1[05]|5[15])|6(?:10|28|0[12])|0(?:01|70)))',
    '168' => '(?:8(?:5(?:[67]0|85|3[03]|5[058]|0[1-468]|2[05]|1[0-2])|6(?:01|26|[18][16])|081))',
    '169' => '(?:8(?:5(?:6[018]|2[0-25-7]|8[0568]|4[013]|7[07]|3[0135]|0[37-9]|1[015-7]|5[01568])|6(?:2[04]|5[056]|7[78]|0[1358]|1[0-36]|6[1468]|4[0458]|3[179])|0(?:50|77|1[12])|7(?:[01]1|22)|915))',
    '170' => '(?:(?:8(?:4(?:1[015-79]|4[0-2478]|0[124-69]|7[067]|5[015-9]|6[0156]|2[0-467]|8[08]|3[02-468])|6(?:[68]6|12|53|0[25]|3[35])|5(?:51|85)|073)|6080))',
    '171' => '(?:85(?:8[26]|5[02578]|7[027]|4[045]|3[159]|2[0-35-8]|1[0-2468]|6[0189]|0[1-37-9]))',
    '173' => '(?:8(?:5(?:[06]1|30|4[03]|1[0-25-9]|8[058]|5[258])|6(?:48|66|3[29]|1[01]|0[1256])|710))',
    '174' => '(?:8(?:5(?:30|88|5[058]|6[07]|2[0146]|0[15])|6(?:01|12|46|3[369]|8[068])|7(?:[01]1|3[079]|4[0134])|860|903))',
    '175' => '(?:85(?:88|7[17]))',
    '176' => '(?:85(?:[46]0|85|1[0-2568]|2[1258]|3[013-6]|0[1-378]))',
    '177' => '(?:85(?:[12]1|0[1-357-9]))',
    '178' => '(?:8(?:5(?:11|55|67|0[12])|6(?:[68]6|01|24)))',
    '179' => '(?:8(?:9(?:0[134679]|1[014])|501))',
    '180' => '(?:8(?:5(?:80|1[79]|7[17]|6[67]|3[138]|2[27]|5[05]|0[58])|6(?:29|60|3[03]|1[018]|0[28])|7(?:50|77)))',
    '181' => '(?:8(?:5(?:41|3[135]|7[17]|0[35]|8[5-8]|1[01578]|5[15]|2[0-28])|6(?:22|33|48|1[14]|0[18])|001))',
    '182' => '(?:8(?:5(?:08|67|70|85|2[025]|5[58]|1[0-2])|6(?:21|86|0[12])|001))',
    '183' => '(?:8(?:5(?:61|2[124-689]|1[1-46]|5[013]|3[0249]|0[12568]|4[0189])|70[1-35-7]))',
    '184' => '(?:8(?:5(?:[34]3|22|67|95|8[158]|5[58]|7[57]|0[1-58]|1[01])|795))',
    '185' => '(?:8(?:5(?:33|40|6[27]|0[126]|1[01])|601|795))',
    '186' => '(?:8(?:6(?:50|0[1-3]|1[19]|8[068]|6[68])|5(?:01|19|85)|79[78]|001))',
    '187' => '(?:8(?:5(?:40|0[2357]|3[13]|5[1358]|2[02]|6[07]|8[1578]|7[078]|1[0-28])|(?:61|70)1))',
    '188' => '(?:8(?:5(?:[58]5|11)|6(?:66|80)|701))',
    '189' => '(?:85(?:[01]1|85|5[05]|2[01]))',
    '190' => '(?:(?:8(?:5(?:3[015-79]|6[0-25-7]|5[013-578]|8[1-3689]|0[135-9]|7[1-358]|1[013-9]|4[034]|2[0-28])|6(?:66|8[0168]))|129[2357]|0192))',
    '191' => '(?:8(?:5(?:20|55|0[1-35-79]|1[0-2])|6(?:60|86)))',
    '192' => '(?:(?:8(?:5(?:77|85|2[025]|6[28]|5[1368]|1[0-256]|3[235-8]|0[125-8])|6(?:11|22|33|5[015]|4[48])|702)|0(?:9(?:9[2-4]|8[1-3689])|39[2-8])))',
    '193' => '(?:(?:8(?:5(?:[57]0|33|2[05]|1[01]|0[15])|6[68]6)|09(?:85|9[178])))',
    '194' => '(?:(?:8(?:5(?:77|1[015]|4[03]|0[23578]|8[0568]|5[0158]|2[07]|6[067]|3[038])|6(?:66|1[0-2]))|029[2-8]))',
    '195' => '(?:85(?:85|5[05]))',
    '196' => '(?:8(?:5(?:01|22|5[058]|8[58]|1[01])|6(?:[01]1|86|6[68])))',
    '197' => '(?:8(?:5(?:[01]1|55)|6(?:01|23)))',
    '198' => '(?:8(?:5(?:55|77|2[25]|1[02]|8[58]|3[12])|7(?:01|22|60|1[01])|6(?:[01]1|66)))',
    '201' => '(?:8(?:5(?:[01]1|8[58])|6(?:01|48|86)))',
    '202' => '(?:85(?:20|85|5[58]))',
    '203' => '(?:8(?:5(?:[12]1|55|8[58])|601|739))',
    '204' => '(?:85(?:11|22|33|67|5[58]|8[589]))',
    '205' => '(?:8(?:6(?:6[06]|0[13467])|5(?:11|55|0[13])))',
    '206' => '(?:8(?:5(?:30|77|4[03]|2[025]|8[568]|6[67]|0[235]|5[05]|1[125])|6(?:[68]6|11|0[12])))',
    '207' => '(?:85(?:[18]5|01))',
    '208' => '(?:85(?:85|0[1-3]|5[05]))',
    '210' => '(?:(?:8(?:5(?:3[127]|2[1-3]|5[027-9]|6[0259]|0[1246]|7[0167]|8[36]|1[125]|4[014578])|6(?:66|0[14]|8[016]))|9(?:5(?:[06]7|11|26|55|3[03]|8[28])|650)))',
    '211' => '(?:8(?:5(?:[2-4]0|66|5[058]|7[07]|8[58]|1[01]|0[125])|6(?:11|6[68])))',
    '212' => '(?:8(?:5(?:44|90|1[13]|0[1-389]|6[03467]|8[1-489]|2[05]|5[1457]|7[026]|3[016])|602))',
    '213' => '(?:85(?:66|2[0-35]|0[2357]|5[01389]|3[35]|7[0367]|8[015-9]|1[125]))',
    '214' => '(?:85(?:[26]5|33|8[058]|7[01]))',
    '215' => '(?:85(?:[36]0|09|42|7[06]|1[015]|8[58]|5[08]|2[017]))',
    '216' => '(?:85(?:[56]6|22|70|1[0-249]|0[125]))',
    '220' => '(?:8(?:5(?:58|77|1[015]|3[69]|2[0-3]|8[058]|0[12]|4[0-2]|6[56])|6(?:8[06]|0[149]|1[1-6]|2[02]|7[48]|6[08])|080))',
    '221' => '(?:8(?:5(?:[46]0|37|88|2[0238]|1[17]|5[058])|7(?:12|41|65|0[1-35])|6(?:11|23|66|8[68])))',
    '222' => '(?:8(?:5(?:77|3[03]|8[056]|6[1-6]|0[157-9]|1[15]|5[0268]|2[035])|6[25]2))',
    '223' => '(?:8(?:5(?:1[025]|[58][058]|2[0-256]|7[27]|6[067]|4[0-2]|0[125-8]|3[039])|68[67]))',
    '224' => '(?:8(?:5(?:10|78|8[05]|0[1-5]|5[01]|3[039]|2[024])|68[68]|730))',
    '225' => '(?:85(?:[28]5|[56]0|13|3[59]|0[1-38]))',
    '226' => '(?:85(?:[25]5|1[02]|0[1-37]))',
    '227' => '(?:85(?:22|40|0[1258]|1[28]))',
    '230' => '(?:8(?:5(?:11|85|7[17]|0[14]|5[05])|6(?:[01]1|[68]6|2[38])|765))',
    '231' => '(?:8(?:5(?:[25]0|42|6[26]|3[46]|8[08])|4(?:[38]4|45|61|1[19]|7[078])|3(?:3[018]|2[0134]|1[0145])|6(?:16|82|5[04])|0(?:80|0[18])|711|966))',
    '232' => '(?:8(?:5(?:15|31|76|8[057]|5[58])|6(?:02|88)))',
    '233' => '(?:85(?:0[1-3]|5[056]))',
    '235' => '(?:85(?:[58]8|2[23]|0[15]))',
    '236' => '(?:8(?:5(?:15|0[1-4]|5[05])|6(?:48|53)))',
    '237' => '(?:85(?:23|55|8[58]|1[05]))',
    '238' => '(?:(?:8(?:5(?:[04]1|33|8[058]|2[02]|6[57]|5[08]|1[01])|6[18]6)|029[28]))',
    '239' => '(?:8(?:5(?:01|8[58])|68[68]))',
    '240' => '(?:(?:85(?:[02]1|[45]0|15)|019[2-8]))',
    '241' => '(?:8(?:5(?:15|0[12])|606))',
    '242' => '(?:8(?:5(?:[07]7|55)|6(?:01|10)))',
    '243' => '(?:(?:0(?:4(?:60|9[2-8]|8[3-689])|19[23578]|29[278]|392)|8(?:5(?:21|33|88|5[015]|7[17]|1[01]|0[15])|60[14])))',
    '244' => '(?:8(?:5(?:10|0[1-3]|6[69]|7[17]|2[28]|5[058]|8[589]|3[039])|601))',
    '245' => '(?:85(?:[16]0|01|42|89|5[0358]|7[57]))',
    '246' => '(?:85(?:20|5[06]))',
    '247' => '(?:8(?:5(?:[135]0|77|88)|686))',
    '248' => '(?:8(?:55[58]|686))',
    '249' => '(?:8(?:510|686))',
    '250' => '(?:(?:0(?:2(?:80|9[2-68])|39[28]|[15]92)|85(?:11|55|88)))',
    '251' => '(?:8(?:5(?:40|2[02]|5[0158]|1[0135]|6[067]|8[18]|3[014]|0[125])|601))',
    '252' => '(?:(?:5(?:2(?:01|33|77|8[0568]|5[258]|1[01]|2[125]|9[2-578])|1(?:[56]2|8[128]|7[27]|9[126]))|0(?:3(?:7[03-57]|9[258]|8[013568])|88[0-3568])|85(?:[02]2|[47]0|11|85|3[89]|6[67]|5[08])|119[235]))',
    '253' => '(?:(?:8(?:5(?:[03]1|10|22|43|67|7[17]|5[058]|8[58])|686)|019[235-8]))',
    '254' => '(?:8(?:5(?:43|55|3[23]|8[58]|0[12])|6(?:01|86|1[024])))',
    '255' => '(?:8555)',
    '256' => '(?:8510)',
    '257' => '(?:8(?:5(?:11|33|55|66|2[23]|0[12]|8[4-68])|686))',
    '258' => '(?:(?:85(?:11|85|3[38]|0[168])|0195))',
    '259' => '(?:(?:1(?:1(?:8[58]|9[235-8])|29[23]|39[26])|0(?:19[2-46-8]|39[2356])))',
    '260' => '(?:8(?:6(?:45|5[46]|1[0-3689]|[03][1367]|7[0-357]|8[258]|2[0156]|6[0135-8])|5(?:40|77|2[34]|8[568]|1[0-68]|6[03467]|0[125-9]|3[258]|5[124-79])|7(?:1[0257]|3[03]|2[02]|0[1-37])))',
    '261' => '(?:8(?:5(?:30|66|75|5[245]|4[45]|1[235]|2[12]|8[126-8]|0[1-378])|6(?:09|86)|733))',
    '262' => '(?:8(?:5(?:36|55|0[2-468]|1[0-2])|7(?:10|33)))',
    '263' => '(?:8(?:5(?:[12]2|06|33|77|8[58]|5[05])|733))',
    '264' => '(?:8(?:5(?:[35]0|8[25]|0[15])|6(?:46|51|0[14])|733))',
    '265' => '(?:8501)',
    '266' => '(?:8(?:550|733))',
    '270' => '(?:(?:1(?:3(?:8[1-357]|9[23568])|19[2468]|49[2356]|69[3-5]|592)|2(?:2(?:9[2578]|8[08])|39[23])|8(?:5(?:[0-2]1|55)|625)|019[28]))',
    '271' => '(?:8(?:5(?:01|22|33|8[058]|1[0158]|5[0157]|6[02-4])|6(?:66|72|2[05])))',
    '272' => '(?:(?:85(?:[47]3|01|3[38]|[58][058]|2[02]|1[1-368]|6[01])|0192))',
    '273' => '(?:(?:8(?:5(?:7[04]|3[03]|2[0-3]|8[458]|1[0-25]|6[067]|4[023]|5[01568]|0[1-58])|6(?:01|27)|733)|019[2357]))',
    '274' => '(?:8(?:5(?:[12]0|77|85|3[03]|0[13-7]|5[58])|601))',
    '275' => '(?:8(?:5(?:[01]1|28|33|60|8[58]|7[25-7])|6(?:[01]1|66)))',
    '276' => '(?:85(?:01|80|2[34]))',
    '277' => '(?:8(?:5(?:1[158]|8[124-8]|0[13-57]|7[07]|6[156]|5[0146-8]|3[139]|2[12])|6(?:86|5[45]|6[16])))',
    '278' => '(?:8(?:5(?:[02]1|10|33|77|5[05])|6(?:01|86)))',
    '279' => '(?:8(?:5(?:30|41|67|5[0358]|2[125-7]|1[168]|8[58]|0[1-359])|686))',
    '282' => '(?:86(?:03|10))',
    '283' => '(?:(?:8(?:5(?:[01]1|55|88)|650)|0195))',
    '284' => '(?:8555)',
    '285' => '(?:8(?:5(?:50|67|0[1-3]|8[568]|2[0-2]|1[01])|6(?:19|5[05])|765))',
    '286' => '(?:(?:85(?:[03]1|8[58])|029[23]))',
    '287' => '(?:(?:8(?:5(?:[58]5|10|0[1-3])|601)|0292))',
    '288' => '(?:8601)',
    '289' => '(?:(?:1(?:59[2-4]|29[78]|69[23]|79[23]|[13]92)|0(?:[124-6]92|39[2-4])|2(?:19[278]|292|595)))',
    '290' => '(?:(?:8(?:5(?:77|6[06]|0[13]|5[0158]|8[58]|[13][01])|610)|019[2-4]))',
    '292' => '(?:8(?:5(?:01|2[025]|3[0359]|6[58]|5[05]|1[01])|6(?:11|86)))',
    '293' => '(?:85(?:06|11))',
    '294' => '(?:8(?:50[1-3]|[67]01))',
    '295' => '(?:(?:0192|8601))',
    '296' => '(?:(?:860[12]|0197))',
    '297' => '(?:(?:8(?:5(?:[01]1|33|67|8[158]|5[58])|6(?:11|22|66))|0(?:19[2-8]|29[28])))',
    '298' => '(?:(?:029[25-7]|8501))',
    '299' => '(?:(?:4(?:39[24-6]|[126]92|49[23])|0(?:29[235-8]|19[2-58])|2(?:[1245]92|79[25])|5(?:29[25]|192)|119[2-5]|3292))',
    '300' => '(?:(?:2(?:6(?:86|9[58])|49[2-8]|79[23578]|59[35]|395)|0(?:39[2-8]|19[23]|49[26]|59[35]|[67]92)|1(?:29[2-6]|19[235]|[34]92|696)|8(?:5(?:50|67|88)|6(?:01|19|86))|4(?:19[23]|29[35]|495|598)|3(?:29[245]|59[258])))',
    '301' => '(?:8(?:6(?:0[12]|1[01])|5(?:55|0[15])))',
    '302' => '(?:(?:85(?:85|0[12])|019[28]))',
    '303' => '(?:850[13])',
    '304' => '(?:8[56]01)',
    '305' => '(?:8(?:5(?:55|6[1-9]|0[146]|8[58]|2[01]|1[56])|6(?:42|0[124]|8[67])))',
    '306' => '(?:(?:0(?:49[2357]|[36]92|595)|86(?:01|86)))',
    '307' => '(?:8(?:50[12]|601))',
    '308' => '(?:(?:8(?:5(?:40|2[1-4]|1[0-3])|6(?:[03]8|16))|019[34]))',
    '309' => '(?:1(?:29[2-7]|19[25]|79[23]|698))',
    '310' => '(?:8(?:5(?:[67]7|40|8[158]|5[0158]|1[12]|3[36]|0[125]|2[0258])|6(?:22|41|86|7[17]|0[124]|6[68]|1[016])|282|753))',
    '311' => '(?:(?:3(?:19[2-57]|49[2-478]|89[2-4])|1(?:39[23]|49[23]|59[23]|792)|4(?:19[3-68]|39[1-3]|59[25])|019[2-4]|249[235]))',
    '312' => '(?:85(?:11|0[1-578]))',
    '313' => '(?:8(?:5(?:[58]5|11)|6(?:[68]6|11)))',
    '314' => '(?:(?:8(?:501|655)|019[2-578]))',
    '315' => '(?:(?:8(?:5(?:22|85|1[12])|640)|0195))',
    '316' => '(?:85(?:11|33|0[12]))',
    '317' => '(?:8(?:5(?:11|55)|60[12]))',
    '318' => '(?:85[01]1)',
    '319' => '(?:(?:1(?:1(?:9[24-6]|8[48])|29[235]|59[23]|393)|0(?:29[2-5]|39[3-57]|19[28])|2692|3595))',
    '320' => '(?:8(?:5(?:5[015]|3[0-38]|6[0467]|8[058]|4[013]|7[07]|0[1-3578]|2[1-358]|1[0-2457])|6(?:20|55|68|1[018]|0[17]|8[068])))',
    '321' => '(?:(?:3(?:29[235-8]|49[378]|39[25]|59[58])|0(?:29[2358]|19[458]|59[235]|692)|2(?:59[23568]|49[23]|792)|1(?:29[27]|49[23]|692)|4(?:39[23568]|29[235])|85(?:[58]5|0[25])))',
    '322' => '(?:(?:8(?:5(?:11|0[1-3]|8[58]|5[05])|6(?:66|88|0[13]))|0(?:393|692)))',
    '323' => '(?:(?:8(?:5(?:11|58|67|8[56])|6(?:[01]1|78|86))|[01]192))',
    '324' => '(?:(?:8(?:5(?:01|85|1[06]|5[015])|6(?:25|4[12]))|0(?:59[2-6]|29[23]|69[23]|492)))',
    '325' => '(?:039[23578])',
    '326' => '(?:(?:8(?:5(?:20|72|85|5[058]|1[01]|0[125])|6(?:[01]1|30|55|86))|039[235]))',
    '327' => '(?:(?:8(?:5(?:11|0[13])|6(?:78|0[13]))|0(?:59[25]|192|398)))',
    '328' => '(?:(?:8(?:5(?:33|5[0568]|8[568]|0[1-5])|6(?:86|6[68]))|0192))',
    '329' => '(?:(?:1(?:19[3-68]|39[2-5]|292|493)|0(?:59[568]|49[28]|69[26]|195)|2(?:79[237]|19[23]|99[23]|292)|4(?:49[23]|392)|3292))',
    '330' => '(?:(?:9(?:5(?:90|5[013589]|4[03-58]|6[4-6]|3[156]|2[35]|7[57]|1[0-2]|0[1-37-9]|8[0-3568])|6(?:[69]6|11|30|88|0[18]|2[126])|3(?:01|30|77|1[01])|0(?:11|45|77|88)|7(?:15|9[67])|1(?:09|11)|850)|8(?:5(?:47|8[015]|0[3568]|3[238]|1[0189]|2[29]|7[129]|5[01]|6[56])|6(?:01|69|8[68]))))',
    '331' => '(?:(?:8(?:5(?:[24]0|01|1[13]|5[02]|6[07]|3[237]|8[06-8])|6(?:33|58|8[67]))|9(?:5(?:[1-35]0|77)|624)))',
    '332' => '(?:8(?:5(?:21|48|77|85|5[568]|0[12]|1[0-2])|6(?:[68]6|01|54)))',
    '333' => '(?:86[01]1)',
    '334' => '(?:85[01]1)',
    '335' => '(?:8(?:5(?:22|33|55|8[58]|1[01]|0[1-35])|6(?:55|66)|792))',
    '336' => '(?:8(?:5(?:40|6[14]|1[25]|0[568]|8[167]|5[58]|2[0256])|6(?:01|36|55)|760))',
    '337' => '(?:85(?:32|70|86|0[27]))',
    '338' => '(?:8(?:5(?:8[056]|2[3-5]|6[67]|7[0157]|1[0235]|3[18]|4[01]|0[3468]|5[13578])|686))',
    '339' => '(?:8(?:5(?:21|39|66|85|0[19]|5[18]|1[01])|6(?:01|86)))',
    '340' => '(?:(?:8(?:5(?:24|33|77|5[015]|0[19]|8[58]|6[078]|1[01])|6(?:59|86|1[01]))|0(?:19[23]|295)))',
    '341' => '(?:85(?:01|5[058]|2[67]))',
    '342' => '(?:8(?:50[125]|601))',
    '343' => '(?:(?:8(?:5(?:11|40|85|5[45]|0[12])|601)|019[23]))',
    '344' => '(?:8(?:5(?:11|40|55|66|77|3[35]|8[58]|2[12]|0[68])|686))',
    '345' => '(?:850[1248])',
    '346' => '(?:(?:8(?:5(?:[34]0|24|0[16])|68[56])|019[2-68]))',
    '347' => '(?:(?:85(?:67|85|0[1-4]|1[03]|5[05])|019[25]))',
    '348' => '(?:8(?:5(?:[25]5|30|1[23]|4[09]|0[135-7])|601))',
    '349' => '(?:(?:0(?:19[23568]|29[2-4])|1(?:19[23]|292)))',
    '350' => '(?:(?:0(?:2(?:9[25]|8[02-9])|39[2-6]|49[3-6]|19[237])|1(?:3(?:9[28]|8[08])|1(?:81|9[26-8])|29[25-8])|8(?:5(?:[13]1|8[58]|5[05]|0[18])|6(?:01|66))|22(?:92|8[0178])))',
    '351' => '(?:(?:8(?:5(?:[26]0|51|0[18]|1[01]|8[56])|601)|01(?:88|9[2-46-8])))',
    '352' => '(?:8(?:5(?:01|10|23|49|8[89]|7[27]|5[58])|6(?:23|66)))',
    '353' => '(?:85(?:01|55))',
    '354' => '(?:85(?:33|77|8[05]|5[58]|0[13-5]|1[01]))',
    '355' => '(?:(?:8(?:5(?:01|85)|60[1-6])|0(?:19[235]|39[25]|292)))',
    '356' => '(?:85(?:33|67|85|0[127]|5[056]|1[01]))',
    '357' => '(?:8(?:5(?:01|10|27|5[058]|8[58])|673))',
    '358' => '(?:85(?:[02]1|1[015]|[58][58]))',
    '359' => '(?:(?:8(?:5(?:[67]0|33|42|85|5[058]|1[013]|2[02]|0[157])|6(?:01|48|86))|11(?:9[2356]|8[89])))',
    '360' => '(?:(?:8(?:5(?:[67]7|32|43|2[0-3]|1[25]|8[05]|0[12]|5[589])|6(?:11|20|0[18]))|019[2-6]))',
    '361' => '(?:8(?:5(?:[58]5|39|1[013]|0[3-8])|60[1-4]))',
    '362' => '(?:8(?:5(?:[67]7|31|42|0[14]|2[013]|8[58]|5[035]|1[017])|688))',
    '363' => '(?:8(?:5(?:10|0[19])|601))',
    '364' => '(?:8(?:5(?:[01]1|[58]5)|633))',
    '365' => '(?:8(?:5(?:[58]5|1[124]|0[1-3568])|6(?:11|0[13])))',
    '366' => '(?:85(?:67|81|1[015]|0[12]))',
    '367' => '(?:(?:0(?:19[248]|29[278])|8(?:501|686)))',
    '368' => '(?:(?:8(?:50[125]|68[06])|0(?:19[235]|292)))',
    '369' => '(?:(?:1(?:29[2358]|89[2-5]|19[235]|59[236]|[34]92|998)|0(?:29[2357]|19[258]|39[235])))',
    '370' => '(?:(?:8(?:5(?:[01]1|22|43|65|3[17]|8[58]|5[05])|6(?:[01]1|22|86|6[68]))|1(?:39[2-6]|19[2356]|29[235]|592)|0(?:59[568]|49[25]|193|692|795)|2(?:39[23568]|49[58]|[12]92)|3(?:59[2-4]|[146]92|39[23])))',
    '371' => '(?:(?:8(?:5(?:43|67|70|85|0[1-578]|2[25]|1[0-467]|5[01])|6(?:[01]1|[68]6|40))|0(?:192|294)))',
    '372' => '(?:8(?:5(?:58|67|8[058]|0[128])|686))',
    '373' => '(?:8(?:5(?:21|40|78|0[1589]|1[0135]|8[58]|5[0157]|3[01]|6[017])|6(?:01|22|6[06]|3[09]|8[68]|1[01])))',
    '374' => '(?:(?:8(?:5(?:01|33|55|77|88|2[01]|1[0-28])|6(?:11|22|40|86|0[18]))|019[23]))',
    '375' => '(?:8(?:50[1-6]|60[1-4]))',
    '376' => '(?:(?:8(?:5(?:31|0[1-3]|1[056]|2[38]|[58][58])|6(?:86|6[68]))|0(?:19[2-4]|39[27])))',
    '377' => '(?:(?:0(?:8(?:8[23]|9[2-46-8])|19[235]|29[2-4]|39[25]|49[24]|792)|8(?:5(?:[67]7|20|33|55|1[013]|0[1-38]|8[58])|6(?:01|16))|1(?:79[2-7]|39[235]|59[3-5]|69[235])))',
    '378' => '(?:(?:0498|8501))',
    '379' => '(?:(?:2(?:1(?:8[01457]|9[2-578])|39[2358]|29[28])|1(?:[16]92|[24]98|393)|0(?:19[2356]|292)))',
    '380' => '(?:8(?:5(?:4[0356]|0[1-35-8]|8[013-689]|5[0-2578]|7[0235-7]|6[015-8]|2[0-24-6]|1[0-25689]|3[013-9])|6(?:22|55|0[158]|6[068]|8[68]|4[08]|1[0-24]|3[039])|79[4-8]))',
    '381' => '(?:(?:8(?:5(?:[67][07]|3[09]|0[138]|4[58]|2[05]|1[0-2]|8[08]|5[68])|6(?:02|86)|79[13])|0(?:29[23578]|19[23]|49[78])|22(?:8[1-35-8]|9[258])|4(?:19[23]|393)))',
    '382' => '(?:8(?:5(?:33|55|0[128]|8[578]|1[01])|633))',
    '383' => '(?:8(?:5(?:55|67|8[158]|0[156]|1[15])|6(?:14|86)))',
    '384' => '(?:(?:8(?:5(?:01|58|8[58])|605)|0(?:69[2578]|798)|(?:11|22)92))',
    '385' => '(?:8(?:5(?:[01]1|22|33|8[568]|5[58])|6[01]1))',
    '386' => '(?:(?:8(?:6(?:24|77|0[17-9]|8[3568]|6[68]|3[48]|1[01])|5(?:[67]7|22|43|5[1358]|8[458]|1[01]|0[15])|7(?:20|1[05]|0[15]))|0(?:49[23578]|39[36]|[15]92)|1(?:19[23]|298)|2292))',
    '387' => '(?:8(?:5(?:[26]1|[58]5|0[1-3]|1[12])|60[13]))',
    '388' => '(?:85(?:11|22|55))',
    '389' => '(?:(?:0(?:6(?:8[128]|9[235-8])|19[24-8]|29[23568]|59[2358]|89[2378])|1(?:19[256]|293|392)|2(?:[1357]92|29[28])))',
    '390' => '(?:(?:8(?:5(?:55|0[1-35-8]|2[0358]|1[01358]|4[013]|3[01359])|6(?:86|1[015]|2[013]|3[09]|4[08]|0[1-35])|7(?:22|1[0-245]|0[1-37]))|1(?:1(?:9[378]|8[1-35-9])|29[358]|39[2-4]|[457]92)))',
    '391' => '(?:(?:0(?:29[2-6]|39[2-6]|192)|85(?:0[137]|2[12]|1[0-2])))',
    '392' => '(?:8(?:5(?:[58]5|20|7[78]|4[089]|1[01]|0[125])|6(?:86|2[78]|0[19]|1[01])))',
    '393' => '(?:8(?:5(?:11|85|0[1-3])|601))',
    '394' => '(?:8(?:5(?:[24]0|77|1[0-25]|8[58]|5[05])|6(?:11|65|86)))',
    '395' => '(?:(?:8(?:5(?:[34]3|77|2[028]|5[568]|6[67]|8[58]|1[15]|0[1-35])|6(?:09|11|22|46|55|8[28]))|019[2356]))',
    '396' => '(?:(?:8(?:5(?:01|85|5[058]|1[01])|6(?:09|82|1[17]))|0(?:198|293)))',
    '397' => '(?:(?:8(?:5(?:55|67|71|8[58])|60[29])|0[23]92))',
    '398' => '(?:8(?:6(?:86|0[12])|501))',
    '399' => '(?:(?:8(?:7(?:44|60|2[0-258]|5[0145]|1[0-2]|3[0389]|0[1-37])|2(?:9[2357]|8[1-3568])|3(?:86|92)|69[56]|192)|4(?:5(?:6[4-8]|8[13-9]|9[2-578]|7[0-3568])|69[235-7]|39[2-5]|19[25]|498)|0(?:7(?:9[56]|8[1256])|49[235-8]|29[235])|3(?:19[23]|295|797|892)|1(?:392|511|689|895)|9(?:192|393|494)|7192))',
    '400' => '(?:(?:8(?:5(?:8[568]|0[1568]|1[0-25]|4[03-5]|7[01578]|2[15]|5[05689]|6[56]|3[1356])|6(?:01|10|33|66))|0(?:2(?:80|9[238])|19[2-6]|49[2358]|39[358]|59[238]|69[235])|159[2-478]))',
    '401' => '(?:(?:0(?:3(?:80|9[5-8])|59[257]|292)|8[56]01))',
    '402' => '(?:85(?:01|55))',
    '403' => '(?:8(?:5(?:22|55)|601))',
    '404' => '(?:8[56]01)',
    '405' => '(?:85(?:[58]5|01|77))',
    '406' => '(?:8(?:5(?:05|10|5[58])|601))',
    '407' => '(?:85(?:[01]1|55))',
    '408' => '(?:(?:85(?:[18]5|22|33|5[05])|01(?:88|92)))',
    '409' => '(?:(?:3(?:8(?:9[2-8]|8[01357-9])|39[23]|79[23]|293|692)|2(?:19[2-6]|59[2378]|398|992)|1(?:298|392)|019[2358]))',
    '410' => '(?:(?:8(?:5(?:67|0[148]|2[025]|5[0-258]|8[058]|3[0135]|7[05]|1[0145]|4[034])|6(?:10|8[69]|5[45]|0[12])|7(?:10|39))|2(?:39[2-6]|19[2-5]|29[257]|592)|1(?:39[2-6]|19[2356])|3(?:29[23]|69[36])|0(?:39[568]|192)))',
    '411' => '(?:8(?:6(?:30|89|2[03]|4[148]|6[068]|5[0-2]|1[01])|5(?:02|33|60|77|2[05]|5[15]|[14][01])|7(?:[45]0|[78]7|2[025]|3[01])))',
    '412' => '(?:8(?:5(?:24|50|85|1[1-3]|0[15])|6(?:3[04]|0[159])))',
    '413' => '(?:(?:8(?:5(?:30|8[59]|0[25]|5[058]|6[067]|1[01])|6(?:26|78|1[18]))|0(?:29[238]|49[23]|196)))',
    '414' => '(?:8(?:5(?:11|5[05])|60[12]))',
    '415' => '(?:(?:8(?:5(?:30|0[125-9]|[12][0-8])|6(?:11|0[23]))|0(?:19[2-4]|392)))',
    '416' => '(?:8(?:5(?:[02]1|77|4[04]|3[03]|5[58])|6(?:60|5[04-69])))',
    '417' => '(?:8(?:5(?:6[05-7]|3[01358]|8[058]|0[135-8]|1[0-29]|5[05]|7[0157]|2[029]|4[035])|6(?:[15]0|32|86|0[19])))',
    '418' => '(?:(?:86(?:[68]6|01)|0192))',
    '419' => '(?:0(?:19[23]|29[35]|392))',
    '420' => '(?:8(?:6(?:6[06]|0[1-46]|4[14]|7[07]|3[03679]|5[05]|8[01568]|1[0-268]|2[02-4])|5(?:70|2[0-358]|0[1-357-9]|8[0158]|1[0-25]|6[07]|5[0578]|3[06-8])|7(?:0[2-469]|1[02]|3[389]|4[07]|2[0-2]|6[01])))',
    '421' => '(?:(?:0(?:1(?:88|9[23578])|39[2-7]|59[23568]|49[2356]|29[238])|1(?:29[58]|392)|329[25-7]))',
    '422' => '(?:8(?:5(?:[58]0|45|[26]\d|0[24-79]|7[0-8]|3[01]|1[0-24-9])|6(?:5[04]|3[03]|7[07]|8[068]|6[68]|1[059]|2[0-28])|766))',
    '424' => '(?:(?:8(?:6(?:48|50|0[1-3]|7[78]|3[1367]|[68][68]|1[01]|2[024])|7(?:3[04]|2[0147]|5[0-25]|6[07]|0[18]|1[579])|5(?:66|0[23]|5[058]|1[01]))|0(?:19[23]|292)))',
    '425' => '(?:8(?:5(?:[58]5|[67]0|11|22|33|0[1-358])|6(?:11|8[06])|7(?:11|0[18])))',
    '426' => '(?:(?:8(?:6(?:01|3[13]|7[07]|1[27]|4[026]|6[2368])|5(?:39|43|1[015]|0[13]|7[057]|6[67])|7(?:11|22))|0292))',
    '427' => '(?:(?:8(?:5(?:41|55|0[12589]|2[25]|8[18]|1[0-2])|6(?:86|0[12]))|019[356]))',
    '428' => '(?:(?:8(?:6(?:86|5[0-2])|50[1-3])|0192))',
    '430' => '(?:(?:8(?:5(?:[24]0|11|7[057]|6[07]|5[358]|8[0578]|3[036])|6(?:20|8[0679]|3[09]|7[0578]|6[578]|5[02-5]))|0898))',
    '431' => '(?:(?:0(?:49[2-6]|29[258]|19[23]|395)|3(?:19[2-6]|39[23]|492)|1(?:39[2-5]|49[5-7])|(?:22|41)95))',
    '432' => '(?:8(?:5(?:41|80|5[015]|3[127]|2[0-38]|0[178]|6[12])|6(?:08|11|26|8[068])))',
    '433' => '(?:8(?:5(?:[2-4]0|01|67|5[058]|1[01])|601))',
    '434' => '(?:8(?:5(?:11|33|50|0[125])|601))',
    '435' => '(?:8(?:5(?:40|75|3[39]|0[25]|2[02]|6[0178]|8[58]|1[05]|5[1578])|6(?:42|86|1[19]|6[01])))',
    '436' => '(?:8(?:65[0-3]|50[1-3]))',
    '437' => '(?:(?:1(?:6(?:8[6-8]|9[2-8])|19[2-7]|39[2357]|49[24-6]|59[2-4]|292)|8(?:5(?:[01]1|[45]5)|6(?:[01]1|[68]6))|0(?:29[23]|693)))',
    '438' => '(?:(?:8(?:5(?:01|10|43|77|85|5[058])|6(?:[01]1|22|50|86)|71[18])|0(?:19[235]|292)))',
    '439' => '(?:865[01])',
    '440' => '(?:8(?:5(?:1\d|3[0-3]|0[124-8]|2[0-8])|60[1-4]))',
    '441' => '(?:(?:8(?:5(?:6[06]|2[025]|5[058]|7[07]|8[08]|0[1-37]|1[0-2579]|4[035]|3[039])|6[68]6)|0(?:19[3-5]|29[25]|39[23])|3(?:19[2-6]|492|695)|1(?:29[2-5]|[346]92)))',
    '442' => '(?:8(?:5(?:20|58|3[0-358]|0[1-35-79]|6[169]|1[0-35-8]|8[0-25-8]|7[35-7]|9[01]|4[013-6])|60[1-3]))',
    '443' => '(?:(?:8(?:5(?:55|88)|6[01]1)|019[2-4]))',
    '444' => '(?:(?:8(?:5(?:77|3[03]|6[047]|1[0-267]|0[178]|8[1568]|2[02]|4[235]|5[1-58])|6(?:86|0[126]|1[0-2])|7(?:10|87))|0(?:3(?:81|9[1-8])|49[2-6]|59[2356]|19[2-4]|798)|1(?:3(?:8[5-8]|9[3478])|19[2358]|29[5-8])|3(?:59[2-5]|69[2568])|2(?:19[2-4]|89[23])))',
    '445' => '(?:8(?:5(?:85|1[01]|0[1-35])|60[12]))',
    '446' => '(?:8(?:5(?:40|1[12478]|3[35]|0[1-8]|[58][58]|2[02-6])|6(?:35|41|86|0[12])))',
    '447' => '(?:8(?:5(?:0[1-35-7]|1[0-2])|6(?:[18]0|0[1358])))',
    '448' => '(?:8(?:6(?:10|0[1259]|5[0-35-7]|6[0156]|8[68]|7[017])|5(?:23|31|50|0[16])|731))',
    '449' => '(?:029[2-4])',
    '450' => '(?:(?:8(?:5(?:40|3[0238]|2[0-3]|6[17]|1[05]|7[57]|8[035]|0[125])|6(?:[48]0|01|77|2[06]|1[148]|5[01])|7(?:11|30|65))|6133))',
    '451' => '(?:8(?:5(?:[14]1|85|[25][015]|6[0158]|0[1-38]|7[0157])|6(?:50|88)|701))',
    '452' => '(?:8(?:5(?:21|44|70|0[1-3]|6[1-79])|60[1-4]))',
    '453' => '(?:8(?:5(?:[56]5|40|77|8[015]|2[12]|0[15]|3[039]|1[0-28])|6(?:[01]1|62|86)|765))',
    '454' => '(?:8(?:5(?:3[03]|2[0-24-79]|5[058]|1[124-9]|6[05]|0[1-689])|651))',
    '455' => '(?:8(?:6(?:[07]1|[46]8|2[06]|3[09])|5(?:[1458]5|21|30|0[15])))',
    '456' => '(?:8(?:5(?:23|30|6[07]|1[16]|8[0578]|0[12]|5[56])|6(?:20|0[12]|1[0-2]|[68][68])|7(?:11|39|63)))',
    '457' => '(?:8(?:5(?:[48]5|3[0-35]|[05][158]|2[02]|1[0-25]|7[07]|6[067])|71[12]))',
    '458' => '(?:85(?:30|55|[18][015]|0[1258]|2[0-25]|7[01]))',
    '459' => '(?:85(?:11|22|40))',
    '460' => '(?:8(?:6(?:90|7[0-2489]|8[1-9]|6[035-9]|0[1-3689]|3[0-35-8]|5[0135-7]|2[013568]|1[013-9])|4(?:7[02357]|0[1-35-8]|1[125-7]|8[1-58]|5[0156]|2[0256]|9[01]|3[0-69]|6[0-28]|4[014578])|5(?:5[01589]|[23][0-58]|8[05-8]|1[0-68]|4[0135]|7[04578]|0[13-9]|6[06-8])|3(?:02|6[06]|2[015]|5[018]|3[0138]|8[038]|1[0-24589])|7(?:20|65|91|0[1-46-8]|1[18])|20[1-4]))',
    '461' => '(?:8(?:5(?:60|8[0-2568]|2[025]|5[058]|3[0-29]|0[13-8]|7[57]|4[01]|1[125])|6(?:66|80|4[015]|3[019]|0[2358]|5[01458]|2[016]|1[024]|7[0-3568])|7(?:0[36-8]|2[159]|9[58]|1[0457])))',
    '462' => '(?:8(?:5(?:2[23]|4[03]|7[5-7]|5[158]|0[189]|3[05]|1[129]|8[08])|666))',
    '463' => '(?:85(?:[18]0|5[057]|2[128]|6[0157]|7[157]|0[1-35]|3[03568]|4[013578]))',
    '464' => '(?:8(?:5(?:85|5[058]|2[0-25]|4[035-7]|1[12]|6[0167]|3[01369]|7[017])|6(?:[278]1|0[1-3]|4[134]|3[1-357]|5[0-4]|6[12]|1[0135-7])|710))',
    '465' => '(?:8(?:5(?:20|6[05-7]|5[0-258]|0[15-8]|1[0156])|6(?:51|68|70|1[0-2]|2[026])))',
    '466' => '(?:8(?:5(?:40|3[39]|6[057]|2[25]|8[058]|1[0-25]|5[0458]|0[125-8])|6(?:73|6[06]|5[05-7]|3[035])|7(?:11|0[17])))',
    '467' => '(?:8(?:5(?:01|6[1-367]|7[17]|3[013]|8[0158]|2[0-25]|5[58]|1[01])|6(?:51|86|2[26]|1[015]|0[1-3]|3[039])))',
    '468' => '(?:8(?:5(?:3[1-46]|2[02]|1[0-4]|8[58]|0[1-7])|626))',
    '469' => '(?:879[3467])',
    '470' => '(?:(?:0(?:1(?:88|9[24-68])|29[2-7]|39[2-6]|49[2356]|592)|2(?:19[235-7]|29[26-8]|39[2-48]|49[23])|1(?:19[2-68]|29[2-6])|3(?:29[56]|495)))',
    '471' => '(?:8(?:5(?:7[1-4]|6[056]|3[0-25-7]|0[1-36-8]|8[58]|5[05]|1[0235]|2[1257])|60[1-39]))',
    '472' => '(?:8(?:6(?:[68]6|39)|5[58]5))',
    '473' => '(?:85(?:01|33|1[12]))',
    '474' => '(?:8(?:5(?:22|35|43|8[01458]|5[0578]|1[01]|0[1-35])|6(?:[05]1|42|66|8[68]|1[01])|7(?:10|66|77|0[17])))',
    '475' => '(?:8(?:5(?:41|60|74|99|5[057]|2[28]|8[58]|0[12]|1[01])|6(?:[01]1|55|86|6[68])))',
    '476' => '(?:8(?:5(?:[67]7|33|0[13]|8[58]|1[01])|6(?:[68]6|01)))',
    '477' => '(?:85(?:21|38))',
    '478' => '(?:8(?:5(?:55|0[1-5])|6(?:01|4[01])))',
    '479' => '(?:8(?:5(?:01|55|77|8[5-9]|1[018])|7(?:87|0[1-8]|1[12])|6(?:01|10|23|68)))',
    '480' => '(?:(?:0(?:2(?:8[128]|9[1246])|19[23578]|39[235])|1(?:1(?:8[89]|9[2-8])|298)))',
    '481' => '(?:8(?:5(?:26|88|4[03]|5[058]|1[0135]|0[1-58]|3[1359])|6(?:[08]1|15|78)))',
    '482' => '(?:8(?:5(?:01|30|55|1[01])|6(?:86|5[12])))',
    '483' => '(?:8(?:5(?:55|0[2357])|70[14]))',
    '484' => '(?:8(?:5(?:0[1-8]|1[01])|609))',
    '485' => '(?:8(?:5(?:05|40|1[0-26]|2[0-3]|3[013]|5[0-25]|6[1-35])|65[0-5]|750))',
    '486' => '(?:8(?:5(?:01|40|67|75|[15][015]|2[24]|8[58])|6[68]6))',
    '487' => '(?:8(?:6(?:22|50)|501))',
    '488' => '(?:8(?:5(?:[58]5|20|78|0[15])|6(?:55|66|8[68])))',
    '489' => '(?:8(?:5(?:20|67|5[05]|1[01])|6(?:[58]0|4[25]|1[01])|7(?:01|77)|450))',
    '490' => '(?:1(?:19[2-48]|29[2356]|392))',
    '491' => '(?:(?:8(?:5(?:85|1[2356]|0[12589]|5[1358]|7[125-7]|6[12]|2[368]|3[1-35])|6(?:0[18]|1[0-2]|8[68]))|0(?:39[2-5]|192)))',
    '492' => '(?:8(?:5(?:2[013589]|1[0-3]|4[0-25-8]|0[12])|6(?:[05]1|46|8[0-7]|2[128])))',
    '494' => '(?:8(?:5(?:1[168]|0[1257])|6(?:[01]1|86)))',
    '495' => '(?:8(?:5(?:31|0[15]|1[017])|601))',
    '496' => '(?:8(?:5(?:[78]5|3[1-57]|0[138]|5[58])|6(?:01|48|86|3[39])|720))',
    '497' => '(?:8(?:5(?:4[158]|0[1258]|3[013]|1[0-2]|2[0278])|601))',
    '498' => '(?:850[1-35])',
    '500' => '(?:8(?:6(?:1[056]|4[0568]|7[0-26-8]|2[0-25]|0[1-357]|8[0-25-79]|5[0157]|3[05-9]|6[06-8])|5(?:88|1[0358]|4[045]|0[124578]|7[07]|6[015-7]|2[1-5]|3[035]|5[024-8])|7(?:65|5[0-35]|4[0-38]|3[0-47]|1[015-8]|0[1-378]|2[0-257-9])))',
    '501' => '(?:(?:0(?:49[2-8]|69[2-7]|29[2-6]|[135]92|79[78])|3(?:99[2-48]|29[356]|39[235]|89[2-4]|792)|6(?:1(?:9[2-8]|8[01])|29[235-7])|4(?:29[278]|19[23]|59[25])|1(?:19[2-68]|[235]92)|2(?:[1258]92|69[578])|5(?:[146]92|393)))',
    '502' => '(?:8(?:5(?:[0-2]1|58|67)|792))',
    '503' => '(?:(?:8(?:5(?:5[02-46-9]|1\d|2[0-3]|0[1-9]|7[01]|6[0-24-9])|60[134])|0(?:19[258]|29[256]|[46]95|392)|2(?:39[2-7]|49[2-5]|19[23])|1(?:39[2-6]|59[235])))',
    '504' => '(?:8(?:5(?:[48]5|11|0[14]|5[15])|7(?:10|0[12])|6(?:01|42)))',
    '505' => '(?:(?:8(?:50[1358]|606)|0392))',
    '506' => '(?:(?:8(?:6(?:66|78|0[13]|8[6-8])|5(?:77|85|0[26]|5[05]))|1(?:49[23568]|19[56]|392)|019[24]|2192))',
    '507' => '(?:8(?:5(?:[16]1|33|2[237])|6(?:50|0[1-3578])|70[1-3568]))',
    '508' => '(?:(?:8(?:5(?:[58]5|11|0[0-2])|6(?:[68]6|11))|0(?:292|494)))',
    '509' => '(?:(?:7(?:79[2357]|[258]92|49[23]|69[23])|1(?:39[2-6]|69[235]|19[23]|492)|0(?:29[25-8]|19[278]|393|492)|2(?:59[2358]|29[235])|9(?:29[23568]|19[25])|5(?:19[2358]|292)|(?:83|4[1-3])92|3(?:195|292)|619[2-6]))',
    '510' => '(?:(?:8(?:5(?:[34]0|5[0257]|0[3-6]|2[025]|8[058]|1[0-25]|7[57]|6[0-27])|6(?:[23]1|42|66|70|5[15]|1[56]|0[145]))|0(?:29[2-58]|[13]92)|1292))',
    '511' => '(?:(?:8(?:5(?:[67]7|02|33|5[058]|8[58]|1[01])|6(?:[68]6|01|78)|7(?:11|98))|0(?:29[2-6]|19[28]|59[23]|492)|1192))',
    '512' => '(?:85(?:12|38|50))',
    '513' => '(?:8(?:6(?:[57]0|01|8[06]|3[0-3]|6[016])|5(?:[1-3]0|0[15])|701))',
    '514' => '(?:(?:8(?:5(?:4[0356]|3[0-38]|2[01468]|8[568]|7[0178]|5[02358]|1[1-58]|0[1-3578]|6[06-8])|6(?:[01]1|[68]6|3[35]))|2(?:39[23568]|29[2-4]|192)|1(?:29[2-7]|19[25])|039[235-7]))',
    '515' => '(?:(?:8(?:5(?:77|3[03]|2[25]|8[568]|6[67]|1[0135]|5[0578]|0[1359])|688)|2(?:69[23]|592)|059[2568]))',
    '516' => '(?:(?:8(?:5(?:20|77|5[0-58]|1[1568]|4[3-9]|6[67]|8[18]|0[1-35])|6(?:86|0[12]))|1(?:19[2568]|492)|019[2-48]|2195))',
    '517' => '(?:(?:0(?:59[23]|292|494)|85(?:01|1[17])))',
    '518' => '(?:(?:0(?:49[2-68]|29[2-6]|192)|85(?:01|18|33)))',
    '519' => '(?:(?:0(?:19[35-8]|49[2357]|59[2-5]|292|393|696)|2(?:59[23]|[17]92)|3(?:69[2-6]|492)|439[2-6]|529[23]|1192))',
    '520' => '(?:(?:8(?:5(?:[23]0|01|67|8[0568]|7[057]|5[058]|1[1-36])|6(?:39|66))|3(?:1(?:9[45]|8[02589])|08[0-58]|28[12589]|49[23]|393)|2(?:39[2-5]|59[24-6]|19[24]|492)|1(?:1(?:88|92)|[2568]92|49[25])|0(?:2(?:87|92)|58[08])))',
    '521' => '(?:(?:1(?:29[25]|39[28]|192)|8(?:60|5[0-2])1|0[23]92))',
    '522' => '(?:(?:8(?:5(?:11|40|3[39]|0[13]|8[58]|2[023])|6(?:55|66))|029[27]))',
    '523' => '(?:8(?:5(?:23|0[1-3]|5[58]|1[05])|651))',
    '524' => '(?:(?:85(?:01|24|77|85)|0292))',
    '525' => '(?:85(?:77|2[0-25]|6[67]|[58][58]|1[15]|0[125]))',
    '526' => '(?:(?:8(?:5(?:01|45|58|8[05])|6(?:60|86))|029[23]))',
    '527' => '(?:(?:8(?:5(?:[27]7|42|8[058]|6[67]|1[12]|5[0458]|0[589])|687)|0195))',
    '528' => '(?:8(?:5(?:[58]5|0[12]|1[01])|666))',
    '529' => '(?:(?:1(?:3(?:93|8[0-368])|59[2578]|49[235]|69[28]|195|892)|0(?:49[238]|[27]92)))',
    '530' => '(?:(?:8(?:2(?:6[26]|1[0-25-7]|8[128]|2[27]|5[12]|4[157]|7[08]|0[13-6]|3[049])|5(?:01|35|44|2[1-3]|6[5-7]|5[1568]|7[45]|8[02368]|1[1-37])|3(?:2[134]|8[389]|4[16]|5[05]|1[18]|[03][48])|6(?:1[018]|0[12]|8[08])|4(?:75|1[015]|4[18])|79[136-8])|6051))',
    '531' => '(?:8(?:5(?:11|67|0[1-3]|5[58])|787))',
    '532' => '(?:8(?:5(?:[38]5|60|77|2[045]|0[1578]|5[0258]|1[145])|680))',
    '533' => '(?:8(?:5(?:33|85|5[58]|0[12])|651))',
    '534' => '(?:85(?:11|85|0[12]))',
    '535' => '(?:85(?:[58]5|01))',
    '536' => '(?:8(?:5(?:10|36|67|0[1358]|8[58]|2[237]|5[038])|686))',
    '537' => '(?:8(?:5[01]1|686))',
    '538' => '(?:8(?:5(?:[58]5|01|10)|6(?:[68]6|55)))',
    '539' => '(?:8794)',
    '540' => '(?:(?:8(?:5(?:66|5[01589]|0[158]|3[03-5]|7[01578]|4[014]|2[267]|1[0-2579]|8[14-8])|6(?:20|8[69]|4[25]|3[09]|0[2-8]|7[078]|6[08]|1[01])|795)|6255))',
    '541' => '(?:(?:85(?:5[01346-9]|2[013-689]|3[0457-9]|4[0-35-9]|1[124-9]|6[3568]|8[13-79]|7[15-9]|0[1-689])|6666))',
    '542' => '(?:8(?:5(?:33|42|77|0[1-4]|8[0568]|6[67]|2[235]|5[0458]|1[01])|6(?:54|60|8[68])|745))',
    '543' => '(?:8(?:5(?:43|[58][58]|0[12])|6(?:01|66|8[68])))',
    '544' => '(?:8(?:5(?:01|55)|666))',
    '545' => '(?:85(?:[01]1|22|33|45|5[058]|8[56]))',
    '546' => '(?:8501)',
    '547' => '(?:85(?:01|80|1[04]))',
    '549' => '(?:85(?:01|85))',
    '550' => '(?:8(?:5(?:38|6[67]|2[27]|8[05]|7[0578]|5[0258]|0[1-35])|6(?:59|60)))',
    '551' => '(?:85[05]1)',
    '552' => '(?:85(?:01|10))',
    '553' => '(?:8(?:5(?:01|67|85|1[1-3]|5[03])|739))',
    '554' => '(?:85(?:[01]1|88|5[58]))',
    '555' => '(?:85(?:55|0[12]))',
    '556' => '(?:8(?:5(?:01|85|5[058]|1[0256])|6(?:01|70|6[03-6])))',
    '557' => '(?:8501)',
    '558' => '(?:85(?:01|85|5[58]))',
    '559' => '(?:8(?:5(?:01|22|1[019]|5[03589]|8[58]|6[01])|6(?:[01]1|5[18])|729))',
    '560' => '(?:85(?:79|80|4[38]|5[25]|6[0157]|3[12]))',
    '561' => '(?:85(?:[06]1|20|77|5[058]|1[01]))',
    '562' => '(?:8(?:5(?:11|22|43|8[0568]|[05][58]|6[0278])|686))',
    '563' => '(?:(?:85(?:[67]7|10|88)|0[23]92))',
    '564' => '(?:8(?:5(?:23|67|5[015]|0[13]|8[05]|1[15])|6(?:80|5[01])))',
    '565' => '(?:85(?:11|40|65))',
    '566' => '(?:8(?:5(?:[58]5|01|13|66)|686))',
    '567' => '(?:8(?:5(?:[34]0|[56]7|78|85|1[015]|2[0135]|0[125])|6(?:51|80)))',
    '569' => '(?:(?:8(?:5(?:33|49|77|0[135]|2[02]|[58][58]|6[679]|1[0-2])|6(?:60|86))|1(?:19[2-7]|09[24-68])))',
    '570' => '(?:8(?:5(?:39|40|0[125-7]|[58][58]|1[15])|6(?:[68]6|34|77)))',
    '571' => '(?:8(?:5(?:[45]5|67|71|0[347]|8[05])|6(?:33|86)))',
    '572' => '(?:85(?:40|67|8[01589]|2[28]|3[013]|7[02]|5[0158]|0[1578]|1[01]))',
    '573' => '(?:(?:8(?:5(?:11|34|73)|666)|10(?:[34]0|01)|019[25]))',
    '574' => '(?:85(?:01|55|3[04]))',
    '575' => '(?:85(?:[01]1|[58][58]))',
    '576' => '(?:8501)',
    '577' => '(?:8(?:5(?:11|40|3[37]|0[2359]|5[01458]|8[1258]|6[067]|7[57]|2[0-2])|611))',
    '578' => '(?:85(?:22|55|77|8[58]|0[12]|1[15]))',
    '579' => '(?:850[12])',
    '580' => '(?:8(?:50[1-5]|601))',
    '581' => '(?:8(?:5(?:[08]5|11|39|58)|686))',
    '582' => '(?:85(?:01|55|8[25]))',
    '583' => '(?:85(?:01|22|63|8[0358]|5[058]))',
    '584' => '(?:8(?:5(?:[13]1|22|40|85)|651))',
    '585' => '(?:85(?:01|85|5[05]))',
    '586' => '(?:85(?:[58]5|01|77|2[18]|1[15]))',
    '587' => '(?:85(?:55|8[56]))',
    '589' => '(?:85(?:11|85|0[12]))',
    '590' => '(?:(?:8(?:5(?:[34]0|77|0[13]|2[27-9]|1[17]|6[07]|8[58]|5[01])|686)|0(?:4(?:9[3-6]|8[12])|592)))',
    '591' => '(?:85(?:11|55|0[125]))',
    '592' => '(?:8585)',
    '594' => '(?:(?:850[12]|1198))',
    '595' => '(?:8(?:5(?:85|5[58])|6(?:50|86)))',
    '596' => '(?:8(?:6(?:[25]4|86)|510))',
    '597' => '(?:8(?:5(?:22|43|55|8[58]|0[12]|1[15])|686))',
    '598' => '(?:85(?:[13]1|22|6[06]|0[38]|5[05]))',
    '599' => '(?:(?:0[23]92|8531))',
    '600' => '(?:8(?:5(?:[347]0|1[019]|5[058]|8[1568]|6[67]|0[1-35])|6(?:52|77|86|6[56])|7(?:11|87)))',
    '601' => '(?:(?:85(?:01|50|3[03]|8[58]|1[01])|0(?:292|797)|1(?:192|495)))',
    '602' => '(?:8(?:5(?:[01]1|55|66|70|8[058]|2[05])|611))',
    '603' => '(?:85(?:11|22|55|77))',
    '604' => '(?:8(?:5(?:20|8[058]|7[178]|6[07]|5[01568]|1[01]|0[1-358])|666|798))',
    '605' => '(?:8(?:5[01]1|686))',
    '606' => '(?:8(?:5(?:11|22|36|40|[58][58]|0[1257])|792))',
    '607' => '(?:85[017]1)',
    '610' => '(?:(?:0(?:3(?:80|9[3-6])|19[256]|28[179])|119[2578]))',
    '611' => '(?:85(?:[58]5|01))',
    '612' => '(?:8(?:5(?:[01]1|22|77|85|3[03]|5[058])|6(?:60|77|86)))',
    '613' => '(?:8585)',
    '614' => '(?:85(?:[01]1|88))',
    '615' => '(?:8(?:5(?:[34]0|01|2[02]|5[58]|1[01])|686))',
    '616' => '(?:85(?:[01]1|33|55|66|8[56]))',
    '617' => '(?:8(?:5(?:[01]1|[23]0|66|5[015]|8[58])|66[56]))',
    '618' => '(?:85(?:[28]5|67|70|0[13]|5[58]|1[18]))',
    '619' => '(?:(?:02(?:8[0235-9]|9[25])|1(?:[12]95|393)))',
    '620' => '(?:(?:850[1-8]|149[23]))',
    '621' => '(?:8(?:5(?:[58]5|01)|686))',
    '622' => '(?:(?:0292|8651))',
    '623' => '(?:85(?:01|88))',
    '624' => '(?:8(?:555|686))',
    '625' => '(?:8(?:5(?:[58]5|0[12]|1[01])|666))',
    '626' => '(?:(?:85(?:[07]1|10)|0493))',
    '627' => '(?:8(?:5(?:55|67|70)|688))',
    '629' => '(?:(?:0(?:19[26-8]|39[28])|1192|2498))',
    '630' => '(?:(?:8(?:5(?:3[0356]|2[0289]|8[05-8]|1[28]|6[367]|7[0578]|0[1-3568]|4[038]|5[0258])|6(?:7[07]|[68][68]|5[15]))|0(?:2(?:88|9[23])|192)|2192))',
    '631' => '(?:85(?:[58]5|11|2[23]|0[1-35]))',
    '632' => '(?:(?:8(?:5(?:[14]0|[67]7|8[578]|5[258])|6(?:79|88))|0292))',
    '633' => '(?:(?:8(?:5(?:01|38|85)|686)|0(?:29[28]|39[28])|2[14]92))',
    '634' => '(?:85(?:5[015]|2[1-4]|8[056]|1[01]|6[017]|0[1-35]))',
    '635' => '(?:8(?:5(?:30|85|1[015]|0[128]|2[08])|787))',
    '636' => '(?:(?:0(?:29[2-58]|19[238]|39[238])|8(?:5(?:[358]5|11|0[13])|798)))',
    '637' => '(?:85[01]1)',
    '638' => '(?:(?:85(?:[02]1|10)|0[23]92))',
    '639' => '(?:(?:1(?:0(?:8[0-259]|9[35])|1(?:9[26-8]|8[368]))|2(?:19[578]|29[258])|3(?:192|594)|029[238]))',
    '640' => '(?:(?:8(?:5(?:6[04-7]|7[057]|3[356]|4[04-6]|5[0-25-8]|0[1-3578]|2[0245]|1[0-69]|8[0-2589])|6(?:8[67]|6[68]|5[1-79])|787)|119[26]|0492))',
    '641' => '(?:8(?:5(?:0[189]|1[01])|770))',
    '642' => '(?:8501)',
    '644' => '(?:(?:86(?:55|86)|1292))',
    '645' => '(?:8511)',
    '646' => '(?:(?:8(?:5(?:[01]1|8[058]|4[45]|5[08])|660)|(?:02|1[14])92))',
    '647' => '(?:(?:1(?:294|792)|8555))',
    '648' => '(?:(?:0(?:2(?:8\d|9[2-8])|198|392)|85(?:41|85)))',
    '649' => '(?:(?:6(?:49[2-4]|59[235]|[126]92)|(?:[04]1|35)92|219[2358]|719[245]))',
    '650' => '(?:8(?:5(?:43|1[015]|5[01589]|6[057]|2[128]|3[0369]|8[04-689]|7[0156]|0[125])|6(?:[68][06]|7[07])|7(?:87|94)))',
    '651' => '(?:(?:8(?:5(?:67|70|85|1[12]|2[56])|798)|2(?:1(?:8[07]|9[4-7])|49[24])|01(?:7[0-2578]|9[35]|8[1578])|1195))',
    '652' => '(?:85(?:[17]0|01|85|5[05]))',
    '653' => '(?:85(?:70|85))',
    '654' => '(?:(?:85(?:70|85)|019[2358]))',
    '655' => '(?:8570)',
    '656' => '(?:(?:0(?:59[25]|[14]92|393)|1(?:59[28]|395|792)|8(?:6[568]6|555)|2[2-4]92))',
    '657' => '(?:85(?:01|70))',
    '658' => '(?:85(?:01|70|5[58]))',
    '659' => '(?:85(?:11|0[1-3]))',
    '660' => '(?:85(?:[01]1|4[04]|8[058]|5[58]))',
    '661' => '(?:8(?:5(?:[23]0|01|77|85|6[47]|5[058]|1[01])|661))',
    '662' => '(?:85(?:[34]3|10|21|67|8[056]|5[258]|0[1-35]))',
    '663' => '(?:85(?:[67]7|01|10|45|58|8[568]))',
    '664' => '(?:8(?:5(?:[58]8|33|2[02]|4[05]|0[1-3578]|1[01])|6(?:24|41|50|1[015])))',
    '665' => '(?:8(?:5(?:01|43|67|8[58]|5[05])|665))',
    '666' => '(?:(?:0292|8501))',
    '667' => '(?:(?:8(?:555|651)|0198))',
    '668' => '(?:(?:0(?:29[238]|393)|86(?:66|5[05])))',
    '669' => '(?:(?:3(?:39[24-6]|19[28]|69[23]|892)|5(?:19[2378]|39[258]|292)|6(?:[2578]92|19[25])|2(?:[12]92|397)|159[25]|4[13]92))',
    '670' => '(?:8(?:5(?:43|3[03]|7[057]|8[058]|6[67]|5[0458]|2[024]|1[017]|0[1256])|6(?:8[0289]|7[057]|5[25]|6[068])))',
    '671' => '(?:(?:1(?:2(?:9[235]|8[0-35689])|6(?:92|8[0-248])|1(?:92|8[018])|59[235]|39[23])|2(?:59[2358]|19[238]|28[08])|419[23]|0295))',
    '672' => '(?:8(?:5(?:01|67|85|5[058])|6(?:55|66|77)))',
    '673' => '(?:(?:8(?:5(?:11|58|85)|6[68]6)|1(?:49[3-5]|192|395)|0[45]92))',
    '674' => '(?:8(?:5(?:[58]5|01)|686))',
    '675' => '(?:(?:8(?:5(?:01|22|33|66|77|88|1[019]|5[58])|68[68])|01(?:9[2-468]|8[0-68])|1(?:3(?:80|95)|192|297)|239[358]))',
    '676' => '(?:8(?:5(?:01|33|40|58|66|85|1[03])|6(?:55|7[07]|8[68])))',
    '677' => '(?:851[01])',
    '678' => '(?:(?:1(?:29[257]|19[58])|0(?:19[235]|292)|85(?:43|85)))',
    '679' => '(?:(?:2(?:2(?:9[25]|8[0-589])|392|493)|5(?:3(?:92|8[0-3])|19[28]|292|595)|0(?:1(?:98|8[0178])|29[25])|4(?:19[235]|39[235]|298)|1[12]92|339[23]))',
    '680' => '(?:(?:8(?:5(?:33|41|6[06]|7[0-257]|2[02]|8[58]|0[12]|5[0-5]|1[017])|6(?:[01]1|[34]4|22|66|78|8[68])|701)|0(?:49[235]|197|792)|1192))',
    '681' => '(?:8501)',
    '682' => '(?:(?:8(?:5(?:[58]5|22|0[15])|6[01]1)|0(?:19[2357]|498)))',
    '683' => '(?:8(?:5(?:20|1[0-2568]|0[1-68])|6(?:70|86|0[1-5])))',
    '684' => '(?:8(?:5(?:[01]1|[58]5)|6(?:01|86)))',
    '685' => '(?:8(?:5(?:[58]5|12)|6(?:01|66)))',
    '689' => '(?:(?:2(?:29[2358]|39[235])|(?:[45]2|3[45])92|059[25]|119[23]))',
    '690' => '(?:(?:8(?:5(?:40|77|5[0-2568]|1[0235-9]|6[07]|0[1-57-9]|8[08]|3[0159]|2[0-3568])|6(?:[01]1|7[07]|6[068]|8[68]))|039[36]|219[28]|1492))',
    '691' => '(?:860[12])',
    '692' => '(?:8(?:5(?:[15]0|06)|6(?:01|86)))',
    '693' => '(?:8(?:5(?:01|23|66|3[013]|5[05]|8[57]|1[01])|6(?:01|14|86)))',
    '694' => '(?:8501)',
    '695' => '(?:85(?:77|85|0[125]))',
    '696' => '(?:(?:0(?:19[2358]|393|692)|8510))',
    '697' => '(?:(?:8(?:5(?:01|85|1[12])|686)|0492))',
    '698' => '(?:(?:8(?:50[13-5]|65[01])|0292))',
    '699' => '(?:(?:0(?:5(?:88|9[23])|19[235]|29[23]|49[26]|69[67]|792)|1(?:39[2-6]|29[23]|592|898)|4(?:29[28]|692)|5(?:292|695)|2598))',
    '700' => '(?:8(?:5(?:4[04-69]|0[2-7]|7[0-2578]|3[024589]|5[014-8]|8[015689]|2[2578]|6[0-289]|1[125-9])|6(?:60|86|7[378]|2[01358]|0[13-8]|4[05]|5[57]|3[459]|1[013-9])|7(?:0[167]|2[27]|3[1-48])))',
    '701' => '(?:(?:0(?:19[2-57]|29[25-8]|393)|4(?:39[248]|29[23]|59[23])|1(?:19[25]|29[26])|2(?:292|595)|329[23]))',
    '702' => '(?:8(?:5(?:1[0-25]|0[125-8])|60[1-35-79]))',
    '703' => '(?:8(?:5(?:44|6[06]|3[03]|0[1258]|[58][058]|2[02]|7[03-5]|1[016])|6(?:55|86)|750))',
    '704' => '(?:85(?:10|55|88|0[12]))',
    '705' => '(?:8(?:5(?:10|0[127]|[58][58]|7[57])|6(?:0[239]|1[45])))',
    '706' => '(?:8(?:5(?:01|55|3[13]|1[01])|65[15]))',
    '707' => '(?:85(?:85|0[12]))',
    '708' => '(?:(?:8(?:5(?:20|1[0-25-9]|0[1-35-79])|6(?:09|5[2-47]))|1(?:19[38]|39[23])|0(?:39[23]|698)))',
    '709' => '(?:(?:0(?:49[24-8]|89[23578]|792)|2(?:19[268]|39[38])|3(?:49[478]|198)|(?:12|4[23])92))',
    '710' => '(?:(?:8(?:5(?:11|43|75|8[158]|5[058]|[36][05]|0[15]|2[0258])|6(?:[347]8|[68]6|22|1[15]|0[125]))|029[2-48]|1398))',
    '711' => '(?:8(?:5(?:20|55|88|6[57]|1[01])|6(?:11|22|50|8[68])))',
    '712' => '(?:8(?:5(?:25|77|3[34]|5[058]|8[58]|6[57]|1[1-5]|0[125])|6(?:11|33|86)))',
    '713' => '(?:8(?:5(?:01|50|65|77)|6(?:01|86|6[68])|713))',
    '714' => '(?:(?:8(?:585|601)|129[78]|0192))',
    '715' => '(?:8(?:50[1-3]|60[1-3]))',
    '716' => '(?:(?:8(?:5(?:11|85|0[18])|601)|0(?:192|295|396)|1[13]92))',
    '717' => '(?:8501)',
    '718' => '(?:(?:85(?:[1356]0|01|85)|0392))',
    '719' => '(?:(?:0(?:39[238]|19[25]|295)|3(?:19[2-57]|292)|119[23578]))',
    '720' => '(?:(?:8(?:5(?:55|1[0-2578]|3[156]|2[024-7]|0[1-37-9])|6(?:01|50|4[0135]|3[6-9]))|039[278]|219[25]))',
    '721' => '(?:8(?:5(?:7[5-7]|6[47]|2[28]|8[568]|4[0135]|1[0145]|5[01568]|0[125])|6(?:31|88|0[17])))',
    '722' => '(?:(?:8(?:5(?:10|0[1-35-8])|60[1245])|2(?:19[238]|49[2-4]|392)|1(?:19[23]|[47]92)|039[23]))',
    '723' => '(?:8(?:5(?:01|20|55|1[0-25])|6(?:01|86|1[01])))',
    '725' => '(?:86[68]6)',
    '726' => '(?:8(?:6(?:28|32|1[04]|0[139])|5(?:[15]5|0[125])))',
    '727' => '(?:8501)',
    '728' => '(?:85(?:11|0[1-3]))',
    '729' => '(?:(?:3(?:49[278]|19[23]|592)|0(?:49[25]|292|393)|2(?:39[2-5]|292)|149[23]|4295|5792))',
    '730' => '(?:8(?:5(?:3[0135689]|8[0235-9]|5[1289]|4[0-258]|1[01348]|6[1-356]|0[1-47-9]|7[015-7]|2[0-378])|6(?:7[02578]|4[1-36]|0[13569]|1[0-29]|8[067]|5[0-25-8]|6[126-8]|3[01]|2[026])|7(?:[12]2|87|3[09]|0[167]|9[4-8])))',
    '731' => '(?:(?:0(?:19[2-7]|29[235]|59[235]|692)|3(?:19[2-68]|39[358]|595)|4(?:39[2368]|29[2-4])|1(?:59[57]|795)|519[23578]|219[58]))',
    '732' => '(?:8(?:5(?:6[4-68]|1[0-2]|0[1-57-9])|7(?:65|91)|652))',
    '733' => '(?:8(?:6(?:3[03]|2[1-6]|4[1-36-8]|7[0578]|0[18]|5[01]|6[069]|1[016])|5(?:01|4[0358]|5[0-358]|2[0158]|3[0135]|1[0-4])|701))',
    '734' => '(?:8(?:5(?:[37]0|22|43|58|6[07]|1[035])|798))',
    '735' => '(?:8(?:5(?:01|10|55|77|88)|6(?:70|86)))',
    '736' => '(?:8(?:5(?:55|0[124-9])|60[12]))',
    '737' => '(?:(?:8(?:5(?:20|54|77|0[1-9]|1[0236-8])|6(?:09|11|86|5[0-3]))|2(?:29[235]|19[35]|39[23])|01(?:82|9[23578])))',
    '738' => '(?:(?:8(?:5(?:12|0[1-9])|60[1-3])|0292))',
    '739' => '(?:(?:8(?:5(?:01|30|1[1-4]|2[124-9])|6(?:0[1-3]|1[56]))|0(?:4(?:81|9[24-7])|69[23568]|19[238]|59[25])|1(?:79[2-4]|19[25]|29[23])|2(?:49[248]|69[235])))',
    '740' => '(?:8(?:5(?:[58]5|01|67|3[35]|1[016])|6(?:11|39|86|4[26])))',
    '741' => '(?:8585)',
    '742' => '(?:(?:8(?:6(?:88|6[69]|2[25]|0[58]|4[56])|5(?:55|76|1[01])|7(?:14|87))|1(?:19[2-6]|59[28]|398)|0[34]92|219[23]))',
    '743' => '(?:(?:85(?:[15]0|77|0[12])|019[23]))',
    '744' => '(?:8(?:5(?:21|85)|6[01]1))',
    '745' => '(?:(?:8(?:6(?:[68]6|01|22|48|1[13]|5[56])|5(?:10|47|85|6[67]|2[29]))|069[68]))',
    '746' => '(?:8(?:6(?:01|66)|501))',
    '747' => '(?:(?:8(?:5(?:11|22|55|67|0[19]|8[58])|6(?:11|22|86))|[01]292))',
    '749' => '(?:0195)',
    '750' => '(?:(?:8(?:5(?:0[1-8]|2[0145]|1[0-3578])|6(?:10|0[1-378]))|069[23]|119[23]))',
    '751' => '(?:8(?:5(?:10|0[38])|650))',
    '752' => '(?:8(?:5(?:01|85|5[58]|1[01])|60[19]))',
    '753' => '(?:(?:8(?:5(?:40|88|7[07]|5[58]|1[0-57-9]|0[1-46-9]|3[0-8]|2[0-25689])|65[034])|029[23]))',
    '754' => '(?:(?:8(?:5(?:[358]5|[01]1|22)|6(?:01|1[01]))|1(?:19[23]|292)|0291))',
    '755' => '(?:(?:8(?:5(?:22|43|77|8[058]|6[067]|1[01]|5[0457]|0[125])|6(?:33|42|0[19]|2[25]|1[01]))|019[25]))',
    '756' => '(?:8(?:5(?:85|0[12])|60[12]))',
    '757' => '(?:(?:8(?:5(?:11|85)|6(?:34|86))|029[28]))',
    '758' => '(?:8(?:6(?:15|86|4[58])|5(?:[58]5|70)))',
    '759' => '(?:(?:(?:22|55)92|029[2357]|419[2468]|659[25]))',
    '760' => '(?:8(?:5(?:1\d|0[1-578]|5[0-2457-9]|[36][0-246-9]|4[4-7]|2[0-3578]|8[0-8]|7[0-69])|6(?:71|6[0178]|3[04689]|5[05]|[14][48]|2[013-6]|8[06-8]|0[13478])))',
    '761' => '(?:(?:0(?:1(?:8[5-9]|9[2-8])|39[3-7]|79[35]|[46]92)|4(?:4(?:89|9[2-8])|3(?:88|9[235-8])|19[2-5])|8(?:5(?:[014]1|33|77|8[25689]|6[67]|5[58])|601)|1(?:79[2-5]|49[2-4]|592)|2(?:39[2356]|49[23])))',
    '762' => '(?:8(?:5(?:1[015]|0[23578])|60[12]))',
    '763' => '(?:8(?:5(?:1[0-268]|0[1-478])|60[358]))',
    '764' => '(?:85(?:20|0[1-3578]|1[01]))',
    '765' => '(?:850[1-35-8])',
    '766' => '(?:850[12])',
    '767' => '(?:85(?:07|85|1[0-3]))',
    '768' => '(?:(?:8(?:50[12]|60[12])|019[25]))',
    '769' => '(?:(?:2(?:7(?:88|9[24-6])|69[2356]|19[235]|[349]92)|1(?:6(?:89|9[4-68])|192|593)|0(?:19[2-578]|29[2356])))',
    '770' => '(?:8(?:5(?:5[025]|7[0-3]|0[1-9]|1[0-468]|2[0-689]|4[0146-8]|8[58]|6[0357]|3[0-35689])|6(?:10|48|0[15])|7(?:87|9[48])))',
    '771' => '(?:(?:0(?:1(?:8[235-9]|9[2-68])|2(?:8[57-9]|9[2-68]))|1(?:2(?:89|9[24578])|49[2-48]|[357]92|19[23]|695)|(?:33|2[135]|4[13]|5[24])95|6(?:192|495)))',
    '772' => '(?:8(?:5(?:20|1[015]|0[1-35])|601))',
    '773' => '(?:8(?:50[124]|601))',
    '774' => '(?:8[56]01)',
    '775' => '(?:(?:0[235]95|8570))',
    '776' => '(?:8(?:5(?:01|55|8[2358])|6(?:11|86)))',
    '777' => '(?:0395)',
    '778' => '(?:(?:850[13-7]|0[12]95))',
    '779' => '(?:(?:3(?:39[3-5]|[4-6]95|29[58])|1(?:29[235]|19[58])|4(?:[178]95|49[56])|(?:53|2[13])95|019[2-5]))',
    '780' => '(?:8(?:5(?:4[01458]|0[15-79]|6[0-26-8]|5[04689]|3[02-578]|2[0135-9]|1[0-8]|7[0-27])|6(?:66|7[5-7]|8[02-8]|0[125])))',
    '781' => '(?:(?:5(?:19[25]|29[25]|79[23]|495)|85(?:21|43|60|1[015]|5[125])|(?:03|42|1[158])92|2(?:19[2-4]|492)|3(?:49[23]|692)|7185))',
    '782' => '(?:8502)',
    '783' => '(?:85(?:55|0[125-9]))',
    '784' => '(?:850[135])',
    '785' => '(?:(?:8(?:5(?:[256]0|[01]1|33|85|7[04-8])|6(?:01|50))|0[156]95))',
    '786' => '(?:(?:0393|8501))',
    '787' => '(?:(?:0[38]92|8501))',
    '788' => '(?:8(?:501|686))',
    '789' => '(?:(?:1(?:[29]92|795)|0392))',
    '790' => '(?:8(?:5(?:4[0-356]|7[013-578]|9[05]|6[015-7]|2[04589]|1[0-4679]|3[0-79]|5[1-7]|8[013-9]|0[1-3589])|6(?:32|6[015-7]|7[078]|8[68]|5[0-35689])|7(?:87|9[135-8])))',
    '791' => '(?:(?:8(?:5(?:51|2[3-578]|1[0-36-8]|3[01568]|0[125-8])|6(?:0[34]|7[1257]))|0(?:2(?:8[018]|9[257])|3(?:85|9[23578])|59[34])|3(?:19[2-8]|29[235]|[35]92)|(?:45|1[17])92|219[135]))',
    '792' => '(?:8(?:5(?:43|67|1[018]|8[0568]|5[05]|2[01]|0[15])|6(?:14|70|86)))',
    '793' => '(?:8(?:5(?:[58]5|0[19]|1[05])|601))',
    '794' => '(?:(?:8(?:5(?:82|1[018]|0[28])|6(?:0[1278]|1[14]))|2(?:39[25]|59[23]|[12]92)|1(?:39[23]|[14]92)|019[23]))',
    '795' => '(?:(?:8(?:5(?:0[124-8]|1[01])|60[1-3])|0392))',
    '796' => '(?:(?:0(?:29[235]|495|892)|850[12]))',
    '797' => '(?:(?:(?:02|1[257])92|85[01]1))',
    '798' => '(?:(?:8(?:6(?:01|1[14])|51[01])|4(?:19[2-7]|292|495)|1(?:39[2357]|192)|3(?:39[23]|792)|2192))',
    '799' => '(?:(?:1(?:5(?:8[128]|9[2-68])|39[2-5]|198|692)|2(?:49[2356]|29[2-4]|19[25]|39[23]|69[26])|0(?:19[2-7]|49[235-8])|3(?:19[2-6]|79[23]|292)))',
    '800' => '(?:(?:0(?:2(?:9[3-8]|8[1-48])|39[2-6])|8(?:5(?:10|85|5[05])|6(?:11|86|0[13]))))',
    '801' => '(?:8(?:5(?:85|5[05]|0[237]|1[01])|601))',
    '802' => '(?:8(?:5(?:8[015]|3[34]|2[124]|1[0-25]|6[067]|[45][05]|0[18]|7[017])|6(?:42|51|77|86|0[14])|701))',
    '803' => '(?:8(?:5(?:20|43|3[0-35]|6[17]|5[058]|8[068]|1[0-357]|0[1458])|6(?:02|30|86|6[06])|787))',
    '804' => '(?:8(?:5(?:[12]0|77|88|0[135]|3[89]|5[058])|601))',
    '805' => '(?:8(?:5(?:[58]5|3[013-689]|2[0178]|0[1357-9]|1[02-468])|6(?:06|25)))',
    '806' => '(?:8(?:5(?:67|70|4[03]|0[19]|5[58]|1[01]|8[56])|6(?:[68]6|79|1[12])))',
    '807' => '(?:(?:85(?:01|8[568]|5[56])|019[28]|1392))',
    '808' => '(?:(?:8(?:5(?:02|1[045]|5[058]|8[58])|606)|0196))',
    '809' => '(?:8501)',
    '810' => '(?:8(?:5(?:3[0-357-9]|7[0-2578]|1[1-9]|5[135-8]|2[0-578]|0[1-46-9]|8[13-57-9]|6[0135-8]|4[0-6])|6(?:5[0-7]|4[28]|6[02-79]|3[01346-8]|1[0179]|8[35689]|0[13-9]|2[0-2579]|7[035-8])|7(?:98|2[0-257]|0[17]|3[14]|1[06-8])))',
    '811' => '(?:(?:2(?:29[2-578]|49[256]|19[23]|39[28]|592)|3(?:19[23578]|29[3568]|492|598)|4(?:19[2358]|39[23]|292)|1(?:39[2-57]|29[28])|0(?:19[2356]|295)|5192))',
    '812' => '(?:(?:8(?:6(?:6[023689]|1[13-578]|4[0-24-68]|2[024-689]|5[0-689]|0[1-35689]|7[0-246-9]|3[0-36-9]|8[013-9])|5(?:5[0-35-79]|2\d|7[03-7]|4[1-8]|3[0-36-9]|0[13-57-9]|1[0-5]|8[0-24-9]|6[024-8])|7(?:1[0-278]|0[35-9]|9[24]))|95(?:11|20|8[89]|0[235]|5[12])))',
    '813' => '(?:8(?:5(?:29|33|68|1[39]|7[78]|0[13]|8[58])|6(?:2[36]|8[01])))',
    '814' => '(?:(?:8(?:5(?:77|0[135]|2[0-25]|5[03-68]|6[57]|8[589]|1[0-2])|6(?:02|51)|798)|01(?:80|9[238])))',
    '815' => '(?:8(?:5(?:11|33|88|4[06]|0[13]|2[09]|5[05])|6(?:[68]6|01)))',
    '816' => '(?:8(?:5(?:[13]0|[67]7|01|[58][05])|666))',
    '817' => '(?:(?:1(?:[26]92|797)|85(?:20|1[07])))',
    '818' => '(?:(?:8(?:5(?:34|55|67|0[1-3]|1[69]|7[178]|4[09]|8[58])|6(?:42|86|6[68]))|019[2-578]))',
    '819' => '(?:(?:85(?:11|33|85|5[0-258]|0[124])|1(?:19[235]|[36]92)|0(?:39[25]|192)))',
    '820' => '(?:(?:8(?:5(?:[24]0|33|55|1[02367]|0[125-8])|60[1-357])|0(?:[2357]92|69[36]|193)|119[23]))',
    '821' => '(?:8501)',
    '822' => '(?:(?:1(?:29[236]|19[23]|492)|8(?:5(?:[58]5|01)|666)))',
    '823' => '(?:8555)',
    '824' => '(?:(?:8(?:5(?:55|1[01])|6[01]1)|0(?:[128]92|695)))',
    '825' => '(?:8(?:5(?:[67]7|01|8[58])|601))',
    '826' => '(?:8(?:5(?:[58]5|29|67)|609))',
    '827' => '(?:8501)',
    '828' => '(?:8501)',
    '829' => '(?:039[23])',
    '830' => '(?:(?:8(?:5(?:67|0[135]|3[03]|4[013]|1[0-25]|7[07]|8[358]|5[58]|2[0-2])|6(?:77|6[6-8]|0[1-36]|1[12]|2[29]|8[68]|3[01]))|1(?:19[2356]|29[258])|65(?:28|87)|0[12]92))',
    '831' => '(?:8(?:6(?:01|86)|501))',
    '832' => '(?:8(?:555|601))',
    '833' => '(?:8601)',
    '834' => '(?:(?:0(?:19[2-68]|292)|1[24]92|85[58]5))',
    '835' => '(?:(?:8[56]01|0192))',
    '836' => '(?:8(?:5(?:77|3[134]|0[25]|1[02]|6[67]|8[58]|5[56])|6(?:10|66|8[06])))',
    '837' => '(?:8501)',
    '838' => '(?:(?:8(?:6(?:[68]6|77|0[12])|5(?:85|1[25]))|1(?:39[78]|79[23]|[56]92)|0(?:19[378]|298)))',
    '839' => '(?:(?:1(?:39[3-6]|49[378]|298)|85(?:40|0[1258])|029[235]))',
    '840' => '(?:(?:8(?:5(?:[246]0|11|5[0-258]|8[058]|0[12]|7[01])|6(?:[01]1|27|66|8[689]))|2(?:19[2357]|295)|0(?:292|598)|1192))',
    '841' => '(?:8(?:6(?:11|86|0[12])|5(?:[01]1|85)))',
    '842' => '(?:(?:8(?:5(?:85|0[12])|601)|0(?:19[2357]|29[23])))',
    '843' => '(?:(?:8(?:5(?:01|8[58]|5[05])|6(?:39|86))|039[2-4]))',
    '844' => '(?:8(?:6(?:25|0[12]|1[56])|5(?:[58]5|01)))',
    '845' => '(?:85(?:01|1[01]))',
    '846' => '(?:8501)',
    '847' => '(?:(?:8(?:5(?:11|88)|601)|0(?:19[23]|39[23])|1292))',
    '848' => '(?:(?:0492|8501))',
    '849' => '(?:(?:85(?:14|22|77|0[1-3]|[58][58])|1(?:[124]92|39[24]|698)|3(?:19[23]|29[23])|419[2-5]|239[235]|519[238]|059[27]))',
    '850' => '(?:8(?:5(?:2[0-35]|8[0568]|1[0-258]|7[057]|5[0158]|0[13-8]|6[0367]|3[0167]|4[013578])|6(?:22|45|7[78]|1[018]|5[02]|6[268]|8[5-8]|0[236])))',
    '851' => '(?:(?:0(?:49[2-478]|19[358]|39[25]|592)|2(?:1(?:85|9[5-8])|29[28]|492)|3(?:39[24]|[25]92)))',
    '852' => '(?:8(?:5(?:32|66|77|88|1[015]|0[17-9]|4[24]|5[58]|2[0-378])|601|794))',
    '853' => '(?:(?:8(?:50[12]|601)|(?:06|2[23])92))',
    '854' => '(?:(?:8(?:5(?:40|55|0[19])|6(?:01|50|66))|0(?:69[26-8]|59[235]|[24]92)))',
    '855' => '(?:8(?:5(?:01|5[05])|686))',
    '856' => '(?:8(?:5(?:[58]5|16|77|6[018])|6(?:70|86|0[19])))',
    '857' => '(?:(?:8(?:5(?:33|58|66|0[1-38]|8[58]|7[57]|1[01])|6(?:[68]6|11))|2(?:49[24]|392)|4(?:495|592)|119[23578]|0[134]92))',
    '858' => '(?:85(?:01|55|8[0589]))',
    '859' => '(?:(?:3(?:79[2378]|29[238]|692)|0(?:49[2578]|19[23])|(?:1[2-5]|6[24])92|4(?:59[5-8]|892)|5(?:39[23]|192)))',
    '860' => '(?:8(?:5(?:4[1357]|3[0149]|7[057]|8[04-8]|0[1-47-9]|6[15-8]|5[0-24-8]|2[0-578]|1[0-8])|6(?:55|2[245]|8[168]|1[159]|0[1-68]|6[08])|79[157]))',
    '861' => '(?:(?:0(?:59[2-68]|19[58]|69[28]|89[28]|[39]92)|1(?:19[23578]|39[24]|295)|4(?:19[23578]|[34]92|696)|3(?:19[24-6]|29[56]|592)|2(?:29[235-7]|[14]92)|85(?:01|14|38|2[089])|5(?:49[2-5]|59[28])|6[13]95|7292))',
    '862' => '(?:8(?:6(?:6[06]|7[6-8]|2[02]|3[35]|0[139]|1[0-2]|8[08]|5[125])|7(?:20|44|1[06]|9[34]|0[12])|5(?:[127]0|0[258])))',
    '863' => '(?:(?:8(?:6(?:31|86)|5[58]5)|2(?:292|895)|1992))',
    '864' => '(?:8(?:6(?:11|86)|501))',
    '865' => '(?:(?:85(?:[01]1|33|77|5[05])|019[23]))',
    '866' => '(?:(?:8(?:5(?:[58]5|33|0[1-3]|1[01])|6(?:60|86|0[125]))|0(?:29[235]|195)))',
    '867' => '(?:85(?:[58]5|01))',
    '868' => '(?:(?:8(?:5(?:55|1[15]|0[1-358])|601)|0(?:59[23578]|39[23]|795)))',
    '869' => '(?:(?:0(?:19[238]|29[235]|49[2-4]|59[238]|696)|2(?:59[2358]|69[2356]|49[23])|1(?:29[2358]|19[237])|5(?:39[23]|498|692)|3(?:296|692)|4292))',
    '870' => '(?:(?:8(?:5(?:41|70|85|0[1-6]|5[158]|2[13-5]|1[0138]|3[238]|6[02-4])|6(?:46|58|[78][6-8]|1[169]|3[4-6]|2[07]|6[05]|0[15]))|0(?:1(?:89|9[2-8])|39[235-8]|292|401)|1(?:19[258]|292)))',
    '871' => '(?:(?:8(?:5(?:21|77|85|5[05]|0[12]|1[01])|6(?:[02]9|42|66|8[68]))|0(?:99[23]|[27]95|192)))',
    '872' => '(?:0592)',
    '873' => '(?:(?:0(?:29[238]|498)|8501))',
    '874' => '(?:8(?:5(?:[01]1|[67]7|8[58]|5[578])|6(?:11|39|86|6[06])))',
    '875' => '(?:(?:8(?:6(?:86|1[26])|501)|0292))',
    '876' => '(?:(?:8(?:5(?:55|8[05])|6(?:01|66))|2492))',
    '877' => '(?:(?:8(?:5(?:01|55)|6(?:01|86))|0(?:39[23]|296)|1292))',
    '878' => '(?:8555)',
    '879' => '(?:(?:5(?:19[235-8]|59[235]|498)|4(?:49[28]|[26]92|194|895)|0(?:49[2358]|692)|6(?:69[235]|192)|159[258]|719[28]|2692))',
    '880' => '(?:(?:8(?:5(?:7[05-7]|4[3-6]|2[02357]|1[0-357-9]|8[01368]|3[02359]|6[167]|5[015-9]|0[1-57-9])|6(?:[25]5|10|49|3[39]|0[124-6]|6[68])|725)|1(?:19[2-6]|39[278])|029[3-578]|229[23]))',
    '881' => '(?:85(?:01|67))',
    '882' => '(?:(?:8(?:6(?:11|66|78|8[68])|5(?:85|0[38]))|1(?:29[3-5]|192)|0192))',
    '883' => '(?:(?:85(?:01|10|33|55|8[58])|(?:01|13)92))',
    '884' => '(?:86(?:01|55|66))',
    '885' => '(?:(?:8(?:5(?:11|33|55|67|8[58]|0[12])|6(?:01|36|1[018]))|129[258]))',
    '886' => '(?:(?:8(?:5(?:20|88|0[1-35-7]|1[0-2])|6(?:11|0[12]))|0[12]92))',
    '887' => '(?:8(?:585|686))',
    '888' => '(?:8555)',
    '889' => '(?:(?:1(?:49[2358]|69[2356]|99[4-7]|[18]92|795)|0(?:69[235-8]|59[25]|[13]92)|(?:4[2-5]|2[14])92))',
    '890' => '(?:8(?:5(?:6[05-7]|1[0-2578]|3[0-25]|8[015689]|4[013-5]|0[1-8]|2[0-57]|5[0258]|7[014578])|6(?:10|66|0[13])|79[48]))',
    '891' => '(?:(?:0(?:1(?:8\d|9[2-8])|49[378]|[67]92)|3(?:19[2-68]|69[23]|79[23])|1(?:39[2-5]|[15]92)|9(?:29[2-6]|192)|(?:[46]2|7[16])92|2(?:39[36]|192)|8293))',
    '892' => '(?:8(?:5(?:20|4[03]|8[0568]|1[25]|5[058]|6[367]|0[125]|3[0-359])|6(?:[24]6|11|33|50|77|88|0[13])))',
    '893' => '(?:(?:1(?:19[28]|69[23]|298)|8(?:5(?:10|0[12])|611)|(?:02|2[34])92))',
    '894' => '(?:(?:8(?:5(?:11|67|0[17]|[58][58])|6(?:01|55|66|77|8[68]))|(?:3[13]|1[25])92|0(?:192|595)))',
    '895' => '(?:(?:8(?:5(?:40|55|88|0[1-6]|1[59])|6(?:01|50|86))|1(?:29[2356]|49[23]|595)|229[28]|0292))',
    '896' => '(?:(?:1(?:[13]92|696)|86(?:01|86)))',
    '897' => '(?:(?:039[23]|8501))',
    '898' => '(?:8501)',
    '899' => '(?:(?:5(?:29[2-4]|69[348]|19[23]|49[25]|392)|6(?:49[2-5]|19[23]|29[23]|592)|(?:3[14]|7[146]|8[16])92|2(?:59[2-6]|[127]92)|4(?:39[2-6]|[12]92)|0(?:29[23578]|492)|1(?:395|498|696)))',
    '900' => '(?:8(?:5(?:4[03-57]|5\d|2[02457]|8[1568]|0[13-57]|6[07]|3[03-5]|7[0178]|1[0-467])|6(?:10|66|78|5[0146]|0[1-59]|8[68])|7(?:[01]1|9[5-7])))',
    '901' => '(?:(?:2(?:5(?:40|88|97|6[0679]|0[1268]|1[0-25]|5[0-35-9]|3[014]|2[0156])|6(?:86|0[127]|1[01])|7(?:01|10|33)|49[2356]|39[25])|0(?:49[2-6]|29[2-5]|19[2-4]|39[23]|592|695)|3(?:[679]92|19[23]|59[25]|496|895)|1(?:19[2356]|39[23]|[24]92|595)))',
    '902' => '(?:85(?:21|8[58]|5[05]|[17][01]))',
    '903' => '(?:(?:02(?:20|1[013-578]|0[13-7])|860[1-3]))',
    '904' => '(?:(?:0(?:19[2-5]|39[2-5]|49[2-46]|29[35])|2(?:19[2-6]|39[2-4]|29[23])|1(?:29[2-4]|[13]92)|85(?:[01]1|85)))',
    '905' => '(?:(?:0(?:59[2-6]|79[2-6]|[24]92|695)|8(?:5(?:01|12|40|85)|6(?:11|68))|1(?:[23]92|495)|2192))',
    '906' => '(?:(?:0[256]92|8[56]01))',
    '907' => '(?:(?:850[1-3]|1[28]92))',
    '910' => '(?:(?:8(?:5(?:3[0235-9]|8\d|4[013-58]|0[1-47-9]|5[0-57-9]|1[0-79]|6[0-24-8]|2[0-8]|7[15689])|6(?:22|30|6[0568]|0[136]|5[05]|8[068]|7[08]|1[01])|730)|1(?:19[2-5]|29[2-5]|392)|0(?:29[236-8]|39[23])|(?:23|3[56])92|419[35-8]))',
    '911' => '(?:8(?:5(?:[03]1|[14]0|88|5[58])|601))',
    '912' => '(?:(?:8(?:5(?:[58]5|24|40|67)|6[68]6)|0292))',
    '913' => '(?:8(?:5(?:[01]1|33|55|77|8[58])|611))',
    '914' => '(?:(?:8(?:5(?:[14]0|24|67|5[058]|8[05]|0[12])|6(?:09|66|8[68]))|019[258]))',
    '915' => '(?:(?:8(?:5(?:[58]5|01|3[03]|1[01])|666)|0292|1195))',
    '916' => '(?:(?:8(?:5(?:67|5[058]|8[58]|1[05]|0[1578])|6(?:[468]6|01))|0(?:29[235]|[14]92)|1198))',
    '917' => '(?:(?:8(?:5(?:[24]4|33|77|6[17]|5[058]|1[12]|0[57]|8[0458])|6(?:01|86))|0(?:29[2378]|39[38]|198)))',
    '918' => '(?:8(?:5(?:4[03]|5[0568]|6[05-8]|1[0158]|7[0578]|2[0235]|3[037]|0[1-358]|8[03568])|68[168]))',
    '919' => '(?:(?:0(?:59[24578]|69[2578]|[124]92|898)|1(?:39[235-7]|[15]92)|2(?:29[2-4]|392)))',
    '920' => '(?:(?:8(?:5(?:0[1-9]|2[0-25]|3[0135-9]|4[014]|7[0357]|1[0-3578]|5[0-46-8]|6[0135-8]|8[035-8])|6(?:0[125-79]|7[0146-8]|2[01356]|8[01568]|5[4-8]|4[0-248]|3[01378]|6[0156]|1[0-69])|7(?:[67]7|30|0[137]|9[13-7]|2[0-289]|1[0189]))|0(?:3(?:8[135-8]|9[23568])|29[235]|192)|1(?:1(?:92|8[0-245])|39[2367])|2(?:39[2-5]|19[256])|3198))',
    '921' => '(?:8(?:5(?:5[0257]|4[14689]|3[0-269]|7[1-9]|2[02-79]|0[15-8]|8[0-47-9]|6[0-2457]|1[0-257-9])|6(?:01|3[079]|1[126]|[25][01])|798))',
    '922' => '(?:(?:8(?:5(?:01|30|66|2[25]|8[58]|5[05]|1[01])|6(?:09|11|22|50|78|86))|0(?:29[2-578]|19[23]|49[57]|595)))',
    '923' => '(?:(?:8(?:5(?:5[0-257]|8[0168]|3[013]|2[0158]|0[1-357]|6[067]|7[078]|4[14-6]|1[01])|6(?:50|66|2[06]|1[156]|4[2-46]|8[68]|0[135689]|3[039]))|1(?:29[2-7]|198)|039[238]))',
    '924' => '(?:8(?:5(?:01|22|33|44|66|77|8[058]|5[58]|1[01])|68[68]))',
    '925' => '(?:(?:8(?:5(?:30|85|6[67]|5[05]|0[1-3568]|2[15]|1[01])|6(?:[12]0|09|88))|0(?:19[38]|392|498)))',
    '926' => '(?:(?:8(?:5(?:[013]1|20|66|4[015]|8[568]|5[058])|6(?:[68]6|42|50|1[01]|0[1-359]))|0(?:29[23]|192)))',
    '927' => '(?:(?:0(?:49[235]|29[23]|695)|129[57]|219[23]|8601))',
    '928' => '(?:(?:8(?:5(?:[28]5|41|0[12])|609)|039[235]))',
    '929' => '(?:(?:1(?:39[2-7]|19[23568]|49[2-4]|[6-8]92|29[23])|0(?:49[2-5]|19[238]|29[26]|39[23])|2(?:19[25]|[23]92)))',
    '930' => '(?:(?:8(?:5(?:0[12457-9]|3[0-25-9]|4[03-58]|[26][0-256]|8[0135-9]|1[0-35-8]|7[078]|5[024-68])|6(?:11|44|5[06]|0[34]|3[67]|6[078]|8[016])|798)|0(?:19[3-68]|39[3-57]|29[238])|1(?:29[258]|392)|2198))',
    '931' => '(?:8(?:5(?:33|62|2[23]|4[03]|7[17]|0[128]|[58][58]|1[0157])|6(?:01|88)))',
    '932' => '(?:(?:8(?:5(?:33|40|75|1[0-258]|5[0158]|6[27]|8[58]|0[1-358]|2[0258])|611)|0(?:39[23568]|19[38]|29[28])))',
    '933' => '(?:(?:8(?:5(?:4[03]|0[1268]|6[367]|8[58]|1[01568]|3[0-3578]|5[08]|2[035-8])|6(?:[28]8|66|0[1-356]|1[01])|7(?:77|88))|0(?:39[235-7]|19[235]|29[235])))',
    '934' => '(?:8(?:5(?:22|77|6[78]|3[14]|[58][058]|0[12]|1[15])|6(?:[15]1|8[68])))',
    '935' => '(?:(?:8(?:5(?:[01]1|55|3[15])|6(?:01|86))|0492))',
    '936' => '(?:8(?:5(?:36|77|0[127]|[58][58])|6(?:86|0[18])))',
    '937' => '(?:8(?:5(?:[58]5|03|11|6[67])|6(?:01|60|78)))',
    '938' => '(?:(?:8(?:6(?:1[0-3]|0[12])|5(?:[58]5|0[25]))|029[23]))',
    '939' => '(?:(?:8(?:5(?:21|67|0[127]|[58][058]|1[0157]|7[12])|6(?:01|50|3[06]|4[02]|1[01]))|1(?:39[2-578]|89[23578]|59[2356]|69[2-48]|19[23]|99[78]|492)|0(?:29[2-6]|39[2358]|79[2358]|[15]92|693)|2(?:29[23578]|39[238]|69[24]|192|595|798)|3593))',
    '940' => '(?:(?:8(?:5(?:32|67|7[027]|2[12]|0[18]|5[0458]|1[01]|8[03568])|6(?:41|60|86|3[013]|5[0134]|0[235]|[12][0-2])|707)|2(?:1(?:8[1-8]|9[258])|08[1-358]|392)|029[2-8]|119[3-68]))',
    '941' => '(?:8(?:6(?:[01]1|86)|50[12]))',
    '942' => '(?:(?:8(?:5(?:88|0[1258])|6(?:[01]1|66))|0(?:19[2-6]|39[238]|492)|1492))',
    '943' => '(?:(?:8(?:5(?:61|4[04]|3[0134]|[12][0-25]|5[15]|0[1-358])|6(?:1[06]|0[147]))|0(?:19[23]|595|692)))',
    '944' => '(?:(?:8(?:5(?:01|88|5[05])|6(?:01|86))|0192))',
    '945' => '(?:(?:8(?:5(?:[01]1|[38]5|5[58])|6(?:[01]1|88))|1(?:39[3578]|[15]95)|0(?:19[34]|39[57])))',
    '946' => '(?:(?:8(?:5(?:55|1[13])|601)|0292))',
    '947' => '(?:(?:8(?:5(?:[58]5|0[1-46])|765)|019[238]))',
    '948' => '(?:(?:8(?:50[1-4]|602)|0192))',
    '949' => '(?:(?:7(?:49[24-6]|39[2-4]|59[24]|277)|3(?:29[2-468]|19[2-4]|494)|6(?:69[256]|[124]92|797)|4(?:19[2-4]|392)|5(?:49[2-4]|292)|039[23]|239[24]|8492))',
    '950' => '(?:(?:8(?:5(?:20|6[05-7]|0[1-57]|7[0-25-79]|4[013-5]|5[0135-9]|1[489]|3[0-479]|8[0-35689])|6(?:6[018]|2[0-269]|0[1-368]|5[0145]|7[078]|4[01]|8[016]|[13][039])|7(?:09|5[013589]|2[0-3]|3[023578]|1[01578]|4[014-9]|9[48])|801)|2(?:0(?:8[124-9]|9[235-7])|1(?:8[18]|9[258])|292)|1(?:1(?:9[2-7]|8[1-8])|29[2-8]|49[258])|0(?:19[23568]|292)|3(?:19[58]|393)))',
    '951' => '(?:8(?:5(?:3[0136]|4[045]|7[07]|5[0-256]|6[067]|8[01568]|0[1-68]|1[0-24589]|2[0-28])|6(?:01|3[23]|8[056]|5[05]|2[029]|1[0-2]|[67][68])))',
    '952' => '(?:(?:1(?:59[23]|292|393)|850[12]))',
    '953' => '(?:(?:8(?:6(?:66|0[12])|501)|019[23]))',
    '954' => '(?:(?:86(?:19|86)|019[25]))',
    '955' => '(?:(?:8(?:5(?:43|67|0[13]|5[058]|8[58]|7[57]|1[01])|6(?:66|0[1-3]|7[78]|5[45]|1[126]|8[68])|765)|0192))',
    '956' => '(?:(?:860[1-3]|0192))',
    '957' => '(?:(?:8(?:5(?:[34]0|11|22|67|5[058]|8[58]|0[236])|6(?:[68]6|01))|0(?:19[237]|293)))',
    '958' => '(?:(?:8(?:5(?:01|33|85|5[58])|6(?:01|86))|0292))',
    '959' => '(?:(?:0(?:29[2-6]|19[2-5]|59[235]|39[23]|492)|1(?:29[23568]|39[2357]|69[235]|79[457])|2(?:39[357]|09[23]|292|693|711)|3(?:19[2-46]|49[23]|292|993)|4(?:49[57]|392)))',
    '960' => '(?:(?:8(?:5(?:75|4[06]|0[1-35-8]|1[1258]|8[014589]|5[058]|6[067]|3[0146]|2[0-4])|6(?:48|3[39]|2[056]|7[07]|0[1-357]|6[068]|1[014]|8[68]|5[15]))|0(?:2(?:8[0239]|9[46-8])|1(?:9[245]|8[0145])|69[25]|596|992)|1(?:19[235-8]|29[235-7]|39[23]|[48]92)|2(?:19[3-6]|292)))',
    '961' => '(?:(?:8(?:5(?:22|1[16]|8[58]|0[18])|6(?:11|86|0[12]))|0[134]92))',
    '962' => '(?:(?:8(?:50[1-37-9]|601)|0[2356]92))',
    '963' => '(?:(?:8(?:5(?:20|4[03]|0[1-36-8]|[13][01359]|6[0346-8]|7[0578]|5[01568]|8[03568])|6(?:[24]2|55|8[569]|7[05-7]|6[014-68]|3[07]|0[129]|1[01])|292|794)|4(?:39[368]|[16]92)|(?:6[1-3]|3[46])92|0(?:19[25-8]|296)|5(?:49[23]|[16]92)|7(?:796|893)|138[036-8]))',
    '964' => '(?:(?:8(?:5(?:[67]7|01|58)|601)|0[23]92))',
    '965' => '(?:8(?:5(?:[34]0|67|[58][058]|2[02]|0[1-356]|7[07]|1[016])|6(?:[01]1|78)))',
    '966' => '(?:(?:0(?:19[2-4]|485)|8601))',
    '967' => '(?:8501)',
    '968' => '(?:0498)',
    '969' => '(?:(?:1(?:1(?:8[0168]|9[235])|[2-46]92|79[23])|6(?:19[256]|59[23]|292|495)|3(?:39[236]|59[2-4]|192)|0(?:29[26]|[34]92|197)|4495))',
    '970' => '(?:(?:8(?:6(?:[23]5|[48]6|11)|5(?:[05]1|1[16]))|119[2-4]))',
    '971' => '(?:8615)',
    '972' => '(?:85(?:01|55))',
    '973' => '(?:8(?:5(?:01|55)|601))',
    '974' => '(?:8(?:577|686))',
    '975' => '(?:8(?:585|686))',
    '976' => '(?:85(?:01|10))',
    '979' => '(?:(?:2(?:39[2-4]|195|792)|1(?:[135]92|495)|0(?:69[56]|192)))',
    '980' => '(?:(?:8(?:4(?:66|5[2-468]|7[78]|8[014-68]|4[023578]|2[0369]|1[0145]|3[013569]|0[1-358])|5(?:1[015]|4[3-6]|8[01358]|5[05]|3[13-5]|7[01457-9]|6[0156]|0[15]|2[069])|6(?:40|5[0-26]|6[018]|0[1258]|3[1-36-8]|2[12]|8[56]|7[017])|7(?:0[17]|9[2-578]))|6(?:0(?:55|88)|180)))',
    '981' => '(?:(?:3(?:6(?:8[0-24-68]|9[237])|2(?:9[23568]|8[078])|1(?:9[2-5]|8[089])|49[4-7]|[35]92)|85(?:33|85|6[03]|7[07]|2[235]|5[0-25-8]|1[01]|4[035]|0[125])|1(?:5(?:8[1-3]|9[2356])|29[2-58])|4(?:29[2-4]|392)|2192))',
    '982' => '(?:8(?:5(?:[03]1|44|66|77|2[13]|8[58]|5[15]|1[01])|601|798))',
    '983' => '(?:8(?:5(?:70|2[0238]|3[357]|8[45]|5[156]|4[03-5]|6[05]|1[0237]|0[124679])|6(?:22|39|0[12])))',
    '984' => '(?:8(?:5(?:8[045]|7[057]|6[0178]|3[3589]|5[0-3578]|4[035]|2[125]|1[0-25689]|0[1-35])|6(?:42|54|7[056]|0[13]|8[068]|6[689])))',
    '985' => '(?:8(?:5(?:[15][015]|4[03]|2[0-2]|3[1-358]|0[12467])|6(?:55|0[17])))',
    '986' => '(?:(?:85(?:40|55|0[17]|2[25]|8[05])|0(?:195|792)|229[23]))',
    '987' => '(?:(?:2(?:29[23]|59[23]|195|392)|0(?:19[25]|79[23]|595)|860[23578]|139[35]))',
    '988' => '(?:(?:039[23]|850[12]))',
    '989' => '(?:(?:1(?:69[2-5]|29[235]|39[2-4]|592|795)|6(?:1(?:9[23]|8[1358])|49[23]|[38]92)|2(?:4(?:8[0134]|9[236])|292|393)|0(?:29[2-6]|[58]92|998)|5(?:[3-5]92|69[23])|(?:32|4[15-7])92))',
    '990' => '(?:(?:8(?:5(?:8[057]|5[0158]|1[0-29]|6[067]|4[05]|7[01578]|0[126]|2[125]|3[1359])|6(?:[24]2|06|11|68|7[078])|794)|95(?:06|59|67|78|3[06]|8[0-258])|0(?:49[23]|[37]92)|2(?:196|292)))',
    '991' => '(?:8(?:5(?:[58]5|21|1[1-3]|0[158])|6(?:01|1[03])))',
    '992' => '(?:(?:8(?:5(?:[246]0|85|5[058]|0[12]|1[01])|6(?:01|10))|0(?:39[23]|[48]92)))',
    '993' => '(?:8(?:6(?:11|42|0[12])|5[01]1))',
    '994' => '(?:8(?:5(?:01|85|1[01])|6[01]1))',
    '995' => '(?:8666)',
    '996' => '(?:8(?:501|602))',
    '997' => '(?:(?:8(?:5(?:01|67|2[23]|[58][58]|1[15])|6(?:[01]1|55))|0(?:29[26]|[14]92)|1392))',
    '998' => '(?:(?:8(?:5(?:40|8[058]|5[05]|0[12]|1[01])|6(?:[01]1|33))|019[24]))',
    '999' => '(?:(?:3(?:79[25-7]|19[23]|292)|0(?:193|696)|7(?:292|696)|[1458]292|229[23]))',
);

1;
__END__
