use strict;
use Test::More tests => 29;

use_ok('Number::Phone::JP', 'phs');

my $tel  = Number::Phone::JP->new;
my $line = 20;

for (1..$line) {
	my $num = <DATA>;
	chomp $num;
	ok($tel->set_number($num)->is_valid_number);
}

while (<DATA>) {
	chomp;
	ok(! $tel->set_number($_)->is_valid_number);
}

__DATA__
070 50012345
070 51012345
070 52012345
070 53012345
070 54012345
070 55012345
070 56012345
070 57012345
070 58012345
070 59012345
070 61012345
070 62012345
070 63012345
070 64012345
070 65012345
070 66012345
070 67012345
070 67512345
070 69412345
070 69912345
070 60012345
070 62912345
070 63712345
070 67312345
070 67612345
070 68012345
070 69012345
070 69312345
