
=head1 NAME

Chronicle::Plugin::Snippets::Version - Make the chronicle version available to templates

=head1 DESCRIPTION

This module makes the C<release> variable available to chronicle templates.

This can be used in templates like so:

=for example begin

    Generated by Chronicle <!-- tmpl_var name='release' -->

=for example end

=cut

=head1 METHODS

Now follows documentation on the available methods.

=cut

package Chronicle::Plugin::Snippets::Version;

use strict;
use warnings;


=head2 on_initiate

The C<on_initiate> method is automatically invoked just before any
C<on_generate> methods which might be present.

This method updates the global variables, which are made available to
all loaded templates, to define a C<release> variable containing the
current release number.

=cut

sub on_initiate
{
    my ( $self, %args ) = (@_);

    my $dbh    = $args{ 'dbh' };
    my $config = $args{ 'config' };

    $Chronicle::GLOBAL_TEMPLATE_VARS{ "release" } = $Chronicle::VERSION;
}


1;
