# !/usr/bin/perl -w
use strict;
use Parrot::Opcode;

open INTERP, "> include/parrot/interp_guts.h" or die "Can't open include/parrot/interp_guts.h, $!/$^E";

print INTERP <<CONST;
/*
 *
 * interp_guts.h
 *
 * this file is autogenerated by build_interp_starter.pl
 *
 * Best not edit it
 */

#define BUILD_TABLE(x) do { \\
CONST

my %opcodes            = Parrot::Opcode::read_ops();
my $opcode_fingerprint = Parrot::Opcode::fingerprint();

for my $name (sort {$opcodes{$a}{CODE} <=> $opcodes{$b}{CODE}} keys %opcodes) {
    print INTERP "\tx[$opcodes{$name}{CODE}] = $name; \\\n";
}
print INTERP "} while (0);\n";


#
# BUILD_NAME_TABLE macro:
#

print INTERP <<CONST;
#define BUILD_NAME_TABLE(x) do { \\
CONST

for my $name (sort {$opcodes{$a}{CODE} <=> $opcodes{$b}{CODE}} keys %opcodes) {
    print INTERP "\tx[$opcodes{$name}{CODE}] = \"$name\"; \\\n";
}
print INTERP "} while (0);\n";


#
# BUILD_ARG_TABLE macro:
#

print INTERP <<CONST;
#define BUILD_ARG_TABLE(x) do { \\
CONST

for my $name (sort {$opcodes{$a}{CODE} <=> $opcodes{$b}{CODE}} keys %opcodes) {
    print INTERP "\tx[$opcodes{$name}{CODE}] = $opcodes{$name}{ARGS}; \\\n";
}
print INTERP "} while (0);\n";


#
# Spit out the DO_OP function
#

print INTERP <<EOI;

#define DO_OP(w,x,y,z) do { \\
    x = z->opcode_funcs; \\
    y = x[*w]; \\
    w = (y)(w,z); \\
 } while (0);
EOI

# Spit out the OPCODE_FINGERPRINT macro
print INTERP <<EOI

#define OPCODE_FINGERPRINT "$opcode_fingerprint"
EOI
