
use strict;
use warnings;

use Module::Build 0.3601;


my %module_build_args = (
  "build_requires" => {
    "Module::Build" => "0.3601",
    "Test::Exception" => 0,
    "Test::More" => "0.98"
  },
  "configure_requires" => {
    "Module::Build" => "0.3601"
  },
  "dist_abstract" => "Create a nice formatted table using extended ASCII and ANSI colors",
  "dist_author" => [
    "Steven Haryanto <stevenharyanto\@gmail.com>"
  ],
  "dist_name" => "Text-ANSITable",
  "dist_version" => "0.07",
  "license" => "perl",
  "module_name" => "Text::ANSITable",
  "recommends" => {},
  "recursive_test_files" => 1,
  "requires" => {
    "Color::ANSI::Util" => "0.03",
    "Data::Clone" => 0,
    "Data::Unixish::Apply" => "1.33",
    "Data::Unixish::ansi" => "0.02",
    "DateTime" => 0,
    "JSON" => 0,
    "Log::Any" => 0,
    "Module::List" => 0,
    "Moo" => 0,
    "SHARYANTO::Color::Util" => 0,
    "Text::ANSI::Util" => "0.08",
    "perl" => "5.010001"
  },
  "script_files" => [
    "bin/ansitable-list-color-themes",
    "bin/ansitable-list-border-styles"
  ]
);


my $build = Module::Build->new(%module_build_args);

$build->create_build_script;
