
use strict;
use warnings;

use 5.010001;

use ExtUtils::MakeMaker 6.30;

use File::ShareDir::Install;
install_share dist => "share";


my %WriteMakefileArgs = (
  "ABSTRACT" => "Generate function (and its Rinci metadata) to access table data",
  "AUTHOR" => "Steven Haryanto <stevenharyanto\@gmail.com>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30",
    "File::ShareDir::Install" => "0.03"
  },
  "DISTNAME" => "Perinci-Sub-Gen-AccessTable",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Perinci::Sub::Gen::AccessTable",
  "PREREQ_PM" => {
    "Data::Clone" => 0,
    "Data::Sah" => 0,
    "Lingua::EN::Numbers" => 0,
    "Lingua::ID::Nums2Words" => 0,
    "Locale::TextDomain::UTF8" => 0,
    "Log::Any" => 0,
    "Perinci::CmdLine" => 0,
    "Perinci::Object::Metadata" => 0,
    "Perinci::Sub::Gen" => 0,
    "Perinci::Sub::GetArgs::Argv" => "0.13",
    "Perinci::Sub::Util" => "0.32",
    "Rinci" => "v1.1.13",
    "experimental" => 0
  },
  "TEST_REQUIRES" => {
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::More" => "0.96"
  },
  "VERSION" => "0.29",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Data::Clone" => 0,
  "Data::Sah" => 0,
  "File::Spec" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Lingua::EN::Numbers" => 0,
  "Lingua::ID::Nums2Words" => 0,
  "Locale::TextDomain::UTF8" => 0,
  "Log::Any" => 0,
  "Perinci::CmdLine" => 0,
  "Perinci::Object::Metadata" => 0,
  "Perinci::Sub::Gen" => 0,
  "Perinci::Sub::GetArgs::Argv" => "0.13",
  "Perinci::Sub::Util" => "0.32",
  "Rinci" => "v1.1.13",
  "Test::More" => "0.96",
  "experimental" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
package
MY;
use File::ShareDir::Install qw(postamble);
}


