#!perl
use strict;
use P6C::TestCompiler tests => 5;

##############################
output_is(<<'CODE', <<'OUT', "subroutine call");
sub _fact($tot, $max, $n) {
    if $n > $max {
	print1($max _ "! = " _ $tot);
    } else {
	_fact $tot * $n, $max, $n + 1;
    }
}

sub fact($n) {
    unless 0 <= $n < 20 {
	print1("Sorry, can't take " _ $n _ " factorial");
    } else {
	_fact 1, $n, 1
    }
}

sub main() {
    fact 12;
    fact -1;
    fact 0;
    fact 24;
}

CODE
12! = 479001600
Sorry, can't take -1 factorial
0! = 1
Sorry, can't take 24 factorial
OUT

##############################
output_is(<<'CODE', <<'OUT', "Argument context");
sub zero() {
    print1('zero');
}

sub one($x) {
    print1('one ' _$x);
}

sub two($x, $y) {
    print1('two ' _$x _' ' _$y);
}

sub three($x, $y, $z) {
    print1('three ' _$x _' ' _$y _' ' _$z);
}

sub main() {
    one 1, one 2;
    two 1, 2, two 3, 4;
    three 1, 2, 3, one 4, two 5, 6;
    zero; zero();
    one 1; one(1);
    my $x = 1.1;
    one $x - 0.1; one($x - 0.1);
}

CODE
one 1
one 2
two 1 2
two 3 4
three 1 2 3
one 4
two 5 6
zero
zero
one 1
one 1
one 1.000000
one 1.000000
OUT

##############################
output_is(<<'CODE', <<'OUT', "Closures 1");
sub main() {
    my $f = { print @_[0,1], "\n"; }
    my @x = (1,2);
    $f(@x);
    $f(3,4);
    $f(5..10);
}
CODE
12
34
56
OUT

##############################
output_is(<<'CODE', <<'OUT', "Closures 2");
sub main() {
    my $f = { print $^b, $^a, "\n"; }
    my @x = (1,2);
    $f(@x);
    $f(3,4);
    $f(5..10);
}
CODE
21
43
65
OUT

##############################
output_is(<<'CODE', <<'OUT', "Closures 3");
sub main() {
    my $f = -> $a, $b { print $b, $a, "\n"; }
    my @x = (1,2);
    $f(@x);
    $f(3,4);
    $f(5..10);
}
CODE
21
43
65
OUT
