package Benchmark::Perl::Formance::Cargo;

use warnings;
use strict;

use 5.005; # I don't really know yet, but that's the goal

use vars qw( $VERSION ); $VERSION = '0.01';

=head1 NAME

Benchmark::Perl::Formance::Cargo - Invariant cargo files for Benchmark::Perl::Formance

=head1 ABOUT

This distribution carries large invariant data used for benchmarking
in Benchmark::Perl::Formance so that CPAN is not spammed on every new version of
Benchmark::Perl::Formance.

=head1 AUTHOR

Steffen Schwigon, C<< <ss5 at renormalist.net> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-perl-formance-cargo at rt.cpan.org>, or through the web
interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Perl-Formance-Cargo>.
I will be notified, and then you'll automatically be notified of
progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Benchmark::Perl::Formance::Cargo

You can also look for information at:

=over 4

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Perl-Formance-Cargo>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Perl-Formance-Cargo>

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Perl-Formance-Cargo>

=item * Search CPAN

L<http://search.cpan.org/dist/Perl-Formance-Cargo>

=back

=head1 ACKNOWLEDGEMENTS

ANDK for the hint to decouple this from Benchmark::Perl::Formance.

=head1 COPYRIGHT & LICENSE

Copyright 2008 Steffen Schwigon.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

Some contained files come from the SpamAssassin Public Corpus which
includes the following note regarding the use of the messages:

  - All headers are reproduced in full.  Some address obfuscation has taken
    place, and hostnames in some cases have been replaced with
    "spamassassin.taint.org" (which has a valid MX record).  In most cases
    though, the headers appear as they were received.
  
  - All of these messages were posted to public fora, were sent to me in the
    knowledge that they may be made public, were sent by me, or originated as
    newsletters from public news web sites.
  
  - relying on data from public networked blacklists like DNSBLs, Razor, DCC
    or Pyzor for identification of these messages is not recommended, as a
    previous downloader of this corpus might have reported them!
  
  - Copyright for the text in the messages remains with the original senders.


=cut

1; # End of Benchmark::Perl::Formance::Cargo
