#!/usr/bin/perl -w
use strict;

# ------------------------------------------------------------------------------
# THIS IS A GENERATED SCRIPT, CHANGES MADE HERE WILL BE OVERWRITTEN
# ------------------------------------------------------------------------------

use lib qw(../lib);

use Perl::Module;
use Data::Hub::Util qw(:all);
use Data::Hub qw($Hub);

our %Info = ();
$Info{'t1'} = {
  'result' => '',
  'num' => 1,
  'summary' => 'Create a new KeyGen',
  'package' => 'Algorithm::KeyGen',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Algorithm/KeyGen.pm',
  'comparator' => 'abort',
  'test' => '  use Algorithm::KeyGen; 
  Algorithm::KeyGen->new(9, \'MyCharset\');',
  'lineno' => 56,
  'invert' => 1
}
;
$Info{'t2'} = {
  'result' => '',
  'num' => 2,
  'summary' => '',
  'lineno' => 177,
  'invert' => 1,
  'test' => '  use Algorithm::KeyGen qw($KeyGen);
  for (1 .. 100) {
    die unless $KeyGen->validate($KeyGen->create());
  }',
  'comparator' => 'abort',
  'package' => 'Algorithm::KeyGen',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Algorithm/KeyGen.pm'
}
;
$Info{'t3'} = {
  'invert' => 1,
  'lineno' => 15,
  'test' => '  use Data::CompositeHash;',
  'comparator' => 'abort',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'package' => 'Data::CompositeHash',
  'result' => '',
  'summary' => '',
  'num' => 3
}
;
$Info{'t4'} = {
  'test' => '  my $ch = Data::CompositeHash->new();',
  'invert' => 0,
  'lineno' => 16,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'package' => 'Data::CompositeHash',
  'comparator' => 'abort',
  'num' => 4,
  'result' => '',
  'summary' => 'no default hash provided'
}
;
$Info{'t5'} = {
  'summary' => '',
  'num' => 5,
  'result' => '',
  'lineno' => 31,
  'invert' => 1,
  'test' => '  my $h2 = {a=>\'a2\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->shift;
  $ch->{a};',
  'comparator' => 'defined',
  'package' => 'Data::CompositeHash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm'
}
;
$Info{'t6'} = {
  'invert' => 0,
  'lineno' => 49,
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->{a};',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'package' => 'Data::CompositeHash',
  'num' => 6,
  'result' => 'a1',
  'summary' => ''
}
;
$Info{'t7'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'package' => 'Data::CompositeHash',
  'invert' => 0,
  'lineno' => 68,
  'test' => '  my $h2 = {a=>\'a2\'};
  my $h3 = {a=>\'a3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->push($h3);
  $ch->{a};',
  'num' => 7,
  'summary' => '',
  'result' => 'a2'
}
;
$Info{'t8'} = {
  'result' => '',
  'summary' => '',
  'num' => 8,
  'comparator' => 'defined',
  'package' => 'Data::CompositeHash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'lineno' => 87,
  'invert' => 1,
  'test' => '  my $h2 = {a=>\'a2\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->pop;
  $ch->{a};'
}
;
$Info{'t9'} = {
  'result' => '',
  'summary' => '',
  'num' => 9,
  'package' => 'Data::CompositeHash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'comparator' => 'abort',
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  # We now have a composite stack with prescedence: $h1, $h2, $h3
  # Where $h2 is the default hash
  $ch->{a} = \'AA\';
  $ch->{b} = \'BB\';
  $ch->{c} = \'CC\';
  $ch->{d} = \'DD\';
  die unless $h1->{a} eq \'AA\';
  die unless $h2->{b} eq \'BB\';
  die unless $h3->{c} eq \'CC\';
  die unless $h2->{d} eq \'DD\'; # set on default hash b/c \'d\' did not exist',
  'lineno' => 121,
  'invert' => 1
}
;
$Info{'t10'} = {
  'comparator' => 'abort',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'package' => 'Data::CompositeHash',
  'invert' => 1,
  'lineno' => 157,
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  # We now have a composite stack with prescedence: $h1, $h2, $h3
  # Where $h2 is the default hash
  die unless $ch->{a} eq \'a1\';
  die unless $ch->{b} eq \'b2\';
  die unless $ch->{c} eq \'c3\';
  die unless ref($ch->{\'/\'});',
  'summary' => '',
  'result' => '',
  'num' => 10
}
;
$Info{'t11'} = {
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  join \'\', sort values %$ch;',
  'invert' => 0,
  'lineno' => 192,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'package' => 'Data::CompositeHash',
  'comparator' => 'match',
  'result' => 'a1b2c3',
  'summary' => '',
  'num' => 11
}
;
$Info{'t12'} = {
  'summary' => '',
  'num' => 12,
  'result' => '',
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  die unless exists $$ch{a};
  die unless exists $$ch{b};
  die unless exists $$ch{c};
  die if exists $$ch{d};',
  'lineno' => 213,
  'invert' => 1,
  'package' => 'Data::CompositeHash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'comparator' => 'abort'
}
;
$Info{'t13'} = {
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  delete $ch->{a};
  delete $ch->{b};
  delete $ch->{c};
  join \'\', sort values %$ch;',
  'invert' => 0,
  'lineno' => 234,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'package' => 'Data::CompositeHash',
  'comparator' => 'match',
  'summary' => '',
  'num' => 13,
  'result' => 'a2b3'
}
;
$Info{'t14'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'package' => 'Data::CompositeHash',
  'invert' => 0,
  'lineno' => 255,
  'test' => '  my $h1 = {a=>\'a1\'};
  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $h3 = {a=>\'a3\', b=>\'b3\', c=>\'c3\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  %$ch = ();
  join \'\', sort values %$ch;',
  'num' => 14,
  'result' => 'a2b2',
  'summary' => ''
}
;
$Info{'t15'} = {
  'num' => 15,
  'summary' => '',
  'result' => '',
  'package' => 'Data::CompositeHash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'comparator' => 'true',
  'test' => '  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $ch = Data::CompositeHash->new($h2);
  scalar(%$ch);',
  'lineno' => 273,
  'invert' => 0
}
;
$Info{'t16'} = {
  'comparator' => 'false',
  'package' => 'Data::CompositeHash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'lineno' => 278,
  'invert' => 0,
  'test' => '  my $h2 = {a=>\'a2\', b=>\'b2\'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->pop;
  scalar(%$ch);',
  'num' => 16,
  'result' => '',
  'summary' => ''
}
;
$Info{'t17'} = {
  'invert' => 0,
  'lineno' => 289,
  'test' => '  use Data::CompositeHash;
  my $h1 = {
    \'a\' => \'argon\',
  };
  my $h2 = {
    \'a\' => \'apple\',
    \'b\' => \'banana\',
    \'c\' => \'cherry\',
  };
  my $h3 = {
    \'c\' => \'cyan\',
    \'d\' => \'dark brown\',
  };
  my $result = \'\';
  # Create a composite hash, using $h2 as the default hash
  my $ch = Data::CompositeHash->new($h2);
  # Add $h1 as a hash which will overried values in $h2
  $ch->unshift($h1);
  # Add $h3 as a hash with the least prescedence
  $ch->push($h3);
  # Fetch some values
  $result .= $ch->{a} . "\\n";
  $result .= $ch->{b} . "\\n";
  $result .= $ch->{c} . "\\n";
  $result .= $ch->{d} . "\\n";
  # Set an ambiguous value
  $result .= "--\\n";
  $ch->{a} = \'aluminium\';
  $result .= $h1->{a} . "\\n"; # contains new value
  $result .= $h2->{a} . "\\n"; # not touched
  # Set an ambiguous value
  $result .= "--\\n";
  $ch->{c} = \'cantelope\';
  $result .= $h2->{c} . "\\n"; # contains new value
  $result .= $h3->{c} . "\\n"; # not touched
  # Setting a value which is not defined in any hash sets
  # it on the defalut hash
  $result .= "--\\n";
  $ch->{e} = \'edible fruit\';
  $result .= $h2->{e};',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm',
  'package' => 'Data::CompositeHash',
  'summary' => '',
  'num' => 17,
  'result' => 'argon
banana
cherry
dark brown
--
aluminium
apple
--
cantelope
cyan
--
edible fruit'
}
;
$Info{'t18'} = {
  'num' => 18,
  'summary' => '',
  'result' => '',
  'package' => 'Data::Format::Hash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/Hash.pm',
  'comparator' => 'abort',
  'test' => '  use Data::Format::Hash qw(hf_parse);',
  'lineno' => 73,
  'invert' => 1
}
;
$Info{'t19'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/Hash.pm',
  'package' => 'Data::Format::Hash',
  'comparator' => 'match',
  'test' => '  my $d = q(
  baz => biz
  foo => %{
  bar => @{
  tender
  stool
  }
  }
  );
  my $h = hf_parse(\\$d);
  $$h{\'baz\'};',
  'invert' => 0,
  'lineno' => 74,
  'result' => 'biz',
  'summary' => 'Parse a simple nested collection',
  'num' => 19
}
;
$Info{'t20'} = {
  'summary' => '',
  'num' => 20,
  'result' => '',
  'comparator' => 'abort',
  'package' => 'Data::Format::Hash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/Hash.pm',
  'lineno' => 315,
  'invert' => 1,
  'test' => '  use Data::Format::Hash qw(hf_format);'
}
;
$Info{'t21'} = {
  'num' => 21,
  'summary' => 'Format a simple nested collection',
  'result' => 'foo => %{
  bar => @{
    tender
    stool
  }
}',
  'comparator' => 'match',
  'package' => 'Data::Format::Hash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/Hash.pm',
  'lineno' => 316,
  'invert' => 0,
  'test' => '  my $d = {foo=>{bar=>[\'tender\',\'stool\']}};
  hf_format($d)'
}
;
$Info{'t22'} = {
  'lineno' => 15,
  'invert' => 0,
  'test' => '  use Data::Format::HexString qw(:all);
  hexstr_format( \'Dogs (Waters, Gilmour) 17:06\' );',
  'comparator' => 'match',
  'package' => 'Data::Format::HexString',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/HexString.pm',
  'num' => 22,
  'summary' => '',
  'result' => 'Dogs_0x20__0x28_Waters_0x2c__0x20_Gilmour_0x29__0x20_17_0x3a_06'
}
;
$Info{'t23'} = {
  'comparator' => 'match',
  'package' => 'Data::Format::HexString',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/HexString.pm',
  'lineno' => 29,
  'invert' => 0,
  'test' => '  hexstr_parse(\'Dogs_0x20__0x28_Waters_0x2c__0x20_Gilmour_0x29__0x20_17_0x3a_06\');',
  'summary' => '',
  'num' => 23,
  'result' => 'Dogs (Waters, Gilmour) 17:06'
}
;
$Info{'t24'} = {
  'num' => 24,
  'result' => '',
  'summary' => '',
  'comparator' => 'abort',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/XFR.pm',
  'package' => 'Data::Format::XFR',
  'invert' => 1,
  'lineno' => 205,
  'test' => '  use Data::Format::XFR;
  use Data::OrderedHash;
  my $h = Data::OrderedHash->new(
    a => [\'alpha\', \'beta\', \'copper\'],
    b => {
      one => 1,
    },
    c => \'charlie\',
  );
  my $xfr = Data::Format::XFR->new(\'base64\');
  my $known = \'%{YQ==@{${YWxwaGE=}${YmV0YQ==}${Y29wcGVy}}Yg==%{b25l${MQ==}}Yw==${Y2hhcmxpZQ==}}\';
  my $str = $xfr->format($h);
  die "format error:\\nstr: $str\\n!= : $known" unless $str eq $known;
  my $h2 = $xfr->parse($str);
  die \'parse error\' unless $h2->{a}[1] eq $h->{a}[1];'
}
;
$Info{'t25'} = {
  'summary' => '',
  'num' => 25,
  'result' => '',
  'lineno' => 33,
  'invert' => 1,
  'test' => '    
  use strict;
  use Data::Hub::Address;
  my $a = Data::Hub::Address->new("/b/c/d");
  die $a->to_string unless \'/b/c/d\' eq $a->to_string;
  die $a->first unless \'\' eq $a->first;
  die $a->last unless \'d\' eq $a->last;
  $a->pop;
  die unless \'/b/c\' eq $a->to_string;
  $a->push("D");
  die unless \'/b/c/D\' eq $a->to_string;
  $a->shift;
  die unless \'b/c/D\' eq $a->to_string;
  $a->unshift(\'A\');
  die unless \'A/b/c/D\' eq $a->to_string;',
  'comparator' => 'abort',
  'package' => 'Data::Hub::Address',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Address.pm'
}
;
$Info{'t26'} = {
  'num' => 26,
  'result' => 'abc',
  'summary' => 'Append to an array',
  'package' => 'Data::Hub::Courier',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm',
  'comparator' => 'match',
  'test' => '  my $h = {g=>[qw(a b)]};
  Data::Hub::Courier::append($h, \'/g\', \'c\');
  join(\'\', @{$$h{g}});',
  'lineno' => 208,
  'invert' => 0
}
;
$Info{'t27'} = {
  'result' => 'abc',
  'num' => 27,
  'summary' => 'Append to a hash',
  'test' => '  my $h = {g=>Data::OrderedHash->new(a => 1, b => 2)};
  Data::Hub::Courier::append($h, \'/g\', c => 3);
  join(\'\', keys %{$$h{g}});',
  'lineno' => 213,
  'invert' => 0,
  'package' => 'Data::Hub::Courier',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm',
  'comparator' => 'match'
}
;
$Info{'t28'} = {
  'test' => '  my $h = {g=>str_ref(\'ab\')};
  Data::Hub::Courier::append($h, \'/g\', \'c\');
  ${$$h{g}};',
  'lineno' => 218,
  'invert' => 0,
  'package' => 'Data::Hub::Courier',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm',
  'comparator' => 'match',
  'result' => 'abc',
  'num' => 28,
  'summary' => 'Append to a scalar'
}
;
$Info{'t29'} = {
  'num' => 29,
  'summary' => 'Prepend to an array',
  'result' => 'abc',
  'package' => 'Data::Hub::Courier',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm',
  'comparator' => 'match',
  'test' => '  my $h = {g=>[qw(b c)]};
  Data::Hub::Courier::prepend($h, \'/g\', \'a\');
  join(\'\', @{$$h{g}});',
  'lineno' => 255,
  'invert' => 0
}
;
$Info{'t30'} = {
  'test' => '  my $h = {g=>Data::OrderedHash->new(b => 2, c => 3)};
  Data::Hub::Courier::prepend($h, \'/g\', a => 1);
  join(\'\', keys %{$$h{g}});',
  'invert' => 0,
  'lineno' => 260,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm',
  'package' => 'Data::Hub::Courier',
  'comparator' => 'match',
  'result' => 'abc',
  'num' => 30,
  'summary' => 'Prepend to a hash'
}
;
$Info{'t31'} = {
  'result' => 'abc',
  'summary' => 'Prepend to a scalar',
  'num' => 31,
  'package' => 'Data::Hub::Courier',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm',
  'comparator' => 'match',
  'test' => '  my $h = {g=>str_ref(\'bc\')};
  Data::Hub::Courier::prepend($h, \'/g\', \'a\');
  ${$$h{g}};',
  'lineno' => 265,
  'invert' => 0
}
;
$Info{'t32'} = {
  'num' => 32,
  'result' => 'Hello World!',
  'summary' => '',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm',
  'package' => 'Data::Hub::Courier',
  'invert' => 0,
  'lineno' => 385,
  'test' => '  use Data::Hub::Courier;
  my $h = {
    A => {
      I => [
        \'Hello\'
      ],
    },
  };
  Data::Hub::Courier::set($h, \'/A/I/1\', \'World!\');
  my $a = Data::Hub::Courier::get($h, \'/A/I\');
  join \' \', @$a;'
}
;
$Info{'t33'} = {
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'comparator' => 'abort',
  'test' => '  # This test case simply sets up the test data and subroutine for running
  # subsequent test queries.
  use Data::Hub::Util qw(:all);
  use Data::Format::Hash qw(hf_format hf_parse);
  use Data::OrderedHash;
  my $ttt_data = curry(hf_parse(\'
    array => @{
      a
      b
      c
      ab
      abc
    }
    hash => %{
      a => Alpha
      b => Beta
      c => Charlie
    }
    array_of_hashes => @{
      %{
        name => a
        text => Alpha
      }
      %{
        name => b
        text => Beta
      }
      %{
        name => c
        text => Charlie
      }
    }
    hash_of_hashes => %{
      a => %{
        text => Alpha
        num => 3
      }
      b => %{
        text => Beta
        num => 2
      }
      c => %{
        text => Charlie
        num => 1
      }
    }
  \'));
  # The test data is curried to provide the get method of Data::Hub::Courier
  sub ttt_query {
    my $q = shift;
    my $r = $ttt_data->get($q);
    return unless defined $r;
    my $ref = ref($r);
    $ref ? hf_format({$ref => $r}) : $r;
  }',
  'lineno' => 410,
  'invert' => 1,
  'summary' => '',
  'result' => '',
  'num' => 33
}
;
$Info{'t34'} = {
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'comparator' => 'defined',
  'test' => '  # Use an invalid index
  ttt_query(\'array/{?:fail}\');',
  'lineno' => 481,
  'invert' => 1,
  'summary' => '',
  'num' => 34,
  'result' => ''
}
;
$Info{'t35'} = {
  'lineno' => 486,
  'invert' => 1,
  'test' => '  # Get the value whose value is \'\'
  ttt_query(\'array/{?:}\');',
  'comparator' => 'defined',
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'summary' => '',
  'result' => '',
  'num' => 35
}
;
$Info{'t36'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'package' => 'Data::Hub::Query',
  'comparator' => 'match',
  'test' => '  # Get the value whose key is eq 0
  ttt_query(\'array/{?:0}\');',
  'invert' => 0,
  'lineno' => 491,
  'summary' => '',
  'result' => 'a',
  'num' => 36
}
;
$Info{'t37'} = {
  'num' => 37,
  'result' => 'Data::Hub::Subset => %{
  0 => a
}',
  'summary' => '',
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'comparator' => 'match',
  'test' => '  # Get the value whose key is == 0
  ttt_query(\'array/{?(==):0}\');',
  'lineno' => 500,
  'invert' => 0
}
;
$Info{'t38'} = {
  'result' => 'Data::Hub::Subset => %{
  2 => c
  3 => ab
  4 => abc
}',
  'summary' => '',
  'num' => 38,
  'test' => '  # Get all items whose key is >= 2
  ttt_query(\'array/{?(>=):2}\');',
  'lineno' => 511,
  'invert' => 0,
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'comparator' => 'match'
}
;
$Info{'t39'} = {
  'result' => 'a',
  'num' => 39,
  'summary' => '',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'package' => 'Data::Hub::Query',
  'invert' => 0,
  'lineno' => 524,
  'test' => '  # Get the value whose value is \'a\'
  ttt_query(\'array/{?*:a}\');'
}
;
$Info{'t40'} = {
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'lineno' => 533,
  'invert' => 0,
  'test' => '  # Get all items whose value is eq \'a\'
  ttt_query(\'array/{?*(eq):a}\');',
  'result' => 'Data::Hub::Subset => %{
  0 => a
}',
  'summary' => '',
  'num' => 40
}
;
$Info{'t41'} = {
  'result' => 'Data::Hub::Subset => %{
  0 => a
  3 => ab
  4 => abc
}',
  'num' => 41,
  'summary' => '',
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'lineno' => 544,
  'invert' => 0,
  'test' => '  # Get all items whose value is =~ /a/
  ttt_query(\'array/{?*(=~):a}\');'
}
;
$Info{'t42'} = {
  'result' => 'Alpha',
  'num' => 42,
  'summary' => '',
  'test' => '  # Get the value whose key is eq \'a\'
  ttt_query(\'hash/{?:a}\');',
  'lineno' => 561,
  'invert' => 0,
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'comparator' => 'match'
}
;
$Info{'t43'} = {
  'summary' => '',
  'num' => 43,
  'result' => 'Alpha',
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'comparator' => 'match',
  'test' => '  # Get the value whose value is eq \'Alpha\'
  ttt_query(\'hash/{?*:Alpha}\');',
  'lineno' => 570,
  'invert' => 0
}
;
$Info{'t44'} = {
  'test' => '  # Get all items whose value is eq \'Alpha\'
  ttt_query(\'hash/{?*(eq):Alpha}\');',
  'invert' => 0,
  'lineno' => 579,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'package' => 'Data::Hub::Query',
  'comparator' => 'match',
  'num' => 44,
  'summary' => '',
  'result' => 'Data::Hub::Subset => %{
  a => Alpha
}'
}
;
$Info{'t45'} = {
  'num' => 45,
  'result' => 'Data::Hub::Subset => %{
  a => Alpha
  b => Beta
}',
  'summary' => '',
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'comparator' => 'match',
  'test' => '  # Get all items whose value is =~ /a$/
  ttt_query(\'hash/{?*(=~):a$}\');',
  'lineno' => 590,
  'invert' => 0
}
;
$Info{'t46'} = {
  'result' => 'Data::OrderedHash => %{
  name => a
  text => Alpha
}',
  'num' => 46,
  'summary' => '',
  'lineno' => 606,
  'invert' => 0,
  'test' => '  # Get the value whose key is eq 0
  ttt_query(\'array_of_hashes/{?:0}\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm'
}
;
$Info{'t47'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'package' => 'Data::Hub::Query',
  'invert' => 0,
  'lineno' => 618,
  'test' => '  # Get the value whose name is eq \'a\'
  ttt_query(\'array_of_hashes/{?name:a}\');',
  'summary' => '',
  'result' => 'Data::OrderedHash => %{
  name => a
  text => Alpha
}',
  'num' => 47
}
;
$Info{'t48'} = {
  'result' => 'Data::Hub::Subset => %{
  0 => %{
    name => a
    text => Alpha
  }
}',
  'summary' => '',
  'num' => 48,
  'invert' => 0,
  'lineno' => 630,
  'test' => '  # Get all items whose name is eq \'a\'
  ttt_query(\'array_of_hashes/{?name(eq):a}\');',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'package' => 'Data::Hub::Query'
}
;
$Info{'t49'} = {
  'test' => '  # Get all items whose name is =~ /a|b/
  ttt_query(\'array_of_hashes/{?name(=~):a|b}\');',
  'invert' => 0,
  'lineno' => 644,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'package' => 'Data::Hub::Query',
  'comparator' => 'match',
  'result' => 'Data::Hub::Subset => %{
  0 => %{
    name => a
    text => Alpha
  }
  1 => %{
    name => b
    text => Beta
  }
}',
  'num' => 49,
  'summary' => ''
}
;
$Info{'t50'} = {
  'num' => 50,
  'result' => 'Data::OrderedHash => %{
  text => Alpha
  num => 3
}',
  'summary' => '',
  'test' => '  # Get the value whose key is eq \'a\'
  ttt_query(\'hash_of_hashes/{?:a}\');',
  'invert' => 0,
  'lineno' => 666,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'package' => 'Data::Hub::Query',
  'comparator' => 'match'
}
;
$Info{'t51'} = {
  'test' => '  # Get the value whose text is eq \'Alpha\'
  ttt_query(\'hash_of_hashes/{?text:Alpha}\');',
  'lineno' => 678,
  'invert' => 0,
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'comparator' => 'match',
  'result' => 'Data::OrderedHash => %{
  text => Alpha
  num => 3
}',
  'summary' => '',
  'num' => 51
}
;
$Info{'t52'} = {
  'test' => '  # Get all items whose text is eq \'Alpha\'
  ttt_query(\'hash_of_hashes/{?text(eq):Alpha}\');',
  'lineno' => 690,
  'invert' => 0,
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'comparator' => 'match',
  'num' => 52,
  'result' => 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
}',
  'summary' => ''
}
;
$Info{'t53'} = {
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'comparator' => 'match',
  'test' => '  # Get all items whose num is > 1
  ttt_query(\'hash_of_hashes/{?num(>):1}\');',
  'lineno' => 704,
  'invert' => 0,
  'num' => 53,
  'summary' => '',
  'result' => 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
  b => %{
    text => Beta
    num => 2
  }
}'
}
;
$Info{'t54'} = {
  'result' => 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
  c => %{
    text => Charlie
    num => 1
  }
}',
  'num' => 54,
  'summary' => '',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'package' => 'Data::Hub::Query',
  'invert' => 0,
  'lineno' => 726,
  'test' => '  ttt_query(\'hash_of_hashes/*|{?(ne):b}\');'
}
;
$Info{'t55'} = {
  'result' => 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
  c => %{
    text => Charlie
    num => 1
  }
}',
  'num' => 55,
  'summary' => '',
  'invert' => 0,
  'lineno' => 743,
  'test' => '  ttt_query(\'hash_of_hashes/*|{?text(=~):B|C}\');',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'package' => 'Data::Hub::Query'
}
;
$Info{'t56'} = {
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm',
  'comparator' => 'match',
  'test' => '  ttt_query(\'hash_of_hashes/*|{?(=~):[ab]}|{?text(=~):B|C}\');',
  'lineno' => 762,
  'invert' => 0,
  'result' => 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
}',
  'summary' => '',
  'num' => 56
}
;
$Info{'t57'} = {
  'num' => 57,
  'summary' => '',
  'result' => 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
}',
  'lineno' => 775,
  'invert' => 0,
  'test' => '  ttt_query(\'hash_of_hashes/{?(=~):[ab]}|{?text(=~):B|C}\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Query',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm'
}
;
$Info{'t58'} = {
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'abort',
  'test' => '  use Data::Hub::Util qw(:all);',
  'lineno' => 85,
  'invert' => 1,
  'summary' => 'Load this module',
  'num' => 58,
  'result' => ''
}
;
$Info{'t59'} = {
  'lineno' => 125,
  'invert' => 0,
  'test' => '  curry({a=>{b=>\'c\'}})->get(\'/a/b\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'summary' => '',
  'num' => 59,
  'result' => 'c'
}
;
$Info{'t60'} = {
  'summary' => '',
  'result' => 'Data::Hub::FileSystem::Node',
  'num' => 60,
  'lineno' => 137,
  'invert' => 0,
  'test' => '  FS(\'Node\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm'
}
;
$Info{'t61'} = {
  'num' => 61,
  'result' => 'data-hash',
  'summary' => '',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  typeof(\'foo.bar\', {});',
  'lineno' => 148,
  'invert' => 0
}
;
$Info{'t62'} = {
  'test' => '  typeof(\'/with/path/foo.bar\', []);',
  'lineno' => 149,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'num' => 62,
  'summary' => '',
  'result' => 'data-array'
}
;
$Info{'t63'} = {
  'num' => 63,
  'summary' => '',
  'result' => 'data-scalar-bar',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 150,
  'invert' => 0,
  'test' => '  typeof(\'foo.bar\', \'baz\');'
}
;
$Info{'t64'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 228,
  'test' => '  my $addr = \'/one/two/{/i/am/three}/four\';
  join(\':\', addr_shift($addr), addr_shift($addr), addr_shift($addr),
  addr_shift($addr)); ',
  'num' => 64,
  'summary' => '',
  'result' => 'one:two:{/i/am/three}:four'
}
;
$Info{'t65'} = {
  'lineno' => 241,
  'invert' => 0,
  'test' => '  my $addr = \'/one/two\';
  my $last = addr_pop($addr);
  "$last,$addr"',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'summary' => '',
  'result' => 'two,/one',
  'num' => 65
}
;
$Info{'t66'} = {
  'num' => 66,
  'result' => '/',
  'summary' => '',
  'test' => '  addr_normalize(\'/\');',
  'lineno' => 255,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match'
}
;
$Info{'t67'} = {
  'result' => '/a',
  'num' => 67,
  'summary' => '',
  'test' => '  addr_normalize(\'/a/\');',
  'invert' => 0,
  'lineno' => 256,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match'
}
;
$Info{'t68'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  addr_normalize(\'/a/b/..\');',
  'invert' => 0,
  'lineno' => 257,
  'num' => 68,
  'summary' => '',
  'result' => '/a'
}
;
$Info{'t69'} = {
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 258,
  'invert' => 0,
  'test' => '  addr_normalize(\'/a/../b\');',
  'summary' => '',
  'num' => 69,
  'result' => '/b'
}
;
$Info{'t70'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 259,
  'test' => '  addr_normalize(\'/a/../../b\');',
  'num' => 70,
  'summary' => '',
  'result' => '/b'
}
;
$Info{'t71'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  addr_normalize(\'/a/.../b\');',
  'invert' => 0,
  'lineno' => 260,
  'num' => 71,
  'summary' => '',
  'result' => '/a'
}
;
$Info{'t72'} = {
  'result' => '/a',
  'num' => 72,
  'summary' => '',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  addr_normalize(\'/a/.../\');',
  'lineno' => 261,
  'invert' => 0
}
;
$Info{'t73'} = {
  'test' => '  addr_normalize(\'/a/...\');',
  'lineno' => 262,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'summary' => '',
  'num' => 73,
  'result' => '/a'
}
;
$Info{'t74'} = {
  'summary' => '',
  'result' => '/a',
  'num' => 74,
  'test' => '  addr_normalize(\'/a/.../..\');',
  'lineno' => 263,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match'
}
;
$Info{'t75'} = {
  'test' => '  addr_normalize(\'/a/../...\');',
  'lineno' => 264,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'summary' => '',
  'result' => '/',
  'num' => 75
}
;
$Info{'t76'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'defined',
  'test' => '  addr_parent();',
  'invert' => 1,
  'lineno' => 275,
  'result' => '',
  'summary' => '',
  'num' => 76
}
;
$Info{'t77'} = {
  'summary' => '',
  'result' => '',
  'num' => 77,
  'comparator' => 'defined',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 1,
  'lineno' => 276,
  'test' => '  addr_parent(\'\');'
}
;
$Info{'t78'} = {
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 277,
  'invert' => 0,
  'test' => '  addr_parent(\'/\');',
  'result' => '/',
  'num' => 78,
  'summary' => ''
}
;
$Info{'t79'} = {
  'lineno' => 278,
  'invert' => 0,
  'test' => '  addr_parent(\'/a\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'num' => 79,
  'summary' => '',
  'result' => '/'
}
;
$Info{'t80'} = {
  'result' => '/',
  'num' => 80,
  'summary' => '',
  'lineno' => 279,
  'invert' => 0,
  'test' => '  addr_parent(\'/a/b/..\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm'
}
;
$Info{'t81'} = {
  'result' => 'a',
  'summary' => '',
  'num' => 81,
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 280,
  'test' => '  addr_parent(\'a/b/\');'
}
;
$Info{'t82'} = {
  'lineno' => 281,
  'invert' => 0,
  'test' => '  addr_parent(\'a/b.c\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'summary' => '',
  'result' => 'a',
  'num' => 82
}
;
$Info{'t83'} = {
  'summary' => '',
  'num' => 83,
  'result' => '',
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 294,
  'invert' => 1,
  'test' => '  addr_name(\'\');'
}
;
$Info{'t84'} = {
  'test' => '  addr_name(\'/\');',
  'invert' => 0,
  'lineno' => 295,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'num' => 84,
  'summary' => '',
  'result' => ''
}
;
$Info{'t85'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  addr_name(\'/a\');',
  'invert' => 0,
  'lineno' => 296,
  'result' => 'a',
  'summary' => '',
  'num' => 85
}
;
$Info{'t86'} = {
  'result' => 'a',
  'summary' => '',
  'num' => 86,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  addr_name(\'/a/b/..\');',
  'invert' => 0,
  'lineno' => 297
}
;
$Info{'t87'} = {
  'num' => 87,
  'result' => 'b',
  'summary' => '',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  addr_name(\'a/b/\');',
  'lineno' => 298,
  'invert' => 0
}
;
$Info{'t88'} = {
  'result' => 'b.c',
  'num' => 88,
  'summary' => '',
  'test' => '  addr_name(\'a/b.c\');',
  'invert' => 0,
  'lineno' => 299,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match'
}
;
$Info{'t89'} = {
  'num' => 89,
  'summary' => '',
  'result' => '0',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 311,
  'invert' => 0,
  'test' => '  scalar(addr_split(\'\'));'
}
;
$Info{'t90'} = {
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 312,
  'invert' => 0,
  'test' => '  join \' \', addr_split(\'/\');',
  'result' => '',
  'summary' => '',
  'num' => 90
}
;
$Info{'t91'} = {
  'test' => '  join \' \', addr_split(\'/a\');',
  'invert' => 0,
  'lineno' => 313,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'result' => 'a',
  'summary' => '',
  'num' => 91
}
;
$Info{'t92'} = {
  'summary' => '',
  'result' => 'a',
  'num' => 92,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  join \' \', addr_split(\'/a/b/..\');',
  'invert' => 0,
  'lineno' => 314
}
;
$Info{'t93'} = {
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  join \' \', addr_split(\'a/b/\');',
  'lineno' => 315,
  'invert' => 0,
  'num' => 93,
  'result' => 'a b',
  'summary' => ''
}
;
$Info{'t94'} = {
  'result' => 'a b.c',
  'summary' => '',
  'num' => 94,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  join \' \', addr_split(\'a/b.c\');',
  'lineno' => 316,
  'invert' => 0
}
;
$Info{'t95'} = {
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 330,
  'invert' => 0,
  'test' => '  addr_join(\'/\');',
  'num' => 95,
  'summary' => '',
  'result' => '/'
}
;
$Info{'t96'} = {
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  addr_join(\'/a\', \'/\');',
  'lineno' => 331,
  'invert' => 0,
  'summary' => '',
  'result' => '/a',
  'num' => 96
}
;
$Info{'t97'} = {
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 332,
  'invert' => 0,
  'test' => '  addr_join(\'/a/\', \'b/..\');',
  'num' => 97,
  'summary' => '',
  'result' => '/a'
}
;
$Info{'t98'} = {
  'summary' => '',
  'result' => '/b',
  'num' => 98,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 333,
  'invert' => 0,
  'test' => '  addr_join(\'/a/..\', \'/b\');'
}
;
$Info{'t99'} = {
  'num' => 99,
  'result' => '/b',
  'summary' => '',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 334,
  'test' => '  addr_join(\'/a/../\', \'../b\');'
}
;
$Info{'t100'} = {
  'test' => '  addr_join(\'/a/.../\', \'b\');',
  'lineno' => 335,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'result' => '/a',
  'summary' => '',
  'num' => 100
}
;
$Info{'t101'} = {
  'result' => '/a',
  'num' => 101,
  'summary' => '',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  addr_join(\'/a/\', \'.../\');',
  'lineno' => 336,
  'invert' => 0
}
;
$Info{'t102'} = {
  'num' => 102,
  'result' => '/a',
  'summary' => '',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 337,
  'invert' => 0,
  'test' => '  addr_join(\'/a/\', \'...\');'
}
;
$Info{'t103'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 338,
  'test' => '  addr_join(\'/a/\', \'b/\');',
  'summary' => '',
  'num' => 103,
  'result' => '/a/b'
}
;
$Info{'t104'} = {
  'lineno' => 339,
  'invert' => 0,
  'test' => '  addr_join(\'/a/\', \'b\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'result' => '/a/b',
  'num' => 104,
  'summary' => ''
}
;
$Info{'t105'} = {
  'summary' => '',
  'result' => '/a/b',
  'num' => 105,
  'test' => '  addr_join(\'/a\', \'/b\');',
  'invert' => 0,
  'lineno' => 340,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match'
}
;
$Info{'t106'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 341,
  'test' => '  addr_join(\'/a\', \'b\');',
  'summary' => '',
  'result' => '/a/b',
  'num' => 106
}
;
$Info{'t107'} = {
  'summary' => '',
  'num' => 107,
  'result' => '/a/b/c',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  addr_join(\'/a\', \'b\', \'c\');',
  'invert' => 0,
  'lineno' => 342
}
;
$Info{'t108'} = {
  'test' => '  addr_ext(undef);',
  'invert' => 1,
  'lineno' => 353,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'defined',
  'summary' => '',
  'num' => 108,
  'result' => ''
}
;
$Info{'t109'} = {
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 354,
  'invert' => 0,
  'test' => '  addr_ext(\'foo.txt\');',
  'num' => 109,
  'summary' => '',
  'result' => 'txt'
}
;
$Info{'t110'} = {
  'num' => 110,
  'summary' => '',
  'result' => 'txt',
  'test' => '  addr_ext(\'/foo.txt\');',
  'invert' => 0,
  'lineno' => 355,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match'
}
;
$Info{'t111'} = {
  'summary' => '',
  'num' => 111,
  'result' => 'txt',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 356,
  'invert' => 0,
  'test' => '  addr_ext(\'./foo.txt\');'
}
;
$Info{'t112'} = {
  'num' => 112,
  'result' => 'txt',
  'summary' => '',
  'test' => '  addr_ext(\'../foo.txt\');',
  'invert' => 0,
  'lineno' => 357,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match'
}
;
$Info{'t113'} = {
  'summary' => '',
  'result' => 'txt',
  'num' => 113,
  'invert' => 0,
  'lineno' => 358,
  'test' => '  addr_ext(\'/foo/foo.txt\');',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util'
}
;
$Info{'t114'} = {
  'num' => 114,
  'result' => 'txt',
  'summary' => '',
  'test' => '  addr_ext(\'/foo.bar.txt\');',
  'lineno' => 359,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match'
}
;
$Info{'t115'} = {
  'num' => 115,
  'summary' => '',
  'result' => '',
  'test' => '  addr_ext(\'/foo/bar.\');',
  'lineno' => 360,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match'
}
;
$Info{'t116'} = {
  'test' => '  addr_ext(\'/foo/bar\');',
  'lineno' => 361,
  'invert' => 1,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'defined',
  'num' => 116,
  'summary' => '',
  'result' => ''
}
;
$Info{'t117'} = {
  'lineno' => 362,
  'invert' => 1,
  'test' => '  addr_ext(\'.metadata\');',
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'num' => 117,
  'summary' => '',
  'result' => ''
}
;
$Info{'t118'} = {
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 363,
  'invert' => 0,
  'test' => '  addr_ext(\'.metadata.bak\');',
  'result' => 'bak',
  'summary' => '',
  'num' => 118
}
;
$Info{'t119'} = {
  'test' => '  addr_basename(undef);',
  'invert' => 1,
  'lineno' => 377,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'defined',
  'result' => '',
  'num' => 119,
  'summary' => ''
}
;
$Info{'t120'} = {
  'test' => '  addr_basename(\'/\');',
  'lineno' => 378,
  'invert' => 1,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'defined',
  'result' => '',
  'summary' => '',
  'num' => 120
}
;
$Info{'t121'} = {
  'invert' => 0,
  'lineno' => 379,
  'test' => '  addr_basename(\'foo.txt\');',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'num' => 121,
  'result' => 'foo'
}
;
$Info{'t122'} = {
  'result' => 'foo',
  'num' => 122,
  'summary' => '',
  'lineno' => 380,
  'invert' => 0,
  'test' => '  addr_basename(\'foo.txt/\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm'
}
;
$Info{'t123'} = {
  'summary' => '',
  'num' => 123,
  'result' => 'foo',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 381,
  'test' => '  addr_basename(\'/foo.txt\');'
}
;
$Info{'t124'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 382,
  'test' => '  addr_basename(\'./foo.txt\');',
  'result' => 'foo',
  'summary' => '',
  'num' => 124
}
;
$Info{'t125'} = {
  'test' => '  addr_basename(\'../foo.txt\');',
  'invert' => 0,
  'lineno' => 383,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'num' => 125,
  'summary' => '',
  'result' => 'foo'
}
;
$Info{'t126'} = {
  'lineno' => 384,
  'invert' => 0,
  'test' => '  addr_basename(\'/foo/foo.txt\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'summary' => '',
  'result' => 'foo',
  'num' => 126
}
;
$Info{'t127'} = {
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  addr_basename(\'/foo.bar.txt\');',
  'lineno' => 385,
  'invert' => 0,
  'num' => 127,
  'result' => 'foo.bar',
  'summary' => ''
}
;
$Info{'t128'} = {
  'summary' => '',
  'num' => 128,
  'result' => 'bar',
  'lineno' => 386,
  'invert' => 0,
  'test' => '  addr_basename(\'/foo/bar.\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm'
}
;
$Info{'t129'} = {
  'num' => 129,
  'result' => 'bar',
  'summary' => '',
  'lineno' => 387,
  'invert' => 0,
  'test' => '  addr_basename(\'/foo/bar\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm'
}
;
$Info{'t130'} = {
  'result' => '',
  'num' => 130,
  'summary' => '',
  'lineno' => 388,
  'invert' => 1,
  'test' => '  addr_basename(\'.metadata\');',
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm'
}
;
$Info{'t131'} = {
  'result' => '.metadata',
  'num' => 131,
  'summary' => '',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 389,
  'invert' => 0,
  'test' => '  addr_basename(\'.metadata.bak\');'
}
;
$Info{'t132'} = {
  'invert' => 0,
  'lineno' => 404,
  'test' => '  addr_base(\'/a/b/{d}\');',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'num' => 132,
  'result' => '/a/b'
}
;
$Info{'t133'} = {
  'num' => 133,
  'result' => '/a/b/d',
  'summary' => '',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 405,
  'invert' => 0,
  'test' => '  addr_base(\'/a/b/d\');'
}
;
$Info{'t134'} = {
  'summary' => '',
  'num' => 134,
  'result' => 'one:two:..:four',
  'lineno' => 429,
  'invert' => 0,
  'test' => '  my $path = \'/one/two/../four\';
  join(\':\', path_shift($path), path_shift($path), path_shift($path),
  path_shift($path)); ',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm'
}
;
$Info{'t135'} = {
  'result' => 'two,/one',
  'num' => 135,
  'summary' => '',
  'invert' => 0,
  'lineno' => 442,
  'test' => '  my $path = \'/one/two\';
  my $last = path_pop($path);
  "$last,$path"',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util'
}
;
$Info{'t136'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  my $path = \'/one/two\';
  my $count = path_push($path, \'three\');
  "$path"',
  'invert' => 0,
  'lineno' => 455,
  'result' => '/one/two/three',
  'summary' => '',
  'num' => 136
}
;
$Info{'t137'} = {
  'result' => '0',
  'num' => 137,
  'summary' => '',
  'test' => '  path_split(\'\');',
  'invert' => 0,
  'lineno' => 467,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match'
}
;
$Info{'t138'} = {
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  join \' \', path_split(\'/\');',
  'lineno' => 468,
  'invert' => 0,
  'summary' => '',
  'num' => 138,
  'result' => ''
}
;
$Info{'t139'} = {
  'summary' => '',
  'result' => 'a',
  'num' => 139,
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 469,
  'test' => '  join \' \', path_split(\'/a\');'
}
;
$Info{'t140'} = {
  'num' => 140,
  'result' => 'a',
  'summary' => '',
  'invert' => 0,
  'lineno' => 470,
  'test' => '  join \' \', path_split(\'/a/b/..\');',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util'
}
;
$Info{'t141'} = {
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  join \' \', path_split(\'a/b/\');',
  'lineno' => 471,
  'invert' => 0,
  'result' => 'a b',
  'num' => 141,
  'summary' => ''
}
;
$Info{'t142'} = {
  'num' => 142,
  'summary' => '',
  'result' => 'a b.c',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 472,
  'invert' => 0,
  'test' => '  join \' \', path_split(\'a/b.c\');'
}
;
$Info{'t143'} = {
  'result' => '',
  'num' => 143,
  'summary' => '',
  'lineno' => 489,
  'invert' => 1,
  'test' => '  path_basename(undef);',
  'comparator' => 'defined',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm'
}
;
$Info{'t144'} = {
  'lineno' => 490,
  'invert' => 0,
  'test' => '  path_basename(\'foo.txt\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'num' => 144,
  'summary' => '',
  'result' => 'foo'
}
;
$Info{'t145'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 491,
  'test' => '  path_basename(\'/foo.txt\');',
  'result' => 'foo',
  'summary' => '',
  'num' => 145
}
;
$Info{'t146'} = {
  'num' => 146,
  'summary' => '',
  'result' => 'foo',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  path_basename(\'./foo.txt\');',
  'invert' => 0,
  'lineno' => 492
}
;
$Info{'t147'} = {
  'summary' => '',
  'result' => 'foo',
  'num' => 147,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 493,
  'invert' => 0,
  'test' => '  path_basename(\'../foo.txt\');'
}
;
$Info{'t148'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 494,
  'test' => '  path_basename(\'/foo/foo.txt\');',
  'num' => 148,
  'summary' => '',
  'result' => 'foo'
}
;
$Info{'t149'} = {
  'summary' => '',
  'num' => 149,
  'result' => 'foo.bar',
  'test' => '  path_basename(\'/foo.bar.txt\');',
  'lineno' => 495,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match'
}
;
$Info{'t150'} = {
  'num' => 150,
  'result' => 'bar',
  'summary' => '',
  'lineno' => 496,
  'invert' => 0,
  'test' => '  path_basename(\'/foo/bar.\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm'
}
;
$Info{'t151'} = {
  'summary' => '',
  'result' => 'bar',
  'num' => 151,
  'test' => '  path_basename(\'/foo/bar\');',
  'invert' => 0,
  'lineno' => 497,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match'
}
;
$Info{'t152'} = {
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 498,
  'invert' => 0,
  'test' => '  path_basename(\'.bashrc\');',
  'num' => 152,
  'summary' => '',
  'result' => '.bashrc'
}
;
$Info{'t153'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  path_basename(\'.bashrc.tmp\');',
  'invert' => 0,
  'lineno' => 499,
  'summary' => '',
  'num' => 153,
  'result' => '.bashrc'
}
;
$Info{'t154'} = {
  'result' => 'no-dots',
  'summary' => '',
  'num' => 154,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  path_basename(\'/no-dots\');',
  'invert' => 0,
  'lineno' => 500
}
;
$Info{'t155'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'defined',
  'test' => '  path_ext(undef);',
  'invert' => 1,
  'lineno' => 517,
  'num' => 155,
  'result' => '',
  'summary' => ''
}
;
$Info{'t156'} = {
  'result' => 'txt',
  'summary' => '',
  'num' => 156,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  path_ext(\'foo.txt\');',
  'invert' => 0,
  'lineno' => 518
}
;
$Info{'t157'} = {
  'num' => 157,
  'summary' => '',
  'result' => 'txt',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 519,
  'test' => '  path_ext(\'/foo.txt\');'
}
;
$Info{'t158'} = {
  'num' => 158,
  'result' => 'txt',
  'summary' => '',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 520,
  'test' => '  path_ext(\'./foo.txt\');'
}
;
$Info{'t159'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 521,
  'test' => '  path_ext(\'../foo.txt\');',
  'num' => 159,
  'summary' => '',
  'result' => 'txt'
}
;
$Info{'t160'} = {
  'lineno' => 522,
  'invert' => 0,
  'test' => '  path_ext(\'/foo/foo.txt\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'num' => 160,
  'summary' => '',
  'result' => 'txt'
}
;
$Info{'t161'} = {
  'summary' => '',
  'result' => 'txt',
  'num' => 161,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  path_ext(\'/foo.bar.txt\');',
  'lineno' => 523,
  'invert' => 0
}
;
$Info{'t162'} = {
  'test' => '  path_ext(\'/foo/bar.\');',
  'invert' => 0,
  'lineno' => 524,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'result' => '',
  'num' => 162,
  'summary' => ''
}
;
$Info{'t163'} = {
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'defined',
  'test' => '  path_ext(\'/foo/bar\');',
  'lineno' => 525,
  'invert' => 1,
  'summary' => '',
  'num' => 163,
  'result' => ''
}
;
$Info{'t164'} = {
  'result' => '',
  'summary' => '',
  'num' => 164,
  'comparator' => 'defined',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 1,
  'lineno' => 526,
  'test' => '  path_ext(\'.bashrc\');'
}
;
$Info{'t165'} = {
  'invert' => 0,
  'lineno' => 527,
  'test' => '  path_ext(\'.bashrc.tmp\');',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'result' => 'tmp',
  'num' => 165,
  'summary' => ''
}
;
$Info{'t166'} = {
  'test' => '  path_ext(\'/no-dots\');',
  'lineno' => 528,
  'invert' => 1,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'defined',
  'num' => 166,
  'summary' => '',
  'result' => ''
}
;
$Info{'t167'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 544,
  'test' => '  path_normalize(\'/\');',
  'result' => '/',
  'num' => 167,
  'summary' => ''
}
;
$Info{'t168'} = {
  'summary' => '',
  'result' => '/a',
  'num' => 168,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  path_normalize(\'/a/\');',
  'lineno' => 545,
  'invert' => 0
}
;
$Info{'t169'} = {
  'summary' => '',
  'num' => 169,
  'result' => '/a',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 546,
  'invert' => 0,
  'test' => '  path_normalize(\'/a/b/..\');'
}
;
$Info{'t170'} = {
  'result' => '/a',
  'summary' => '',
  'num' => 170,
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 547,
  'invert' => 0,
  'test' => '  path_normalize(\'/a/../a\');'
}
;
$Info{'t171'} = {
  'summary' => '',
  'num' => 171,
  'result' => '/a',
  'lineno' => 548,
  'invert' => 0,
  'test' => '  path_normalize(\'/a/../../a\');',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm'
}
;
$Info{'t172'} = {
  'test' => '  path_normalize( "../../w/b/../s/x" );',
  'invert' => 0,
  'lineno' => 549,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'num' => 172,
  'result' => '../../w/s/x',
  'summary' => ''
}
;
$Info{'t173'} = {
  'test' => '  path_normalize( "u/n/w/" );',
  'lineno' => 550,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'num' => 173,
  'summary' => '',
  'result' => 'u/n/w'
}
;
$Info{'t174'} = {
  'result' => 'w/s',
  'num' => 174,
  'summary' => '',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 551,
  'invert' => 0,
  'test' => '  path_normalize( "u/../w/b/../s" );'
}
;
$Info{'t175'} = {
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  path_normalize( "u//n" );',
  'lineno' => 552,
  'invert' => 0,
  'num' => 175,
  'summary' => '',
  'result' => 'u/n'
}
;
$Info{'t176'} = {
  'result' => 'u/n/f',
  'summary' => '',
  'num' => 176,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  path_normalize( "u//n/./f" );',
  'lineno' => 553,
  'invert' => 0
}
;
$Info{'t177'} = {
  'invert' => 0,
  'lineno' => 554,
  'test' => '  path_normalize( "http://t/u//n" );',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'summary' => '',
  'result' => 'http://t/u/n',
  'num' => 177
}
;
$Info{'t178'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 555,
  'test' => '  path_normalize( \'/a/b/c/../../../d/e/f\' );',
  'summary' => '',
  'num' => 178,
  'result' => '/d/e/f'
}
;
$Info{'t179'} = {
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 556,
  'invert' => 0,
  'test' => '  path_normalize( \'./a\' );',
  'summary' => '',
  'result' => './a',
  'num' => 179
}
;
$Info{'t180'} = {
  'summary' => '',
  'result' => '/a',
  'num' => 180,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  path_normalize( \'/./a\' );',
  'lineno' => 557,
  'invert' => 0
}
;
$Info{'t181'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'defined',
  'test' => '  path_parent(\'\');',
  'invert' => 1,
  'lineno' => 595,
  'num' => 181,
  'result' => '',
  'summary' => ''
}
;
$Info{'t182'} = {
  'num' => 182,
  'result' => '/',
  'summary' => '',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 596,
  'test' => '  path_parent(\'/\');'
}
;
$Info{'t183'} = {
  'summary' => '',
  'num' => 183,
  'result' => '/',
  'comparator' => 'match',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 597,
  'invert' => 0,
  'test' => '  path_parent(\'/a\');'
}
;
$Info{'t184'} = {
  'summary' => '',
  'result' => '/',
  'num' => 184,
  'invert' => 0,
  'lineno' => 598,
  'test' => '  path_parent(\'/a/b/..\');',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util'
}
;
$Info{'t185'} = {
  'summary' => '',
  'num' => 185,
  'result' => '',
  'test' => '  path_parent(\'a\');',
  'invert' => 0,
  'lineno' => 599,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match'
}
;
$Info{'t186'} = {
  'test' => '  path_parent(\'a/b/\');',
  'lineno' => 600,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'summary' => '',
  'num' => 186,
  'result' => 'a'
}
;
$Info{'t187'} = {
  'result' => 'a',
  'summary' => '',
  'num' => 187,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'test' => '  path_parent(\'a/b.c\');',
  'lineno' => 601,
  'invert' => 0
}
;
$Info{'t188'} = {
  'num' => 188,
  'summary' => '',
  'result' => '../..',
  'test' => '  path_parent(\'../../a\');',
  'invert' => 0,
  'lineno' => 602,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match'
}
;
$Info{'t189'} = {
  'test' => '  path_name(\'\');',
  'invert' => 1,
  'lineno' => 614,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'defined',
  'result' => '',
  'summary' => '',
  'num' => 189
}
;
$Info{'t190'} = {
  'num' => 190,
  'result' => '',
  'summary' => '',
  'test' => '  path_name(\'/\');',
  'lineno' => 615,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match'
}
;
$Info{'t191'} = {
  'test' => '  path_name(\'/a\');',
  'lineno' => 616,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'match',
  'summary' => '',
  'result' => 'a',
  'num' => 191
}
;
$Info{'t192'} = {
  'result' => 'a',
  'num' => 192,
  'summary' => '',
  'test' => '  path_name(\'/a/b/..\');',
  'invert' => 0,
  'lineno' => 617,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match'
}
;
$Info{'t193'} = {
  'num' => 193,
  'summary' => '',
  'result' => 'b',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'match',
  'test' => '  path_name(\'a/b/\');',
  'invert' => 0,
  'lineno' => 618
}
;
$Info{'t194'} = {
  'invert' => 0,
  'lineno' => 619,
  'test' => '  path_name(\'a/b.c\');',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'num' => 194,
  'result' => 'b.c',
  'summary' => ''
}
;
$Info{'t195'} = {
  'test' => '  path_is_absolute(\'/a\');',
  'invert' => 0,
  'lineno' => 631,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'true',
  'summary' => '',
  'result' => '',
  'num' => 195
}
;
$Info{'t196'} = {
  'lineno' => 632,
  'invert' => 0,
  'test' => '  path_is_absolute(\'A:/b\');',
  'comparator' => 'true',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'result' => '',
  'summary' => '',
  'num' => 196
}
;
$Info{'t197'} = {
  'num' => 197,
  'result' => '',
  'summary' => '',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'true',
  'test' => '  path_is_absolute(\'/a/b\');',
  'lineno' => 633,
  'invert' => 0
}
;
$Info{'t198'} = {
  'test' => '  path_is_absolute(\'http://a\');',
  'invert' => 0,
  'lineno' => 634,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'comparator' => 'true',
  'result' => '',
  'num' => 198,
  'summary' => ''
}
;
$Info{'t199'} = {
  'comparator' => 'true',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 635,
  'invert' => 0,
  'test' => '  path_is_absolute(\'svn+ssh://a.b\');',
  'num' => 199,
  'summary' => '',
  'result' => ''
}
;
$Info{'t200'} = {
  'lineno' => 636,
  'invert' => 0,
  'test' => '  path_is_absolute(\'\');',
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'summary' => '',
  'result' => '',
  'num' => 200
}
;
$Info{'t201'} = {
  'test' => '  path_is_absolute(\'a/b\');',
  'lineno' => 637,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'false',
  'result' => '',
  'num' => 201,
  'summary' => ''
}
;
$Info{'t202'} = {
  'result' => '',
  'num' => 202,
  'summary' => '',
  'comparator' => 'false',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 638,
  'test' => '  path_is_absolute(\'a:\\\\b\');'
}
;
$Info{'t203'} = {
  'invert' => 0,
  'lineno' => 639,
  'test' => '  path_is_absolute(\'a/../b\');',
  'comparator' => 'false',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'num' => 203,
  'summary' => '',
  'result' => ''
}
;
$Info{'t204'} = {
  'test' => '  path_is_absolute(\'../a\');',
  'lineno' => 640,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'false',
  'summary' => '',
  'num' => 204,
  'result' => ''
}
;
$Info{'t205'} = {
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 641,
  'invert' => 0,
  'test' => '  path_is_absolute(\'./a\');',
  'result' => '',
  'num' => 205,
  'summary' => ''
}
;
$Info{'t206'} = {
  'invert' => 0,
  'lineno' => 642,
  'test' => '  path_is_absolute(\'svn+ssh//a.b\');',
  'comparator' => 'false',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'result' => '',
  'num' => 206,
  'summary' => ''
}
;
$Info{'t207'} = {
  'lineno' => 643,
  'invert' => 0,
  'test' => '  path_is_absolute(\'1://\');',
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'summary' => '',
  'num' => 207,
  'result' => ''
}
;
$Info{'t208'} = {
  'test' => '  path_is_absolute(\'+://\');',
  'lineno' => 644,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'false',
  'summary' => '',
  'result' => '',
  'num' => 208
}
;
$Info{'t209'} = {
  'num' => 209,
  'summary' => 'normal usage',
  'result' => '',
  'test' => '  dir_is_system(\'.svn\', \'/tmp\');',
  'lineno' => 923,
  'invert' => 0,
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'comparator' => 'true'
}
;
$Info{'t210'} = {
  'comparator' => 'true',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 0,
  'lineno' => 924,
  'test' => '  dir_is_system(\'.git\', \'/tmp\');',
  'num' => 210,
  'summary' => 'normal usage',
  'result' => ''
}
;
$Info{'t211'} = {
  'comparator' => 'false',
  'package' => 'Data::Hub::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'lineno' => 925,
  'invert' => 0,
  'test' => '  dir_is_system(\'.Svn\', \'/tmp\');',
  'summary' => 'case sensitive',
  'num' => 211,
  'result' => ''
}
;
$Info{'t212'} = {
  'comparator' => 'defined',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm',
  'package' => 'Data::Hub::Util',
  'invert' => 1,
  'lineno' => 926,
  'test' => '  dir_is_system(undef, undef);',
  'result' => '',
  'num' => 212,
  'summary' => 'undefined test'
}
;
$Info{'t213'} = {
  'num' => 213,
  'summary' => '',
  'result' => 'Apple;Cherry;Banana',
  'package' => 'Data::OrderedHash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/OrderedHash.pm',
  'comparator' => 'match',
  'test' => '  my %h = ();
  tie %h, \'Data::OrderedHash\';
  $h{\'first\'} = "Apple";
  $h{\'second\'} = "Cherry";
  $h{\'third\'} = "Banana";
  join \';\', values %h;',
  'lineno' => 111,
  'invert' => 0
}
;
$Info{'t214'} = {
  'result' => 'aXbBcC',
  'num' => 214,
  'summary' => 'Items retain their initial position',
  'test' => '  my $h = Data::OrderedHash->new();
  %$h = qw(a A b B c C);
  $$h{\'a\'} = \'X\';
  join \'\', %$h;',
  'lineno' => 120,
  'invert' => 0,
  'package' => 'Data::OrderedHash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/OrderedHash.pm',
  'comparator' => 'match'
}
;
$Info{'t215'} = {
  'summary' => '',
  'result' => 'zxyw',
  'num' => 215,
  'package' => 'Data::OrderedHash',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/OrderedHash.pm',
  'comparator' => 'match',
  'test' => '  my $h = Data::OrderedHash->new();
  $h->{\'z\'} = "Apple";
  $h->{\'x\'} = "Banana";
  $h->{\'y\'} = "Cherry";
  my $r = \'\';
  while (my ($k, $v) = each %$h) { $r .= $k; delete $$h{$k} }
  $h->{\'w\'} = "Can\'t elope";
  $r .= join(\'\', keys %$h);
  $r;',
  'lineno' => 127,
  'invert' => 0
}
;
$Info{'t216'} = {
  'comparator' => 'abort',
  'package' => 'Error::Logical',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Error/Logical.pm',
  'lineno' => 9,
  'invert' => 0,
  'test' => '  use Error::Logical;
  throw Error::DoesNotExist \'some resource\';',
  'num' => 216,
  'summary' => '',
  'result' => ''
}
;
$Info{'t217'} = {
  'summary' => '',
  'result' => '',
  'num' => 217,
  'invert' => 0,
  'lineno' => 12,
  'test' => '  use Error::Programatic;
  throw Error::NotStatic;',
  'comparator' => 'abort',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Error/Programatic.pm',
  'package' => 'Error::Programatic'
}
;
$Info{'t218'} = {
  'summary' => 'Create a new instance',
  'num' => 218,
  'result' => '',
  'comparator' => 'abort',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/LogUtil.pm',
  'package' => 'Misc::LogUtil',
  'invert' => 1,
  'lineno' => 15,
  'test' => '  use Misc::LogUtil;
  Misc::LogUtil->new();'
}
;
$Info{'t219'} = {
  'num' => 219,
  'result' => '',
  'summary' => '',
  'test' => '  use Misc::Stopwatch;',
  'invert' => 1,
  'lineno' => 10,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm',
  'package' => 'Misc::Stopwatch',
  'comparator' => 'abort'
}
;
$Info{'t220'} = {
  'test' => '  my $sw = Misc::Stopwatch->new();',
  'invert' => 0,
  'lineno' => 11,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm',
  'package' => 'Misc::Stopwatch',
  'comparator' => 'true',
  'summary' => '',
  'num' => 220,
  'result' => ''
}
;
$Info{'t221'} = {
  'summary' => '',
  'num' => 221,
  'result' => '',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm',
  'package' => 'Misc::Stopwatch',
  'comparator' => 'abort',
  'test' => '  my $sw = Misc::Stopwatch->new()->start();',
  'invert' => 1,
  'lineno' => 25
}
;
$Info{'t222'} = {
  'comparator' => 'abort',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm',
  'package' => 'Misc::Stopwatch',
  'invert' => 1,
  'lineno' => 41,
  'test' => '  my $sw = Misc::Stopwatch->new()->start()->lap();',
  'summary' => '',
  'num' => 222,
  'result' => ''
}
;
$Info{'t223'} = {
  'test' => '  my $sw = Misc::Stopwatch->new()->start()->stop();',
  'lineno' => 54,
  'invert' => 1,
  'package' => 'Misc::Stopwatch',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm',
  'comparator' => 'abort',
  'num' => 223,
  'summary' => '',
  'result' => ''
}
;
$Info{'t224'} = {
  'result' => '',
  'summary' => '',
  'num' => 224,
  'package' => 'Misc::Stopwatch',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm',
  'comparator' => 'true',
  'test' => '  Misc::Stopwatch->new()->start()->elapsed();',
  'lineno' => 76,
  'invert' => 0
}
;
$Info{'t225'} = {
  'test' => '  my $sw = Misc::Stopwatch->new()->reset();',
  'lineno' => 97,
  'invert' => 1,
  'package' => 'Misc::Stopwatch',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm',
  'comparator' => 'abort',
  'num' => 225,
  'result' => '',
  'summary' => ''
}
;
$Info{'t226'} = {
  'num' => 226,
  'summary' => '',
  'result' => '',
  'comparator' => 'false',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm',
  'package' => 'Misc::Stopwatch',
  'invert' => 0,
  'lineno' => 111,
  'test' => '  Misc::Stopwatch->new()->is_running();'
}
;
$Info{'t227'} = {
  'package' => 'Misc::Stopwatch',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm',
  'comparator' => 'true',
  'test' => '  Misc::Stopwatch->new()->start()->is_running();',
  'lineno' => 112,
  'invert' => 0,
  'result' => '',
  'summary' => '',
  'num' => 227
}
;
$Info{'t228'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Time.pm',
  'package' => 'Misc::Time',
  'comparator' => 'abort',
  'test' => '  use Misc::Time qw(:all);',
  'invert' => 1,
  'lineno' => 88,
  'num' => 228,
  'result' => '',
  'summary' => ''
}
;
$Info{'t229'} = {
  'comparator' => 'match',
  'package' => 'Misc::Time',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Time.pm',
  'lineno' => 89,
  'invert' => 0,
  'test' => '  time_apr_to_hires(\'1193094188212812\');',
  'num' => 229,
  'result' => '1193094188.212812',
  'summary' => 'Simple time string conversion'
}
;
$Info{'t230'} = {
  'comparator' => 'abort',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'invert' => 1,
  'lineno' => 31,
  'test' => '  use Parse::Padding qw(padding);',
  'result' => '',
  'num' => 230,
  'summary' => ''
}
;
$Info{'t231'} = {
  'package' => 'Parse::Padding',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'comparator' => 'match',
  'test' => '  my $str = "    a   ";
  join \';\', padding(\\$str, 4, 5);',
  'lineno' => 33,
  'invert' => 0,
  'num' => 231,
  'result' => '4;3',
  'summary' => ''
}
;
$Info{'t232'} = {
  'result' => '2;3',
  'summary' => '',
  'num' => 232,
  'lineno' => 37,
  'invert' => 0,
  'test' => '  my $str = " \\na\\r\\n ";
  join \';\', padding(\\$str, 2, 3);',
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm'
}
;
$Info{'t233'} = {
  'package' => 'Parse::Padding',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'comparator' => 'match',
  'test' => '  my $str = " \\na\\r\\n ";
  join \';\', padding(\\$str, 2, 3, -crlf);',
  'lineno' => 41,
  'invert' => 0,
  'summary' => '',
  'result' => '1;2',
  'num' => 233
}
;
$Info{'t234'} = {
  'num' => 234,
  'result' => '1;2',
  'summary' => '',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'comparator' => 'match',
  'test' => '  my $str = " \\n\\na\\r\\n\\r\\n ";
  join \';\', padding(\\$str, 3, 4, -crlf);',
  'invert' => 0,
  'lineno' => 45
}
;
$Info{'t235'} = {
  'invert' => 0,
  'lineno' => 49,
  'test' => '  my $str = " a ";
  join \';\', padding(\\$str, 1, 2, -crlf);',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'summary' => '',
  'result' => '0;0',
  'num' => 235
}
;
$Info{'t236'} = {
  'comparator' => 'abort',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'invert' => 1,
  'lineno' => 92,
  'test' => '  use Parse::Padding qw(trailing);',
  'num' => 236,
  'result' => '',
  'summary' => ''
}
;
$Info{'t237'} = {
  'summary' => 'invalid index',
  'num' => 237,
  'result' => '',
  'test' => '  trailing(\'\\r\\n\', " xxx\\r\\n", \'abc\');',
  'lineno' => 93,
  'invert' => 0,
  'package' => 'Parse::Padding',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'comparator' => 'abort'
}
;
$Info{'t238'} = {
  'lineno' => 94,
  'invert' => 0,
  'test' => '  trailing(\'\', " xxx\\r\\n", 4);',
  'comparator' => 'abort',
  'package' => 'Parse::Padding',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'result' => '',
  'summary' => 'invalid chars',
  'num' => 238
}
;
$Info{'t239'} = {
  'result' => '3',
  'num' => 239,
  'summary' => '',
  'invert' => 0,
  'lineno' => 95,
  'test' => '  trailing(\'\\s\', " xxx \\r\\n", 4);',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding'
}
;
$Info{'t240'} = {
  'result' => '0',
  'num' => 240,
  'summary' => '',
  'test' => '  trailing(\'\\r\\n\', " xxx \\r\\n", 4);',
  'invert' => 0,
  'lineno' => 96,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'comparator' => 'match'
}
;
$Info{'t241'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'invert' => 0,
  'lineno' => 97,
  'test' => '  trailing(\'\\r\\n\', " xxx\\r\\n", 4);',
  'num' => 241,
  'summary' => '',
  'result' => '2'
}
;
$Info{'t242'} = {
  'num' => 242,
  'summary' => '',
  'result' => '0',
  'invert' => 0,
  'lineno' => 98,
  'test' => '  trailing(\'\\r\\n\', " xxx\\r\\n", 999);',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding'
}
;
$Info{'t243'} = {
  'summary' => '',
  'num' => 243,
  'result' => '0',
  'test' => '  trailing(\'\\r\\n\', " xxx\\r\\n", -999);',
  'invert' => 0,
  'lineno' => 99,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'comparator' => 'match'
}
;
$Info{'t244'} = {
  'summary' => '',
  'result' => '2',
  'num' => 244,
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'invert' => 0,
  'lineno' => 100,
  'test' => '  trailing(\'\\r\\n\', "\\r\\n\\r\\n", 0, 1);'
}
;
$Info{'t245'} = {
  'result' => '1',
  'num' => 245,
  'summary' => '',
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'lineno' => 101,
  'invert' => 0,
  'test' => '  trailing(\'\\r\\n\', "\\n\\n\\n", 0, 1);'
}
;
$Info{'t246'} = {
  'invert' => 0,
  'lineno' => 102,
  'test' => '  trailing(\'abcd\', "a\\na", 2, 1);',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'num' => 246,
  'result' => '1',
  'summary' => 'end-of-string == $eol'
}
;
$Info{'t247'} = {
  'num' => 247,
  'summary' => '',
  'result' => '',
  'lineno' => 142,
  'invert' => 1,
  'test' => '  use Parse::Padding qw(leading);',
  'comparator' => 'abort',
  'package' => 'Parse::Padding',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm'
}
;
$Info{'t248'} = {
  'lineno' => 143,
  'invert' => 0,
  'test' => '  leading(\'\\s\', " xxx", 1);',
  'comparator' => 'match',
  'package' => 'Parse::Padding',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'summary' => '',
  'result' => '1',
  'num' => 248
}
;
$Info{'t249'} = {
  'summary' => '',
  'result' => '3',
  'num' => 249,
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'invert' => 0,
  'lineno' => 144,
  'test' => '  leading(\'\\s\', "\\r \\nxxx", 3);'
}
;
$Info{'t250'} = {
  'summary' => '',
  'num' => 250,
  'result' => '0',
  'test' => '  leading(\'\\r\\n\', " xxx", 1);',
  'invert' => 0,
  'lineno' => 145,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'comparator' => 'match'
}
;
$Info{'t251'} = {
  'num' => 251,
  'summary' => '',
  'result' => '3',
  'test' => '  leading(\'\\r\\n\', "\\r\\n\\rxxx", 3);',
  'lineno' => 146,
  'invert' => 0,
  'package' => 'Parse::Padding',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'comparator' => 'match'
}
;
$Info{'t252'} = {
  'summary' => '',
  'result' => '0',
  'num' => 252,
  'invert' => 0,
  'lineno' => 147,
  'test' => '  leading(\'\\r\\n\', "\\r\\n\\rxxx", -999);',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding'
}
;
$Info{'t253'} = {
  'num' => 253,
  'result' => '0',
  'summary' => '',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'invert' => 0,
  'lineno' => 148,
  'test' => '  leading(\'\\r\\n\', "\\r\\n\\rxxx", 999);'
}
;
$Info{'t254'} = {
  'lineno' => 149,
  'invert' => 0,
  'test' => '  leading(\'\', "\\r\\n\\rxxx", 3);',
  'comparator' => 'abort',
  'package' => 'Parse::Padding',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'result' => '',
  'summary' => 'invalid chars',
  'num' => 254
}
;
$Info{'t255'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'comparator' => 'abort',
  'test' => '  leading(\'\\r\\n\', "\\r\\n\\rxxx", \'abc\');',
  'invert' => 0,
  'lineno' => 150,
  'result' => '',
  'summary' => 'invalid index',
  'num' => 255
}
;
$Info{'t256'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'package' => 'Parse::Padding',
  'comparator' => 'match',
  'test' => '  leading(\'abcd\', "axe", 1, 1);',
  'invert' => 0,
  'lineno' => 151,
  'result' => '1',
  'num' => 256,
  'summary' => 'begin-of-string == $bol'
}
;
$Info{'t257'} = {
  'package' => 'Parse::Padding',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm',
  'comparator' => 'match',
  'test' => '  leading(\'abcd\', "\\naxe", 2, 1);',
  'lineno' => 152,
  'invert' => 0,
  'result' => '1',
  'summary' => '',
  'num' => 257
}
;
$Info{'t258'} = {
  'comparator' => 'abort',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm',
  'package' => 'Parse::StringToken',
  'invert' => 1,
  'lineno' => 21,
  'test' => '  use Parse::StringToken qw(:all);',
  'num' => 258,
  'result' => '',
  'summary' => 'Include symbols'
}
;
$Info{'t259'} = {
  'result' => '',
  'num' => 259,
  'summary' => 'Needs to have matching pairs',
  'lineno' => 44,
  'invert' => 0,
  'test' => '  str_token(\'\', -contained => \'123\');',
  'comparator' => 'abort',
  'package' => 'Parse::StringToken',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm'
}
;
$Info{'t260'} = {
  'test' => '  str_token("a b c")->shift;',
  'lineno' => 58,
  'invert' => 0,
  'package' => 'Parse::StringToken',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm',
  'comparator' => 'match',
  'result' => 'a',
  'num' => 260,
  'summary' => 'Basic'
}
;
$Info{'t261'} = {
  'num' => 261,
  'summary' => 'Contains spaces',
  'result' => 'and a two',
  'test' => '  my $s = str_token(q(one \'and a two\' "and a three"));
  $s->shift; $s->shift;',
  'invert' => 0,
  'lineno' => 59,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm',
  'package' => 'Parse::StringToken',
  'comparator' => 'match'
}
;
$Info{'t262'} = {
  'summary' => 'Basic',
  'result' => 'c',
  'num' => 262,
  'invert' => 0,
  'lineno' => 82,
  'test' => '  str_token("a b c")->pop;',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm',
  'package' => 'Parse::StringToken'
}
;
$Info{'t263'} = {
  'num' => 263,
  'summary' => 'Contains spaces',
  'result' => 'and a two',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm',
  'package' => 'Parse::StringToken',
  'invert' => 0,
  'lineno' => 83,
  'test' => '  my $s = str_token(q(one \'and a two\' "and a three"));
  $s->pop;
  $s->pop;'
}
;
$Info{'t264'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm',
  'package' => 'Parse::StringToken',
  'comparator' => 'match',
  'test' => '  join(\'-\', str_token("a b c")->split);',
  'invert' => 0,
  'lineno' => 100,
  'result' => 'a-b-c',
  'summary' => 'Basic',
  'num' => 264
}
;
$Info{'t265'} = {
  'summary' => '',
  'result' => '0-3,1-2',
  'num' => 265,
  'test' => '  use Parse::Template::Base;
  my $p = new Parse::Template::Base;
  my $text = \'<<>>\';
  my @pos = $p->substr_pos(\\$text, \'<\', \'>\', 0);
  join \',\', map {join \'-\', @$_} @pos;',
  'lineno' => 954,
  'invert' => 0,
  'package' => 'Parse::Template::Base',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Base.pm',
  'comparator' => 'match'
}
;
$Info{'t266'} = {
  'invert' => 0,
  'lineno' => 1055,
  'test' => '  use Parse::Template::Standard;
  my $t = \'Hello [#name]\';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\\$t, {name => \'World\'});
  return $$o;',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Base.pm',
  'package' => 'Parse::Template::Base',
  'summary' => 'Simple replacement',
  'result' => 'Hello World',
  'num' => 266
}
;
$Info{'t267'} = {
  'num' => 267,
  'result' => 'Hello World',
  'summary' => 'Variable expansion',
  'test' => '  use Parse::Template::Standard;
  my $t = \'Hello [#name]\';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\\$t, {name => \'[#next]\', next => \'World\'});
  return $$o;',
  'lineno' => 1063,
  'invert' => 0,
  'package' => 'Parse::Template::Base',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Base.pm',
  'comparator' => 'match'
}
;
$Info{'t268'} = {
  'package' => 'Parse::Template::Base',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Base.pm',
  'comparator' => 'match',
  'test' => '  use Parse::Template::Standard;
  my $t = \'Hello [#data/name]\';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\\$t, {data => {name => \'World\'}});
  return $$o;',
  'lineno' => 1071,
  'invert' => 0,
  'num' => 268,
  'summary' => 'Nested elements',
  'result' => 'Hello World'
}
;
$Info{'t269'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Base.pm',
  'package' => 'Parse::Template::Base',
  'invert' => 0,
  'lineno' => 1079,
  'test' => '  use Parse::Template::Standard;
  my $t = \'Hello [#[#name]]\';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\\$t, {name => \'next\', next => \'World\'});
  return $$o;',
  'num' => 269,
  'summary' => 'Dynamic expansion',
  'result' => 'Hello World'
}
;
$Info{'t270'} = {
  'comparator' => 'abort',
  'package' => 'Parse::Template::Web',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Web.pm',
  'lineno' => 64,
  'invert' => 1,
  'test' => '  use Parse::Template::Web;',
  'result' => '',
  'num' => 270,
  'summary' => ''
}
;
$Info{'t271'} = {
  'lineno' => 65,
  'invert' => 1,
  'test' => '  use Data::Hub;',
  'comparator' => 'abort',
  'package' => 'Parse::Template::Web',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Web.pm',
  'summary' => '',
  'result' => '',
  'num' => 271
}
;
$Info{'t272'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Web.pm',
  'package' => 'Parse::Template::Web',
  'comparator' => 'match',
  'test' => '  my $p = Parse::Template::Web->new(Data::Hub->new());
  $p->defang(\'a[#b]c\');',
  'invert' => 0,
  'lineno' => 66,
  'num' => 272,
  'result' => 'abc',
  'summary' => ''
}
;
$Info{'t273'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Web.pm',
  'package' => 'Parse::Template::Web',
  'comparator' => 'match',
  'test' => '  my $p = Parse::Template::Web->new(Data::Hub->new());
  my $r = $p->defang([\'a[#b]c\', \'a<b>c</d>e\']);
  join(\'\', @$r);',
  'invert' => 0,
  'lineno' => 69,
  'summary' => '',
  'result' => 'abcabc/de',
  'num' => 273
}
;
$Info{'t274'} = {
  'summary' => '',
  'num' => 274,
  'result' => '3:|:1:odd',
  'test' => '  package Foo;
  use Perl::Class;
  use base qw(Perl::Class::Hash);
  sub new {
    $_[0]->SUPER::new(1 => 2, \'odd\');
  }
  1;
  package main;
  my $c = Foo->new();
  $c->{3} = 4;
  join \':\', (keys %$c, \'|\', sort keys %{$c->__});',
  'lineno' => 69,
  'invert' => 0,
  'package' => 'Perl::Class::Scalar',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Class.pm',
  'comparator' => 'match'
}
;
$Info{'t275'} = {
  'num' => 275,
  'summary' => '',
  'result' => '',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'package' => 'Perl::Compare',
  'comparator' => 'false',
  'test' => '  compare(\'eq\',\'\',undef);',
  'invert' => 0,
  'lineno' => 125
}
;
$Info{'t276'} = {
  'num' => 276,
  'summary' => '',
  'result' => '',
  'comparator' => 'true',
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'lineno' => 126,
  'invert' => 0,
  'test' => '  compare(\'eq\',\'abc\',\'abc\');'
}
;
$Info{'t277'} = {
  'invert' => 0,
  'lineno' => 127,
  'test' => '  compare(\'ne\',\'abc\',\'Abc\');',
  'comparator' => 'true',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'package' => 'Perl::Compare',
  'result' => '',
  'num' => 277,
  'summary' => ''
}
;
$Info{'t278'} = {
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'comparator' => 'false',
  'test' => '  compare(\'eq\',\'abc\',undef);',
  'lineno' => 128,
  'invert' => 0,
  'result' => '',
  'num' => 278,
  'summary' => ''
}
;
$Info{'t279'} = {
  'summary' => '',
  'result' => '',
  'num' => 279,
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'comparator' => 'true',
  'test' => '  compare(\'!~\',\'abc\',\'A\');',
  'lineno' => 129,
  'invert' => 0
}
;
$Info{'t280'} = {
  'result' => '',
  'num' => 280,
  'summary' => '',
  'lineno' => 130,
  'invert' => 0,
  'test' => '  compare(\'=~\',\'abc\',\'a\');',
  'comparator' => 'true',
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm'
}
;
$Info{'t281'} = {
  'num' => 281,
  'result' => '',
  'summary' => '',
  'lineno' => 131,
  'invert' => 0,
  'test' => '  compare(\'==\',1234,1234);',
  'comparator' => 'true',
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm'
}
;
$Info{'t282'} = {
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'comparator' => 'true',
  'test' => '  compare(\'>=\',1234,1234);',
  'lineno' => 132,
  'invert' => 0,
  'num' => 282,
  'summary' => '',
  'result' => ''
}
;
$Info{'t283'} = {
  'result' => '',
  'summary' => '',
  'num' => 283,
  'test' => '  compare(\'eqic\',\'abc\',\'Abc\');',
  'invert' => 0,
  'lineno' => 133,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'package' => 'Perl::Compare',
  'comparator' => 'true'
}
;
$Info{'t284'} = {
  'result' => '',
  'num' => 284,
  'summary' => '',
  'comparator' => 'true',
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'lineno' => 134,
  'invert' => 0,
  'test' => '  compare(\'==\',undef,undef);'
}
;
$Info{'t285'} = {
  'summary' => '',
  'result' => '',
  'num' => 285,
  'test' => '  compare(\'==\',0,undef);',
  'lineno' => 135,
  'invert' => 0,
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'comparator' => 'false'
}
;
$Info{'t286'} = {
  'comparator' => 'false',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'package' => 'Perl::Compare',
  'invert' => 0,
  'lineno' => 136,
  'test' => '  compare(\'!~i\',\'abc\',\'A\');',
  'summary' => '',
  'result' => '',
  'num' => 286
}
;
$Info{'t287'} = {
  'invert' => 0,
  'lineno' => 137,
  'test' => '  compare(\'=~i\',\'abc\',\'A\');',
  'comparator' => 'true',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'package' => 'Perl::Compare',
  'result' => '',
  'summary' => '',
  'num' => 287
}
;
$Info{'t288'} = {
  'lineno' => 138,
  'invert' => 0,
  'test' => '  compare(\'eqic\',\'abc\',\'Abc\');',
  'comparator' => 'true',
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'summary' => '',
  'result' => '',
  'num' => 288
}
;
$Info{'t289'} = {
  'lineno' => 139,
  'invert' => 0,
  'test' => '  compare(\'neic\',\'abc\',\'Abc\');',
  'comparator' => 'false',
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'num' => 289,
  'result' => '',
  'summary' => ''
}
;
$Info{'t290'} = {
  'result' => '',
  'summary' => '',
  'num' => 290,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'package' => 'Perl::Compare',
  'comparator' => 'true',
  'test' => '  compare(\'mod\',4,2);',
  'invert' => 0,
  'lineno' => 140
}
;
$Info{'t291'} = {
  'result' => '',
  'summary' => '',
  'num' => 291,
  'invert' => 0,
  'lineno' => 141,
  'test' => '  compare(\'bw\',\'abc\',\'a\');',
  'comparator' => 'true',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'package' => 'Perl::Compare'
}
;
$Info{'t292'} = {
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'comparator' => 'false',
  'test' => '  compare(\'bw\',\'abc\',\'b\');',
  'lineno' => 142,
  'invert' => 0,
  'summary' => '',
  'result' => '',
  'num' => 292
}
;
$Info{'t293'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'package' => 'Perl::Compare',
  'comparator' => 'false',
  'test' => '  compare(\'ew\',\'abc\',\'b\');',
  'invert' => 0,
  'lineno' => 143,
  'num' => 293,
  'result' => '',
  'summary' => ''
}
;
$Info{'t294'} = {
  'invert' => 0,
  'lineno' => 144,
  'test' => '  compare(\'ew\',\'abc\',\'c\');',
  'comparator' => 'true',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'package' => 'Perl::Compare',
  'result' => '',
  'summary' => '',
  'num' => 294
}
;
$Info{'t295'} = {
  'summary' => '',
  'result' => '1;2;10;20',
  'num' => 295,
  'comparator' => 'match',
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'lineno' => 158,
  'invert' => 0,
  'test' => '  my @numbers = ( 20, 1, 10, 2 );
  join \';\', sort { &sort_compare(\'<=>\',$a,$b) } @numbers;'
}
;
$Info{'t296'} = {
  'summary' => '',
  'result' => '',
  'num' => 296,
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'comparator' => 'abort',
  'test' => '  use Perl::Compare qw(sort_keydepth);',
  'lineno' => 180,
  'invert' => 1
}
;
$Info{'t297'} = {
  'num' => 297,
  'result' => 'o/ne;t/w/o;th/r/e/e',
  'summary' => 'The deepest elements come last',
  'test' => '  join \';\', sort {&sort_keydepth($a, $b)} qw(t/w/o o/ne th/r/e/e);',
  'lineno' => 182,
  'invert' => 0,
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'comparator' => 'match'
}
;
$Info{'t298'} = {
  'lineno' => 186,
  'invert' => 0,
  'test' => '  no warnings \'uninitialized\';
  join \';\', sort {&sort_keydepth($a, $b)} (qw(t/w/o o/ne none th/r/e/e), undef);',
  'comparator' => 'match',
  'package' => 'Perl::Compare',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm',
  'num' => 298,
  'result' => ';none;o/ne;t/w/o;th/r/e/e',
  'summary' => 'Those without come after undefined but before those with'
}
;
$Info{'t299'} = {
  'summary' => '',
  'result' => '',
  'num' => 299,
  'comparator' => 'abort',
  'package' => 'Perl::Module',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Module.pm',
  'lineno' => 16,
  'invert' => 1,
  'test' => '  use Perl::Module;'
}
;
$Info{'t300'} = {
  'test' => '  join "\\n", sort @Perl::Module::EXPORT;',
  'lineno' => 17,
  'invert' => 0,
  'package' => 'Perl::Module',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Module.pm',
  'comparator' => 'match',
  'summary' => '',
  'num' => 300,
  'result' => 'Dumper
blessed
bytesize
can
carp
checksum
clone
cluck
compare
confess
croak
gettimeofday
grep_first
grep_first_index
index_imatch
index_match
index_unescaped
int_div
is_numeric
isa
max
min
my_opts
overlay
push_uniq
reftype
sleep
sort_compare
sort_keydepth
stat
str_ref
strftime
strptime
time
tv_interval
unshift_uniq
warnf'
}
;
$Info{'t301'} = {
  'comparator' => 'match',
  'package' => 'Perl::Options',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Options.pm',
  'lineno' => 29,
  'invert' => 0,
  'test' => '  my $sub = sub {
    my ($opts, @argv) = my_opts(\\@_);
    my $ret = join(\',\', sort(@_));
    $ret .= \';\' . join(\',\', sort keys %$opts);
    return $ret;
  };
  &$sub(\'a\', \'b\', \'-opt1\', -opt2 => \'See\', \'-opt3=0\');',
  'result' => 'a,b;opt1,opt2,opt3',
  'summary' => '',
  'num' => 301
}
;
$Info{'t302'} = {
  'num' => 302,
  'summary' => 'Load this module',
  'result' => '',
  'comparator' => 'abort',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'lineno' => 58,
  'invert' => 1,
  'test' => '  use Perl::Util qw(:all);'
}
;
$Info{'t303'} = {
  'num' => 303,
  'result' => 'a',
  'summary' => '',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'comparator' => 'match',
  'test' => '  my $a = str_ref("a"); $$a;',
  'lineno' => 92,
  'invert' => 0
}
;
$Info{'t304'} = {
  'lineno' => 128,
  'invert' => 0,
  'test' => '  is_numeric(\'-1\');',
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'summary' => '',
  'num' => 304,
  'result' => ''
}
;
$Info{'t305'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'comparator' => 'true',
  'test' => '  is_numeric(\'0\');',
  'invert' => 0,
  'lineno' => 129,
  'summary' => '',
  'result' => '',
  'num' => 305
}
;
$Info{'t306'} = {
  'summary' => '',
  'num' => 306,
  'result' => '',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'comparator' => 'true',
  'test' => '  is_numeric(\'+1\');',
  'invert' => 0,
  'lineno' => 130
}
;
$Info{'t307'} = {
  'result' => '',
  'summary' => '',
  'num' => 307,
  'comparator' => 'true',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'invert' => 0,
  'lineno' => 131,
  'test' => '  is_numeric(\'3.14\');'
}
;
$Info{'t308'} = {
  'num' => 308,
  'summary' => '',
  'result' => '',
  'lineno' => 132,
  'invert' => 0,
  'test' => '  is_numeric(\'6.02214E23\');',
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm'
}
;
$Info{'t309'} = {
  'test' => '  is_numeric(\'6.626068e-34\');',
  'invert' => 0,
  'lineno' => 133,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'comparator' => 'true',
  'result' => '',
  'summary' => '',
  'num' => 309
}
;
$Info{'t310'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'comparator' => 'false',
  'test' => '  is_numeric(\'3.1.4\');',
  'invert' => 0,
  'lineno' => 134,
  'summary' => '',
  'num' => 310,
  'result' => ''
}
;
$Info{'t311'} = {
  'num' => 311,
  'summary' => '',
  'result' => '',
  'lineno' => 135,
  'invert' => 0,
  'test' => '  is_numeric(\'\');',
  'comparator' => 'false',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm'
}
;
$Info{'t312'} = {
  'summary' => '',
  'num' => 312,
  'result' => '',
  'comparator' => 'false',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'lineno' => 136,
  'invert' => 0,
  'test' => '  is_numeric(\'three\');'
}
;
$Info{'t313'} = {
  'lineno' => 137,
  'invert' => 0,
  'test' => '  is_numeric(undef);',
  'comparator' => 'false',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'result' => '',
  'summary' => '',
  'num' => 313
}
;
$Info{'t314'} = {
  'test' => '  join(\'r\',int_div(3,2));',
  'lineno' => 151,
  'invert' => 0,
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'comparator' => 'match',
  'summary' => '3 divided by 2',
  'num' => 314,
  'result' => '1r1'
}
;
$Info{'t315'} = {
  'summary' => '3.9 divided by 2 (does not round)',
  'result' => '1r1',
  'num' => 315,
  'invert' => 0,
  'lineno' => 152,
  'test' => '  join(\'r\',int_div(3.9,2));',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util'
}
;
$Info{'t316'} = {
  'lineno' => 153,
  'invert' => 0,
  'test' => '  int_div(3,0);',
  'comparator' => 'abort',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'num' => 316,
  'result' => '',
  'summary' => 'divide by zero'
}
;
$Info{'t317'} = {
  'comparator' => 'abort',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'lineno' => 154,
  'invert' => 0,
  'test' => '  int_div(\'three\',1);',
  'summary' => 'not numeric',
  'result' => '',
  'num' => 317
}
;
$Info{'t318'} = {
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'comparator' => 'match',
  'test' => '  grep_first {/a/} qw(apple banana cherry);',
  'lineno' => 167,
  'invert' => 0,
  'num' => 318,
  'summary' => 'first item with an \\\'a\\\' in it',
  'result' => 'apple'
}
;
$Info{'t319'} = {
  'num' => 319,
  'summary' => 'index of first item with an \\\'a\\\' in it',
  'result' => '0',
  'test' => '  grep_first_index {/a/} qw(apple banana cherry);',
  'lineno' => 185,
  'invert' => 0,
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'comparator' => 'match'
}
;
$Info{'t320'} = {
  'summary' => '',
  'result' => '4',
  'num' => 320,
  'lineno' => 252,
  'invert' => 0,
  'test' => '  index_match("abracadabra", "[cd]")',
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm'
}
;
$Info{'t321'} = {
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'lineno' => 253,
  'invert' => 0,
  'test' => '  index_match("abracadabra", "a", 3)',
  'summary' => '',
  'num' => 321,
  'result' => '3'
}
;
$Info{'t322'} = {
  'test' => '  index_match("abracadabra", "d{2,2}")',
  'invert' => 0,
  'lineno' => 254,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'comparator' => 'match',
  'num' => 322,
  'result' => '-1',
  'summary' => ''
}
;
$Info{'t323'} = {
  'num' => 323,
  'result' => '4',
  'summary' => '',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'comparator' => 'match',
  'test' => '  my ($p, $str) = index_match("scant", "can");
  $p + length($str);',
  'lineno' => 255,
  'invert' => 0
}
;
$Info{'t324'} = {
  'invert' => 0,
  'lineno' => 257,
  'test' => '  index_match("foobar foo bar", \'\\bfoo\\b\') # zero-width test',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'result' => '7',
  'summary' => '',
  'num' => 324
}
;
$Info{'t325'} = {
  'invert' => 0,
  'lineno' => 258,
  'test' => '  index_match("foobar foo bar", \'Bar\') # no-match',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'summary' => '',
  'num' => 325,
  'result' => '-1'
}
;
$Info{'t326'} = {
  'result' => '0',
  'num' => 326,
  'summary' => '',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'invert' => 0,
  'lineno' => 259,
  'test' => '  index_match("aa", "a")'
}
;
$Info{'t327'} = {
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'lineno' => 260,
  'invert' => 0,
  'test' => '  index_match("aa", "a", 1)',
  'num' => 327,
  'result' => '1',
  'summary' => ''
}
;
$Info{'t328'} = {
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'comparator' => 'match',
  'test' => '  index_imatch("foobar foo bar", \'Bar\') # Case insensitive match',
  'lineno' => 271,
  'invert' => 0,
  'result' => '3',
  'num' => 328,
  'summary' => ''
}
;
$Info{'t329'} = {
  'result' => '2',
  'num' => 329,
  'summary' => '',
  'invert' => 0,
  'lineno' => 272,
  'test' => '  index_imatch(" b\\n a", \'\\s*a\') # Case insensitive match',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util'
}
;
$Info{'t330'} = {
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'comparator' => 'match',
  'test' => "  checksum('\x{201c}Hello\x{201d}', 'world');",
  'invert' => 0,
  'lineno' => 302,
  'num' => 330,
  'summary' => '',
  'result' => '1625030915'
}
;
$Info{'t331'} = {
  'result' => '10 B',
  'summary' => '',
  'num' => 331,
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'comparator' => 'match',
  'test' => '  bytesize(10)',
  'lineno' => 321,
  'invert' => 0
}
;
$Info{'t332'} = {
  'summary' => '',
  'result' => '10.77 KB',
  'num' => 332,
  'test' => '  bytesize(11028)',
  'invert' => 0,
  'lineno' => 322,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'comparator' => 'match'
}
;
$Info{'t333'} = {
  'summary' => '',
  'num' => 333,
  'result' => '953.6743 MB',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'invert' => 0,
  'lineno' => 323,
  'test' => '  bytesize(1000 ** 3, -precision => 4)'
}
;
$Info{'t334'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'invert' => 0,
  'lineno' => 324,
  'test' => '  bytesize(2 ** 30)',
  'summary' => '',
  'num' => 334,
  'result' => '1 GB'
}
;
$Info{'t335'} = {
  'result' => '512 PiB',
  'summary' => '',
  'num' => 335,
  'test' => '  bytesize(2 ** 59, -binary_symbol)',
  'lineno' => 325,
  'invert' => 0,
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'comparator' => 'match'
}
;
$Info{'t336'} = {
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'comparator' => 'defined',
  'test' => '  reftype(undef)',
  'lineno' => 357,
  'invert' => 1,
  'num' => 336,
  'summary' => '',
  'result' => ''
}
;
$Info{'t337'} = {
  'lineno' => 358,
  'invert' => 0,
  'test' => '  reftype(\'\')',
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'summary' => '',
  'result' => '',
  'num' => 337
}
;
$Info{'t338'} = {
  'result' => 'HASH',
  'num' => 338,
  'summary' => '',
  'lineno' => 359,
  'invert' => 0,
  'test' => '  reftype({})',
  'comparator' => 'match',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm'
}
;
$Info{'t339'} = {
  'test' => '  reftype([])',
  'lineno' => 360,
  'invert' => 0,
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'comparator' => 'match',
  'summary' => '',
  'result' => 'ARRAY',
  'num' => 339
}
;
$Info{'t340'} = {
  'result' => 'SCALAR',
  'summary' => '',
  'num' => 340,
  'test' => '  my $a = \'\'; reftype(\\$a)',
  'invert' => 0,
  'lineno' => 361,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util',
  'comparator' => 'match'
}
;
$Info{'t341'} = {
  'num' => 341,
  'summary' => '',
  'result' => 'REF',
  'invert' => 0,
  'lineno' => 362,
  'test' => '  my $a = \'\'; my $b = \\$a; reftype(\\$b)',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'package' => 'Perl::Util'
}
;
$Info{'t342'} = {
  'result' => '',
  'summary' => '',
  'num' => 342,
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'lineno' => 374,
  'invert' => 0,
  'test' => '  isa({}, \'HASH\')'
}
;
$Info{'t343'} = {
  'lineno' => 375,
  'invert' => 0,
  'test' => '  isa([], \'ARRAY\')',
  'comparator' => 'true',
  'package' => 'Perl::Util',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm',
  'result' => '',
  'num' => 343,
  'summary' => ''
}
;
$Info{'t344'} = {
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Livesite/Args.pm',
  'package' => 'WWW::Livesite::Args',
  'invert' => 0,
  'lineno' => 86,
  'test' => '  use WWW::Livesite::Args;
  my $qs = WWW::Livesite::Args->new(\'msg=hello%20world\');
  die if defined $qs->{MSG};
  return $qs->{msg};',
  'num' => 344,
  'result' => 'hello world',
  'summary' => ''
}
;
$Info{'t345'} = {
  'summary' => '',
  'result' => '1|2',
  'num' => 345,
  'package' => 'WWW::Livesite::Args',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Livesite/Args.pm',
  'comparator' => 'match',
  'test' => '  use WWW::Livesite::Args;
  my $qs = WWW::Livesite::Args->new(\'a=1&a=2\');
  my $a = $qs->{a};
  return join \'|\', @$a;',
  'lineno' => 93,
  'invert' => 0
}
;
$Info{'t346'} = {
  'invert' => 1,
  'lineno' => 197,
  'test' => '  use WWW::Misc::Image qw(resize_str_to_props);',
  'comparator' => 'abort',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'package' => 'WWW::Misc::Image',
  'result' => '',
  'summary' => '',
  'num' => 346
}
;
$Info{'t347'} = {
  'package' => 'WWW::Misc::Image',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'comparator' => 'match',
  'test' => '  my $props = resize_str_to_props(\'800\');
  join(\';\', map { $_ . \'=\' . $$props{$_} } sort keys %$props);',
  'lineno' => 198,
  'invert' => 0,
  'num' => 347,
  'result' => 'max_x=800;max_y=0;min_x=0;min_y=0',
  'summary' => ''
}
;
$Info{'t348'} = {
  'num' => 348,
  'summary' => '',
  'result' => 'max_x=800;max_y=600;min_x=0;min_y=0',
  'test' => '  my $props = resize_str_to_props(\'800x600\');
  join(\';\', map { $_ . \'=\' . $$props{$_} } sort keys %$props);',
  'lineno' => 202,
  'invert' => 0,
  'package' => 'WWW::Misc::Image',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'comparator' => 'match'
}
;
$Info{'t349'} = {
  'lineno' => 206,
  'invert' => 0,
  'test' => '  my $props = resize_str_to_props(\'800x600/480\');
  join(\';\', map { $_ . \'=\' . $$props{$_} } sort keys %$props);',
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'summary' => '',
  'result' => 'max_x=800;max_y=600;min_x=480;min_y=0',
  'num' => 349
}
;
$Info{'t350'} = {
  'num' => 350,
  'result' => 'max_x=800;max_y=0;min_x=480;min_y=0',
  'summary' => '',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'package' => 'WWW::Misc::Image',
  'invert' => 0,
  'lineno' => 210,
  'test' => '  my $props = resize_str_to_props(\'800/480\');
  join(\';\', map { $_ . \'=\' . $$props{$_} } sort keys %$props);'
}
;
$Info{'t351'} = {
  'package' => 'WWW::Misc::Image',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'comparator' => 'match',
  'test' => '  my $props = resize_str_to_props(\'100/z\');
  join(\';\', map { $_ . \'=\' . $$props{$_} } sort keys %$props);',
  'lineno' => 214,
  'invert' => 0,
  'num' => 351,
  'result' => 'flags=z;max_x=100;max_y=0;min_x=0;min_y=0',
  'summary' => ''
}
;
$Info{'t352'} = {
  'summary' => '',
  'num' => 352,
  'result' => '',
  'lineno' => 244,
  'invert' => 1,
  'test' => '  use WWW::Misc::Image qw(props_to_resize_str);',
  'comparator' => 'abort',
  'package' => 'WWW::Misc::Image',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm'
}
;
$Info{'t353'} = {
  'invert' => 0,
  'lineno' => 245,
  'test' => '  props_to_resize_str({max_x => 800});',
  'comparator' => 'match',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'package' => 'WWW::Misc::Image',
  'result' => '800',
  'summary' => '',
  'num' => 353
}
;
$Info{'t354'} = {
  'package' => 'WWW::Misc::Image',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'comparator' => 'match',
  'test' => '  props_to_resize_str({max_x => 800, max_y => 600});',
  'lineno' => 246,
  'invert' => 0,
  'num' => 354,
  'result' => '800x600',
  'summary' => ''
}
;
$Info{'t355'} = {
  'result' => '800/480',
  'num' => 355,
  'summary' => '',
  'test' => '  props_to_resize_str({max_x => 800, min_x => 480});',
  'invert' => 0,
  'lineno' => 247,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'package' => 'WWW::Misc::Image',
  'comparator' => 'match'
}
;
$Info{'t356'} = {
  'test' => '  props_to_resize_str({max_x => 100, max_y => 100,min_x => 100, min_y => 100});',
  'invert' => 0,
  'lineno' => 248,
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'package' => 'WWW::Misc::Image',
  'comparator' => 'match',
  'result' => '100x100/100x100',
  'num' => 356,
  'summary' => ''
}
;
$Info{'t357'} = {
  'comparator' => 'match',
  'package' => 'WWW::Misc::Image',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'lineno' => 250,
  'invert' => 0,
  'test' => '  props_to_resize_str({max_x => 100, flags => \'z\'});',
  'num' => 357,
  'result' => '100/z',
  'summary' => ''
}
;
$Info{'t358'} = {
  'comparator' => 'abort',
  'package' => 'WWW::Misc::Image',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'lineno' => 301,
  'invert' => 1,
  'test' => '  use WWW::Misc::Image qw(image_dims);',
  'summary' => '',
  'num' => 358,
  'result' => ''
}
;
$Info{'t359'} = {
  'comparator' => 'false',
  'package' => 'WWW::Misc::Image',
  'lib' => '/usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm',
  'lineno' => 302,
  'invert' => 0,
  'test' => '  image_dims("/foo");',
  'result' => '',
  'summary' => '',
  'num' => 359
}
;

our ($test,$tinfo,$result,$total_tests) = (undef,undef,undef,0);
$$Hub{'/sys/OPTS/v'} = 0 unless defined $$Hub{'/sys/OPTS/v'};
main();

# ------------------------------------------------------------------------------
# main - Test harness
# ------------------------------------------------------------------------------

sub main {
  $test = 1; # start at 1 to match ExtUtils::Command::MM
  my ($pass_count,$fail_count) = (0,0);
  while (eval("defined &t$test")) {
    $tinfo = $Info{"t$test"} or die "Cannot find testcase: $test\n";
    undef $result;
    $total_tests++;
    my $passed = eval( "&t$test()" );
    if( $@ ) {
      $result = $@;
      $passed = 0;
    } else {
      $passed = !$passed if( $$tinfo{'invert'} );
    }
    my $result_str = defined $result ? "'$result'" : 'undef';
    chomp $result_str;
    if( $passed ) {
      $pass_count++;
      printstatus( "passed: $result_str" ) if $$Hub{'/sys/OPTS/v'} > 1;
      printstatus( 'passed' ) if $$Hub{'/sys/OPTS/v'} eq 1;
    } else {
      $fail_count++;
      my $prefix = $result_str =~ /\n/ ? "FAILED:\n" : "FAILED: ";
      printstatus( "$prefix$result_str" );
    }
    $test++;
  }
  print "$pass_count of $total_tests passed.\n";
  exit ($pass_count == $total_tests ? 0 : 1);
}

# ------------------------------------------------------------------------------
# printstatus - Print pass/fail message
# ------------------------------------------------------------------------------

sub printstatus {
  printf "Test [%4d] %-25s line %5d: %s\n",
    $test,
    path_name($$tinfo{'package'}),
    $$tinfo{'lineno'}, @_;
}

# ------------------------------------------------------------------------------
# t1 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Algorithm/KeyGen.pm line: 56
# ------------------------------------------------------------------------------

sub t1 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Algorithm::KeyGen; 
  Algorithm::KeyGen->new(9, 'MyCharset');
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t2 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Algorithm/KeyGen.pm line: 177
# ------------------------------------------------------------------------------

sub t2 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Algorithm::KeyGen qw($KeyGen);
  for (1 .. 100) {
    die unless $KeyGen->validate($KeyGen->create());
  }
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t3 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 15
# ------------------------------------------------------------------------------

sub t3 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::CompositeHash;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t4 - Abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 16
# ------------------------------------------------------------------------------

sub t4 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $ch = Data::CompositeHash->new();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t5 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 31
# ------------------------------------------------------------------------------

sub t5 {
  $result = eval {
  my $h2 = {a=>'a2'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->shift;
  $ch->{a};
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t6 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 49
# ------------------------------------------------------------------------------

sub t6 {
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->{a};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a1';
}

# ------------------------------------------------------------------------------
# t7 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 68
# ------------------------------------------------------------------------------

sub t7 {
  $result = eval {
  my $h2 = {a=>'a2'};
  my $h3 = {a=>'a3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->push($h3);
  $ch->{a};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a2';
}

# ------------------------------------------------------------------------------
# t8 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 87
# ------------------------------------------------------------------------------

sub t8 {
  $result = eval {
  my $h2 = {a=>'a2'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->pop;
  $ch->{a};
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t9 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 121
# ------------------------------------------------------------------------------

sub t9 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  # We now have a composite stack with prescedence: $h1, $h2, $h3
  # Where $h2 is the default hash
  $ch->{a} = 'AA';
  $ch->{b} = 'BB';
  $ch->{c} = 'CC';
  $ch->{d} = 'DD';
  die unless $h1->{a} eq 'AA';
  die unless $h2->{b} eq 'BB';
  die unless $h3->{c} eq 'CC';
  die unless $h2->{d} eq 'DD'; # set on default hash b/c 'd' did not exist
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t10 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 157
# ------------------------------------------------------------------------------

sub t10 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  # We now have a composite stack with prescedence: $h1, $h2, $h3
  # Where $h2 is the default hash
  die unless $ch->{a} eq 'a1';
  die unless $ch->{b} eq 'b2';
  die unless $ch->{c} eq 'c3';
  die unless ref($ch->{'/'});
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t11 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 192
# ------------------------------------------------------------------------------

sub t11 {
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  join '', sort values %$ch;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a1b2c3';
}

# ------------------------------------------------------------------------------
# t12 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 213
# ------------------------------------------------------------------------------

sub t12 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  die unless exists $$ch{a};
  die unless exists $$ch{b};
  die unless exists $$ch{c};
  die if exists $$ch{d};
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t13 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 234
# ------------------------------------------------------------------------------

sub t13 {
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  delete $ch->{a};
  delete $ch->{b};
  delete $ch->{c};
  join '', sort values %$ch;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a2b3';
}

# ------------------------------------------------------------------------------
# t14 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 255
# ------------------------------------------------------------------------------

sub t14 {
  $result = eval {
  my $h1 = {a=>'a1'};
  my $h2 = {a=>'a2', b=>'b2'};
  my $h3 = {a=>'a3', b=>'b3', c=>'c3'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->unshift($h1);
  $ch->push($h3);
  %$ch = ();
  join '', sort values %$ch;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a2b2';
}

# ------------------------------------------------------------------------------
# t15 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 273
# ------------------------------------------------------------------------------

sub t15 {
  $result = eval {
  my $h2 = {a=>'a2', b=>'b2'};
  my $ch = Data::CompositeHash->new($h2);
  scalar(%$ch);
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t16 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 278
# ------------------------------------------------------------------------------

sub t16 {
  $result = eval {
  my $h2 = {a=>'a2', b=>'b2'};
  my $ch = Data::CompositeHash->new($h2);
  $ch->pop;
  scalar(%$ch);
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t17 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/CompositeHash.pm line: 289
# ------------------------------------------------------------------------------

sub t17 {
  $result = eval {
  use Data::CompositeHash;
  my $h1 = {
    'a' => 'argon',
  };
  my $h2 = {
    'a' => 'apple',
    'b' => 'banana',
    'c' => 'cherry',
  };
  my $h3 = {
    'c' => 'cyan',
    'd' => 'dark brown',
  };
  my $result = '';
  # Create a composite hash, using $h2 as the default hash
  my $ch = Data::CompositeHash->new($h2);
  # Add $h1 as a hash which will overried values in $h2
  $ch->unshift($h1);
  # Add $h3 as a hash with the least prescedence
  $ch->push($h3);
  # Fetch some values
  $result .= $ch->{a} . "\n";
  $result .= $ch->{b} . "\n";
  $result .= $ch->{c} . "\n";
  $result .= $ch->{d} . "\n";
  # Set an ambiguous value
  $result .= "--\n";
  $ch->{a} = 'aluminium';
  $result .= $h1->{a} . "\n"; # contains new value
  $result .= $h2->{a} . "\n"; # not touched
  # Set an ambiguous value
  $result .= "--\n";
  $ch->{c} = 'cantelope';
  $result .= $h2->{c} . "\n"; # contains new value
  $result .= $h3->{c} . "\n"; # not touched
  # Setting a value which is not defined in any hash sets
  # it on the defalut hash
  $result .= "--\n";
  $ch->{e} = 'edible fruit';
  $result .= $h2->{e};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'argon
banana
cherry
dark brown
--
aluminium
apple
--
cantelope
cyan
--
edible fruit';
}

# ------------------------------------------------------------------------------
# t18 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/Hash.pm line: 73
# ------------------------------------------------------------------------------

sub t18 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::Format::Hash qw(hf_parse);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t19 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/Hash.pm line: 74
# ------------------------------------------------------------------------------

sub t19 {
  $result = eval {
  my $d = q(
  baz => biz
  foo => %{
  bar => @{
  tender
  stool
  }
  }
  );
  my $h = hf_parse(\$d);
  $$h{'baz'};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'biz';
}

# ------------------------------------------------------------------------------
# t20 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/Hash.pm line: 315
# ------------------------------------------------------------------------------

sub t20 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::Format::Hash qw(hf_format);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t21 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/Hash.pm line: 316
# ------------------------------------------------------------------------------

sub t21 {
  $result = eval {
  my $d = {foo=>{bar=>['tender','stool']}};
  hf_format($d)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo => %{
  bar => @{
    tender
    stool
  }
}';
}

# ------------------------------------------------------------------------------
# t22 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/HexString.pm line: 15
# ------------------------------------------------------------------------------

sub t22 {
  $result = eval {
  use Data::Format::HexString qw(:all);
  hexstr_format( 'Dogs (Waters, Gilmour) 17:06' );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Dogs_0x20__0x28_Waters_0x2c__0x20_Gilmour_0x29__0x20_17_0x3a_06';
}

# ------------------------------------------------------------------------------
# t23 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/HexString.pm line: 29
# ------------------------------------------------------------------------------

sub t23 {
  $result = eval {
  hexstr_parse('Dogs_0x20__0x28_Waters_0x2c__0x20_Gilmour_0x29__0x20_17_0x3a_06');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Dogs (Waters, Gilmour) 17:06';
}

# ------------------------------------------------------------------------------
# t24 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Format/XFR.pm line: 205
# ------------------------------------------------------------------------------

sub t24 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::Format::XFR;
  use Data::OrderedHash;
  my $h = Data::OrderedHash->new(
    a => ['alpha', 'beta', 'copper'],
    b => {
      one => 1,
    },
    c => 'charlie',
  );
  my $xfr = Data::Format::XFR->new('base64');
  my $known = '%{YQ==@{${YWxwaGE=}${YmV0YQ==}${Y29wcGVy}}Yg==%{b25l${MQ==}}Yw==${Y2hhcmxpZQ==}}';
  my $str = $xfr->format($h);
  die "format error:\nstr: $str\n!= : $known" unless $str eq $known;
  my $h2 = $xfr->parse($str);
  die 'parse error' unless $h2->{a}[1] eq $h->{a}[1];
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t25 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Address.pm line: 33
# ------------------------------------------------------------------------------

sub t25 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
    
  use strict;
  use Data::Hub::Address;
  my $a = Data::Hub::Address->new("/b/c/d");
  die $a->to_string unless '/b/c/d' eq $a->to_string;
  die $a->first unless '' eq $a->first;
  die $a->last unless 'd' eq $a->last;
  $a->pop;
  die unless '/b/c' eq $a->to_string;
  $a->push("D");
  die unless '/b/c/D' eq $a->to_string;
  $a->shift;
  die unless 'b/c/D' eq $a->to_string;
  $a->unshift('A');
  die unless 'A/b/c/D' eq $a->to_string;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t26 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm line: 208
# ------------------------------------------------------------------------------

sub t26 {
  $result = eval {
  my $h = {g=>[qw(a b)]};
  Data::Hub::Courier::append($h, '/g', 'c');
  join('', @{$$h{g}});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t27 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm line: 213
# ------------------------------------------------------------------------------

sub t27 {
  $result = eval {
  my $h = {g=>Data::OrderedHash->new(a => 1, b => 2)};
  Data::Hub::Courier::append($h, '/g', c => 3);
  join('', keys %{$$h{g}});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t28 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm line: 218
# ------------------------------------------------------------------------------

sub t28 {
  $result = eval {
  my $h = {g=>str_ref('ab')};
  Data::Hub::Courier::append($h, '/g', 'c');
  ${$$h{g}};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t29 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm line: 255
# ------------------------------------------------------------------------------

sub t29 {
  $result = eval {
  my $h = {g=>[qw(b c)]};
  Data::Hub::Courier::prepend($h, '/g', 'a');
  join('', @{$$h{g}});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t30 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm line: 260
# ------------------------------------------------------------------------------

sub t30 {
  $result = eval {
  my $h = {g=>Data::OrderedHash->new(b => 2, c => 3)};
  Data::Hub::Courier::prepend($h, '/g', a => 1);
  join('', keys %{$$h{g}});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t31 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm line: 265
# ------------------------------------------------------------------------------

sub t31 {
  $result = eval {
  my $h = {g=>str_ref('bc')};
  Data::Hub::Courier::prepend($h, '/g', 'a');
  ${$$h{g}};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t32 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Courier.pm line: 385
# ------------------------------------------------------------------------------

sub t32 {
  $result = eval {
  use Data::Hub::Courier;
  my $h = {
    A => {
      I => [
        'Hello'
      ],
    },
  };
  Data::Hub::Courier::set($h, '/A/I/1', 'World!');
  my $a = Data::Hub::Courier::get($h, '/A/I');
  join ' ', @$a;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Hello World!';
}

# ------------------------------------------------------------------------------
# t33 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 410
# ------------------------------------------------------------------------------

sub t33 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  # This test case simply sets up the test data and subroutine for running
  # subsequent test queries.
  use Data::Hub::Util qw(:all);
  use Data::Format::Hash qw(hf_format hf_parse);
  use Data::OrderedHash;
  my $ttt_data = curry(hf_parse('
    array => @{
      a
      b
      c
      ab
      abc
    }
    hash => %{
      a => Alpha
      b => Beta
      c => Charlie
    }
    array_of_hashes => @{
      %{
        name => a
        text => Alpha
      }
      %{
        name => b
        text => Beta
      }
      %{
        name => c
        text => Charlie
      }
    }
    hash_of_hashes => %{
      a => %{
        text => Alpha
        num => 3
      }
      b => %{
        text => Beta
        num => 2
      }
      c => %{
        text => Charlie
        num => 1
      }
    }
  '));
  # The test data is curried to provide the get method of Data::Hub::Courier
  sub ttt_query {
    my $q = shift;
    my $r = $ttt_data->get($q);
    return unless defined $r;
    my $ref = ref($r);
    $ref ? hf_format({$ref => $r}) : $r;
  }
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t34 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 481
# ------------------------------------------------------------------------------

sub t34 {
  $result = eval {
  # Use an invalid index
  ttt_query('array/{?:fail}');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t35 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 486
# ------------------------------------------------------------------------------

sub t35 {
  $result = eval {
  # Get the value whose value is ''
  ttt_query('array/{?:}');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t36 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 491
# ------------------------------------------------------------------------------

sub t36 {
  $result = eval {
  # Get the value whose key is eq 0
  ttt_query('array/{?:0}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t37 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 500
# ------------------------------------------------------------------------------

sub t37 {
  $result = eval {
  # Get the value whose key is == 0
  ttt_query('array/{?(==):0}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  0 => a
}';
}

# ------------------------------------------------------------------------------
# t38 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 511
# ------------------------------------------------------------------------------

sub t38 {
  $result = eval {
  # Get all items whose key is >= 2
  ttt_query('array/{?(>=):2}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  2 => c
  3 => ab
  4 => abc
}';
}

# ------------------------------------------------------------------------------
# t39 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 524
# ------------------------------------------------------------------------------

sub t39 {
  $result = eval {
  # Get the value whose value is 'a'
  ttt_query('array/{?*:a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t40 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 533
# ------------------------------------------------------------------------------

sub t40 {
  $result = eval {
  # Get all items whose value is eq 'a'
  ttt_query('array/{?*(eq):a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  0 => a
}';
}

# ------------------------------------------------------------------------------
# t41 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 544
# ------------------------------------------------------------------------------

sub t41 {
  $result = eval {
  # Get all items whose value is =~ /a/
  ttt_query('array/{?*(=~):a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  0 => a
  3 => ab
  4 => abc
}';
}

# ------------------------------------------------------------------------------
# t42 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 561
# ------------------------------------------------------------------------------

sub t42 {
  $result = eval {
  # Get the value whose key is eq 'a'
  ttt_query('hash/{?:a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Alpha';
}

# ------------------------------------------------------------------------------
# t43 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 570
# ------------------------------------------------------------------------------

sub t43 {
  $result = eval {
  # Get the value whose value is eq 'Alpha'
  ttt_query('hash/{?*:Alpha}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Alpha';
}

# ------------------------------------------------------------------------------
# t44 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 579
# ------------------------------------------------------------------------------

sub t44 {
  $result = eval {
  # Get all items whose value is eq 'Alpha'
  ttt_query('hash/{?*(eq):Alpha}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  a => Alpha
}';
}

# ------------------------------------------------------------------------------
# t45 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 590
# ------------------------------------------------------------------------------

sub t45 {
  $result = eval {
  # Get all items whose value is =~ /a$/
  ttt_query('hash/{?*(=~):a$}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  a => Alpha
  b => Beta
}';
}

# ------------------------------------------------------------------------------
# t46 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 606
# ------------------------------------------------------------------------------

sub t46 {
  $result = eval {
  # Get the value whose key is eq 0
  ttt_query('array_of_hashes/{?:0}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::OrderedHash => %{
  name => a
  text => Alpha
}';
}

# ------------------------------------------------------------------------------
# t47 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 618
# ------------------------------------------------------------------------------

sub t47 {
  $result = eval {
  # Get the value whose name is eq 'a'
  ttt_query('array_of_hashes/{?name:a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::OrderedHash => %{
  name => a
  text => Alpha
}';
}

# ------------------------------------------------------------------------------
# t48 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 630
# ------------------------------------------------------------------------------

sub t48 {
  $result = eval {
  # Get all items whose name is eq 'a'
  ttt_query('array_of_hashes/{?name(eq):a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  0 => %{
    name => a
    text => Alpha
  }
}';
}

# ------------------------------------------------------------------------------
# t49 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 644
# ------------------------------------------------------------------------------

sub t49 {
  $result = eval {
  # Get all items whose name is =~ /a|b/
  ttt_query('array_of_hashes/{?name(=~):a|b}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  0 => %{
    name => a
    text => Alpha
  }
  1 => %{
    name => b
    text => Beta
  }
}';
}

# ------------------------------------------------------------------------------
# t50 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 666
# ------------------------------------------------------------------------------

sub t50 {
  $result = eval {
  # Get the value whose key is eq 'a'
  ttt_query('hash_of_hashes/{?:a}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::OrderedHash => %{
  text => Alpha
  num => 3
}';
}

# ------------------------------------------------------------------------------
# t51 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 678
# ------------------------------------------------------------------------------

sub t51 {
  $result = eval {
  # Get the value whose text is eq 'Alpha'
  ttt_query('hash_of_hashes/{?text:Alpha}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::OrderedHash => %{
  text => Alpha
  num => 3
}';
}

# ------------------------------------------------------------------------------
# t52 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 690
# ------------------------------------------------------------------------------

sub t52 {
  $result = eval {
  # Get all items whose text is eq 'Alpha'
  ttt_query('hash_of_hashes/{?text(eq):Alpha}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
}';
}

# ------------------------------------------------------------------------------
# t53 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 704
# ------------------------------------------------------------------------------

sub t53 {
  $result = eval {
  # Get all items whose num is > 1
  ttt_query('hash_of_hashes/{?num(>):1}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
  b => %{
    text => Beta
    num => 2
  }
}';
}

# ------------------------------------------------------------------------------
# t54 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 726
# ------------------------------------------------------------------------------

sub t54 {
  $result = eval {
  ttt_query('hash_of_hashes/*|{?(ne):b}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  a => %{
    text => Alpha
    num => 3
  }
  c => %{
    text => Charlie
    num => 1
  }
}';
}

# ------------------------------------------------------------------------------
# t55 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 743
# ------------------------------------------------------------------------------

sub t55 {
  $result = eval {
  ttt_query('hash_of_hashes/*|{?text(=~):B|C}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
  c => %{
    text => Charlie
    num => 1
  }
}';
}

# ------------------------------------------------------------------------------
# t56 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 762
# ------------------------------------------------------------------------------

sub t56 {
  $result = eval {
  ttt_query('hash_of_hashes/*|{?(=~):[ab]}|{?text(=~):B|C}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
}';
}

# ------------------------------------------------------------------------------
# t57 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Query.pm line: 775
# ------------------------------------------------------------------------------

sub t57 {
  $result = eval {
  ttt_query('hash_of_hashes/{?(=~):[ab]}|{?text(=~):B|C}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::Subset => %{
  b => %{
    text => Beta
    num => 2
  }
}';
}

# ------------------------------------------------------------------------------
# t58 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 85
# ------------------------------------------------------------------------------

sub t58 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::Hub::Util qw(:all);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t59 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 125
# ------------------------------------------------------------------------------

sub t59 {
  $result = eval {
  curry({a=>{b=>'c'}})->get('/a/b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'c';
}

# ------------------------------------------------------------------------------
# t60 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 137
# ------------------------------------------------------------------------------

sub t60 {
  $result = eval {
  FS('Node');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Data::Hub::FileSystem::Node';
}

# ------------------------------------------------------------------------------
# t61 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 148
# ------------------------------------------------------------------------------

sub t61 {
  $result = eval {
  typeof('foo.bar', {});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'data-hash';
}

# ------------------------------------------------------------------------------
# t62 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 149
# ------------------------------------------------------------------------------

sub t62 {
  $result = eval {
  typeof('/with/path/foo.bar', []);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'data-array';
}

# ------------------------------------------------------------------------------
# t63 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 150
# ------------------------------------------------------------------------------

sub t63 {
  $result = eval {
  typeof('foo.bar', 'baz');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'data-scalar-bar';
}

# ------------------------------------------------------------------------------
# t64 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 228
# ------------------------------------------------------------------------------

sub t64 {
  $result = eval {
  my $addr = '/one/two/{/i/am/three}/four';
  join(':', addr_shift($addr), addr_shift($addr), addr_shift($addr),
  addr_shift($addr)); 
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'one:two:{/i/am/three}:four';
}

# ------------------------------------------------------------------------------
# t65 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 241
# ------------------------------------------------------------------------------

sub t65 {
  $result = eval {
  my $addr = '/one/two';
  my $last = addr_pop($addr);
  "$last,$addr"
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'two,/one';
}

# ------------------------------------------------------------------------------
# t66 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 255
# ------------------------------------------------------------------------------

sub t66 {
  $result = eval {
  addr_normalize('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t67 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 256
# ------------------------------------------------------------------------------

sub t67 {
  $result = eval {
  addr_normalize('/a/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t68 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 257
# ------------------------------------------------------------------------------

sub t68 {
  $result = eval {
  addr_normalize('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t69 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 258
# ------------------------------------------------------------------------------

sub t69 {
  $result = eval {
  addr_normalize('/a/../b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/b';
}

# ------------------------------------------------------------------------------
# t70 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 259
# ------------------------------------------------------------------------------

sub t70 {
  $result = eval {
  addr_normalize('/a/../../b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/b';
}

# ------------------------------------------------------------------------------
# t71 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 260
# ------------------------------------------------------------------------------

sub t71 {
  $result = eval {
  addr_normalize('/a/.../b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t72 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 261
# ------------------------------------------------------------------------------

sub t72 {
  $result = eval {
  addr_normalize('/a/.../');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t73 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 262
# ------------------------------------------------------------------------------

sub t73 {
  $result = eval {
  addr_normalize('/a/...');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t74 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 263
# ------------------------------------------------------------------------------

sub t74 {
  $result = eval {
  addr_normalize('/a/.../..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t75 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 264
# ------------------------------------------------------------------------------

sub t75 {
  $result = eval {
  addr_normalize('/a/../...');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t76 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 275
# ------------------------------------------------------------------------------

sub t76 {
  $result = eval {
  addr_parent();
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t77 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 276
# ------------------------------------------------------------------------------

sub t77 {
  $result = eval {
  addr_parent('');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t78 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 277
# ------------------------------------------------------------------------------

sub t78 {
  $result = eval {
  addr_parent('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t79 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 278
# ------------------------------------------------------------------------------

sub t79 {
  $result = eval {
  addr_parent('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t80 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 279
# ------------------------------------------------------------------------------

sub t80 {
  $result = eval {
  addr_parent('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t81 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 280
# ------------------------------------------------------------------------------

sub t81 {
  $result = eval {
  addr_parent('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t82 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 281
# ------------------------------------------------------------------------------

sub t82 {
  $result = eval {
  addr_parent('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t83 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 294
# ------------------------------------------------------------------------------

sub t83 {
  $result = eval {
  addr_name('');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t84 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 295
# ------------------------------------------------------------------------------

sub t84 {
  $result = eval {
  addr_name('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t85 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 296
# ------------------------------------------------------------------------------

sub t85 {
  $result = eval {
  addr_name('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t86 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 297
# ------------------------------------------------------------------------------

sub t86 {
  $result = eval {
  addr_name('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t87 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 298
# ------------------------------------------------------------------------------

sub t87 {
  $result = eval {
  addr_name('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'b';
}

# ------------------------------------------------------------------------------
# t88 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 299
# ------------------------------------------------------------------------------

sub t88 {
  $result = eval {
  addr_name('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'b.c';
}

# ------------------------------------------------------------------------------
# t89 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 311
# ------------------------------------------------------------------------------

sub t89 {
  $result = eval {
  scalar(addr_split(''));
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t90 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 312
# ------------------------------------------------------------------------------

sub t90 {
  $result = eval {
  join ' ', addr_split('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t91 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 313
# ------------------------------------------------------------------------------

sub t91 {
  $result = eval {
  join ' ', addr_split('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t92 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 314
# ------------------------------------------------------------------------------

sub t92 {
  $result = eval {
  join ' ', addr_split('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t93 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 315
# ------------------------------------------------------------------------------

sub t93 {
  $result = eval {
  join ' ', addr_split('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a b';
}

# ------------------------------------------------------------------------------
# t94 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 316
# ------------------------------------------------------------------------------

sub t94 {
  $result = eval {
  join ' ', addr_split('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a b.c';
}

# ------------------------------------------------------------------------------
# t95 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 330
# ------------------------------------------------------------------------------

sub t95 {
  $result = eval {
  addr_join('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t96 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 331
# ------------------------------------------------------------------------------

sub t96 {
  $result = eval {
  addr_join('/a', '/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t97 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 332
# ------------------------------------------------------------------------------

sub t97 {
  $result = eval {
  addr_join('/a/', 'b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t98 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 333
# ------------------------------------------------------------------------------

sub t98 {
  $result = eval {
  addr_join('/a/..', '/b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/b';
}

# ------------------------------------------------------------------------------
# t99 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 334
# ------------------------------------------------------------------------------

sub t99 {
  $result = eval {
  addr_join('/a/../', '../b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/b';
}

# ------------------------------------------------------------------------------
# t100 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 335
# ------------------------------------------------------------------------------

sub t100 {
  $result = eval {
  addr_join('/a/.../', 'b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t101 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 336
# ------------------------------------------------------------------------------

sub t101 {
  $result = eval {
  addr_join('/a/', '.../');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t102 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 337
# ------------------------------------------------------------------------------

sub t102 {
  $result = eval {
  addr_join('/a/', '...');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t103 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 338
# ------------------------------------------------------------------------------

sub t103 {
  $result = eval {
  addr_join('/a/', 'b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b';
}

# ------------------------------------------------------------------------------
# t104 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 339
# ------------------------------------------------------------------------------

sub t104 {
  $result = eval {
  addr_join('/a/', 'b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b';
}

# ------------------------------------------------------------------------------
# t105 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 340
# ------------------------------------------------------------------------------

sub t105 {
  $result = eval {
  addr_join('/a', '/b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b';
}

# ------------------------------------------------------------------------------
# t106 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 341
# ------------------------------------------------------------------------------

sub t106 {
  $result = eval {
  addr_join('/a', 'b');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b';
}

# ------------------------------------------------------------------------------
# t107 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 342
# ------------------------------------------------------------------------------

sub t107 {
  $result = eval {
  addr_join('/a', 'b', 'c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b/c';
}

# ------------------------------------------------------------------------------
# t108 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 353
# ------------------------------------------------------------------------------

sub t108 {
  $result = eval {
  addr_ext(undef);
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t109 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 354
# ------------------------------------------------------------------------------

sub t109 {
  $result = eval {
  addr_ext('foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t110 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 355
# ------------------------------------------------------------------------------

sub t110 {
  $result = eval {
  addr_ext('/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t111 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 356
# ------------------------------------------------------------------------------

sub t111 {
  $result = eval {
  addr_ext('./foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t112 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 357
# ------------------------------------------------------------------------------

sub t112 {
  $result = eval {
  addr_ext('../foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t113 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 358
# ------------------------------------------------------------------------------

sub t113 {
  $result = eval {
  addr_ext('/foo/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t114 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 359
# ------------------------------------------------------------------------------

sub t114 {
  $result = eval {
  addr_ext('/foo.bar.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t115 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 360
# ------------------------------------------------------------------------------

sub t115 {
  $result = eval {
  addr_ext('/foo/bar.');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t116 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 361
# ------------------------------------------------------------------------------

sub t116 {
  $result = eval {
  addr_ext('/foo/bar');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t117 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 362
# ------------------------------------------------------------------------------

sub t117 {
  $result = eval {
  addr_ext('.metadata');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t118 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 363
# ------------------------------------------------------------------------------

sub t118 {
  $result = eval {
  addr_ext('.metadata.bak');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'bak';
}

# ------------------------------------------------------------------------------
# t119 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 377
# ------------------------------------------------------------------------------

sub t119 {
  $result = eval {
  addr_basename(undef);
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t120 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 378
# ------------------------------------------------------------------------------

sub t120 {
  $result = eval {
  addr_basename('/');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t121 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 379
# ------------------------------------------------------------------------------

sub t121 {
  $result = eval {
  addr_basename('foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t122 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 380
# ------------------------------------------------------------------------------

sub t122 {
  $result = eval {
  addr_basename('foo.txt/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t123 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 381
# ------------------------------------------------------------------------------

sub t123 {
  $result = eval {
  addr_basename('/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t124 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 382
# ------------------------------------------------------------------------------

sub t124 {
  $result = eval {
  addr_basename('./foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t125 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 383
# ------------------------------------------------------------------------------

sub t125 {
  $result = eval {
  addr_basename('../foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t126 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 384
# ------------------------------------------------------------------------------

sub t126 {
  $result = eval {
  addr_basename('/foo/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t127 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 385
# ------------------------------------------------------------------------------

sub t127 {
  $result = eval {
  addr_basename('/foo.bar.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo.bar';
}

# ------------------------------------------------------------------------------
# t128 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 386
# ------------------------------------------------------------------------------

sub t128 {
  $result = eval {
  addr_basename('/foo/bar.');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'bar';
}

# ------------------------------------------------------------------------------
# t129 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 387
# ------------------------------------------------------------------------------

sub t129 {
  $result = eval {
  addr_basename('/foo/bar');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'bar';
}

# ------------------------------------------------------------------------------
# t130 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 388
# ------------------------------------------------------------------------------

sub t130 {
  $result = eval {
  addr_basename('.metadata');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t131 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 389
# ------------------------------------------------------------------------------

sub t131 {
  $result = eval {
  addr_basename('.metadata.bak');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '.metadata';
}

# ------------------------------------------------------------------------------
# t132 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 404
# ------------------------------------------------------------------------------

sub t132 {
  $result = eval {
  addr_base('/a/b/{d}');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b';
}

# ------------------------------------------------------------------------------
# t133 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 405
# ------------------------------------------------------------------------------

sub t133 {
  $result = eval {
  addr_base('/a/b/d');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a/b/d';
}

# ------------------------------------------------------------------------------
# t134 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 429
# ------------------------------------------------------------------------------

sub t134 {
  $result = eval {
  my $path = '/one/two/../four';
  join(':', path_shift($path), path_shift($path), path_shift($path),
  path_shift($path)); 
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'one:two:..:four';
}

# ------------------------------------------------------------------------------
# t135 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 442
# ------------------------------------------------------------------------------

sub t135 {
  $result = eval {
  my $path = '/one/two';
  my $last = path_pop($path);
  "$last,$path"
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'two,/one';
}

# ------------------------------------------------------------------------------
# t136 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 455
# ------------------------------------------------------------------------------

sub t136 {
  $result = eval {
  my $path = '/one/two';
  my $count = path_push($path, 'three');
  "$path"
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/one/two/three';
}

# ------------------------------------------------------------------------------
# t137 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 467
# ------------------------------------------------------------------------------

sub t137 {
  $result = eval {
  path_split('');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t138 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 468
# ------------------------------------------------------------------------------

sub t138 {
  $result = eval {
  join ' ', path_split('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t139 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 469
# ------------------------------------------------------------------------------

sub t139 {
  $result = eval {
  join ' ', path_split('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t140 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 470
# ------------------------------------------------------------------------------

sub t140 {
  $result = eval {
  join ' ', path_split('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t141 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 471
# ------------------------------------------------------------------------------

sub t141 {
  $result = eval {
  join ' ', path_split('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a b';
}

# ------------------------------------------------------------------------------
# t142 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 472
# ------------------------------------------------------------------------------

sub t142 {
  $result = eval {
  join ' ', path_split('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a b.c';
}

# ------------------------------------------------------------------------------
# t143 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 489
# ------------------------------------------------------------------------------

sub t143 {
  $result = eval {
  path_basename(undef);
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t144 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 490
# ------------------------------------------------------------------------------

sub t144 {
  $result = eval {
  path_basename('foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t145 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 491
# ------------------------------------------------------------------------------

sub t145 {
  $result = eval {
  path_basename('/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t146 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 492
# ------------------------------------------------------------------------------

sub t146 {
  $result = eval {
  path_basename('./foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t147 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 493
# ------------------------------------------------------------------------------

sub t147 {
  $result = eval {
  path_basename('../foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t148 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 494
# ------------------------------------------------------------------------------

sub t148 {
  $result = eval {
  path_basename('/foo/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo';
}

# ------------------------------------------------------------------------------
# t149 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 495
# ------------------------------------------------------------------------------

sub t149 {
  $result = eval {
  path_basename('/foo.bar.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'foo.bar';
}

# ------------------------------------------------------------------------------
# t150 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 496
# ------------------------------------------------------------------------------

sub t150 {
  $result = eval {
  path_basename('/foo/bar.');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'bar';
}

# ------------------------------------------------------------------------------
# t151 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 497
# ------------------------------------------------------------------------------

sub t151 {
  $result = eval {
  path_basename('/foo/bar');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'bar';
}

# ------------------------------------------------------------------------------
# t152 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 498
# ------------------------------------------------------------------------------

sub t152 {
  $result = eval {
  path_basename('.bashrc');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '.bashrc';
}

# ------------------------------------------------------------------------------
# t153 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 499
# ------------------------------------------------------------------------------

sub t153 {
  $result = eval {
  path_basename('.bashrc.tmp');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '.bashrc';
}

# ------------------------------------------------------------------------------
# t154 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 500
# ------------------------------------------------------------------------------

sub t154 {
  $result = eval {
  path_basename('/no-dots');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'no-dots';
}

# ------------------------------------------------------------------------------
# t155 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 517
# ------------------------------------------------------------------------------

sub t155 {
  $result = eval {
  path_ext(undef);
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t156 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 518
# ------------------------------------------------------------------------------

sub t156 {
  $result = eval {
  path_ext('foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t157 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 519
# ------------------------------------------------------------------------------

sub t157 {
  $result = eval {
  path_ext('/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t158 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 520
# ------------------------------------------------------------------------------

sub t158 {
  $result = eval {
  path_ext('./foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t159 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 521
# ------------------------------------------------------------------------------

sub t159 {
  $result = eval {
  path_ext('../foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t160 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 522
# ------------------------------------------------------------------------------

sub t160 {
  $result = eval {
  path_ext('/foo/foo.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t161 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 523
# ------------------------------------------------------------------------------

sub t161 {
  $result = eval {
  path_ext('/foo.bar.txt');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'txt';
}

# ------------------------------------------------------------------------------
# t162 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 524
# ------------------------------------------------------------------------------

sub t162 {
  $result = eval {
  path_ext('/foo/bar.');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t163 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 525
# ------------------------------------------------------------------------------

sub t163 {
  $result = eval {
  path_ext('/foo/bar');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t164 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 526
# ------------------------------------------------------------------------------

sub t164 {
  $result = eval {
  path_ext('.bashrc');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t165 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 527
# ------------------------------------------------------------------------------

sub t165 {
  $result = eval {
  path_ext('.bashrc.tmp');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'tmp';
}

# ------------------------------------------------------------------------------
# t166 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 528
# ------------------------------------------------------------------------------

sub t166 {
  $result = eval {
  path_ext('/no-dots');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t167 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 544
# ------------------------------------------------------------------------------

sub t167 {
  $result = eval {
  path_normalize('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t168 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 545
# ------------------------------------------------------------------------------

sub t168 {
  $result = eval {
  path_normalize('/a/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t169 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 546
# ------------------------------------------------------------------------------

sub t169 {
  $result = eval {
  path_normalize('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t170 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 547
# ------------------------------------------------------------------------------

sub t170 {
  $result = eval {
  path_normalize('/a/../a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t171 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 548
# ------------------------------------------------------------------------------

sub t171 {
  $result = eval {
  path_normalize('/a/../../a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t172 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 549
# ------------------------------------------------------------------------------

sub t172 {
  $result = eval {
  path_normalize( "../../w/b/../s/x" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '../../w/s/x';
}

# ------------------------------------------------------------------------------
# t173 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 550
# ------------------------------------------------------------------------------

sub t173 {
  $result = eval {
  path_normalize( "u/n/w/" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'u/n/w';
}

# ------------------------------------------------------------------------------
# t174 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 551
# ------------------------------------------------------------------------------

sub t174 {
  $result = eval {
  path_normalize( "u/../w/b/../s" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'w/s';
}

# ------------------------------------------------------------------------------
# t175 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 552
# ------------------------------------------------------------------------------

sub t175 {
  $result = eval {
  path_normalize( "u//n" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'u/n';
}

# ------------------------------------------------------------------------------
# t176 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 553
# ------------------------------------------------------------------------------

sub t176 {
  $result = eval {
  path_normalize( "u//n/./f" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'u/n/f';
}

# ------------------------------------------------------------------------------
# t177 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 554
# ------------------------------------------------------------------------------

sub t177 {
  $result = eval {
  path_normalize( "http://t/u//n" );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'http://t/u/n';
}

# ------------------------------------------------------------------------------
# t178 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 555
# ------------------------------------------------------------------------------

sub t178 {
  $result = eval {
  path_normalize( '/a/b/c/../../../d/e/f' );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/d/e/f';
}

# ------------------------------------------------------------------------------
# t179 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 556
# ------------------------------------------------------------------------------

sub t179 {
  $result = eval {
  path_normalize( './a' );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq './a';
}

# ------------------------------------------------------------------------------
# t180 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 557
# ------------------------------------------------------------------------------

sub t180 {
  $result = eval {
  path_normalize( '/./a' );
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/a';
}

# ------------------------------------------------------------------------------
# t181 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 595
# ------------------------------------------------------------------------------

sub t181 {
  $result = eval {
  path_parent('');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t182 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 596
# ------------------------------------------------------------------------------

sub t182 {
  $result = eval {
  path_parent('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t183 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 597
# ------------------------------------------------------------------------------

sub t183 {
  $result = eval {
  path_parent('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t184 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 598
# ------------------------------------------------------------------------------

sub t184 {
  $result = eval {
  path_parent('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '/';
}

# ------------------------------------------------------------------------------
# t185 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 599
# ------------------------------------------------------------------------------

sub t185 {
  $result = eval {
  path_parent('a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t186 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 600
# ------------------------------------------------------------------------------

sub t186 {
  $result = eval {
  path_parent('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t187 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 601
# ------------------------------------------------------------------------------

sub t187 {
  $result = eval {
  path_parent('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t188 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 602
# ------------------------------------------------------------------------------

sub t188 {
  $result = eval {
  path_parent('../../a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '../..';
}

# ------------------------------------------------------------------------------
# t189 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 614
# ------------------------------------------------------------------------------

sub t189 {
  $result = eval {
  path_name('');
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t190 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 615
# ------------------------------------------------------------------------------

sub t190 {
  $result = eval {
  path_name('/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t191 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 616
# ------------------------------------------------------------------------------

sub t191 {
  $result = eval {
  path_name('/a');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t192 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 617
# ------------------------------------------------------------------------------

sub t192 {
  $result = eval {
  path_name('/a/b/..');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t193 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 618
# ------------------------------------------------------------------------------

sub t193 {
  $result = eval {
  path_name('a/b/');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'b';
}

# ------------------------------------------------------------------------------
# t194 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 619
# ------------------------------------------------------------------------------

sub t194 {
  $result = eval {
  path_name('a/b.c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'b.c';
}

# ------------------------------------------------------------------------------
# t195 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 631
# ------------------------------------------------------------------------------

sub t195 {
  $result = eval {
  path_is_absolute('/a');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t196 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 632
# ------------------------------------------------------------------------------

sub t196 {
  $result = eval {
  path_is_absolute('A:/b');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t197 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 633
# ------------------------------------------------------------------------------

sub t197 {
  $result = eval {
  path_is_absolute('/a/b');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t198 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 634
# ------------------------------------------------------------------------------

sub t198 {
  $result = eval {
  path_is_absolute('http://a');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t199 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 635
# ------------------------------------------------------------------------------

sub t199 {
  $result = eval {
  path_is_absolute('svn+ssh://a.b');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t200 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 636
# ------------------------------------------------------------------------------

sub t200 {
  $result = eval {
  path_is_absolute('');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t201 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 637
# ------------------------------------------------------------------------------

sub t201 {
  $result = eval {
  path_is_absolute('a/b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t202 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 638
# ------------------------------------------------------------------------------

sub t202 {
  $result = eval {
  path_is_absolute('a:\\b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t203 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 639
# ------------------------------------------------------------------------------

sub t203 {
  $result = eval {
  path_is_absolute('a/../b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t204 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 640
# ------------------------------------------------------------------------------

sub t204 {
  $result = eval {
  path_is_absolute('../a');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t205 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 641
# ------------------------------------------------------------------------------

sub t205 {
  $result = eval {
  path_is_absolute('./a');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t206 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 642
# ------------------------------------------------------------------------------

sub t206 {
  $result = eval {
  path_is_absolute('svn+ssh//a.b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t207 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 643
# ------------------------------------------------------------------------------

sub t207 {
  $result = eval {
  path_is_absolute('1://');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t208 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 644
# ------------------------------------------------------------------------------

sub t208 {
  $result = eval {
  path_is_absolute('+://');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t209 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 923
# ------------------------------------------------------------------------------

sub t209 {
  $result = eval {
  dir_is_system('.svn', '/tmp');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t210 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 924
# ------------------------------------------------------------------------------

sub t210 {
  $result = eval {
  dir_is_system('.git', '/tmp');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t211 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 925
# ------------------------------------------------------------------------------

sub t211 {
  $result = eval {
  dir_is_system('.Svn', '/tmp');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t212 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/Hub/Util.pm line: 926
# ------------------------------------------------------------------------------

sub t212 {
  $result = eval {
  dir_is_system(undef, undef);
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t213 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/OrderedHash.pm line: 111
# ------------------------------------------------------------------------------

sub t213 {
  $result = eval {
  my %h = ();
  tie %h, 'Data::OrderedHash';
  $h{'first'} = "Apple";
  $h{'second'} = "Cherry";
  $h{'third'} = "Banana";
  join ';', values %h;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Apple;Cherry;Banana';
}

# ------------------------------------------------------------------------------
# t214 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/OrderedHash.pm line: 120
# ------------------------------------------------------------------------------

sub t214 {
  $result = eval {
  my $h = Data::OrderedHash->new();
  %$h = qw(a A b B c C);
  $$h{'a'} = 'X';
  join '', %$h;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'aXbBcC';
}

# ------------------------------------------------------------------------------
# t215 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Data/OrderedHash.pm line: 127
# ------------------------------------------------------------------------------

sub t215 {
  $result = eval {
  my $h = Data::OrderedHash->new();
  $h->{'z'} = "Apple";
  $h->{'x'} = "Banana";
  $h->{'y'} = "Cherry";
  my $r = '';
  while (my ($k, $v) = each %$h) { $r .= $k; delete $$h{$k} }
  $h->{'w'} = "Can't elope";
  $r .= join('', keys %$h);
  $r;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'zxyw';
}

# ------------------------------------------------------------------------------
# t216 - Abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Error/Logical.pm line: 9
# ------------------------------------------------------------------------------

sub t216 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Error::Logical;
  throw Error::DoesNotExist 'some resource';
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t217 - Abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Error/Programatic.pm line: 12
# ------------------------------------------------------------------------------

sub t217 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Error::Programatic;
  throw Error::NotStatic;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t218 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/LogUtil.pm line: 15
# ------------------------------------------------------------------------------

sub t218 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Misc::LogUtil;
  Misc::LogUtil->new();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t219 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm line: 10
# ------------------------------------------------------------------------------

sub t219 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Misc::Stopwatch;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t220 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm line: 11
# ------------------------------------------------------------------------------

sub t220 {
  $result = eval {
  my $sw = Misc::Stopwatch->new();
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t221 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm line: 25
# ------------------------------------------------------------------------------

sub t221 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $sw = Misc::Stopwatch->new()->start();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t222 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm line: 41
# ------------------------------------------------------------------------------

sub t222 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $sw = Misc::Stopwatch->new()->start()->lap();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t223 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm line: 54
# ------------------------------------------------------------------------------

sub t223 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $sw = Misc::Stopwatch->new()->start()->stop();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t224 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm line: 76
# ------------------------------------------------------------------------------

sub t224 {
  $result = eval {
  Misc::Stopwatch->new()->start()->elapsed();
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t225 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm line: 97
# ------------------------------------------------------------------------------

sub t225 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  my $sw = Misc::Stopwatch->new()->reset();
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t226 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm line: 111
# ------------------------------------------------------------------------------

sub t226 {
  $result = eval {
  Misc::Stopwatch->new()->is_running();
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t227 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Stopwatch.pm line: 112
# ------------------------------------------------------------------------------

sub t227 {
  $result = eval {
  Misc::Stopwatch->new()->start()->is_running();
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t228 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Time.pm line: 88
# ------------------------------------------------------------------------------

sub t228 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Misc::Time qw(:all);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t229 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Misc/Time.pm line: 89
# ------------------------------------------------------------------------------

sub t229 {
  $result = eval {
  time_apr_to_hires('1193094188212812');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1193094188.212812';
}

# ------------------------------------------------------------------------------
# t230 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 31
# ------------------------------------------------------------------------------

sub t230 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Parse::Padding qw(padding);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t231 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 33
# ------------------------------------------------------------------------------

sub t231 {
  $result = eval {
  my $str = "    a   ";
  join ';', padding(\$str, 4, 5);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '4;3';
}

# ------------------------------------------------------------------------------
# t232 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 37
# ------------------------------------------------------------------------------

sub t232 {
  $result = eval {
  my $str = " \na\r\n ";
  join ';', padding(\$str, 2, 3);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '2;3';
}

# ------------------------------------------------------------------------------
# t233 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 41
# ------------------------------------------------------------------------------

sub t233 {
  $result = eval {
  my $str = " \na\r\n ";
  join ';', padding(\$str, 2, 3, -crlf);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1;2';
}

# ------------------------------------------------------------------------------
# t234 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 45
# ------------------------------------------------------------------------------

sub t234 {
  $result = eval {
  my $str = " \n\na\r\n\r\n ";
  join ';', padding(\$str, 3, 4, -crlf);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1;2';
}

# ------------------------------------------------------------------------------
# t235 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 49
# ------------------------------------------------------------------------------

sub t235 {
  $result = eval {
  my $str = " a ";
  join ';', padding(\$str, 1, 2, -crlf);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0;0';
}

# ------------------------------------------------------------------------------
# t236 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 92
# ------------------------------------------------------------------------------

sub t236 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Parse::Padding qw(trailing);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t237 - Abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 93
# ------------------------------------------------------------------------------

sub t237 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  trailing('\r\n', " xxx\r\n", 'abc');
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t238 - Abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 94
# ------------------------------------------------------------------------------

sub t238 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  trailing('', " xxx\r\n", 4);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t239 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 95
# ------------------------------------------------------------------------------

sub t239 {
  $result = eval {
  trailing('\s', " xxx \r\n", 4);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3';
}

# ------------------------------------------------------------------------------
# t240 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 96
# ------------------------------------------------------------------------------

sub t240 {
  $result = eval {
  trailing('\r\n', " xxx \r\n", 4);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t241 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 97
# ------------------------------------------------------------------------------

sub t241 {
  $result = eval {
  trailing('\r\n', " xxx\r\n", 4);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '2';
}

# ------------------------------------------------------------------------------
# t242 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 98
# ------------------------------------------------------------------------------

sub t242 {
  $result = eval {
  trailing('\r\n', " xxx\r\n", 999);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t243 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 99
# ------------------------------------------------------------------------------

sub t243 {
  $result = eval {
  trailing('\r\n', " xxx\r\n", -999);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t244 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 100
# ------------------------------------------------------------------------------

sub t244 {
  $result = eval {
  trailing('\r\n', "\r\n\r\n", 0, 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '2';
}

# ------------------------------------------------------------------------------
# t245 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 101
# ------------------------------------------------------------------------------

sub t245 {
  $result = eval {
  trailing('\r\n', "\n\n\n", 0, 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t246 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 102
# ------------------------------------------------------------------------------

sub t246 {
  $result = eval {
  trailing('abcd', "a\na", 2, 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t247 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 142
# ------------------------------------------------------------------------------

sub t247 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Parse::Padding qw(leading);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t248 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 143
# ------------------------------------------------------------------------------

sub t248 {
  $result = eval {
  leading('\s', " xxx", 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t249 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 144
# ------------------------------------------------------------------------------

sub t249 {
  $result = eval {
  leading('\s', "\r \nxxx", 3);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3';
}

# ------------------------------------------------------------------------------
# t250 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 145
# ------------------------------------------------------------------------------

sub t250 {
  $result = eval {
  leading('\r\n', " xxx", 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t251 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 146
# ------------------------------------------------------------------------------

sub t251 {
  $result = eval {
  leading('\r\n', "\r\n\rxxx", 3);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3';
}

# ------------------------------------------------------------------------------
# t252 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 147
# ------------------------------------------------------------------------------

sub t252 {
  $result = eval {
  leading('\r\n', "\r\n\rxxx", -999);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t253 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 148
# ------------------------------------------------------------------------------

sub t253 {
  $result = eval {
  leading('\r\n', "\r\n\rxxx", 999);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t254 - Abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 149
# ------------------------------------------------------------------------------

sub t254 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  leading('', "\r\n\rxxx", 3);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t255 - Abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 150
# ------------------------------------------------------------------------------

sub t255 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  leading('\r\n', "\r\n\rxxx", 'abc');
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t256 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 151
# ------------------------------------------------------------------------------

sub t256 {
  $result = eval {
  leading('abcd', "axe", 1, 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t257 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Padding.pm line: 152
# ------------------------------------------------------------------------------

sub t257 {
  $result = eval {
  leading('abcd', "\naxe", 2, 1);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t258 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm line: 21
# ------------------------------------------------------------------------------

sub t258 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Parse::StringToken qw(:all);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t259 - Abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm line: 44
# ------------------------------------------------------------------------------

sub t259 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  str_token('', -contained => '123');
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t260 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm line: 58
# ------------------------------------------------------------------------------

sub t260 {
  $result = eval {
  str_token("a b c")->shift;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t261 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm line: 59
# ------------------------------------------------------------------------------

sub t261 {
  $result = eval {
  my $s = str_token(q(one 'and a two' "and a three"));
  $s->shift; $s->shift;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'and a two';
}

# ------------------------------------------------------------------------------
# t262 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm line: 82
# ------------------------------------------------------------------------------

sub t262 {
  $result = eval {
  str_token("a b c")->pop;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'c';
}

# ------------------------------------------------------------------------------
# t263 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm line: 83
# ------------------------------------------------------------------------------

sub t263 {
  $result = eval {
  my $s = str_token(q(one 'and a two' "and a three"));
  $s->pop;
  $s->pop;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'and a two';
}

# ------------------------------------------------------------------------------
# t264 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/StringToken.pm line: 100
# ------------------------------------------------------------------------------

sub t264 {
  $result = eval {
  join('-', str_token("a b c")->split);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a-b-c';
}

# ------------------------------------------------------------------------------
# t265 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Base.pm line: 954
# ------------------------------------------------------------------------------

sub t265 {
  $result = eval {
  use Parse::Template::Base;
  my $p = new Parse::Template::Base;
  my $text = '<<>>';
  my @pos = $p->substr_pos(\$text, '<', '>', 0);
  join ',', map {join '-', @$_} @pos;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0-3,1-2';
}

# ------------------------------------------------------------------------------
# t266 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Base.pm line: 1055
# ------------------------------------------------------------------------------

sub t266 {
  $result = eval {
  use Parse::Template::Standard;
  my $t = 'Hello [#name]';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\$t, {name => 'World'});
  return $$o;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Hello World';
}

# ------------------------------------------------------------------------------
# t267 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Base.pm line: 1063
# ------------------------------------------------------------------------------

sub t267 {
  $result = eval {
  use Parse::Template::Standard;
  my $t = 'Hello [#name]';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\$t, {name => '[#next]', next => 'World'});
  return $$o;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Hello World';
}

# ------------------------------------------------------------------------------
# t268 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Base.pm line: 1071
# ------------------------------------------------------------------------------

sub t268 {
  $result = eval {
  use Parse::Template::Standard;
  my $t = 'Hello [#data/name]';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\$t, {data => {name => 'World'}});
  return $$o;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Hello World';
}

# ------------------------------------------------------------------------------
# t269 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Base.pm line: 1079
# ------------------------------------------------------------------------------

sub t269 {
  $result = eval {
  use Parse::Template::Standard;
  my $t = 'Hello [#[#name]]';
  my $p = new Parse::Template::Standard();
  my $o = $p->compile_text(\$t, {name => 'next', next => 'World'});
  return $$o;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Hello World';
}

# ------------------------------------------------------------------------------
# t270 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Web.pm line: 64
# ------------------------------------------------------------------------------

sub t270 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Parse::Template::Web;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t271 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Web.pm line: 65
# ------------------------------------------------------------------------------

sub t271 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Data::Hub;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t272 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Web.pm line: 66
# ------------------------------------------------------------------------------

sub t272 {
  $result = eval {
  my $p = Parse::Template::Web->new(Data::Hub->new());
  $p->defang('a[#b]c');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abc';
}

# ------------------------------------------------------------------------------
# t273 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Parse/Template/Web.pm line: 69
# ------------------------------------------------------------------------------

sub t273 {
  $result = eval {
  my $p = Parse::Template::Web->new(Data::Hub->new());
  my $r = $p->defang(['a[#b]c', 'a<b>c</d>e']);
  join('', @$r);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'abcabc/de';
}

# ------------------------------------------------------------------------------
# t274 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Class.pm line: 69
# ------------------------------------------------------------------------------

sub t274 {
  $result = eval {
  package Foo;
  use Perl::Class;
  use base qw(Perl::Class::Hash);
  sub new {
    $_[0]->SUPER::new(1 => 2, 'odd');
  }
  1;
  package main;
  my $c = Foo->new();
  $c->{3} = 4;
  join ':', (keys %$c, '|', sort keys %{$c->__});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3:|:1:odd';
}

# ------------------------------------------------------------------------------
# t275 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 125
# ------------------------------------------------------------------------------

sub t275 {
  $result = eval {
  compare('eq','',undef);
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t276 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 126
# ------------------------------------------------------------------------------

sub t276 {
  $result = eval {
  compare('eq','abc','abc');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t277 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 127
# ------------------------------------------------------------------------------

sub t277 {
  $result = eval {
  compare('ne','abc','Abc');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t278 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 128
# ------------------------------------------------------------------------------

sub t278 {
  $result = eval {
  compare('eq','abc',undef);
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t279 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 129
# ------------------------------------------------------------------------------

sub t279 {
  $result = eval {
  compare('!~','abc','A');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t280 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 130
# ------------------------------------------------------------------------------

sub t280 {
  $result = eval {
  compare('=~','abc','a');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t281 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 131
# ------------------------------------------------------------------------------

sub t281 {
  $result = eval {
  compare('==',1234,1234);
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t282 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 132
# ------------------------------------------------------------------------------

sub t282 {
  $result = eval {
  compare('>=',1234,1234);
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t283 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 133
# ------------------------------------------------------------------------------

sub t283 {
  $result = eval {
  compare('eqic','abc','Abc');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t284 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 134
# ------------------------------------------------------------------------------

sub t284 {
  $result = eval {
  compare('==',undef,undef);
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t285 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 135
# ------------------------------------------------------------------------------

sub t285 {
  $result = eval {
  compare('==',0,undef);
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t286 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 136
# ------------------------------------------------------------------------------

sub t286 {
  $result = eval {
  compare('!~i','abc','A');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t287 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 137
# ------------------------------------------------------------------------------

sub t287 {
  $result = eval {
  compare('=~i','abc','A');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t288 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 138
# ------------------------------------------------------------------------------

sub t288 {
  $result = eval {
  compare('eqic','abc','Abc');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t289 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 139
# ------------------------------------------------------------------------------

sub t289 {
  $result = eval {
  compare('neic','abc','Abc');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t290 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 140
# ------------------------------------------------------------------------------

sub t290 {
  $result = eval {
  compare('mod',4,2);
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t291 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 141
# ------------------------------------------------------------------------------

sub t291 {
  $result = eval {
  compare('bw','abc','a');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t292 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 142
# ------------------------------------------------------------------------------

sub t292 {
  $result = eval {
  compare('bw','abc','b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t293 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 143
# ------------------------------------------------------------------------------

sub t293 {
  $result = eval {
  compare('ew','abc','b');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t294 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 144
# ------------------------------------------------------------------------------

sub t294 {
  $result = eval {
  compare('ew','abc','c');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t295 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 158
# ------------------------------------------------------------------------------

sub t295 {
  $result = eval {
  my @numbers = ( 20, 1, 10, 2 );
  join ';', sort { &sort_compare('<=>',$a,$b) } @numbers;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1;2;10;20';
}

# ------------------------------------------------------------------------------
# t296 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 180
# ------------------------------------------------------------------------------

sub t296 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Perl::Compare qw(sort_keydepth);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t297 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 182
# ------------------------------------------------------------------------------

sub t297 {
  $result = eval {
  join ';', sort {&sort_keydepth($a, $b)} qw(t/w/o o/ne th/r/e/e);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'o/ne;t/w/o;th/r/e/e';
}

# ------------------------------------------------------------------------------
# t298 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Compare.pm line: 186
# ------------------------------------------------------------------------------

sub t298 {
  $result = eval {
  no warnings 'uninitialized';
  join ';', sort {&sort_keydepth($a, $b)} (qw(t/w/o o/ne none th/r/e/e), undef);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq ';none;o/ne;t/w/o;th/r/e/e';
}

# ------------------------------------------------------------------------------
# t299 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Module.pm line: 16
# ------------------------------------------------------------------------------

sub t299 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Perl::Module;
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t300 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Module.pm line: 17
# ------------------------------------------------------------------------------

sub t300 {
  $result = eval {
  join "\n", sort @Perl::Module::EXPORT;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'Dumper
blessed
bytesize
can
carp
checksum
clone
cluck
compare
confess
croak
gettimeofday
grep_first
grep_first_index
index_imatch
index_match
index_unescaped
int_div
is_numeric
isa
max
min
my_opts
overlay
push_uniq
reftype
sleep
sort_compare
sort_keydepth
stat
str_ref
strftime
strptime
time
tv_interval
unshift_uniq
warnf';
}

# ------------------------------------------------------------------------------
# t301 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Options.pm line: 29
# ------------------------------------------------------------------------------

sub t301 {
  $result = eval {
  my $sub = sub {
    my ($opts, @argv) = my_opts(\@_);
    my $ret = join(',', sort(@_));
    $ret .= ';' . join(',', sort keys %$opts);
    return $ret;
  };
  &$sub('a', 'b', '-opt1', -opt2 => 'See', '-opt3=0');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a,b;opt1,opt2,opt3';
}

# ------------------------------------------------------------------------------
# t302 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 58
# ------------------------------------------------------------------------------

sub t302 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use Perl::Util qw(:all);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t303 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 92
# ------------------------------------------------------------------------------

sub t303 {
  $result = eval {
  my $a = str_ref("a"); $$a;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'a';
}

# ------------------------------------------------------------------------------
# t304 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 128
# ------------------------------------------------------------------------------

sub t304 {
  $result = eval {
  is_numeric('-1');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t305 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 129
# ------------------------------------------------------------------------------

sub t305 {
  $result = eval {
  is_numeric('0');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t306 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 130
# ------------------------------------------------------------------------------

sub t306 {
  $result = eval {
  is_numeric('+1');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t307 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 131
# ------------------------------------------------------------------------------

sub t307 {
  $result = eval {
  is_numeric('3.14');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t308 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 132
# ------------------------------------------------------------------------------

sub t308 {
  $result = eval {
  is_numeric('6.02214E23');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t309 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 133
# ------------------------------------------------------------------------------

sub t309 {
  $result = eval {
  is_numeric('6.626068e-34');
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t310 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 134
# ------------------------------------------------------------------------------

sub t310 {
  $result = eval {
  is_numeric('3.1.4');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t311 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 135
# ------------------------------------------------------------------------------

sub t311 {
  $result = eval {
  is_numeric('');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t312 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 136
# ------------------------------------------------------------------------------

sub t312 {
  $result = eval {
  is_numeric('three');
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t313 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 137
# ------------------------------------------------------------------------------

sub t313 {
  $result = eval {
  is_numeric(undef);
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

# ------------------------------------------------------------------------------
# t314 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 151
# ------------------------------------------------------------------------------

sub t314 {
  $result = eval {
  join('r',int_div(3,2));
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1r1';
}

# ------------------------------------------------------------------------------
# t315 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 152
# ------------------------------------------------------------------------------

sub t315 {
  $result = eval {
  join('r',int_div(3.9,2));
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1r1';
}

# ------------------------------------------------------------------------------
# t316 - Abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 153
# ------------------------------------------------------------------------------

sub t316 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  int_div(3,0);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t317 - Abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 154
# ------------------------------------------------------------------------------

sub t317 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  int_div('three',1);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t318 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 167
# ------------------------------------------------------------------------------

sub t318 {
  $result = eval {
  grep_first {/a/} qw(apple banana cherry);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'apple';
}

# ------------------------------------------------------------------------------
# t319 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 185
# ------------------------------------------------------------------------------

sub t319 {
  $result = eval {
  grep_first_index {/a/} qw(apple banana cherry);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t320 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 252
# ------------------------------------------------------------------------------

sub t320 {
  $result = eval {
  index_match("abracadabra", "[cd]")
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '4';
}

# ------------------------------------------------------------------------------
# t321 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 253
# ------------------------------------------------------------------------------

sub t321 {
  $result = eval {
  index_match("abracadabra", "a", 3)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3';
}

# ------------------------------------------------------------------------------
# t322 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 254
# ------------------------------------------------------------------------------

sub t322 {
  $result = eval {
  index_match("abracadabra", "d{2,2}")
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '-1';
}

# ------------------------------------------------------------------------------
# t323 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 255
# ------------------------------------------------------------------------------

sub t323 {
  $result = eval {
  my ($p, $str) = index_match("scant", "can");
  $p + length($str);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '4';
}

# ------------------------------------------------------------------------------
# t324 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 257
# ------------------------------------------------------------------------------

sub t324 {
  $result = eval {
  index_match("foobar foo bar", '\bfoo\b') # zero-width test
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '7';
}

# ------------------------------------------------------------------------------
# t325 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 258
# ------------------------------------------------------------------------------

sub t325 {
  $result = eval {
  index_match("foobar foo bar", 'Bar') # no-match
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '-1';
}

# ------------------------------------------------------------------------------
# t326 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 259
# ------------------------------------------------------------------------------

sub t326 {
  $result = eval {
  index_match("aa", "a")
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '0';
}

# ------------------------------------------------------------------------------
# t327 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 260
# ------------------------------------------------------------------------------

sub t327 {
  $result = eval {
  index_match("aa", "a", 1)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1';
}

# ------------------------------------------------------------------------------
# t328 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 271
# ------------------------------------------------------------------------------

sub t328 {
  $result = eval {
  index_imatch("foobar foo bar", 'Bar') # Case insensitive match
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '3';
}

# ------------------------------------------------------------------------------
# t329 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 272
# ------------------------------------------------------------------------------

sub t329 {
  $result = eval {
  index_imatch(" b\n a", '\s*a') # Case insensitive match
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '2';
}

# ------------------------------------------------------------------------------
# t330 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 302
# ------------------------------------------------------------------------------

sub t330 {
  $result = eval {
  checksum('“Hello”', 'world');
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1625030915';
}

# ------------------------------------------------------------------------------
# t331 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 321
# ------------------------------------------------------------------------------

sub t331 {
  $result = eval {
  bytesize(10)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '10 B';
}

# ------------------------------------------------------------------------------
# t332 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 322
# ------------------------------------------------------------------------------

sub t332 {
  $result = eval {
  bytesize(11028)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '10.77 KB';
}

# ------------------------------------------------------------------------------
# t333 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 323
# ------------------------------------------------------------------------------

sub t333 {
  $result = eval {
  bytesize(1000 ** 3, -precision => 4)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '953.6743 MB';
}

# ------------------------------------------------------------------------------
# t334 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 324
# ------------------------------------------------------------------------------

sub t334 {
  $result = eval {
  bytesize(2 ** 30)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1 GB';
}

# ------------------------------------------------------------------------------
# t335 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 325
# ------------------------------------------------------------------------------

sub t335 {
  $result = eval {
  bytesize(2 ** 59, -binary_symbol)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '512 PiB';
}

# ------------------------------------------------------------------------------
# t336 - Is not defined
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 357
# ------------------------------------------------------------------------------

sub t336 {
  $result = eval {
  reftype(undef)
  };
  $@ and die $@;
  return defined $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t337 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 358
# ------------------------------------------------------------------------------

sub t337 {
  $result = eval {
  reftype('')
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '';
}

# ------------------------------------------------------------------------------
# t338 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 359
# ------------------------------------------------------------------------------

sub t338 {
  $result = eval {
  reftype({})
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'HASH';
}

# ------------------------------------------------------------------------------
# t339 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 360
# ------------------------------------------------------------------------------

sub t339 {
  $result = eval {
  reftype([])
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'ARRAY';
}

# ------------------------------------------------------------------------------
# t340 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 361
# ------------------------------------------------------------------------------

sub t340 {
  $result = eval {
  my $a = ''; reftype(\$a)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'SCALAR';
}

# ------------------------------------------------------------------------------
# t341 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 362
# ------------------------------------------------------------------------------

sub t341 {
  $result = eval {
  my $a = ''; my $b = \$a; reftype(\$b)
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'REF';
}

# ------------------------------------------------------------------------------
# t342 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 374
# ------------------------------------------------------------------------------

sub t342 {
  $result = eval {
  isa({}, 'HASH')
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t343 - True
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/Perl/Util.pm line: 375
# ------------------------------------------------------------------------------

sub t343 {
  $result = eval {
  isa([], 'ARRAY')
  };
  $@ and die $@;
  return $result ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t344 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Livesite/Args.pm line: 86
# ------------------------------------------------------------------------------

sub t344 {
  $result = eval {
  use WWW::Livesite::Args;
  my $qs = WWW::Livesite::Args->new('msg=hello%20world');
  die if defined $qs->{MSG};
  return $qs->{msg};
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'hello world';
}

# ------------------------------------------------------------------------------
# t345 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Livesite/Args.pm line: 93
# ------------------------------------------------------------------------------

sub t345 {
  $result = eval {
  use WWW::Livesite::Args;
  my $qs = WWW::Livesite::Args->new('a=1&a=2');
  my $a = $qs->{a};
  return join '|', @$a;
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '1|2';
}

# ------------------------------------------------------------------------------
# t346 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 197
# ------------------------------------------------------------------------------

sub t346 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use WWW::Misc::Image qw(resize_str_to_props);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t347 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 198
# ------------------------------------------------------------------------------

sub t347 {
  $result = eval {
  my $props = resize_str_to_props('800');
  join(';', map { $_ . '=' . $$props{$_} } sort keys %$props);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'max_x=800;max_y=0;min_x=0;min_y=0';
}

# ------------------------------------------------------------------------------
# t348 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 202
# ------------------------------------------------------------------------------

sub t348 {
  $result = eval {
  my $props = resize_str_to_props('800x600');
  join(';', map { $_ . '=' . $$props{$_} } sort keys %$props);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'max_x=800;max_y=600;min_x=0;min_y=0';
}

# ------------------------------------------------------------------------------
# t349 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 206
# ------------------------------------------------------------------------------

sub t349 {
  $result = eval {
  my $props = resize_str_to_props('800x600/480');
  join(';', map { $_ . '=' . $$props{$_} } sort keys %$props);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'max_x=800;max_y=600;min_x=480;min_y=0';
}

# ------------------------------------------------------------------------------
# t350 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 210
# ------------------------------------------------------------------------------

sub t350 {
  $result = eval {
  my $props = resize_str_to_props('800/480');
  join(';', map { $_ . '=' . $$props{$_} } sort keys %$props);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'max_x=800;max_y=0;min_x=480;min_y=0';
}

# ------------------------------------------------------------------------------
# t351 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 214
# ------------------------------------------------------------------------------

sub t351 {
  $result = eval {
  my $props = resize_str_to_props('100/z');
  join(';', map { $_ . '=' . $$props{$_} } sort keys %$props);
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq 'flags=z;max_x=100;max_y=0;min_x=0;min_y=0';
}

# ------------------------------------------------------------------------------
# t352 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 244
# ------------------------------------------------------------------------------

sub t352 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use WWW::Misc::Image qw(props_to_resize_str);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t353 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 245
# ------------------------------------------------------------------------------

sub t353 {
  $result = eval {
  props_to_resize_str({max_x => 800});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '800';
}

# ------------------------------------------------------------------------------
# t354 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 246
# ------------------------------------------------------------------------------

sub t354 {
  $result = eval {
  props_to_resize_str({max_x => 800, max_y => 600});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '800x600';
}

# ------------------------------------------------------------------------------
# t355 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 247
# ------------------------------------------------------------------------------

sub t355 {
  $result = eval {
  props_to_resize_str({max_x => 800, min_x => 480});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '800/480';
}

# ------------------------------------------------------------------------------
# t356 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 248
# ------------------------------------------------------------------------------

sub t356 {
  $result = eval {
  props_to_resize_str({max_x => 100, max_y => 100,min_x => 100, min_y => 100});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '100x100/100x100';
}

# ------------------------------------------------------------------------------
# t357 - Match
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 250
# ------------------------------------------------------------------------------

sub t357 {
  $result = eval {
  props_to_resize_str({max_x => 100, flags => 'z'});
  };
  $@ and die $@;
  return unless defined $result;
  return $result eq '100/z';
}

# ------------------------------------------------------------------------------
# t358 - Does not abort
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 301
# ------------------------------------------------------------------------------

sub t358 {
  no warnings 'closure';  # allows one test case to setup subroutines for 
                          # subsequent tests.
  $result = eval {
  use WWW::Misc::Image qw(image_dims);
  };
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t359 - False
# Generated from /usr/local/src/lsn/lsn-data-hub/out/lsn-data-hub-05.00288/lib/WWW/Misc/Image.pm line: 302
# ------------------------------------------------------------------------------

sub t359 {
  $result = eval {
  image_dims("/foo");
  };
  $@ and die $@;
  return $result ? 0 : 1;
}

