# Copyright (C) 1999 Bibliotech Ltd., 631-633 Fulham Rd., London SW6 5UQ.
#
# $Id: Net-FTPServer.spec.PL,v 1.4 2001/02/22 12:01:50 rich Exp $

use strict;

my $output = (@ARGV > 0 ? $ARGV[0] : "Net-FTPServer.spec");

unless (do "lib/Net/FTPServer.pm")
  {
    if ($@) { die $@ }
    die "lib/Net/FTPServer.pm: $!"
  }

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$Net::FTPServer::VERSION/g;
s/\@RELEASE\@/$Net::FTPServer::RELEASE/g;

open SPEC, ">$output" or die "$output: $!";
print SPEC $_;
close SPEC;

__DATA__
# Automatically generated by Net-FTPServer.spec.PL

Summary: Net::FTPServer - an extensible, secure FTP server
Name: Net-FTPServer
Version: @VERSION@
Release: @RELEASE@
Copyright: GPL
Group: Applications/Internet
Source: %{name}-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
Requires: Authen-PAM >= 0.10
Requires: BSD-Resource >= 1.08
Requires: Digest-MD5 >= 2.09
Requires: Getopt-Long >= 2.23
#Requires: IO >= 1.20
Requires: IO-stringy >= 1.215-4
Requires: perl >= 5.00503

%description


%prep
%setup -q


%build
perl Makefile.PL
make
make test


%install
rm -rf $RPM_BUILD_ROOT
make PREFIX=$RPM_BUILD_ROOT/usr install
find $RPM_BUILD_ROOT/usr -type f -print | perl -p -e "s@^$RPM_BUILD_ROOT(.*)@\$1*@g" | grep -v perllocal.pod > %{name}-filelist

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}-filelist
%defattr(-,root,root)

%changelog
* Tue Feb 15 2001 Rob Brown <rbrown@about-inc.com>
- Generalized files - works with Perl 5.6 as well as with Perl 5.005
* Tue Feb 08 2001 Richard Jones <rich@annexia.org>
- initial creation
