#!/usr/bin/perl
#

use strict;
use warnings;
use Test::More;

use Net::DNS::Resolver::Unbound;

my $resolver = Net::DNS::Resolver::Unbound->new();

plan skip_all => 'no local nameserver' unless $resolver->nameservers;
plan tests    => 14;


for ( my $handle = undef ) {
	ok( !$resolver->bgbusy($handle), 'not bgbusy' );
	is( $resolver->bgread($handle), undef, 'undefined bgread' );
}


for ( my $handle = Net::DNS::Resolver::libunbound::emulate_wait(123) ) {
	ok( $handle->waiting(),		'handle->waiting' );
	ok( $resolver->bgbusy($handle), 'bgbusy' );
	is( $handle->query_id(), 123,	'handle->query_id' );
	is( $handle->result(),	 undef, 'no handle->result' );
	ok( !$handle->err(), 'no handle->err' );
}


for ( my $handle = Net::DNS::Resolver::libunbound::emulate_callback( 123, -99 ) ) {
	ok( !$handle->waiting(),	 'not handle->waiting' );
	ok( !$resolver->bgbusy($handle), 'not bgbusy' );
	is( $handle->query_id(), 123,	'handle->query_id' );
	is( $handle->result(),	 undef, 'no handle->result' );
	ok( $handle->err(), 'handle->err' );
	is( $resolver->bgread($handle), undef, 'undefined bgread' );
	like( $resolver->errorstring(), '/-99/', 'unknown error' );
}


exit;
