# -#- buffer-read-only: t -#-
#
#      Copyright (c) 1996-1999 Malcolm Beattie
#      Copyright (c) 2008,2009 Reini Urban
#
#      You may distribute under the terms of either the GNU General Public
#      License or the Artistic License, as specified in the README file.
#
#
#
# This file is autogenerated from bytecode.pl. Changes made here will be lost.
#
package B::Asmdata;

our $VERSION = '1.02_01';

use Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw(%insn_data @insn_name @optype @specialsv_name);
our(%insn_data, @insn_name, @optype, @specialsv_name);

@optype = qw(OP UNOP BINOP LOGOP LISTOP PMOP SVOP PADOP PVOP LOOP COP);
@specialsv_name = qw(Nullsv &PL_sv_undef &PL_sv_yes &PL_sv_no pWARN_ALL pWARN_NONE);

# XXX insn_data is initialised this way because with a large
# %insn_data = (foo => [...], bar => [...], ...) initialiser
# I get a hard-to-track-down stack underflow and segfault.
$insn_data{comment} = [35, \&PUT_comment_t, "GET_comment_t"];
$insn_data{nop} = [10, \&PUT_none, "GET_none"];
$insn_data{ret} = [0, \&PUT_none, "GET_none"];
$insn_data{ldsv} = [1, \&PUT_svindex, "GET_svindex"];
$insn_data{ldop} = [2, \&PUT_opindex, "GET_opindex"];
$insn_data{stsv} = [3, \&PUT_U32, "GET_U32"];
$insn_data{stop} = [4, \&PUT_U32, "GET_U32"];
$insn_data{stpv} = [5, \&PUT_U32, "GET_U32"];
$insn_data{ldspecsv} = [6, \&PUT_U8, "GET_U8"];
$insn_data{ldspecsvx} = [7, \&PUT_U8, "GET_U8"];
$insn_data{newsv} = [8, \&PUT_U8, "GET_U8"];
$insn_data{newsvx} = [9, \&PUT_U32, "GET_U32"];
$insn_data{newop} = [11, \&PUT_U8, "GET_U8"];
$insn_data{newopx} = [12, \&PUT_U16, "GET_U16"];
$insn_data{newopn} = [13, \&PUT_U8, "GET_U8"];
$insn_data{newpv} = [14, \&PUT_PV, "GET_PV"];
$insn_data{pv_cur} = [15, \&PUT_PADOFFSET, "GET_PADOFFSET"];
$insn_data{pv_free} = [16, \&PUT_none, "GET_none"];
$insn_data{sv_upgrade} = [17, \&PUT_U8, "GET_U8"];
$insn_data{sv_refcnt} = [18, \&PUT_U32, "GET_U32"];
$insn_data{sv_refcnt_add} = [19, \&PUT_I32, "GET_I32"];
$insn_data{sv_flags} = [20, \&PUT_U32, "GET_U32"];
$insn_data{xrv} = [21, \&PUT_svindex, "GET_svindex"];
$insn_data{xpv} = [22, \&PUT_none, "GET_none"];
$insn_data{xpv_cur} = [23, \&PUT_PADOFFSET, "GET_PADOFFSET"];
$insn_data{xpv_len} = [24, \&PUT_PADOFFSET, "GET_PADOFFSET"];
$insn_data{xiv32} = [25, \&PUT_I32, "GET_I32"];
$insn_data{xiv64} = [26, \&PUT_IV64, "GET_IV64"];
$insn_data{xnv} = [27, \&PUT_NV, "GET_NV"];
$insn_data{xlv_targoff} = [28, \&PUT_PADOFFSET, "GET_PADOFFSET"];
$insn_data{xlv_targlen} = [29, \&PUT_PADOFFSET, "GET_PADOFFSET"];
$insn_data{xlv_targ} = [30, \&PUT_svindex, "GET_svindex"];
$insn_data{xlv_type} = [31, \&PUT_U8, "GET_U8"];
$insn_data{xbm_useful} = [32, \&PUT_I32, "GET_I32"];
$insn_data{xbm_previous} = [33, \&PUT_U16, "GET_U16"];
$insn_data{xbm_rare} = [34, \&PUT_U8, "GET_U8"];
$insn_data{xfm_lines} = [36, \&PUT_IV, "GET_IV"];
$insn_data{xio_lines} = [37, \&PUT_IV, "GET_IV"];
$insn_data{xio_page} = [38, \&PUT_IV, "GET_IV"];
$insn_data{xio_page_len} = [39, \&PUT_IV, "GET_IV"];
$insn_data{xio_lines_left} = [40, \&PUT_IV, "GET_IV"];
$insn_data{xio_top_name} = [41, \&PUT_pvindex, "GET_pvindex"];
$insn_data{xio_top_gv} = [42, \&PUT_svindex, "GET_svindex"];
$insn_data{xio_fmt_name} = [43, \&PUT_pvindex, "GET_pvindex"];
$insn_data{xio_fmt_gv} = [44, \&PUT_svindex, "GET_svindex"];
$insn_data{xio_bottom_name} = [45, \&PUT_pvindex, "GET_pvindex"];
$insn_data{xio_bottom_gv} = [46, \&PUT_svindex, "GET_svindex"];
$insn_data{xio_subprocess} = [47, \&PUT_U16, "GET_U16"];
$insn_data{xio_type} = [48, \&PUT_U8, "GET_U8"];
$insn_data{xio_flags} = [49, \&PUT_U8, "GET_U8"];
$insn_data{xcv_xsubany} = [50, \&PUT_svindex, "GET_svindex"];
$insn_data{xcv_stash} = [51, \&PUT_svindex, "GET_svindex"];
$insn_data{xcv_start} = [52, \&PUT_opindex, "GET_opindex"];
$insn_data{xcv_root} = [53, \&PUT_opindex, "GET_opindex"];
$insn_data{xcv_gv} = [54, \&PUT_svindex, "GET_svindex"];
$insn_data{xcv_file} = [55, \&PUT_pvindex, "GET_pvindex"];
$insn_data{xcv_depth} = [56, \&PUT_long, "GET_long"];
$insn_data{xcv_padlist} = [57, \&PUT_svindex, "GET_svindex"];
$insn_data{xcv_outside} = [58, \&PUT_svindex, "GET_svindex"];
$insn_data{xcv_flags} = [59, \&PUT_U16, "GET_U16"];
$insn_data{av_extend} = [60, \&PUT_PADOFFSET, "GET_PADOFFSET"];
$insn_data{av_pushx} = [61, \&PUT_svindex, "GET_svindex"];
$insn_data{av_push} = [62, \&PUT_svindex, "GET_svindex"];
$insn_data{xav_fill} = [63, \&PUT_PADOFFSET, "GET_PADOFFSET"];
$insn_data{xav_max} = [64, \&PUT_PADOFFSET, "GET_PADOFFSET"];
$insn_data{xav_flags} = [65, \&PUT_U8, "GET_U8"];
$insn_data{xhv_riter} = [66, \&PUT_I32, "GET_I32"];
$insn_data{xhv_name} = [67, \&PUT_pvindex, "GET_pvindex"];
$insn_data{hv_store} = [68, \&PUT_svindex, "GET_svindex"];
$insn_data{sv_magic} = [69, \&PUT_U8, "GET_U8"];
$insn_data{mg_obj} = [70, \&PUT_svindex, "GET_svindex"];
$insn_data{mg_private} = [71, \&PUT_U16, "GET_U16"];
$insn_data{mg_flags} = [72, \&PUT_U8, "GET_U8"];
$insn_data{mg_name} = [73, \&PUT_pvcontents, "GET_pvcontents"];
$insn_data{mg_namex} = [74, \&PUT_svindex, "GET_svindex"];
$insn_data{xmg_stash} = [75, \&PUT_svindex, "GET_svindex"];
$insn_data{gv_fetchpv} = [76, \&PUT_strconst, "GET_strconst"];
$insn_data{gv_fetchpvx} = [77, \&PUT_strconst, "GET_strconst"];
$insn_data{gv_stashpv} = [78, \&PUT_strconst, "GET_strconst"];
$insn_data{gv_stashpvx} = [79, \&PUT_strconst, "GET_strconst"];
$insn_data{gp_sv} = [80, \&PUT_svindex, "GET_svindex"];
$insn_data{gp_refcnt} = [81, \&PUT_U32, "GET_U32"];
$insn_data{gp_refcnt_add} = [82, \&PUT_I32, "GET_I32"];
$insn_data{gp_av} = [83, \&PUT_svindex, "GET_svindex"];
$insn_data{gp_hv} = [84, \&PUT_svindex, "GET_svindex"];
$insn_data{gp_cv} = [85, \&PUT_svindex, "GET_svindex"];
$insn_data{gp_file} = [86, \&PUT_pvindex, "GET_pvindex"];
$insn_data{gp_io} = [87, \&PUT_svindex, "GET_svindex"];
$insn_data{gp_form} = [88, \&PUT_svindex, "GET_svindex"];
$insn_data{gp_cvgen} = [89, \&PUT_U32, "GET_U32"];
$insn_data{gp_line} = [90, \&PUT_U32, "GET_U32"];
$insn_data{gp_share} = [91, \&PUT_svindex, "GET_svindex"];
$insn_data{xgv_flags} = [92, \&PUT_U8, "GET_U8"];
$insn_data{op_next} = [93, \&PUT_opindex, "GET_opindex"];
$insn_data{op_sibling} = [94, \&PUT_opindex, "GET_opindex"];
$insn_data{op_ppaddr} = [95, \&PUT_strconst, "GET_strconst"];
$insn_data{op_targ} = [96, \&PUT_PADOFFSET, "GET_PADOFFSET"];
$insn_data{op_type} = [97, \&PUT_U16, "GET_U16"];
$insn_data{op_seq} = [98, \&PUT_U16, "GET_U16"];
$insn_data{op_flags} = [99, \&PUT_U8, "GET_U8"];
$insn_data{op_private} = [100, \&PUT_U8, "GET_U8"];
$insn_data{op_first} = [101, \&PUT_opindex, "GET_opindex"];
$insn_data{op_last} = [102, \&PUT_opindex, "GET_opindex"];
$insn_data{op_other} = [103, \&PUT_opindex, "GET_opindex"];
$insn_data{op_pmreplroot} = [104, \&PUT_opindex, "GET_opindex"];
$insn_data{op_pmreplstart} = [105, \&PUT_opindex, "GET_opindex"];
$insn_data{op_pmnext} = [106, \&PUT_opindex, "GET_opindex"];
$insn_data{op_pmreplrootpo} = [107, \&PUT_PADOFFSET, "GET_PADOFFSET"];
$insn_data{op_pmreplrootgv} = [108, \&PUT_svindex, "GET_svindex"];
$insn_data{pregcomp} = [109, \&PUT_pvcontents, "GET_pvcontents"];
$insn_data{op_pmflags} = [110, \&PUT_U16, "GET_U16"];
$insn_data{op_pmpermflags} = [111, \&PUT_U16, "GET_U16"];
$insn_data{op_pmdynflags} = [112, \&PUT_U8, "GET_U8"];
$insn_data{op_sv} = [113, \&PUT_svindex, "GET_svindex"];
$insn_data{op_padix} = [114, \&PUT_PADOFFSET, "GET_PADOFFSET"];
$insn_data{op_pv} = [115, \&PUT_pvcontents, "GET_pvcontents"];
$insn_data{op_pv_tr} = [116, \&PUT_op_tr_array, "GET_op_tr_array"];
$insn_data{op_redoop} = [117, \&PUT_opindex, "GET_opindex"];
$insn_data{op_nextop} = [118, \&PUT_opindex, "GET_opindex"];
$insn_data{op_lastop} = [119, \&PUT_opindex, "GET_opindex"];
$insn_data{cop_label} = [120, \&PUT_pvindex, "GET_pvindex"];
$insn_data{cop_stashpv} = [121, \&PUT_pvindex, "GET_pvindex"];
$insn_data{cop_file} = [122, \&PUT_pvindex, "GET_pvindex"];
$insn_data{cop_stash} = [123, \&PUT_svindex, "GET_svindex"];
$insn_data{cop_filegv} = [124, \&PUT_svindex, "GET_svindex"];
$insn_data{cop_seq} = [125, \&PUT_U32, "GET_U32"];
$insn_data{cop_arybase} = [126, \&PUT_I32, "GET_I32"];
$insn_data{cop_line} = [127, \&PUT_U32, "GET_U32"];
$insn_data{cop_warnings} = [128, \&PUT_svindex, "GET_svindex"];
$insn_data{main_start} = [129, \&PUT_opindex, "GET_opindex"];
$insn_data{main_root} = [130, \&PUT_opindex, "GET_opindex"];
$insn_data{main_cv} = [131, \&PUT_svindex, "GET_svindex"];
$insn_data{curpad} = [132, \&PUT_svindex, "GET_svindex"];
$insn_data{push_begin} = [133, \&PUT_svindex, "GET_svindex"];
$insn_data{push_init} = [134, \&PUT_svindex, "GET_svindex"];
$insn_data{push_end} = [135, \&PUT_svindex, "GET_svindex"];

my ($insn_name, $insn_data);
while (($insn_name, $insn_data) = each %insn_data) {
    $insn_name[$insn_data->[0]] = $insn_name;
}
# Fill in any gaps
@insn_name = map($_ || "unused", @insn_name);

1;

__END__

=head1 NAME

B::Asmdata - Autogenerated data about Perl ops, used to generate bytecode

=head1 SYNOPSIS

	use B::Asmdata qw(%insn_data @insn_name @optype @specialsv_name);

=head1 DESCRIPTION

Provides information about Perl ops in order to generate bytecode via
a bunch of exported variables.  Its mostly used by B::Assembler and
B::Disassembler.

=over 4

=item %insn_data

  my($bytecode_num, $put_sub, $get_meth) = @$insn_data{$op_name};

For a given $op_name (for example, 'cop_label', 'sv_flags', etc...)
you get an array ref containing the bytecode number of the op, a
reference to the subroutine used to 'PUT' the op argument to the bytecode stream,
and the name of the method used to 'GET' op argument from the bytecode stream.

Most ops require one arg, in fact all ops without the PUT/GET_none methods,
and the GET and PUT methods are used to en-/decode the arg to binary bytecode.
The names are constructed from the GET/PUT prefix and the argument type,
such as U8, U16, U32, svindex, opindex, pvindex, ...

The PUT method is used in the L<B::Bytecode> compiler within L<B::Assembler>,
the GET method just for the L<B::Disassembler>.
The GET method is not used by the binary L<ByteLoader> module.

A full C<insn> table with version, opcode, name, lvalue, argtype and flags
is located as DATA in F<bytecode.pl>.

=item @insn_name

  my $op_name = $insn_name[$bytecode_num];

A simple mapping of the bytecode number to the name of the op.
Suitable for using with %insn_data like so:

  my $op_info = $insn_data{$insn_name[$bytecode_num]};

=item @optype

  my $op_type = $optype[$op_type_num];

A simple mapping of the op type number to its type (like 'COP' or 'BINOP').

Since Perl version 5.10 defined in L<B>.

=item @specialsv_name

  my $sv_name = $specialsv_name[$sv_index];

Certain SV types are considered 'special'.  They're represented by
B::SPECIAL and are referred to by a number from the specialsv_list.
This array maps that number back to the name of the SV (like 'Nullsv'
or '&PL_sv_undef').

Since Perl version 5.10 defined in L<B>.

=back

=head1 PORTABILITY

All bytecode values are already portable.
Cross-platform portability is implemented, cross-version not yet.
Cross-version portability will be very limited, cross-platform only
for the same threading model.

=head2 CROSS-PLATFORM PORTABILITY

For different endian-ness there are ByteLoader converters in effect.
Header entry: byteorder.

64int - 64all - 32int is portable. Header entry: ivsize

ITHREADS are unportable.
Header entry: archflag - bitflag 1.

=head2 CROSS-VERSION PORTABILITY (TODO - HARD)

Bytecode ops:
We can only reliably load bytecode from previous versions and promise
that from 5.10.0 on future versions will only add new op numbers at
the end, but will never replace old opcodes with incompatible arguments.
On the first unknown bytecode op from a future version we will die.

TODO: Bytecode opcode op-matrix

We will need a table of all bytecode ops for all previous perl
versions. And replacements in the byteloader for all the unsupported
ops, like xiv64, cop_arybase.

TODO: Perl opcode op-matrix

The ByteLoader will need a op matrix of all previous perl versions
to be able to map the old bytecode op to the new perl pp function.

=head1 AUTHOR

Malcolm Beattie, C<mbeattie@sable.ox.ac.uk>

Reini Urban added the version logic, 5.10 support, portability.

=cut

# ex: set ro:
