/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.handler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import org.jmx4perl.JmxRequest;
import org.jmx4perl.config.Restrictor;
import org.jmx4perl.converter.json.ObjectToJsonConverter;
import org.jmx4perl.handler.JsonRequestHandler;

public class WriteHandler
extends JsonRequestHandler {
    private ObjectToJsonConverter objectToJsonConverter;

    public WriteHandler(Restrictor pRestrictor, ObjectToJsonConverter pObjectToJsonConverter) {
        super(pRestrictor);
        this.objectToJsonConverter = pObjectToJsonConverter;
    }

    public JmxRequest.Type getType() {
        return JmxRequest.Type.WRITE;
    }

    public Object doHandleRequest(MBeanServerConnection server, JmxRequest request) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        if (!this.restrictor.isAttributeWriteAllowed(request.getObjectName(), request.getAttributeName())) {
            throw new SecurityException("Writing attribute " + request.getAttributeName() + " forbidden for MBean " + request.getObjectNameAsString());
        }
        try {
            return this.setAttribute(request, server);
        }
        catch (IntrospectionException exp) {
            throw new IllegalArgumentException("Cannot get info for MBean " + request.getObjectName() + ": " + exp, exp);
        }
        catch (InvalidAttributeValueException e) {
            throw new IllegalArgumentException("Invalid value " + request.getValue() + " for attribute " + request.getAttributeName() + ", MBean " + request.getObjectNameAsString(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot set value " + request.getValue() + " for attribute " + request.getAttributeName() + ", MBean " + request.getObjectNameAsString(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot set value " + request.getValue() + " for attribute " + request.getAttributeName() + ", MBean " + request.getObjectNameAsString(), e);
        }
    }

    private Object setAttribute(JmxRequest request, MBeanServerConnection server) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IntrospectionException, InvalidAttributeValueException, IllegalAccessException, InvocationTargetException, IOException {
        Object oldValue = server.getAttribute(request.getObjectName(), request.getAttributeName());
        MBeanInfo mInfo = server.getMBeanInfo(request.getObjectName());
        MBeanAttributeInfo aInfo = null;
        for (MBeanAttributeInfo i : mInfo.getAttributes()) {
            if (!i.getName().equals(request.getAttributeName())) continue;
            aInfo = i;
            break;
        }
        if (aInfo == null) {
            throw new AttributeNotFoundException("No attribute " + request.getAttributeName() + " found for MBean " + request.getObjectNameAsString());
        }
        String type = aInfo.getType();
        Object[] values = this.objectToJsonConverter.getValues(type, oldValue, request);
        Attribute attribute = new Attribute(request.getAttributeName(), values[0]);
        server.setAttribute(request.getObjectName(), attribute);
        return values[1];
    }
}

