/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.converter.json.simplifier;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jmx4perl.converter.StringToObjectConverter;
import org.jmx4perl.converter.json.ObjectToJsonConverter;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SimplifierHandler<T>
implements ObjectToJsonConverter.Handler {
    private Map<String, Extractor<T>> extractorMap = new HashMap<String, Extractor<T>>();
    private Class<T> type;

    SimplifierHandler(Class<T> pType) {
        this.type = pType;
        this.init(this.extractorMap);
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        if (pExtraArgs.size() > 0) {
            String element = pExtraArgs.pop();
            Extractor<Object> extractor = this.extractorMap.get(element);
            if (extractor == null) {
                throw new IllegalArgumentException("Illegal path element " + element + " for object " + pValue);
            }
            Object attributeValue = null;
            try {
                attributeValue = extractor.extract(pValue);
                return pConverter.extractObject(attributeValue, pExtraArgs, jsonify);
            }
            catch (SkipAttributeException e) {
                throw new IllegalArgumentException("Illegal path element " + element + " for object " + pValue, e);
            }
        }
        JSONObject ret = new JSONObject();
        for (Map.Entry<String, Extractor<T>> entry : this.extractorMap.entrySet()) {
            Object value = null;
            try {
                value = entry.getValue().extract(pValue);
            }
            catch (SkipAttributeException e) {
                continue;
            }
            ret.put((Object)entry.getKey(), pConverter.extractObject(value, pExtraArgs, jsonify));
        }
        return ret;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, String pValue) throws IllegalAccessException, InvocationTargetException {
        return null;
    }

    protected void addExtractors(Object[][] pAttrExtractors) {
        for (int i = 0; i < pAttrExtractors.length; ++i) {
            this.extractorMap.put((String)pAttrExtractors[i][0], (Extractor)pAttrExtractors[i][1]);
        }
    }

    abstract void init(Map<String, Extractor<T>> var1);

    static class SkipAttributeException
    extends Exception {
        SkipAttributeException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Extractor<T> {
        public Object extract(T var1) throws SkipAttributeException;
    }
}

