/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.converter.json.simplifier;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jmx4perl.converter.json.simplifier.SimplifierHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHandler
extends SimplifierHandler<File> {
    public FileHandler() {
        super(File.class);
    }

    @Override
    void init(Map<String, SimplifierHandler.Extractor<File>> pExtractorMap) {
        Object[][] attrExtractors = new Object[][]{{"name", new NameExtractor()}, {"modified", new ModifiedExtractor()}, {"length", new LengthExtractor()}, {"directory", new IsDirectoryExtractor()}, {"canonicalPath", new PathExtractor()}, {"exists", new ExistsExtractor()}};
        this.addExtractors(attrExtractors);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExistsExtractor
    implements SimplifierHandler.Extractor<File> {
        private ExistsExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.exists();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathExtractor
    implements SimplifierHandler.Extractor<File> {
        private PathExtractor() {
        }

        @Override
        public Object extract(File file) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsDirectoryExtractor
    implements SimplifierHandler.Extractor<File> {
        private IsDirectoryExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.isDirectory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LengthExtractor
    implements SimplifierHandler.Extractor<File> {
        private LengthExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.length();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModifiedExtractor
    implements SimplifierHandler.Extractor<File> {
        private ModifiedExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.lastModified();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameExtractor
    implements SimplifierHandler.Extractor<File> {
        private NameExtractor() {
        }

        @Override
        public Object extract(File file) {
            return file.getName();
        }
    }
}

