/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.converter;

import java.util.HashMap;
import java.util.Map;

public class StringToObjectConverter {
    private static final Map<String, Extractor> EXTRACTOR_MAP = new HashMap<String, Extractor>();

    public Object convertFromString(String pType, String pValue) {
        if ("[null]".equals(pValue)) {
            return null;
        }
        if ("\"\"".equals(pValue)) {
            if (this.matchesType(pType, String.class)) {
                return "";
            }
            throw new IllegalArgumentException("Cannot convert empty string tag to type " + pType);
        }
        Extractor extractor = EXTRACTOR_MAP.get(pType);
        if (extractor == null) {
            throw new IllegalArgumentException("Cannot convert string " + pValue + " to type " + pType + " because no converter could be found");
        }
        return extractor.extract(pValue);
    }

    private boolean matchesType(String pType, Class pClass) {
        return pClass.getName().equals(pType);
    }

    static {
        EXTRACTOR_MAP.put(Integer.class.getName(), new IntExtractor());
        EXTRACTOR_MAP.put("int", new IntExtractor());
        EXTRACTOR_MAP.put(Long.class.getName(), new LongExtractor());
        EXTRACTOR_MAP.put("long", new LongExtractor());
        EXTRACTOR_MAP.put(Boolean.class.getName(), new BooleanExtractor());
        EXTRACTOR_MAP.put("boolean", new BooleanExtractor());
        EXTRACTOR_MAP.put(String.class.getName(), new StringExtractor());
    }

    private static class BooleanExtractor
    implements Extractor {
        private BooleanExtractor() {
        }

        public Object extract(String pValue) {
            return Boolean.parseBoolean(pValue);
        }
    }

    private static class LongExtractor
    implements Extractor {
        private LongExtractor() {
        }

        public Object extract(String pValue) {
            return Long.parseLong(pValue);
        }
    }

    private static class IntExtractor
    implements Extractor {
        private IntExtractor() {
        }

        public Object extract(String pValue) {
            return Integer.parseInt(pValue);
        }
    }

    private static class StringExtractor
    implements Extractor {
        private StringExtractor() {
        }

        public Object extract(String pValue) {
            return pValue;
        }
    }

    private static interface Extractor {
        public Object extract(String var1);
    }
}

