/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmx4perl.BackendManager;
import org.jmx4perl.Config;
import org.jmx4perl.JmxRequest;
import org.jmx4perl.JmxRequestFactory;
import org.jmx4perl.LogHandler;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentServlet
extends HttpServlet {
    private static final long serialVersionUID = 42L;
    private HttpRequestHandler httpGetHandler;
    private HttpRequestHandler httpPostHandler;
    private BackendManager backendManager;
    private LogHandler logHandler;

    public AgentServlet() {
        this(null);
    }

    public AgentServlet(LogHandler pLogHandler) {
        this.logHandler = pLogHandler != null ? pLogHandler : this.getDefaultLogHandler();
    }

    public void init(ServletConfig pConfig) throws ServletException {
        super.init(pConfig);
        this.httpGetHandler = this.newGetHttpRequestHandler();
        this.httpPostHandler = this.newPostHttpRequestHandler();
        this.backendManager = new BackendManager(this.servletConfigAsMap(pConfig), this.logHandler);
    }

    public void destroy() {
        this.backendManager.unregisterOwnMBeans();
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(this.httpGetHandler, req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(this.httpPostHandler, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(HttpRequestHandler pReqHandler, HttpServletRequest pReq, HttpServletResponse pResp) throws IOException {
        JSONAware json = null;
        int code = 200;
        try {
            this.checkClientIPAccess(pReq);
            json = pReqHandler.handleRequest(pReq, pResp);
            code = this.extractResultCode(json);
            if (this.backendManager.isDebug()) {
                this.backendManager.info("Response: " + json);
            }
        }
        catch (IllegalArgumentException exp) {
            code = 400;
            json = this.getErrorJSON(400, exp);
        }
        catch (IllegalStateException exp) {
            code = 500;
            json = this.getErrorJSON(500, exp);
        }
        catch (SecurityException exp) {
            code = 403;
            json = this.getErrorJSON(403, new Exception(exp.getMessage()));
        }
        catch (Exception exp) {
            code = 500;
            json = this.getErrorJSON(500, exp);
        }
        catch (Error error) {
            code = 500;
            json = this.getErrorJSON(500, error);
        }
        finally {
            this.sendResponse(pResp, code, json.toJSONString());
        }
    }

    private int extractResultCode(JSONAware pJson) {
        if (pJson instanceof List) {
            int maxCode = 0;
            for (JSONAware j : (List)pJson) {
                int code = this.extractStatus(j);
                if (code <= maxCode) continue;
                maxCode = code;
            }
            return maxCode;
        }
        return this.extractStatus(pJson);
    }

    private int extractStatus(JSONAware pJson) {
        if (pJson instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)pJson;
            if (!jsonObject.containsKey((Object)"status")) {
                throw new IllegalStateException("No status given in response " + pJson);
            }
            return (Integer)jsonObject.get((Object)"status");
        }
        throw new IllegalStateException("Internal: Not a JSONObject but a " + pJson.getClass() + " " + pJson);
    }

    private HttpRequestHandler newPostHttpRequestHandler() {
        return new HttpRequestHandler(){

            public JSONAware handleRequest(HttpServletRequest pReq, HttpServletResponse pResp) throws IOException, MalformedObjectNameException {
                String encoding = pReq.getCharacterEncoding();
                List<JmxRequest> jmxRequests = JmxRequestFactory.createRequestsFromInputStream(encoding != null ? new InputStreamReader((InputStream)pReq.getInputStream(), encoding) : new InputStreamReader((InputStream)pReq.getInputStream()));
                JSONArray responseList = new JSONArray();
                for (JmxRequest jmxReq : jmxRequests) {
                    boolean debug;
                    boolean bl = debug = AgentServlet.this.backendManager.isDebug() && !"debugInfo".equals(jmxReq.getOperation());
                    if (debug) {
                        AgentServlet.this.logRequest(pReq, jmxReq);
                    }
                    JSONObject resp = AgentServlet.this.executeRequest(jmxReq);
                    responseList.add((Object)resp);
                }
                return responseList;
            }
        };
    }

    private HttpRequestHandler newGetHttpRequestHandler() {
        return new HttpRequestHandler(){

            public JSONAware handleRequest(HttpServletRequest pReq, HttpServletResponse pResp) {
                JmxRequest jmxReq = JmxRequestFactory.createRequestFromUrl(pReq.getPathInfo(), pReq.getParameterMap());
                if (AgentServlet.this.backendManager.isDebug() && !"debugInfo".equals(jmxReq.getOperation())) {
                    AgentServlet.this.logRequest(pReq, jmxReq);
                }
                return AgentServlet.this.executeRequest(jmxReq);
            }
        };
    }

    private JSONObject executeRequest(JmxRequest jmxReq) {
        try {
            return this.backendManager.handleRequest(jmxReq);
        }
        catch (ReflectionException e) {
            return this.getErrorJSON(404, e);
        }
        catch (InstanceNotFoundException e) {
            return this.getErrorJSON(404, e);
        }
        catch (MBeanException e) {
            return this.getErrorJSON(500, e);
        }
        catch (AttributeNotFoundException e) {
            return this.getErrorJSON(404, e);
        }
        catch (UnsupportedOperationException e) {
            return this.getErrorJSON(500, e);
        }
        catch (IOException e) {
            return this.getErrorJSON(500, e);
        }
    }

    private Map<Config, String> servletConfigAsMap(ServletConfig pConfig) {
        Enumeration e = pConfig.getInitParameterNames();
        HashMap<Config, String> ret = new HashMap<Config, String>();
        while (e.hasMoreElements()) {
            String keyS = (String)e.nextElement();
            Config key = Config.getByKey(keyS);
            if (key == null) continue;
            ret.put(key, pConfig.getInitParameter(keyS));
        }
        return ret;
    }

    private void logRequest(HttpServletRequest pReq, JmxRequest pJmxReq) {
        this.logHandler.debug("URI: " + pReq.getRequestURI());
        this.logHandler.debug("Path-Info: " + pReq.getPathInfo());
        this.logHandler.debug("Request: " + pJmxReq.toString());
    }

    private void checkClientIPAccess(HttpServletRequest pReq) {
        if (!this.backendManager.isRemoteAccessAllowed(pReq.getRemoteHost(), pReq.getRemoteAddr())) {
            throw new SecurityException("No access from client " + pReq.getRemoteAddr() + " allowed");
        }
    }

    private JSONObject getErrorJSON(int pErrorCode, Throwable pExp) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"status", (Object)pErrorCode);
        jsonObject.put((Object)"error", (Object)pExp.toString());
        StringWriter writer = new StringWriter();
        pExp.printStackTrace(new PrintWriter(writer));
        jsonObject.put((Object)"stacktrace", (Object)writer.toString());
        if (this.backendManager.isDebug()) {
            this.backendManager.error("Error " + pErrorCode, pExp);
        }
        return jsonObject;
    }

    private void sendResponse(HttpServletResponse pResp, int pStatusCode, String pJsonTxt) throws IOException {
        try {
            pResp.setCharacterEncoding("utf-8");
            pResp.setContentType("text/plain");
        }
        catch (NoSuchMethodError error) {
            pResp.setContentType("text/plain; charset=utf-8");
        }
        pResp.setStatus(pStatusCode);
        PrintWriter writer = pResp.getWriter();
        writer.write(pJsonTxt);
    }

    private LogHandler getDefaultLogHandler() {
        return new LogHandler(){

            public void debug(String message) {
                AgentServlet.this.log(message);
            }

            public void info(String message) {
                AgentServlet.this.log(message);
            }

            public void error(String message, Throwable t) {
                AgentServlet.this.log(message, t);
            }
        };
    }

    private static interface HttpRequestHandler {
        public JSONAware handleRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException, MalformedObjectNameException;
    }
}

