#!/usr/bin/perl

use strict;

use Debug::Easy;
my @LogLevel  = qw( ERR WARN NOTICE INFO DEBUG DEBUGMAX );
my @CodeLevel = ('[ ERROR ]', '[WARNING]', '[NOTICE ]', '[ INFO  ]', '[ DEBUG ]', '[-DEBUG-]');
my %SomeHash  = (
    'Thiskey' => 'ThisValue',
    'ThatKey' => 'ThatValue',
    'SomeKey' => 'SomeValue'
);

foreach my $LEVEL (0 .. 5) {
    print STDERR "\n---- Showing When Log Level is Set To $LogLevel[$LEVEL] ----\n\n";
    my $debug = Debug::Easy->new('LogLevel' => $LogLevel[$LEVEL], 'Color' => 1, 'Padding' => -5);

    foreach my $count (0 .. 5) {
        $debug->debug($LogLevel[$count], $LogLevel[$count] . ' Single Line Message Test');
        $debug->debug($LogLevel[$count], $LogLevel[$count] . " Multi-Line Scalar\nMessage Test");
        $debug->debug($LogLevel[$count], [$LogLevel[$count] . ' Multi-Line', 'Array', 'Message Test']);
        $debug->DEBUGMAX(['DEBUGMAX - Data Dumper -',\@LogLevel,\@CodeLevel,\%SomeHash,\&subroutine]);
    }
}

exit(0);

sub subroutine {
    my $variable = shift;
    
    my $another_variable = 'Wow, this is a nifty string!';
    return(1);
}
