###############################################################################
#
# This is the MakeMaker skeleton for the RPC-XML extension. Besides the usual
# tricks, this has to add rules to make the *.xpl files from *.code in the
# methods/ subdir, as well as get them into a place where they get installed
# correctly.
#
###############################################################################
use ExtUtils::MakeMaker;
use File::Spec;
use File::Find;
use Cwd 'cwd';

my ($vol, $dir, undef) = File::Spec->splitpath(File::Spec->rel2abs($0));
$dir                   = File::Spec->catpath($vol, $dir, '');
my $test_config        = File::Spec->catfile($dir, 't', 'test.conf');

eval "require LWP;";
if ($LWP::VERSION and $LWP::VERSION < 5.801)
{
    print STDERR <<END;
@@@@@
        Please note!

        Due to a bug fixed in version 5.801 of LWP, using the spool-to-file
        feature of RPC::XML::Client is broken. The relevant tests will be
        skipped in the test suite, but unless you upgrade your LWP you
        should not attempt to use this feature.
@@@@@

END
}

my %parserlist = ();
my %recommended = ();

# eval "use XML::Parser";
# if ($@ or $XML::Parser::VERSION < 2.31)
# {
#     print STDERR <<END;
# @@@@@
#         XML::Parser not found

#         You do not have to have this package if you plan to always
#         explicitly choose an alternate parser in RPC::XML::ParserFactory,
#         RPC::XML::Client or RPC::XML::Server. It's installation is
#         recommended, however. The default selection of parser will not
#         work without this installed.
# @@@@@

# END

#     $recommended{'XML::Parser'} = '2.31';
# }
# else
# {
#     $parserlist{'XML::Parser'} = $XML::Parser::VERSION;
# }

# eval "use XML::LibXML;";
# if ($@ or $XML::LibXML::VERSION < 1.58)
# {
#     print STDERR <<END;
# @@@@@
#        XML::LibXML not found

#        The RPC::XML::ParserFactory class (the replacement for the previous
#        RPC::XML::Parser class) can use this parser if you have it installed
#        and request it when instantiating either RPC::XML::Client or
#        RPC::XML::Server (or RPC::XML::ParserFactor itself, directly).
# @@@@@

# END

#     $recommended{'XML::LibXML'} = '1.58';
# }
# else
# {
#     $parserlist{'XML::LibXML'} = $XML::LibXML::VERSION;
# }

# Write test.conf file
$parserlist{'XML::Parser'}++;
open(my $fh, "> $test_config")
	or die "Cannot open $test_config for writing: $!";
print $fh sprintf("# Generated by $0 on %s\n", scalar localtime);
print $fh 'parsers = ' . join(', ' => sort keys %parserlist) . "\n";
close $fh;

$CLEAN = 'pod2html-* *.html *.spec *.rpm rpmrc rpmmacro *.log t/*.log ' .
    'META.yml *.ppd ';

@scripts = (File::Spec->catfile(qw(etc make_method)));
$CLEAN  .= File::Spec->catfile(qw(methods *.xpl));

@PM_FILES = ();

find(sub { push(@PM_FILES, $File::Find::name) if (-f $_ and /\.pm$/) }, 'lib');

# Exclude Apache2 stuff until it's ready for deployment
@PM_FILES = grep(! /Apache2/, @PM_FILES);

%PM_FILES = map { ($temp = $_) =~ s|^lib|\$\(INST_LIB\)|; $_ => $temp }
    @PM_FILES;
# Handle the method code in "methods" specially:
find(sub {
         if (-f $_ and /\.base$/)
         {
             s/\.base$//;
             $PM_FILES{File::Spec->catfile('methods', "$_.xpl")} =
                 File::Spec->catfile('$(INST_LIB)', 'RPC', 'XML', "$_.xpl");
         }
     }, 'methods');
# Anything stuck under "lib" is more generic
find(sub {
         if (-f $_ and /\.base$/)
         {
             $File::Find::name =~ s/base$/xpl/;
             ($tmp = $File::Find::name) =~ s|^lib|\$(INST_LIB)|;
             $PM_FILES{$File::Find::name} = $tmp;
             $CLEAN .= " $File::Find::name";
         }
     }, 'lib');

WriteMakefile(
              NAME      => 'RPC::XML',
              VERSION   => '0.69',
              AUTHOR    => 'Randy J. Ray',
              ABSTRACT  => 'Data, client and server classes for XML-RPC',
              EXE_FILES => \@scripts,
              PM        => \%PM_FILES,
              PREREQ_PM => { 'File::Spec'   => 0.8,
                             'constant'     => 1.03,
                             'Scalar::Util' => 1.19,
                             'Test::More'   => 0,
                             'LWP'          => 5.801,
							 'XML::Parser'  => 2.31 },
                             # %parserlist },
              dist      => { COMPRESS => 'gzip -9f' },
              clean     => { FILES => $CLEAN },
              LICENSE   => 'perl',
              SIGN      => 'here, please',
              MIN_PERL_VERSION => 5.006001,
             );

sub MY::post_initialize
{
    my $self = shift;

    my @text;
    my $makemeth = File::Spec->catfile(qw(etc make_method));

    push(@text,
         '.SUFFIXES: .xpl .base',
         '',
         '.base.xpl:',
         "\t\$(PERL) $makemeth --base=\$*",
         '');
    join("\n", @text);
}

sub MY::postamble
{
    my $self = shift;

    my @text;
    my $makemeth = File::Spec->catfile(qw(etc make_method));

    # Create the dependancy rules for the methods/XPL files
    for (sort grep(/\.xpl$/, keys %::PM_FILES))
    {
        s/\.xpl$//;
        push(@text, "$_.xpl: $_.base $_.help $_.code $makemeth");
    }

    join("\n", @text);
}
