
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "work with nestable Pod elements",
  "AUTHOR" => "Ricardo SIGNES <rjbs\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Pod-Elemental",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Pod::Elemental",
  "PREREQ_PM" => {
    "Encode" => 0,
    "Mixin::Linewise::Readers" => 0,
    "Moose" => 0,
    "Moose::Autobox" => "0.10",
    "Moose::Role" => "0.90",
    "Moose::Util::TypeConstraints" => 0,
    "MooseX::Types" => 0,
    "MooseX::Types::Moose" => 0,
    "Pod::Eventual::Simple" => "0.004",
    "String::RewritePrefix" => 0,
    "String::Truncate" => 0,
    "Sub::Exporter" => 0,
    "Sub::Exporter::ForMethods" => 0,
    "namespace::autoclean" => 0,
    "strict" => 0,
    "utf8" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Data::Dumper" => 0,
    "Test::Deep" => 0,
    "Test::Differences" => 0,
    "Test::More" => "0.96"
  },
  "VERSION" => "0.102364",
  "test" => {
    "TESTS" => "t/*.t t/elem/*.t t/pod5/*.t"
  }
);


my %FallbackPrereqs = (
  "Data::Dumper" => 0,
  "Encode" => 0,
  "Mixin::Linewise::Readers" => 0,
  "Moose" => 0,
  "Moose::Autobox" => "0.10",
  "Moose::Role" => "0.90",
  "Moose::Util::TypeConstraints" => 0,
  "MooseX::Types" => 0,
  "MooseX::Types::Moose" => 0,
  "Pod::Eventual::Simple" => "0.004",
  "String::RewritePrefix" => 0,
  "String::Truncate" => 0,
  "Sub::Exporter" => 0,
  "Sub::Exporter::ForMethods" => 0,
  "Test::Deep" => 0,
  "Test::Differences" => 0,
  "Test::More" => "0.96",
  "namespace::autoclean" => 0,
  "strict" => 0,
  "utf8" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



