use strict;
use warnings;
package Dist::Zilla::App::Command::install;
# ABSTRACT: install your dist
$Dist::Zilla::App::Command::install::VERSION = '5.012';
use Dist::Zilla::App -command;

# =head1 SYNOPSIS
#
# Installs your distribution using a specified command.
#
#     dzil install [--install-command="cmd"]
#
# =cut
sub abstract { 'install your dist' }

# =head1 EXAMPLE
#
#     $ dzil install
#     $ dzil install --install-command="cpan ."
#
# =cut

sub opt_spec {
  [ 'install-command=s', 'command to run to install (e.g. "cpan .")' ],
  [ 'keep-build-dir|keep' => 'keep the build directory even after a success' ],
}

# =head1 OPTIONS
#
# =head2 --install-command
#
# This defines what command to run after building the dist in the dist dir.
#
# Any value that works with L<C<system>|perlfunc/system> is accepted.
#
# If not specified, calls (roughly):
#
#     cpanm .
#
# For more information, look at the L<install|Dist::Zilla::Dist::Builder/install> method in
# Dist::Zilla.
#
# =cut

sub execute {
  my ($self, $opt, $arg) = @_;

  $self->zilla->install({
    $opt->install_command
      ? (install_command => [ $opt->install_command ])
      : (),
    $opt->keep_build_dir
      ? (keep_build_dir => 1)
      : (),
  });
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::App::Command::install - install your dist

=head1 VERSION

version 5.012

=head1 SYNOPSIS

Installs your distribution using a specified command.

    dzil install [--install-command="cmd"]

=head1 EXAMPLE

    $ dzil install
    $ dzil install --install-command="cpan ."

=head1 OPTIONS

=head2 --install-command

This defines what command to run after building the dist in the dist dir.

Any value that works with L<C<system>|perlfunc/system> is accepted.

If not specified, calls (roughly):

    cpanm .

For more information, look at the L<install|Dist::Zilla::Dist::Builder/install> method in
Dist::Zilla.

=head1 AUTHOR

Ricardo SIGNES <rjbs@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Ricardo SIGNES.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
