#!perl
# Copyright (C) 2006-2007, The Perl Foundation.
# $Id: continuation.t 29952 2008-08-02 22:45:13Z allison $

use strict;
use warnings;
use lib qw( . lib ../lib ../../lib );
use Test::More;
use Parrot::Test tests => 2;

=head1 NAME

t/pmc/continuation.t - test Continuation PMC


=head1 SYNOPSIS

    % prove t/pmc/continuation.t

=head1 DESCRIPTION

Tests the Continuation PMC.

=cut

pir_output_is( <<'CODE', <<'OUT', 'new' );
.sub 'test' :main
    new P0, 'Continuation'
    print "ok 1\n"
.end
CODE
ok 1
OUT

pir_output_is( <<'CODE', <<'OUT', 'invoke with init' );
.sub 'test' :main
    new P0, 'Continuation'
    set_addr P0, L1
    P0()
    print "not "
L1:
    print "ok 1\n"
.end
CODE
ok 1
OUT

# end of tests.

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
