#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::Yahoo
#     ABSTRACT:  identify Yahoo owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Sun Oct 12 19:32:46 PDT 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::Yahoo;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known Yahoo IP blocks as of Oct 2014
    $self->ips(qw(
        8.3.34.0 - 8.3.35.255
        8.8.178.0 - 8.8.178.255
        27.123.32.0 - 27.123.63.255
        27.123.196.0 - 27.123.197.255
        27.123.198.0 - 27.123.199.255
        27.123.200.0 - 27.123.207.255
        46.228.32.0 - 46.228.47.255
        63.250.192.0 - 63.250.223.255
        64.56.160.0 - 64.56.191.255
        64.157.4.0 - 64.157.4.255
        66.94.224.0 - 66.94.255.255
        66.163.160.0 - 66.163.191.255
        66.218.64.0 - 66.218.95.255
        67.28.112.0 - 67.28.115.255
        67.72.118.0 - 67.72.119.255
        67.195.0.0 - 67.195.255.255
        68.180.128.0 - 68.180.255.255
        69.147.64.0 - 69.147.127.255
        76.13.0.0 - 76.13.255.255
        77.238.160.0 - 77.238.191.255
        87.248.96.0 - 87.248.127.255
        98.136.0.0 - 98.139.255.255
        103.2.12.0 - 103.2.15.255
        106.10.128.0 - 106.10.191.255
        106.10.192.0 - 106.10.223.255
        115.178.0.0 - 115.178.1.255
        115.178.2.0 - 115.178.3.255
        115.178.4.0 - 115.178.5.255
        115.178.6.0 - 115.178.7.255
        115.178.8.0 - 115.178.9.255
        116.214.0.0 - 116.214.15.255
        117.104.190.0 - 117.104.190.255
        117.104.191.0 - 117.104.191.255
        118.151.224.0 - 118.151.255.255
        119.160.240.0 - 119.160.255.255
        121.101.144.0 - 121.101.159.255
        124.108.64.0 - 124.108.71.255
        124.108.80.0 - 124.108.83.255
        124.108.86.0 - 124.108.87.255
        124.108.90.0 - 124.108.91.255
        124.108.92.0 - 124.108.95.255
        124.108.96.0 - 124.108.99.255
        180.222.96.0 - 180.222.111.255
        180.233.112.0 - 180.233.115.255
        180.233.116.0 - 180.233.116.255
        180.233.117.0 - 180.233.117.255
        180.233.118.0 - 180.233.118.255
        180.233.119.0 - 180.233.119.255
        182.22.0.0 - 182.22.127.255
        183.79.0.0 - 183.79.255.255
        183.177.64.0 - 183.177.67.255
        183.177.68.0 - 183.177.71.255
        183.177.80.0 - 183.177.81.255
        183.177.84.0 - 183.177.87.255
        183.177.88.0 - 183.177.89.255
        183.177.94.0 - 183.177.95.255
        184.165.0.0 - 184.165.255.255
        188.125.64.0 - 188.125.95.255
        189.125.135/24
        193.93.196.0 - 193.93.199.255
        194.88.69.0 - 194.88.69.255
        202.4.164.0 - 202.4.164.255
        202.43.192.0 - 202.43.199.255
        202.46.19.0 - 202.46.19.255
        202.86.4.0 - 202.86.7.255
        202.160.176.0 - 202.160.191.255
        202.171.234.0 - 202.171.234.255
        202.174.4.0 - 202.174.4.255
        203.14.212.0 - 203.14.212.255
        203.83.216.0 - 203.83.217.255
        203.95.16.0 - 203.95.23.255
        203.99.254.0 - 203.99.254.255
        203.110.236.0 - 203.110.239.255
        203.141.32.0/20
        203.141.49.0/26
        203.141.49.64/27
        203.141.53.0/24
        203.141.54.0/24
        203.141.61.0/24
        203.145.224.0 - 203.145.255.255
        203.188.192.0 - 203.188.207.255
        203.216.128.0 - 203.216.159.255
        206.3.0.0 - 206.3.31.255
        206.190.32.0 - 206.190.63.255
        207.126.224.0 - 207.126.239.255
        208.67.64.0 - 208.67.71.255
        208.71.40.0 - 208.71.47.255
        209.131.32.0 - 209.131.63.255
        209.191.64.0 - 209.191.127.255
        211.14.12.0/22
        211.14.20.0/22
        212.82.96.0 - 212.82.127.255
        216.115.96.0 - 216.115.111.255
        216.145.48.0 - 216.145.63.255
        216.155.192.0 - 216.155.207.255
        216.252.96.0 - 216.252.127.255
        216.255.224.0 - 216.255.239.255
        217.12.0.0 - 217.12.15.255
        217.146.176.0 - 217.146.191.255
        217.163.20.0 - 217.163.21.255
        2001:0DF0:00ED::/48
        2001:4998:: - 2001:4998:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:49A0:: - 2001:49A0:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF
        2400:7E00::/32
        2406:2000::/32
        2406:6E00::/32
        2406:8600::/32
        2804:1bc::/32
    ));
    return $self;
}

sub name {
    return 'Yahoo';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::Yahoo - identify Yahoo owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::Yahoo;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::Yahoo identifies Yahoo host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::Yahoo object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
