#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::VPLS
#     ABSTRACT:  identify VPLS/Krypt owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Sun Oct 12 19:32:46 PDT 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::VPLS;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known VPLS/Krypt IP blocks as of Oct 2014
    $self->ips(qw(
        66.186.32.0 - 66.186.63.255
        67.198.128.0 - 67.198.255.255
        67.229.0.0 - 67.229.255.255
        74.222.128.0 - 74.222.191.255
        96.62.0.0 - 96.62.255.255
        98.126.0.0 - 98.126.255.255
        103.233.80.0 - 103.233.83.255
        110.34.128.0 - 110.34.255.255
        173.214.0.0 - 173.214.127.255
        174.139.0.0 - 174.139.255.255
        184.75.176.0 - 184.75.191.255
        184.83.0.0 - 184.83.255.255
        209.11.240.0 - 209.11.255.255
    ));
    return $self;
}

sub name {
    return 'VPLS';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::VPLS - identify VPLS/Krypt owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::VPLS;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::VPLS identifies VPLS/Krypt host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::VPLS object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
