#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::ColoCrossing
#     ABSTRACT:  identify ColoCrossing (AS36352) owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Sun Oct 12 19:33:06 PDT 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::ColoCrossing;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known ColoCrossing (AS36352) IP blocks as of Sept 2014
    $self->ips(qw(
        23.94.0.0 - 23.95.255.255
        65.99.193.0 - 65.99.193.255
        65.99.246.0 - 65.99.246.255
        66.225.194.0 - 66.225.195.255
        66.225.198.0 - 66.225.198.255
        66.225.231.0 - 66.225.231.255
        66.225.232.0 - 66.225.232.255
        69.31.134.0 - 69.31.134.255
        72.249.94.0 - 72.249.94.255
        72.249.124.0 - 72.249.124.255
        75.102.10.0 - 75.102.10.255
        75.102.27.0 - 75.102.27.255
        75.102.34.0 - 75.102.34.255
        75.102.38.0 - 75.102.39.255
        75.127.0.0 - 75.127.15.255
        96.8.112.0 - 96.8.127.255
        104.168.0.0 - 104.168.127.255
        107.172.0.0 - 107.175.255.255
        108.174.48.0 - 108.174.63.255
        172.245.0.0 - 172.245.255.255
        192.3.0.0 - 192.3.255.255
        192.210.128.0 - 192.210.255.255
        192.227.128.0 - 192.227.255.255
        198.12.64.0 - 198.12.127.255
        198.23.128.0 - 198.23.255.255
        198.46.128.0 - 198.46.255.255
        198.144.176.0 - 198.144.191.255
        199.21.112.0 - 199.21.115.255
        199.188.100.0 - 199.188.103.255
        205.234.152.0 - 205.234.152.255
        205.234.153.0 - 205.234.153.255
        205.234.159.0 - 205.234.159.255
        205.234.203.0 - 205.234.203.255
        206.123.95.0 - 206.123.95.255
        206.217.128.0 - 206.217.143.255
        207.210.239.0 - 207.210.239.255
        216.246.49.0 - 216.246.49.255
        216.246.108.0 - 216.246.108.255
        216.246.109.0 - 216.246.109.255
    ));
    return $self;
}

sub name {
    return 'ColoCrossing';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::ColoCrossing - identify ColoCrossing (AS36352) owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::ColoCrossing;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::ColoCrossing identifies ColoCrossing (AS36352) host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::ColoCrossing object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
