use 5.010;
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME             => 'Service::Engine',
    AUTHOR           => q{Richard Bush <rbush@netsocialapp.com>},
    VERSION_FROM     => 'lib/Service/Engine.pm',
    ABSTRACT_FROM    => 'lib/Service/Engine.pm',
    LICENSE          => 'artistic_2',
    PL_FILES         => {},
    MIN_PERL_VERSION => '5.010',
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => '0',
    },
    BUILD_REQUIRES => {
        'Test::More' => '0',
    },
    PREREQ_PM => {
        'Cache::Memcached::Fast'  => 0,
        'DBI'                 => 0,
        'File::Pid'           => 0,
        'File::Slurp'         => 0,
        'File::stat'         => 0,
        'IO::Multiplex'       => 0,
        'JSON'                => 0,
        'List::Util'          => 0,
        'LWP::UserAgent'      => 0,
        'Memory::Usage'       => 0,
        'Module::Runtime'     => 0,
        'Net::Server'         => 0,
        'Net::Server::HTTP'   => 0,
        'RedisDB'             => 0,
        'Search::Elasticsearch' => 0,
        'threads'             => 0,
        'threads::shared'     => 0,
        'Thread::Queue'       => 0,
        'Time::localtime'     => 0,
        'URI::Escape'         => 0,
    },
    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES => 'Service-Engine-*' },
);
