use strict;
use warnings;
use Test::More;

require_ok 'FFI::Platypus';
require_ok 'FFI::Platypus::API';
require_ok 'FFI::Platypus::Buffer';
require_ok 'FFI::Platypus::DL';
require_ok 'FFI::Platypus::Declare';
require_ok 'FFI::Platypus::Lang';
require_ok 'FFI::Platypus::Lang::ASM';
require_ok 'FFI::Platypus::Lang::C';
require_ok 'FFI::Platypus::Lang::Win32';
require_ok 'FFI::Platypus::Memory';
require_ok 'FFI::Platypus::Record';
require_ok 'FFI::Platypus::Record::TieArray';
require_ok 'FFI::Platypus::ShareConfig';
require_ok 'FFI::Platypus::Type::PointerSizeBuffer';
require_ok 'FFI::Platypus::Type::StringPointer';
ok -f 't/ffi_platypus.t',                                     'test for FFI::Platypus';
ok -f 't/ffi_platypus_api.t',                                 'test for FFI::Platypus::API';
ok -f 't/ffi_platypus_buffer.t',                              'test for FFI::Platypus::Buffer';
ok -f 't/ffi_platypus_dl.t',                                  'test for FFI::Platypus::DL';
ok -f 't/ffi_platypus_declare.t',                             'test for FFI::Platypus::Declare';
ok -f 't/ffi_platypus_lang.t',                                'test for FFI::Platypus::Lang';
ok -f 't/ffi_platypus_lang_asm.t',                            'test for FFI::Platypus::Lang::ASM';
ok -f 't/ffi_platypus_lang_c.t',                              'test for FFI::Platypus::Lang::C';
ok -f 't/ffi_platypus_lang_win32.t',                          'test for FFI::Platypus::Lang::Win32';
ok -f 't/ffi_platypus_memory.t',                              'test for FFI::Platypus::Memory';
ok -f 't/ffi_platypus_record.t',                              'test for FFI::Platypus::Record';
ok -f 't/ffi_platypus_record_tiearray.t',                     'test for FFI::Platypus::Record::TieArray';
ok -f 't/ffi_platypus_shareconfig.t',                         'test for FFI::Platypus::ShareConfig';
ok -f 't/ffi_platypus_type_pointersizebuffer.t',              'test for FFI::Platypus::Type::PointerSizeBuffer';
ok -f 't/ffi_platypus_type_stringpointer.t',                  'test for FFI::Platypus::Type::StringPointer';
done_testing;

