package Dist::Zilla::PluginBundle::Author::Plicease;

use Moose;
use v5.10;
use Dist::Zilla;

# ABSTRACT: Dist::Zilla plugin bundle used by Plicease
our $VERSION = '0.97'; # VERSION


with 'Dist::Zilla::Role::PluginBundle::Easy';

use namespace::autoclean;

sub configure
{
  my($self) = @_;

  $self->add_bundle('Filter' => {
    -bundle => '@Basic',
    -remove => [ qw( UploadToCPAN Readme ExtraTests ConfirmRelease ) ],
  });

  $self->add_plugins(qw(

    PodWeaver
    NextRelease
    AutoPrereqs
    OurPkgVersion
    MetaJSON

  ));

  $self->add_bundle('Git' => {
    allow_dirty => [ qw( dist.ini Changes README.pod ) ],
  });

  $self->add_plugins([
    AutoMetaResources => {
      'bugtracker.github' => 'user:plicease',
      'repository.github' => 'user:plicease',
      homepage            => 'http://perl.wdlabs.com/%{dist}/',
    }
  ]);

  $self->add_plugins('Author::Plicease::Tests')
    if $self->payload->{release_tests};
    
  $self->add_plugins(qw(

    InstallGuide
    MinimumPerl
    ConfirmRelease

  ));
}

__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=head1 NAME

Dist::Zilla::PluginBundle::Author::Plicease - Dist::Zilla plugin bundle used by Plicease

=head1 VERSION

version 0.97

=head1 SYNOPSIS

In your dist.ini:

 [@Author::Plicease]

=head1 DESCRIPTION

This Dist::Zilla plugin bundle is the equivalent to

 [@Filter]
 -bundle = @Basic
 -remove = UploadToCPAN
 -remove = Readme
 -remove = ExtraTests
 -remove = ConfirmRelease

 [PodWeaver]
 [NextRelease]
 [AutoPrereqs]
 [OurPkgVersion]
 [MetaJSON]

 [@Git]
 allow_dirty = dist.ini
 allow_dirty = Changes
 allow_dirty = README.pod

 [AutoMetaResources]
 bugtracker.github = user:plicease
 repository.github = user:plicease
 homepage = http://perl.wdlabs.com/%{dist}/
 
 [InstallGuide]
 [MinimumPerl]
 [ConfirmRelease]

=head1 SEE ALSO

L<Author::Plicease::Init|Dist::Zilla::Plugin::Author::Plicease::Init>,
L<MintingProfile::Plicease|Dist::Zilla::MintingProfile::Author::Plicease>

=head1 AUTHOR

Graham Ollis <perl@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2012 by Graham Ollis.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
