#!/usr/bin/perl
# $Id: 04grapher.t,v 1.1 2002/01/21 15:40:39 piers Exp $
use strict;
use lib qw(./lib ../lib);
use Test;
use Cwd;
use File::Spec::Functions;
use Module::Dependency::Grapher;
BEGIN { plan tests => 17; }

my $dir = cwd();
if (-d 't') { $dir = catfile( $dir, 't'); }
my $index = catfile( $dir, 'dbindext.dat' );
my $tempfile = catfile( $dir, 'temp.tmp' );

if ( -f $index ) {
	ok(1);
} else {
	for (3..23) { ok(1); }
	warn( "You need to run all the tests in order! $index not found, so skipping tests!" );
	exit;
}

Module::Dependency::Grapher::setIndex( $index );

# test text method
Module::Dependency::Grapher::makeText('both', 'd', $tempfile, { } );
ok( cmpfile( $tempfile, TEXT() ) );
Module::Dependency::Grapher::makeText('both', 'd', $tempfile, { NoLegend => 1 } );
ok( cmpfile( $tempfile, TEXT() ) );
Module::Dependency::Grapher::makeText('both', 'd', $tempfile, { NoVersion => 1 } );
ok( cmpfile( $tempfile, TEXT() ) );
Module::Dependency::Grapher::makeText('parent', 'd', $tempfile, { NoVersion => 1 } );
ok( cmpfile( $tempfile, TEXT2() ) );
Module::Dependency::Grapher::makeText('child', 'd', $tempfile, { NoVersion => 1 } );
ok( cmpfile( $tempfile, TEXT3() ) );

# test html method
Module::Dependency::Grapher::makeHtml('both', 'd', $tempfile, { } );
ok( cmpfile( $tempfile, HTML() ) );
Module::Dependency::Grapher::makeHtml('both', 'd', $tempfile, { NoLegend => 1 } );
ok( cmpfile( $tempfile, HTML() ) );
Module::Dependency::Grapher::makeHtml('both', 'd', $tempfile, { NoVersion => 1 } );
ok( cmpfile( $tempfile, HTML() ) );
Module::Dependency::Grapher::makeHtml('parent', 'd', $tempfile, { NoVersion => 1 } );
ok( cmpfile( $tempfile, HTML2() ) );
Module::Dependency::Grapher::makeHtml('child', 'd', $tempfile, { NoVersion => 1 } );
ok( cmpfile( $tempfile, HTML3() ) );

# test images
my $fmt = 'GIF';
eval {
	Module::Dependency::Grapher::makeImage('both', 'd', $tempfile, { Format => $fmt } );
	ok( cmpfile( $tempfile, 'GIF' ) );
};
if ($@) {
	$fmt = 'PNG';
	Module::Dependency::Grapher::makeImage('both', 'd', $tempfile, { Format => $fmt } );
	ok( cmpfile( $tempfile, 'PNG' ) );
}

# test postscript

eval {
	require PostScript::Simple;
};
if ($@) {
	#warn('skipping PostScript tests');
	for (1..5) { ok(1); }
} else {
	Module::Dependency::Grapher::makePs('both', 'd', $tempfile, {} );
	ok( cmpfile( $tempfile, PS() ) );
	ok( cmpfile( $tempfile, '%!PS-Adobe-3.0 EPSF-1.2' ) );
	ok( cmpfile( $tempfile, '(Dependency Chart) show stroke' ) );
	ok( cmpfile( $tempfile, '%%EOF' ) );
	Module::Dependency::Grapher::makePs('both', 'd', $tempfile, { Format => 'PS' } );
	ok( cmpfile( $tempfile, '%!PS-Adobe-3.0
%%Title:' ) );
}

sub cmpfile {
	my ($file, $subs) = @_;
	local *FILE;
	open (FILE, $file) or die("Can't open temp file: $!");
	undef $/;
	my $str = <FILE>;
	close FILE;
	
	if ( index($str, $subs) > -1 ) {
		return 1;
	} else {
		return 0;
	}
}

sub PS {
	return q[newpath
20 u 88 u moveto
(x.pl) show stroke
newpath
20 u 136 u moveto
(y.pl) show stroke
newpath
220 u 76 u moveto
(a) show stroke
newpath
220 u 112 u moveto
(b) show stroke
newpath
220 u 148 u moveto
(c) show stroke
newpath
420 u 112 u moveto
(d) show stroke
newpath
620 u 76 u moveto
(f) show stroke
newpath
620 u 112 u moveto
(g) show stroke
newpath
620 u 148 u moveto
(h) show stroke
];
}

sub HTML {
	return q[
<table class="MDGraphTable">
<tr><th>Kind</th><th>Items</th></tr>
<tr><td class="MDGraphParent">Parent</td><td class="MDGraphParent">x.pl, y.pl</td></tr>
<tr><td class="MDGraphParent">Parent</td><td class="MDGraphParent">a, b, c</td></tr>
<tr><td class="MDGraphSeed">****</td><td class="MDGraphSeed">d</td></tr>
<tr><td class="MDGraphChild">Child</td><td class="MDGraphChild">f, g, h</td></tr>
</table>
</div>];
}
sub HTML2 {
	return q[
<table class="MDGraphTable">
<tr><th>Kind</th><th>Items</th></tr>
<tr><td class="MDGraphParent">Parent</td><td class="MDGraphParent">x.pl, y.pl</td></tr>
<tr><td class="MDGraphParent">Parent</td><td class="MDGraphParent">a, b, c</td></tr>
<tr><td class="MDGraphSeed">****</td><td class="MDGraphSeed">d</td></tr>
</table>
</div>];
}
sub HTML3 {
	return q[
<table class="MDGraphTable">
<tr><th>Kind</th><th>Items</th></tr>
<tr><td class="MDGraphSeed">****</td><td class="MDGraphSeed">d</td></tr>
<tr><td class="MDGraphChild">Child</td><td class="MDGraphChild">f, g, h</td></tr>
</table>
</div>];
}

sub TEXT {
	return q[
 Parent> +- x.pl, y.pl
         |
 Parent> +- a, b, c
         |
   ****> +- d
         |
  Child> +- f, g, h];
}

sub TEXT2 {
	return q[
 Parent> +- x.pl, y.pl
         |
 Parent> +- a, b, c
         |
   ****> +- d
];
}

sub TEXT3 {
	return q[
   ****> +- d
         |
  Child> +- f, g, h];
}
