package AddressBook::Family;

use strict;
use warnings;

use base 'AddressBook::GEN::Family';

use Gantry::Plugins::AutoCRUD qw(
    do_add
    do_edit
    do_delete
    form_name
    write_file
);

use AddressBook::Model::family qw(
    $FAMILY
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
# This method inherited from AddressBook::GEN::Family

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
# This method inherited from AddressBook::GEN::Family

#-----------------------------------------------------------------
# get_model_name( )
#-----------------------------------------------------------------
sub get_model_name {
    return $FAMILY;
}

#-----------------------------------------------------------------
# get_orm_helper( )
#-----------------------------------------------------------------
sub get_orm_helper {
    return 'Gantry::Plugins::AutoCRUDHelper::DBIxClass';
}

#-----------------------------------------------------------------
# text_descr( )
#-----------------------------------------------------------------
sub text_descr     {
    return 'family';
}

1;

=head1 NAME

AddressBook::Family - A controller in the AddressBook application

=head1 SYNOPSIS

This package is meant to be used in a stand alone server/CGI script or the
Perl block of an httpd.conf file.

Stand Alone Server or CGI script:

    use AddressBook::Family;

    my $cgi = Gantry::Engine::CGI->new( {
        config => {
            #...
        },
        locations => {
            '/someurl' => 'AddressBook::Family',
            #...
        },
    } );

httpd.conf:

    <Perl>
        # ...
        use AddressBook::Family;
    </Perl>

    <Location /someurl>
        SetHandler  perl-script
        PerlHandler AddressBook::Family
    </Location>

If all went well, one of these was correctly written during app generation.

=head1 DESCRIPTION

This module was originally generated by Bigtop.  But feel free to edit it.
You might even want to describe the table this module controls here.

=head1 METHODS

=over 4

=item get_model_name

=item text_descr

=item get_orm_helper


=back


=head1 METHODS INHERITED FROM AddressBook::GEN::Family

=over 4

=item do_main

=item form


=back


=head1 DEPENDENCIES

    AddressBook
    AddressBook::GEN::Family
    AddressBook::Model::family
    Gantry::Plugins::AutoCRUD

=head1 AUTHOR

Phil Crow, E<lt>phil@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
