use warnings;
use strict;

use Test::Simple tests => $::tests;
use IPC::Open3;

my $windows = $^O =~ /^MSWin/;

sub slurp($) {
    my( $ret, $n ) = '';
    while( $n = sysread $_[0], my $txt, 1024 ) {
	$ret .= $txt;
    }
    unless( defined $n ) {
	$ret .= "sysread: $!";
    }
    $ret =~ tr/\r//d if $windows;
    $ret;
}

my $at;
sub at {
    $at //= sprintf '#line %d "%s"', (caller 1)[2, 1];
}
# run pl, expect $_
sub pl(@) {
    at;
    my @cmd = ($^X, '-W', '../pl', @_);
    my $name = join ' ', 'pl', map /[\s*?()[\]{}\$\\'";|&]|^$/ ? "'$_'" : $_, @_;
    if( $windows ) {
	require Win32::ShellQuote;
	$cmd[2] = '..\pl';
	@cmd = $name = Win32::ShellQuote::quote_native( @cmd );
    }
    my $none = '';
    my $pid = open3( $none, my $fh, '', @cmd );
    my $ret = slurp $fh;

    eval $at . q{
      ok $ret eq $_, $name
	or print qq{got: "$ret", expected: "$_"\n}
    };
    undef $at;
    waitpid $pid, 0;
}

# run pl, expect shift
sub pl_e($@) {
    at;
    local $_ = shift;
    &pl;
}

# run pl, expect $_ altered by shift->()
sub pl_a(&@) {
    at;
    local $_ = $_;
    shift->();
    &pl;
}

1;
