use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'          => 'XML::Handler::Dtd2Html',
    'VERSION_FROM'  => 'Dtd2Html.pm', # finds $VERSION
    'ABSTRACT'      => 'HTML documentation generator from a DTD',
    'PREREQ_PM'     => {
                        'XML::Parser'           => 2.31,
                        'XML::SAX'              => 0.11,
                        'XML::SAX::Base'        => 1.00,
                        'XML::SAX::Expat'       => 0.35,
                        'XML::SAX::Writer'      => 0.44,
                        'HTML::Template'        => 0,
    },
    'PM'            => {
                        'Dtd2Html.pm'       => '$(INST_LIBDIR)/Dtd2Html.pm',
                        'home.png'          => '$(INST_LIBDIR)/Dtd2Html/home.png',
                        'prev.png'          => '$(INST_LIBDIR)/Dtd2Html/prev.png',
                        'next.png'          => '$(INST_LIBDIR)/Dtd2Html/next.png',
                        'up.png'            => '$(INST_LIBDIR)/Dtd2Html/up.png',
                        'main.tmpl'         => '$(INST_LIBDIR)/Dtd2Html/main.tmpl',
                        'example.tmpl'      => '$(INST_LIBDIR)/Dtd2Html/example.tmpl',
                        'en/_desc.tmpl'     => '$(INST_LIBDIR)/Dtd2Html/en/_desc.tmpl',
                        'en/_footer.tmpl'   => '$(INST_LIBDIR)/Dtd2Html/en/_footer.tmpl',
                        'en/_header.tmpl'   => '$(INST_LIBDIR)/Dtd2Html/en/_header.tmpl',
                        'en/_index.tmpl'    => '$(INST_LIBDIR)/Dtd2Html/en/_index.tmpl',
                        'en/_main.tmpl'     => '$(INST_LIBDIR)/Dtd2Html/en/_main.tmpl',
                        'en/alpha.tmpl'     => '$(INST_LIBDIR)/Dtd2Html/en/alpha.tmpl',
                        'en/book.tmpl'      => '$(INST_LIBDIR)/Dtd2Html/en/book.tmpl',
                        'en/element.tmpl'   => '$(INST_LIBDIR)/Dtd2Html/en/element.tmpl',
                        'en/entity.tmpl'    => '$(INST_LIBDIR)/Dtd2Html/en/entity.tmpl',
                        'en/frame.tmpl'     => '$(INST_LIBDIR)/Dtd2Html/en/frame.tmpl',
                        'en/index.tmpl'     => '$(INST_LIBDIR)/Dtd2Html/en/index.tmpl',
                        'en/notation.tmpl'  => '$(INST_LIBDIR)/Dtd2Html/en/notation.tmpl',
                        'en/prolog.tmpl'    => '$(INST_LIBDIR)/Dtd2Html/en/prolog.tmpl',
                        'en/simple.tmpl'    => '$(INST_LIBDIR)/Dtd2Html/en/simple.tmpl',
                        'fr/_desc.tmpl'     => '$(INST_LIBDIR)/Dtd2Html/fr/_desc.tmpl',
                        'fr/_footer.tmpl'   => '$(INST_LIBDIR)/Dtd2Html/fr/_footer.tmpl',
                        'fr/_header.tmpl'   => '$(INST_LIBDIR)/Dtd2Html/fr/_header.tmpl',
                        'fr/_index.tmpl'    => '$(INST_LIBDIR)/Dtd2Html/fr/_index.tmpl',
                        'fr/_main.tmpl'     => '$(INST_LIBDIR)/Dtd2Html/fr/_main.tmpl',
                        'fr/alpha.tmpl'     => '$(INST_LIBDIR)/Dtd2Html/fr/alpha.tmpl',
                        'fr/book.tmpl'      => '$(INST_LIBDIR)/Dtd2Html/fr/book.tmpl',
                        'fr/element.tmpl'   => '$(INST_LIBDIR)/Dtd2Html/fr/element.tmpl',
                        'fr/entity.tmpl'    => '$(INST_LIBDIR)/Dtd2Html/fr/entity.tmpl',
                        'fr/frame.tmpl'     => '$(INST_LIBDIR)/Dtd2Html/fr/frame.tmpl',
                        'fr/index.tmpl'     => '$(INST_LIBDIR)/Dtd2Html/fr/index.tmpl',
                        'fr/notation.tmpl'  => '$(INST_LIBDIR)/Dtd2Html/fr/notation.tmpl',
                        'fr/prolog.tmpl'    => '$(INST_LIBDIR)/Dtd2Html/fr/prolog.tmpl',
                        'fr/simple.tmpl'    => '$(INST_LIBDIR)/Dtd2Html/fr/simple.tmpl',
    },
    'EXE_FILES'     => ['dtd2html.pl'],
    'AUTHOR'        => "Francois PERRAD (francois.perrad\@gadz.org)",
    'dist'          => {
                        'COMPRESS'      => 'gzip',
                        'SUFFIX'        => '.gz',
    },
);
