use strict;

#
#			Interface Definition Language (OMG IDL CORBA v3.0)
#
#			IDL to Java Language Mapping Specification, Version 1.1 June 2001
#

package JavaClassVisitor;

use vars qw($VERSION);
$VERSION = '0.02';

use POSIX qw(ctime);

# needs $node->{java_name} (JavaNameVisitor), $node->{java_literal} (JavaLiteralVisitor)

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self = {};
	bless($self, $class);
	my($parser) = @_;
	$self->{srcname} = $parser->YYData->{srcname};
	$self->{srcname_size} = $parser->YYData->{srcname_size};
	$self->{srcname_mtime} = $parser->YYData->{srcname_mtime};
	$self->{symbtab} = $parser->YYData->{symbtab};
	$self->{nb_deprecated} = $parser->YYData->{nb_deprecated};
	$self->{done_hash} = {};
	$self->{num_key} = 'num_java';
	return $self;
}

sub mkdir_stream {
	my $self = shift;
	my($node) = @_;
	my $dirname = $node->{java_package};
	if ($dirname) {
		$dirname =~ s/\./\//g;
		unless (-d $dirname) {
			mkdir $dirname
					or die "can't create $dirname ($!).\n";
		}
	}
}

sub open_stream {
	my $self = shift;
	my($node,$suffix) = @_;
	my $filename;
	my $dirname = $node->{java_package};
	my $prefix = '';
	$prefix = '_' if ($suffix eq 'Stub.java');
	if ($dirname) {
		$dirname =~ s/\./\//g;
		$filename = $dirname . '/' . $prefix . $node->{java_name} . $suffix;
	} else {
		$filename = $prefix . $node->{java_name} . $suffix;
	}
	open(OUT, "> $filename")
			or die "can't open $filename ($!).\n",caller(),"\n";
	$self->{filename} = $filename;

	print OUT "package ",$node->{java_package},";\n"
			if ($node->{java_package});
	print OUT "\n";
	print OUT "/**\n";
	print OUT " * ",$self->{filename},"\n";
	print OUT " * Generated by idl2java (Perl)\n";
	print OUT " * from ",$self->{srcname},", ",$self->{srcname_size}," octets, ",POSIX::ctime($self->{srcname_mtime});
	print OUT " * at ",POSIX::ctime(time());
	print OUT " */\n";
	print OUT "\n";
}

sub _no_mapping {
	my $self = shift;
	my($node) = @_;
	my $FH = $self->{out};
	return unless ($self->{srcname} eq $node->{filename});
	if (ref($node) =~ /^Forward/) {
		$node = $self->{symbtab}->Lookup($node->{full});
	}
	print $FH "\n";
	print $FH "/* no mapping for ",$node->{java_name}," (",ref $node,")*/\n";
	print $FH "\n";
}

sub _get_defn {
	my $self = shift;
	my($defn) = @_;
	if (ref $defn) {
		return $defn;
	} else {
		return $self->{symbtab}->Lookup($defn);
	}
}

#
#	3.5		OMG IDL Specification
#

sub visitSpecification {
	my $self = shift;
	my($node) = @_;
	foreach (@{$node->{list_decl}}) {
		$self->_get_defn($_)->visit($self);
	}
}

#
#	3.7		Module Declaration
#

sub visitModules {
	my $self = shift;
	my($node) = @_;
	unless (-d $node->{java_name}) {
		mkdir $node->{java_name}
				or die "can't create $node->{java_name} ($!).\n";
	}
	unless (exists $node->{$self->{num_key}}) {
		$node->{$self->{num_key}} = 0;
	}
	my $module = ${$node->{list_decl}}[$node->{$self->{num_key}}];
	$module->visit($self);
	$node->{$self->{num_key}} ++;
}

sub visitModule {
	my $self = shift;
	my($node) = @_;
	foreach (@{$node->{list_decl}}) {
		$self->_get_defn($_)->visit($self);
	}
}

#
#	3.8		Interface Declaration
#

sub visitRegularInterface {
	my $self = shift;
	my($node) = @_;
	return unless ($self->{srcname} eq $node->{filename});
	$self->mkdir_stream($node);
	$self->{itf} = $node->{java_name};
	$self->{repos_id} = $node->{repos_id};
	$self->{constants} = '';
	$self->{methodes} = '';
	$self->{stub} = '';
	foreach (@{$node->{list_decl}}) {
		$self->_get_defn($_)->visit($self);
	}

	$self->open_stream($node,'Holder.java');
	print OUT "public final class ",$node->{java_name},"Holder implements org.omg.CORBA.portable.Streamable\n";
	print OUT "{\n";
	print OUT "  public ",$node->{java_Name}," value = ",$node->{java_init},";\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder ()\n";
	print OUT "  {\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder (",$node->{java_Name}," initialValue)\n";
	print OUT "  {\n";
	print OUT "    value = initialValue;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    value = ",$node->{java_read},";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _write (org.omg.CORBA.portable.OutputStream os)\n";
	print OUT "  {\n";
	print OUT "    ",$node->{java_write},"value);\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public org.omg.CORBA.TypeCode _type ()\n";
	print OUT "  {\n";
	print OUT "    return ",$node->{java_Name},"Helper.type ();\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'Helper.java');
	print OUT "abstract public class ",$node->{java_name},"Helper\n";
	print OUT "{\n";
	print OUT "  public static void insert (org.omg.CORBA.Any a, ",$node->{java_Name}," that)\n";
	print OUT "  {\n";
	print OUT "    org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();\n";
	print OUT "    a.type (type ());\n";
	print OUT "    write (out, that);\n";
	print OUT "    a.read_value (out.create_input_stream (), type ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," extract (org.omg.CORBA.Any a)\n";
	print OUT "  {\n";
	print OUT "    return read (a.create_input_stream ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  private static org.omg.CORBA.TypeCode __typeCode = null;\n";
	print OUT "  synchronized public static org.omg.CORBA.TypeCode type ()\n";
	print OUT "  {\n";
	print OUT "    if (__typeCode == null)\n";
	print OUT "    {\n";
	print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_interface_tc (",$node->{java_Name},"Helper.id (), \"",$node->{java_name},"\");\n";
	print OUT "    }\n";
	print OUT "    return __typeCode;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static String id ()\n";
	print OUT "  {\n";
	print OUT "    return \"",$node->{repos_id},"\";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    return narrow (is.read_Object (_",$node->{java_name},"Stub.class));\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static void write (org.omg.CORBA.portable.OutputStream os, ",$node->{java_Name}," value)\n";
	print OUT "  {\n";
	print OUT "    os.write_Object ((org.omg.CORBA.Object) value);\n";
	print OUT "  }\n";
	print OUT "\n";
	if (exists $node->{list_inheritance}) {
		my $has_abstract = 0;
		foreach (@{$node->{list_inheritance}}) {
			$has_abstract = 1 if (exists $_->{modifier});
		}
		if ($has_abstract) {
			print OUT "  public static ",$node->{java_Name}," narrow (java.lang.Object obj)\n";
			print OUT "  {\n";
			print OUT "    if (obj == null)\n";
			print OUT "      return null;\n";
			print OUT "    else if (obj instanceof org.omg.CORBA.Object)\n";
			print OUT "      return narrow ((org.omg.CORBA.Object) obj);\n";
			print OUT "    throw new org.omg.CORBA.BAD_PARAM ();\n";
			print OUT "  }\n";
			print OUT "\n";
		}
	}
	print OUT "  public static ",$node->{java_Name}," narrow (org.omg.CORBA.Object obj)\n";
	print OUT "  {\n";
	print OUT "    if (obj == null)\n";
	print OUT "      return null;\n";
	print OUT "    else if (obj instanceof ",$node->{java_Name},")\n";
	print OUT "      return (",$node->{java_Name},")obj;\n";
	print OUT "    else if (obj._is_a (id ()))\n";
	print OUT "    {\n";
	print OUT "      org.omg.CORBA.portable.ObjectImpl impl = (org.omg.CORBA.portable.ObjectImpl)obj ;\n";
	print OUT "      org.omg.CORBA.portable.Delegate delegate = impl._get_delegate() ;\n";
	print OUT "      ",$node->{java_stub}," stub = new ",$node->{java_stub}," ();\n";
	print OUT "      stub._set_delegate(delegate);\n";
	print OUT "      return stub;\n";
	print OUT "    }\n";
	print OUT "    throw new org.omg.CORBA.BAD_PARAM ();\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'.java');
	if (exists $node->{list_inheritance}) {
		print OUT "public interface ",$node->{java_name}," extends ",$node->{java_name},"Operations";
		foreach (@{$node->{list_inheritance}}) {
			print OUT ", ";
			print OUT $_->{java_Name};
		}
		print OUT "\n";
	} else {
		print OUT "public interface ",$node->{java_name}," extends ",$node->{java_name},"Operations, org.omg.CORBA.Object, org.omg.CORBA.portable.IDLEntity\n";
	}
	print OUT "{\n";
	print OUT $self->{constants};
	print OUT "} // interface ",$node->{java_name},"\n";
	close OUT;

	$self->open_stream($node,'Operations.java');
	if (exists $node->{list_inheritance}) {
		print OUT "public interface ",$node->{java_name},"Operations extends ";
		my $first = 1;
		foreach (@{$node->{list_inheritance}}) {
			print OUT ", " unless ($first);
			if (exists $_->{modifier}) {	# abstract
				print OUT $_->{java_Name};
			} else {
				print OUT $_->{java_Name},"Operations";
			}
			$first = 0;
		}
		print OUT "\n";
	} else {
		print OUT "public interface ",$node->{java_name},"Operations\n";
	}
	print OUT "{\n";
	print OUT $self->{methodes};
	print OUT "} // interface ",$node->{java_name},"Operations\n";
	close OUT;

	$self->open_stream($node,'Stub.java');
	print OUT "public class _",$node->{java_name},"Stub extends org.omg.CORBA.portable.ObjectImpl implements ",$node->{java_Name},"\n";
	print OUT "{\n";
	print OUT "\n";
	print OUT $self->{stub};
	print OUT "  // Type-specific CORBA::Object operations\n";
	print OUT "  private static String[] __ids = {\n";
	print OUT "    \"",$node->{repos_id},"\"";
	foreach (values %{$node->{hash_inheritance}}) {
		print OUT ",\n";
		print OUT "    \"",$_->{repos_id},"\"";
	}
	print OUT "};\n";
	print OUT "\n";
	print OUT "  public String[] _ids ()\n";
	print OUT "  {\n";
	print OUT "    return (String[])__ids.clone ();\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  private void readObject (java.io.ObjectInputStream s) throws java.io.IOException\n";
	print OUT "  {\n";
	print OUT "     String str = s.readUTF ();\n";
	print OUT "     String[] args = null;\n";
	print OUT "     java.util.Properties props = null;\n";
	print OUT "     org.omg.CORBA.Object obj = org.omg.CORBA.ORB.init (args, props).string_to_object (str);\n";
	print OUT "     org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate ();\n";
	print OUT "     _set_delegate (delegate);\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  private void writeObject (java.io.ObjectOutputStream s) throws java.io.IOException\n";
	print OUT "  {\n";
	print OUT "     String[] args = null;\n";
	print OUT "     java.util.Properties props = null;\n";
	print OUT "     String str = org.omg.CORBA.ORB.init (args, props).object_to_string (this);\n";
	print OUT "     s.writeUTF (str);\n";
	print OUT "  }\n";
	print OUT "} // class _",$node->{java_name},"Stub\n";
	close OUT;

	delete $self->{constants};
	delete $self->{methodes};
	delete $self->{stub}
}

sub visitAbstractInterface {
	my $self = shift;
	my($node) = @_;
	return unless ($self->{srcname} eq $node->{filename});
	$self->mkdir_stream($node);
	$self->{itf} = $node->{java_name};
	$self->{repos_id} = $node->{repos_id};
	$self->{constants} = '';
	$self->{methodes} = '';
	$self->{stub} = '';
	foreach (@{$node->{list_decl}}) {
		$self->_get_defn($_)->visit($self);
	}

	$self->open_stream($node,'Holder.java');
	print OUT "public final class ",$node->{java_name},"Holder implements org.omg.CORBA.portable.Streamable\n";
	print OUT "{\n";
	print OUT "  public ",$node->{java_Name}," value = ",$node->{java_init},";\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder ()\n";
	print OUT "  {\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder (",$node->{java_Name}," initialValue)\n";
	print OUT "  {\n";
	print OUT "    value = initialValue;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    value = ",$node->{java_read},";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _write (org.omg.CORBA.portable.OutputStream os)\n";
	print OUT "  {\n";
	print OUT "    ",$node->{java_write},"value);\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public org.omg.CORBA.TypeCode _type ()\n";
	print OUT "  {\n";
	print OUT "    return ",$node->{java_Name},"Helper.type ();\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'Helper.java');
	print OUT "abstract public class ",$node->{java_name},"Helper\n";
	print OUT "{\n";
	print OUT "  public static void insert (org.omg.CORBA.Any a, ",$node->{java_Name}," that)\n";
	print OUT "  {\n";
	print OUT "    org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();\n";
	print OUT "    a.type (type ());\n";
	print OUT "    write (out, that);\n";
	print OUT "    a.read_value (out.create_input_stream (), type ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," extract (org.omg.CORBA.Any a)\n";
	print OUT "  {\n";
	print OUT "    return read (a.create_input_stream ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  private static org.omg.CORBA.TypeCode __typeCode = null;\n";
	print OUT "  synchronized public static org.omg.CORBA.TypeCode type ()\n";
	print OUT "  {\n";
	print OUT "    if (__typeCode == null)\n";
	print OUT "    {\n";
	print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_interface_tc (",$node->{java_Name},"Helper.id (), \"",$node->{java_name},"\");\n";
	print OUT "    }\n";
	print OUT "    return __typeCode;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static String id ()\n";
	print OUT "  {\n";
	print OUT "    return \"",$node->{repos_id},"\";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    return narrow (((org.omg.CORBA_2_3.portable.InputStream)is).read_abstract_interface (_",$node->{java_name},"Stub.class));\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static void write (org.omg.CORBA.portable.OutputStream os, ",$node->{java_Name}," value)\n";
	print OUT "  {\n";
	print OUT "    ((org.omg.CORBA_2_3.portable.OutputStream)os).write_abstract_interface ((java.lang.Object) value);\n";
	print OUT "  }\n";
	print OUT "\n";
	if (exists $node->{list_inheritance}) {
		my $has_abstract = 0;
		foreach (@{$node->{list_inheritance}}) {
			$has_abstract = 1 if (exists $_->{modifier});
		}
		if ($has_abstract) {
			print OUT "  public static ",$node->{java_Name}," narrow (java.lang.Object obj)\n";
			print OUT "  {\n";
			print OUT "    if (obj == null)\n";
			print OUT "      return null;\n";
			print OUT "    else if (obj instanceof org.omg.CORBA.Object)\n";
			print OUT "      return narrow ((org.omg.CORBA.Object) obj);\n";
			print OUT "    throw new org.omg.CORBA.BAD_PARAM ();\n";
			print OUT "  }\n";
			print OUT "\n";
		}
	}
	print OUT "  public static ",$node->{java_Name}," narrow (java.lang.Object obj)\n";
	print OUT "  {\n";
	print OUT "    if (obj == null)\n";
	print OUT "      return null;\n";
	print OUT "    else if (obj instanceof ",$node->{java_Name},")\n";
	print OUT "      return (",$node->{java_Name},")obj;\n";
	print OUT "    else if ((obj instanceof org.omg.CORBA.portable.ObjectImpl) &&\n";
	print OUT "             (((org.omg.CORBA.Object)obj)._is_a (id ())))\n";
	print OUT "    {\n";
	print OUT "      org.omg.CORBA.portable.ObjectImpl impl = (org.omg.CORBA.portable.ObjectImpl)obj ;\n";
	print OUT "      org.omg.CORBA.portable.Delegate delegate = impl._get_delegate() ;\n";
	print OUT "      ",$node->{java_stub}," stub = new ",$node->{java_stub}," ();\n";
	print OUT "      stub._set_delegate(delegate);\n";
	print OUT "      return stub;\n";
	print OUT "    }\n";
	print OUT "    throw new org.omg.CORBA.BAD_PARAM ();\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'.java');
	if (exists $node->{list_inheritance}) {
		print OUT "public interface ",$node->{java_name}," extends ";
		my $first = 1;
		foreach (@{$node->{list_inheritance}}) {
			print OUT ", " unless ($first);
			print OUT $_->{java_Name};
			$first = 0;
		}
		print OUT "\n";
	} else {
		print OUT "public interface ",$node->{java_name}," extends org.omg.CORBA.portable.IDLEntity\n";
	}
	print OUT "{\n";
	print OUT $self->{constants};
	print OUT $self->{methodes};
	print OUT "} // interface ",$node->{java_name},"\n";
	close OUT;

	$self->open_stream($node,'Stub.java');
	print OUT "public class _",$node->{java_name},"Stub extends org.omg.CORBA.portable.ObjectImpl implements ",$node->{java_Name},"\n";
	print OUT "{\n";
	print OUT "\n";
	print OUT $self->{stub};
	print OUT "  // Type-specific CORBA::Object operations\n";
	print OUT "  private static String[] __ids = {\n";
	print OUT "    \"",$node->{repos_id},"\"";
	foreach (values %{$node->{hash_inheritance}}) {
		print OUT ",\n";
		print OUT "    \"",$_->{repos_id},"\"";
	}
	print OUT "};\n";
	print OUT "\n";
	print OUT "  public String[] _ids ()\n";
	print OUT "  {\n";
	print OUT "    return (String[])__ids.clone ();\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  private void readObject (java.io.ObjectInputStream s) throws java.io.IOException\n";
	print OUT "  {\n";
	print OUT "     String str = s.readUTF ();\n";
	print OUT "     String[] args = null;\n";
	print OUT "     java.util.Properties props = null;\n";
	print OUT "     org.omg.CORBA.Object obj = org.omg.CORBA.ORB.init (args, props).string_to_object (str);\n";
	print OUT "     org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate ();\n";
	print OUT "     _set_delegate (delegate);\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  private void writeObject (java.io.ObjectOutputStream s) throws java.io.IOException\n";
	print OUT "  {\n";
	print OUT "     String[] args = null;\n";
	print OUT "     java.util.Properties props = null;\n";
	print OUT "     String str = org.omg.CORBA.ORB.init (args, props).object_to_string (this);\n";
	print OUT "     s.writeUTF (str);\n";
	print OUT "  }\n";
	print OUT "} // class _",$node->{java_name},"Stub\n";
	close OUT;

	delete $self->{constants};
	delete $self->{methodes};
	delete $self->{stub}
}

sub visitLocalInterface {
	# TODO
}

sub visitForwardRegularInterface {
	# empty
}

sub visitForwardAbstractInterface {
	# empty
}

sub visitForwardLocalInterface {
	# empty
}

#
#	3.9		Value Declaration
#
#	3.9.1	Regular Value Type
#

sub visitRegularValue {
	my $self = shift;
	my($node) = @_;
	# TODO
}

sub visitStateMembers {
	my $self = shift;
	my($node) = @_;
	foreach (@{$node->{list_decl}}) {
		$self->_get_defn($_)->visit($self);
	}
}

sub visitStateMember {
	my $self = shift;
	my($node) = @_;
	# TODO
}

sub visitFactory {
	my $self = shift;
	my($node) = @_;
	# TODO
}

#
#	3.9.2	Boxed Value Type
#

sub visitBoxedValue {
	my $self = shift;
	my($node) = @_;
	# TODO
}

#
#	3.9.3	Abstract Value Type
#

sub visitAbstractValue {
	# TODO
}

#
#	3.9.4	Value Forward Declaration
#

sub visitForwardRegularValue {
	# empty
}

sub visitForwardAbstractValue {
	# empty
}

#
#	3.10	Constant Declaration
#

sub visitConstant {
	my $self = shift;
	my($node) = @_;
	return unless ($self->{srcname} eq $node->{filename});
	my $type = $self->_get_defn($node->{type});
	my $defn;
	my $pkg = $node->{full};
	$pkg =~ s/::[0-9A-Z_a-z]+$//;
	$defn = $self->{symbtab}->Lookup($pkg) if ($pkg);
	if ( defined $defn and $defn->isa('BaseInterface') ) {
		$self->{constants} .= "  public static final " . $type->{java_name} . " " . $node->{java_name} . " = ";
		$self->{constants} .= "(" . $type->{java_name} . ")(" . $node->{value}->{java_literal} . ");\n";
	} else {
		$self->open_stream($node,'.java');
		print OUT "public interface ",$node->{java_name},"\n";
		print OUT "{\n";
		print OUT "  public static final ",$type->{java_name};
			print OUT " value = (",$type->{java_name},")(",$node->{value}->{java_literal},");\n";
		print OUT "}\n";
		close OUT;
	}
}

#
#	3.11	Type Declaration
#

sub visitTypeDeclarators {
	my $self = shift;
	my($node) = @_;
	foreach (@{$node->{list_decl}}) {
		$self->_get_defn($_)->visit($self);
	}
}

sub visitTypeDeclarator {
	my $self = shift;
	my($node) = @_;
	return unless ($self->{srcname} eq $node->{filename});
	if (exists $node->{modifier}) {
		# TODO
		return;
	}
	my $type = $self->_get_defn($node->{type});
	if (	   $type->isa('StructType')
			or $type->isa('UnionType')
			or $type->isa('EnumType') ) {
		$type->visit($self);
	}
	if (exists $node->{array_size}) {
		warn __PACKAGE__,"::visitTypeDecalarator $node->{idf} : empty array_size.\n"
				unless (@{$node->{array_size}});

		my @array = ();
		foreach (@{$node->{array_size}}) {
			push @array, "[]";
		}
		my @array_max = ();
		while ($type->isa('SequenceType')) {
			push @array, "[]";
			if (exists $type->{max}) {
				push @array_max, $type->{max};
			} else {
				push @array_max, undef;
			}
			$type = $self->_get_defn($type->{type});
		}
		$self->mkdir_stream($node);
		$self->open_stream($node,'Holder.java');
		print OUT "public final class ",$node->{java_name},"Holder implements org.omg.CORBA.portable.Streamable\n";
		print OUT "{\n";
		print OUT "  public ",$type->{java_Name}," value",@array," = null;\n";
		print OUT "\n";
		print OUT "  public ",$node->{java_name},"Holder ()\n";
		print OUT "  {\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public ",$node->{java_name},"Holder (",$type->{java_Name},@array," initialValue)\n";
		print OUT "  {\n";
		print OUT "    value = initialValue;\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public void _read (org.omg.CORBA.portable.InputStream is)\n";
		print OUT "  {\n";
		print OUT "    value = ",$node->{java_Name},"Helper.read (is);\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public void _write (org.omg.CORBA.portable.OutputStream os)\n";
		print OUT "  {\n";
		print OUT "    ",$node->{java_Name},"Helper.write (os, value);\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public org.omg.CORBA.TypeCode _type ()\n";
		print OUT "  {\n";
		print OUT "    return ",$node->{java_Name},"Helper.type ();\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "}\n";
		close OUT;

		$self->open_stream($node,'Helper.java');
		print OUT "abstract public class ",$node->{java_name},"Helper\n";
		print OUT "{\n";
		print OUT "  public static void insert (org.omg.CORBA.Any a, ",$type->{java_Name},@array," that)\n";
		print OUT "  {\n";
		print OUT "    org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();\n";
		print OUT "    a.type (type ());\n";
		print OUT "    write (out, that);\n";
		print OUT "    a.read_value (out.create_input_stream (), type ());\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public static ",$type->{java_Name},@array," extract (org.omg.CORBA.Any a)\n";
		print OUT "  {\n";
		print OUT "    return read (a.create_input_stream ());\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  private static org.omg.CORBA.TypeCode __typeCode = null;\n";
		print OUT "  synchronized public static org.omg.CORBA.TypeCode type ()\n";
		print OUT "  {\n";
		print OUT "    if (__typeCode == null)\n";
		print OUT "    {\n";
		print OUT "      __typeCode = ",$type->{java_type_code},";\n";
		foreach (reverse @array_max) {
			if (defined $_) {
				print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_sequence_tc (",$_->{java_literal},", __typeCode);\n";
			} else {
				print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_sequence_tc (0, __typeCode);\n";
			}
		}
		foreach (@{$node->{array_size}}) {
			print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_array_tc (",$_->{java_literal},", __typeCode );\n";
		}
		print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_alias_tc (",$node->{java_Name},"Helper.id (), \"",$node->{java_name},"\", __typeCode);\n";
		print OUT "    }\n";
		print OUT "    return __typeCode;\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public static java.lang.String id ()\n";
		print OUT "  {\n";
		print OUT "    return \"",$node->{repos_id},"\";\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public static ",$type->{java_Name},@array," read (org.omg.CORBA.portable.InputStream is)\n";
		print OUT "  {\n";
		print OUT "    ",$type->{java_Name}," value",@array," = null;\n";
		my @tab = ("  ");
		my $i = 0;
		my $idx = '';
		my @array1= @array;
		foreach (@{$node->{array_size}}) {
			push @tab, "  ";
			pop @array1;
			print OUT @tab,"value",$idx," = new ",$type->{java_Name},"[",$_->{java_literal},"]",@array1,";\n";
			print OUT @tab,"for (int _o",$i," = 0;_o",$i," < (",$_->{java_literal},"); ++_o",$i,")\n";
			print OUT @tab,"{\n";
			$idx .= "[_o" . $i . "]";
			$i ++;
		}
		foreach (@array_max) {
			push @tab, "  ";
			pop @array1;
			print OUT @tab,"int _len",$i," = is.read_long ();\n";
			if (defined $_) {
				print OUT @tab,"if (_len",$i," > (",$_->{java_literal},"))\n";
				print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
			}
			print OUT @tab,"value",$idx," = new ",$type->{java_Name},"[_len",$i,"]",@array1,";\n";
			print OUT @tab,"for (int _o",$i," = 0;_o",$i," < value",$idx,".length; ++_o",$i,")\n";
			print OUT @tab,"{\n";
			$idx .= "[_o" . $i . "]";
			$i ++;
		}
		print OUT @tab,"  value",$idx," = ",$type->{java_read},";\n";
		if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
			print OUT @tab,"  if (value",$idx,".length () > (",$type->{max}->{java_literal},"))\n";
			print OUT @tab,"    throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
		}
		foreach (@array_max) {
			print OUT @tab,"}\n";
			pop @tab;
		}
		foreach (@{$node->{array_size}}) {
			print OUT @tab,"}\n";
			pop @tab;
		}
		print OUT "    return value;\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public static void write (org.omg.CORBA.portable.OutputStream os, ",$type->{java_Name},@array," value)\n";
		print OUT "  {\n";
		@tab = ("  ");
		$i = 0;
		$idx = '';
		foreach (@{$node->{array_size}}) {
			push @tab, "  ";
			print OUT @tab,"if (value",$idx,".length != (",$_->{java_literal},"))\n";
			print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
			print OUT @tab,"for (int _i",$i," = 0;_i",$i," < (",$_->{java_literal},"); ++_i",$i,")\n";
			print OUT @tab,"{\n";
			$idx .= "[_i" . $i . "]";
			$i ++;
		}
		foreach (@array_max) {
			push @tab, "  ";
			if (defined $_) {
				print OUT @tab,"if (value",$idx,".length > (",$_->{java_literal},"))\n";
				print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
			}
			print OUT @tab,"os.write_long (value",$idx,".length);\n";
			print OUT @tab,"for (int _i",$i," = 0;_i",$i," < value",$idx,".length; ++_i",$i,")\n";
			print OUT @tab,"{\n";
			$idx .= "[_i" . $i . "]";
			$i ++;
		}
		if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
			print OUT @tab,"  if (value",$idx,".length () > (",$type->{max}->{java_literal},"))\n";
			print OUT @tab,"    throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
		}
		print OUT @tab,"  ",$type->{java_write},"value",$idx,");\n";
		foreach (@array_max) {
			print OUT @tab,"}\n";
			pop @tab;
		}
		foreach (@{$node->{array_size}}) {
			print OUT @tab,"}\n";
			pop @tab;
		}
		print OUT "  }\n";
		print OUT "\n";
		print OUT "}\n";
		close OUT;
	} else {
		if (	   $type->isa('SequenceType')
				or $type->isa('BasicType')
				or $type->isa('StringType')
				or $type->isa('WideStringType')
				or $type->isa('FixedPtType') ) {
			# nothing
		} else {
			$self->mkdir_stream($node);
			$self->open_stream($node,'Helper.java');
			print OUT "abstract public class ",$node->{java_name},"Helper\n";
			print OUT "{\n";
			print OUT "  public static void insert (org.omg.CORBA.Any a, ",$type->{java_Name}," that)\n";
			print OUT "  {\n";
			print OUT "    org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();\n";
			print OUT "    a.type (type ());\n";
			print OUT "    write (out, that);\n";
			print OUT "    a.read_value (out.create_input_stream (), type ());\n";
			print OUT "  }\n";
			print OUT "\n";
			print OUT "  public static ",$type->{java_Name}," extract (org.omg.CORBA.Any a)\n";
			print OUT "  {\n";
			print OUT "    return read (a.create_input_stream ());\n";
			print OUT "  }\n";
			print OUT "\n";
			print OUT "  private static org.omg.CORBA.TypeCode __typeCode = null;\n";
			print OUT "  synchronized public static org.omg.CORBA.TypeCode type ()\n";
			print OUT "  {\n";
			print OUT "    if (__typeCode == null)\n";
			print OUT "    {\n";
			print OUT "      __typeCode = ",$type->{java_type_code},";\n";
			print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_alias_tc (",$node->{java_Name},"Helper.id (), \"",$node->{java_name},"\", __typeCode);\n";
			print OUT "    }\n";
			print OUT "    return __typeCode;\n";
			print OUT "  }\n";
			print OUT "\n";
			print OUT "  public static java.lang.String id ()\n";
			print OUT "  {\n";
			print OUT "    return \"",$node->{repos_id},"\";\n";
			print OUT "  }\n";
			print OUT "\n";
			print OUT "  public static ",$type->{java_Name}," read (org.omg.CORBA.portable.InputStream is)\n";
			print OUT "  {\n";
			print OUT "    ",$type->{java_Name}," value = ",$type->{java_init},";\n";
			print OUT "    value = ",$type->{java_read},";\n";
			if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
				print OUT "    if (value.length () > (",$type->{max}->{java_literal},"))\n";
				print OUT "      throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
			}
			print OUT "    return value;\n";
			print OUT "  }\n";
			print OUT "\n";
			print OUT "  public static void write (org.omg.CORBA.portable.OutputStream os, ",$type->{java_Name}," value)\n";
			print OUT "  {\n";
			if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
				print OUT "    if (value.length () > (",$type->{max}->{java_literal},"))\n";
				print OUT "      throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
			}
			print OUT "    ",$type->{java_write},"value);\n";
			print OUT "  }\n";
			print OUT "\n";
			print OUT "}\n";
			close OUT;
		}
	}
}

#
#	3.11.2	Constructed Types
#
#	3.11.2.1	Structures
#

sub visitStructType {
	my $self = shift;
	my($node) = @_;
	return unless ($self->{srcname} eq $node->{filename});
	return if (exists $self->{done_hash}->{$node->{java_Name}});
	$self->{done_hash}->{$node->{java_Name}} = 1;
	$self->mkdir_stream($node);
	foreach (@{$node->{list_expr}}) {
		my $type = $self->_get_defn($_->{type});
		if (	   $type->isa('StructType')
				or $type->isa('UnionType') ) {
			$type->visit($self);
		}
	}
	my $first;

	$self->open_stream($node,'Holder.java');
	print OUT "public final class ",$node->{java_name},"Holder implements org.omg.CORBA.portable.Streamable\n";
	print OUT "{\n";
	print OUT "  public ",$node->{java_Name}," value = ",$node->{java_init},";\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder ()\n";
	print OUT "  {\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder (",$node->{java_Name}," initialValue)\n";
	print OUT "  {\n";
	print OUT "    value = initialValue;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    value = ",$node->{java_read},";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _write (org.omg.CORBA.portable.OutputStream os)\n";
	print OUT "  {\n";
	print OUT "    ",$node->{java_write},"value);\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public org.omg.CORBA.TypeCode _type ()\n";
	print OUT "  {\n";
	print OUT "    return ",$node->{java_Name},"Helper.type ();\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'Helper.java');
	print OUT "abstract public class ",$node->{java_name},"Helper\n";
	print OUT "{\n";
	print OUT "  public static void insert (org.omg.CORBA.Any a, ",$node->{java_Name}," that)\n";
	print OUT "  {\n";
	print OUT "    org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();\n";
	print OUT "    a.type (type ());\n";
	print OUT "    write (out, that);\n";
	print OUT "    a.read_value (out.create_input_stream (), type ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," extract (org.omg.CORBA.Any a)\n";
	print OUT "  {\n";
	print OUT "    return read (a.create_input_stream ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  private static org.omg.CORBA.TypeCode __typeCode = null;\n";
	print OUT "  private static boolean __active = false;\n";
	print OUT "  synchronized public static org.omg.CORBA.TypeCode type ()\n";
	print OUT "  {\n";
	print OUT "    if (__typeCode == null)\n";
	print OUT "    {\n";
	print OUT "      synchronized (org.omg.CORBA.TypeCode.class)\n";
	print OUT "      {\n";
	print OUT "        if (__typeCode == null)\n";
	print OUT "        {\n";
	print OUT "          if (__active)\n";
	print OUT "          {\n";
#	print OUT "            return org.omg.CORBA.ORB.init().create_recursive_tc ( _id );\n";
	print OUT "            return org.omg.CORBA.ORB.init().create_recursive_tc ( ",$node->{java_Name},"Helper.id () );\n";
	print OUT "          }\n";
	print OUT "          __active = true;\n";
	print OUT "          org.omg.CORBA.StructMember[] _members0 = new org.omg.CORBA.StructMember [",scalar(@{$node->{list_value}}),"];\n";
	print OUT "          org.omg.CORBA.TypeCode _tcOf_members0 = null;\n";
	my $i = 0;
	foreach (@{$node->{list_value}}) {
		my $member = $self->_get_defn($_);			# single or array
		my $type = $self->_get_defn($member->{type});
		my @array_max = ();
		while ($type->isa('SequenceType')) {
			if (exists $type->{max}) {
				push @array_max, $type->{max};
			} else {
				push @array_max, undef;
			}
			$type = $self->_get_defn($type->{type});
		}
		print OUT "          _tcOf_members0 = ",$type->{java_type_code},";\n";
		foreach (reverse @array_max) {
			if (defined $_) {
				print OUT "          _tcOf_members0 = org.omg.CORBA.ORB.init ().create_sequence_tc (",$_->{java_literal},", _tcOf_members0);\n";
			} else {
				print OUT "          _tcOf_members0 = org.omg.CORBA.ORB.init ().create_sequence_tc (0, _tcOf_members0);\n";
			}
		}
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				print OUT "          _tcOf_members0 = org.omg.CORBA.ORB.init ().create_array_tc (",$_->{java_literal},", _tcOf_members0 );\n";
			}
		}
		print OUT "          _members0[",$i,"] = new org.omg.CORBA.StructMember (\n";
		print OUT "            \"",$member->{java_name},"\",\n";
		print OUT "            _tcOf_members0,\n";
		print OUT "            null);\n";
		$i ++;
	}
	print OUT "          __typeCode = org.omg.CORBA.ORB.init ().create_struct_tc (",$node->{java_Name},"Helper.id (), \"",$node->{java_name},"\", _members0);\n";
	print OUT "          __active = false;\n";
	print OUT "        }\n";
	print OUT "      }\n";
	print OUT "    }\n";
	print OUT "    return __typeCode;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static java.lang.String id ()\n";
	print OUT "  {\n";
	print OUT "    return \"",$node->{repos_id},"\";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    ",$node->{java_Name}," value = new ",$node->{java_Name}," ();\n";
	$i = 0;
	foreach (@{$node->{list_value}}) {
		my $member = $self->_get_defn($_);			# single or array
		my $type = $self->_get_defn($member->{type});
		my $name = $member->{java_name};
		my @tab = ("  ");
		my $idx = '';
		my @array1 = ();
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				push @array1, "[]";
			}
		}
		my @array_max = ();
		while ($type->isa('SequenceType')) {
			if (exists $type->{max}) {
				push @array_max, $type->{max};
			} else {
				push @array_max, undef;
			}
			push @array1, "[]";
			$type = $self->_get_defn($type->{type});
		}
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				push @tab, "  ";
				pop @array1;
				print OUT @tab,"value.",$name,$idx," = new ",$type->{java_Name},"[",$_->{java_literal},"]",@array1,";\n";
				print OUT @tab,"for (int _o",$i," = 0;_o",$i," < (",$_->{java_literal},"); ++_o",$i,")\n";
				print OUT @tab,"{\n";
				$idx .= "[_o" . $i . "]";
				$i ++;
			}
		}
		foreach (@array_max) {
			push @tab, "  ";
			pop @array1;
			print OUT @tab,"int _len",$i," = is.read_long ();\n";
			if (defined $_) {
				print OUT @tab,"if (_len",$i," > (",$_->{java_literal},"))\n";
				print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
			}
			print OUT @tab,"value.",$name,$idx," = new ",$type->{java_Name},"[_len",$i,"]",@array1,";\n";
			print OUT @tab,"for (int _o",$i," = 0;_o",$i," < value.",$name,$idx,".length; ++_o",$i,")\n";
			print OUT @tab,"{\n";
			$idx .= "[_o" . $i . "]";
			$i ++;
		}
		print OUT @tab,"  value.",$name,$idx," = ",$type->{java_read},";\n";
		if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
			print OUT @tab,"  if (value.",$name,$idx,".length () > (",$type->{max}->{java_literal},"))\n";
			print OUT @tab,"    throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
		}
		foreach (@array_max) {
			print OUT @tab,"}\n";
			pop @tab;
		}
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				print OUT @tab,"}\n";
				pop @tab;
			}
		}
	}
	print OUT "    return value;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static void write (org.omg.CORBA.portable.OutputStream os, ",$node->{java_Name}," value)\n";
	print OUT "  {\n";
	$i = 0;
	foreach (@{$node->{list_value}}) {
		my $member = $self->_get_defn($_);			# single or array
		my $type = $self->_get_defn($member->{type});
		my $name = $member->{java_name};
		my @tab = ("  ");
		my $idx = '';
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				push @tab, "  ";
				print OUT @tab,"if (value.",$name,$idx,".length != (",$_->{java_literal},"))\n";
				print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
				print OUT @tab,"for (int _i",$i," = 0;_i",$i," < (",$_->{java_literal},"); ++_i",$i,")\n";
				print OUT @tab,"{\n";
				$idx .= "[_i" . $i . "]";
				$i ++;
			}
		}
		my @array_max = ();
		while ($type->isa('SequenceType')) {
			if (exists $type->{max}) {
				push @array_max, $type->{max};
			} else {
				push @array_max, undef;
			}
			$type = $self->_get_defn($type->{type});
		}
		foreach (@array_max) {
			push @tab, "  ";
			if (defined $_) {
				print OUT @tab,"if (value.",$name,$idx,".length > (",$_->{java_literal},"))\n";
				print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
			}
			print OUT @tab,"os.write_long (value.",$name,$idx,".length);\n";
			print OUT @tab,"for (int _i",$i," = 0;_i",$i," < value.",$name,$idx,".length; ++_i",$i,")\n";
			print OUT @tab,"{\n";
			$idx .= "[_i" . $i . "]";
			$i ++;
		}
		if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
			print OUT @tab,"  if (value.",$name,$idx,".length () > (",$type->{max}->{java_literal},"))\n";
			print OUT @tab,"    throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
		}
		print OUT @tab,"  ",$type->{java_write},"value.",$name,$idx,");\n";
		foreach (@array_max) {
			print OUT @tab,"}\n";
			pop @tab;
		}
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				print OUT @tab,"}\n";
				pop @tab;
			}
		}
	}
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'.java');
	print OUT "public final class ",$node->{java_name}," implements org.omg.CORBA.portable.IDLEntity\n";
	print OUT "{\n";
	foreach (@{$node->{list_value}}) {
		my $member = $self->_get_defn($_);			# single or array
		print OUT "  public ",$member->{java_init},";\n";
	}
	print OUT "\n";
	print OUT "  public ",$node->{java_name}," ()\n";
	print OUT "  {\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name}," (";
	$first = 1;
	foreach (@{$node->{list_value}}) {
		my $member = $self->_get_defn($_);			# single or array
		print OUT ", " unless ($first);
		print OUT $member->{java_type}," _",$member->{java_name};
		$first = 0;
	}
	print OUT ")\n";
	print OUT "  {\n";
	foreach (@{$node->{list_value}}) {
		my $member = $self->_get_defn($_);			# single or array
		print OUT "    this.",$member->{java_name}," = _",$member->{java_name},";\n";
	}
	print OUT "  }\n";
	print OUT "\n";
	unless ($self->{nb_deprecated}) {
		print OUT "  public java.lang.String toString()\n";
		print OUT "  {\n";
		print OUT "    final java.lang.StringBuffer _ret = new java.lang.StringBuffer(\"struct ",$node->{java_name}," {\");\n";
		$first = 1;
		foreach (@{$node->{list_value}}) {
			my $member = $self->_get_defn($_);			# single or array
			my $type = $self->_get_defn($member->{type});
			if ($first) {
				print OUT "    _ret.append(\"\\n\");\n";
				$first = 0;
			} else {
				print OUT "    _ret.append(\",\\n\");\n";
			}
			print OUT "    _ret.append(\"",$type->{java_Name}," ",$member->{java_name},"=\");\n";
#			print OUT "    _ret.append(",$_->{to_string},");\n";
			print OUT "    _ret.append(",$member->{java_name},");\n";
		}
		print OUT "    _ret.append(\"\\n\");\n";
		print OUT "    _ret.append(\"}\");\n";
		print OUT "    return _ret.toString();\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public boolean equals (java.lang.Object o)\n";
		print OUT "  {\n";
		print OUT "    if (this == o) return true;\n";
		print OUT "    if (o == null) return false;\n";
		print OUT "\n";
		print OUT "    if (o instanceof ",$node->{java_name},")\n";
		print OUT "    {\n";
		print OUT "      final ",$node->{java_name}," obj = (",$node->{java_name},")o;\n";
		print OUT "      boolean res = true;\n";
		print OUT "      do\n";
		print OUT "      {\n";
#        res = this.f1 == obj.f1;
#        if (!res) break;
#        res = this.f2 == obj.f2 ||
#         (this.f2 != null && obj.f2 != null && this.f2.equals(obj.f2));
		print OUT "      } while (false);\n";
		print OUT "      return res;\n";
		print OUT "    }\n";
		print OUT "    else\n";
		print OUT "    {\n";
		print OUT "      return false;\n";
		print OUT "    }\n";
		print OUT "  }\n";
		print OUT "\n";
	}
	print OUT "} // class ",$node->{java_name},"\n";
	close OUT;
}

#	3.11.2.2	Discriminated Unions
#

sub visitUnionType {
	my $self = shift;
	my($node) = @_;
	return unless ($self->{srcname} eq $node->{filename});
	return if (exists $self->{done_hash}->{$node->{java_Name}});
	$self->{done_hash}->{$node->{java_Name}} = 1;
	$self->mkdir_stream($node);
	foreach (@{$node->{list_expr}}) {
		my $type = $self->_get_defn($_->{element}->{type});
		if (	   $type->isa('StructType')
				or $type->isa('UnionType')
				or $type->isa('EnumType') ) {
			$type->visit($self);
		}
	}
	my $dis = $self->_get_defn($node->{type});
	my $first;

	$self->open_stream($node,'Holder.java');
	print OUT "public final class ",$node->{java_name},"Holder implements org.omg.CORBA.portable.Streamable\n";
	print OUT "{\n";
	print OUT "  public ",$node->{java_Name}," value = ",$node->{java_init},";\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder ()\n";
	print OUT "  {\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder (",$node->{java_Name}," initialValue)\n";
	print OUT "  {\n";
	print OUT "    value = initialValue;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    value = ",$node->{java_read},";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _write (org.omg.CORBA.portable.OutputStream os)\n";
	print OUT "  {\n";
	print OUT "    ",$node->{java_write},"value);\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public org.omg.CORBA.TypeCode _type ()\n";
	print OUT "  {\n";
	print OUT "    return ",$node->{java_Name},"Helper.type ();\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'Helper.java');
	print OUT "abstract public class ",$node->{java_name},"Helper\n";
	print OUT "{\n";
	print OUT "  public static void insert (org.omg.CORBA.Any a, ",$node->{java_Name}," that)\n";
	print OUT "  {\n";
	print OUT "    org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();\n";
	print OUT "    a.type (type ());\n";
	print OUT "    write (out, that);\n";
	print OUT "    a.read_value (out.create_input_stream (), type ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," extract (org.omg.CORBA.Any a)\n";
	print OUT "  {\n";
	print OUT "    return read (a.create_input_stream ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  private static org.omg.CORBA.TypeCode __typeCode = null;\n";
	print OUT "  synchronized public static org.omg.CORBA.TypeCode type ()\n";
	print OUT "  {\n";
	print OUT "    if (__typeCode == null)\n";
	print OUT "    {\n";
	print OUT "      org.omg.CORBA.TypeCode _disTypeCode0;\n";
	print OUT "      _disTypeCode0 = ",$dis->{java_Name},"Helper.type ();\n";
	print OUT "      org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember [",scalar(keys %{$node->{hash_value}}),"];\n";
	print OUT "      org.omg.CORBA.TypeCode _tcOf_members0;\n";
	print OUT "      org.omg.CORBA.Any _anyOf_members0;\n";
	my $i = 0;
	foreach my $case (@{$node->{list_expr}}) {
		my $elt = $case->{element};
		my $value = $self->_get_defn($elt->{value});
		my $type = $self->_get_defn($elt->{type});
		my @array_max = ();
		while ($type->isa('SequenceType')) {
			if (exists $type->{max}) {
				push @array_max, $type->{max};
			} else {
				push @array_max, undef;
			}
			$type = $self->_get_defn($type->{type});
		}
		foreach (@{$case->{list_label}}) {	# default or expression
			print OUT "\n";
			if ($_->isa('Default')) {
				print OUT "      // Branch for ",$value->{java_name}," (Default case)\n";
				print OUT "      _anyOf_members0 = org.omg.CORBA.ORB.init ().create_any ();\n";
				print OUT "      _anyOf_members0.insert_octet ((byte)0); // default member label\n";
			} else {
				print OUT "      // Branch for ",$value->{java_name}," (case label ",$_->{java_literal},")\n";
				print OUT "      _anyOf_members0 = org.omg.CORBA.ORB.init ().create_any ();\n";
				print OUT "      ",$dis->{java_Name},"Helper.insert (_anyOf_members0, ",$_->{java_literal},");\n";
			}
			print OUT "      _tcOf_members0 = ",$type->{java_type_code},";\n";
			foreach (reverse @array_max) {
				if (defined $_) {
					print OUT "      _tcOf_members0 = org.omg.CORBA.ORB.init ().create_sequence_tc (",$_->{java_literal},", _tcOf_members0);\n";
				} else {
					print OUT "      _tcOf_members0 = org.omg.CORBA.ORB.init ().create_sequence_tc (0, _tcOf_members0);\n";
				}
			}
			if (exists $value->{array_size}) {
				foreach (@{$value->{array_size}}) {
					print OUT "      _tcOf_members0 = org.omg.CORBA.ORB.init ().create_array_tc (",$_->{java_literal},", _tcOf_members0 );\n";
				}
			}
			print OUT "      _members0[",$i,"] = new org.omg.CORBA.UnionMember (\n";
			print OUT "        \"",$value->{java_name},"\",\n";
			print OUT "        _anyOf_members0,\n";
			print OUT "        _tcOf_members0,\n";
			print OUT "        null);\n";
			$i ++;
		}
	}
	print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_union_tc (",$node->{java_Name},"Helper.id (), \"",$node->{java_name},"\", _disTypeCode0, _members0);\n";
	print OUT "    }\n";
	print OUT "    return __typeCode;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static String id ()\n";
	print OUT "  {\n";
	print OUT "    return \"",$node->{repos_id},"\";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    ",$node->{java_Name}," value = new ",$node->{java_Name}," ();\n";
	print OUT "    ",$dis->{java_Name}," _dis0 = ",$dis->{java_init},";\n";
	print OUT "    _dis0 = ",$dis->{java_read},";\n";
	print OUT "    switch (_dis0.value ())\n";
	print OUT "    {\n";
	$i = 0;
	foreach my $case (@{$node->{list_expr}}) {
		my $elt = $case->{element};
		my $value = $self->_get_defn($elt->{value});
		my $type = $self->_get_defn($elt->{type});
		foreach (@{$case->{list_label}}) {	# default or expression
			if ($_->isa('Default')) {
				print OUT "      default:\n";
			} else {
				print OUT "      case ",$_->{java_literal},":\n";
			}
		}
		print OUT "        ",$value->{java__init},";\n";
		my $name = $value->{java_name};
		my @tab = ("      ");
		my $idx = '';
		my @array1 = ();
		if (exists $value->{array_size}) {
			foreach (@{$value->{array_size}}) {
				push @array1, "[]";
			}
		}
		my @array_max = ();
		while ($type->isa('SequenceType')) {
			if (exists $type->{max}) {
				push @array_max, $type->{max};
			} else {
				push @array_max, undef;
			}
			push @array1, "[]";
			$type = $self->_get_defn($type->{type});
		}
		if (exists $value->{array_size}) {
			foreach (@{$value->{array_size}}) {
				push @tab, "  ";
				pop @array1;
				print OUT @tab,"_",$name,$idx," = new ",$type->{java_Name},"[",$_->{java_literal},"]",@array1,";\n";
				print OUT @tab,"for (int _o",$i," = 0;_o",$i," < (",$_->{java_literal},"); ++_o",$i,")\n";
				print OUT @tab,"{\n";
				$idx .= "[_o" . $i . "]";
				$i ++;
			}
		}
		foreach (@array_max) {
			push @tab, "  ";
			pop @array1;
			print OUT @tab,"int _len",$i," = is.read_long ();\n";
			if (defined $_) {
				print OUT @tab,"if (_len",$i," > (",$_->{java_literal},"))\n";
				print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
			}
			print OUT @tab,"_",$name,$idx," = new ",$type->{java_Name},"[_len",$i,"]",@array1,";\n";
			print OUT @tab,"for (int _o",$i," = 0;_o",$i," < _",$name,$idx,".length; ++_o",$i,")\n";
			print OUT @tab,"{\n";
			$idx .= "[_o" . $i . "]";
			$i ++;
		}
		print OUT @tab,"  _",$name,$idx," = ",$type->{java_read},";\n";
		if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
			print OUT @tab,"  if (_",$name,$idx,".length () > (",$type->{max}->{java_literal},"))\n";
			print OUT @tab,"    throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
		}
		foreach (@array_max) {
			print OUT @tab,"}\n";
			pop @tab;
		}
		if (exists $value->{array_size}) {
			foreach (@{$value->{array_size}}) {
				print OUT @tab,"}\n";
				pop @tab;
			}
		}
		if (scalar(@{$case->{list_label}}) > 1) {
			print OUT "        value.",$value->{java_name}," (_dis0.value (), _",$value->{java_name},");\n";
		} else {
			print OUT "        value.",$value->{java_name}," (_",$value->{java_name},");\n";
		}
		print OUT "        break;\n";
	}
	if (exists $node->{need_default}) {
		print OUT "      default:\n";
		print OUT "        throw new org.omg.CORBA.BAD_OPERATION ();\n";
	}
	print OUT "    }\n";
	print OUT "    return value;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static void write (org.omg.CORBA.portable.OutputStream os, ",$node->{java_Name}," value)\n";
	print OUT "  {\n";
	print OUT "    ",$dis->{java_write},"value.discriminator ());\n";
	print OUT "    switch (value.discriminator ().value ())\n";
	print OUT "    {\n";
	$i = 0;
	foreach my $case (@{$node->{list_expr}}) {
		my $elt = $case->{element};
		my $value = $self->_get_defn($elt->{value});
		my $type = $self->_get_defn($elt->{type});
		my @array_max = ();
		while ($type->isa('SequenceType')) {
			if (exists $type->{max}) {
				push @array_max, $type->{max};
			} else {
				push @array_max, undef;
			}
			$type = $self->_get_defn($type->{type});
		}
		foreach (@{$case->{list_label}}) {	# default or expression
			if ($_->isa('Default')) {
				print OUT "      default:\n";
			} else {
				print OUT "      case ",$_->{java_literal},":\n";
			}
		}
		my $name = $value->{java_name};
		my @tab = ("      ");
		my $idx = '';
		if (exists $value->{array_size}) {
			foreach (@{$value->{array_size}}) {
				push @tab, "  ";
				print OUT @tab,"if (value.",$name," ()",$idx,".length != (",$_->{java_literal},"))\n";
				print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
				print OUT @tab,"for (int _i",$i," = 0;_i",$i," < (",$_->{java_literal},"); ++_i",$i,")\n";
				print OUT @tab,"{\n";
				$idx .= "[_i" . $i . "]";
				$i ++;
			}
		}
		foreach (@array_max) {
			push @tab, "  ";
			if (defined $_) {
				print OUT @tab,"if (value.",$name," ()",$idx,".length > (",$_->{java_literal},"))\n";
				print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
			}
			print OUT @tab,"os.write_long (value.",$name," ()",$idx,".length);\n";
			print OUT @tab,"for (int _i",$i," = 0;_i",$i," < value.",$name," ()",$idx,".length; ++_i",$i,")\n";
			print OUT @tab,"{\n";
			$idx .= "[_i" . $i . "]";
			$i ++;
		}
		if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
			print OUT @tab,"  if (value.",$name,$idx," ().length () > (",$type->{max}->{java_literal},"))\n";
			print OUT @tab,"    throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
		}
		print OUT @tab,"  ",$type->{java_write},"value.",$name," ()",$idx,");\n";
		foreach (@array_max) {
			print OUT @tab,"}\n";
			pop @tab;
		}
		if (exists $value->{array_size}) {
			foreach (@{$value->{array_size}}) {
				print OUT @tab,"}\n";
				pop @tab;
			}
		}
		print OUT "        break;\n";
	}
	if (exists $node->{need_default}) {
		print OUT "      default:\n";
		print OUT "        throw new org.omg.CORBA.BAD_OPERATION ();\n";
	}
	print OUT "    }\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'.java');
	print OUT "public final class ",$node->{java_name}," implements org.omg.CORBA.portable.IDLEntity\n";
	print OUT "{\n";
	foreach my $case (@{$node->{list_expr}}) {
		my $elt = $case->{element};
		my $value = $self->_get_defn($elt->{value});
		print OUT "  private ",$value->{java_type}," ___",$value->{java_name},";\n";
	}
	print OUT "  private ",$dis->{java_Name}," __discriminator;\n";
	print OUT "  private boolean __uninitialized = true;\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name}," ()\n";
	print OUT "  {\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public ",$dis->{java_Name}," discriminator ()\n";
	print OUT "  {\n";
	print OUT "    if (__uninitialized)\n";
	print OUT "      throw new org.omg.CORBA.BAD_OPERATION ();\n";
	print OUT "    return __discriminator;\n";
	print OUT "  }\n";
	print OUT "\n";
	foreach my $case (@{$node->{list_expr}}) {
		my $elt = $case->{element};
		my $value = $self->_get_defn($elt->{value});
		my $type = $self->_get_defn($elt->{type});
		my $label;
		print OUT "  public ",$value->{java_type}," ",$value->{java_name}," ()\n";
		print OUT "  {\n";
		print OUT "    if (__uninitialized)\n";
		print OUT "      throw new org.omg.CORBA.BAD_OPERATION ();\n";
		print OUT "    verify",$value->{java_name}," (__discriminator);\n";
		print OUT "    return ___",$value->{java_name},";\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public void ",$value->{java_name}," (",$value->{java_type}," value)\n";
		print OUT "  {\n";
		if (defined $node->{default} and $case eq $node->{default}) {
			print OUT "    __discriminator = ",$dis->{java_init},";\n";
		} else {
			$label = ${$case->{list_label}}[0];
			print OUT "    __discriminator = ",$label->{java_literal},";\n";
		}
		print OUT "    ___",$value->{java_name}," = value;\n";
		print OUT "    __uninitialized = false;\n";
		print OUT "  }\n";
		print OUT "\n";
		if (scalar(@{$case->{list_label}}) > 1) {
			print OUT "  public void ",$value->{java_name}," (",$dis->{java_Name}," discriminator, ",$value->{java_type}," value)\n";
			print OUT "  {\n";
			print OUT "    verify",$value->{java_name}," (discriminator);\n";
			print OUT "    __discriminator = discriminator;\n";
			print OUT "    ___",$value->{java_name}," = value;\n";
			print OUT "    __uninitialized = false;\n";
			print OUT "  }\n";
			print OUT "\n";
		}
		print OUT "  private void verify",$value->{java_name}," (",$dis->{java_Name}," discriminator)\n";
		print OUT "  {\n";
		print OUT "    if (";
		if (defined $node->{default} and $case eq $node->{default}) {
			$first = 1;
			foreach (@{$node->{list_value}}) {
					print OUT " || " unless($first);
					print OUT "discriminator == ",$_->{java_literal};
				$first = 0;
			}
		} else {
			$first = 1;
			foreach (@{$case->{list_label}}) {
					print OUT " && " unless($first);
					print OUT "discriminator != ",$_->{java_literal};
				$first = 0;
			}
		}
		print OUT ")\n";
		print OUT "      throw new org.omg.CORBA.BAD_OPERATION ();\n";
		print OUT "  }\n";
		print OUT "\n";
	}
	unless ($self->{nb_deprecated}) {
		print OUT "  public java.lang.String toString()\n";
		print OUT "  {\n";
		print OUT "    final java.lang.StringBuffer _ret = new java.lang.StringBuffer(\"union ",$node->{java_name}," {\");\n";
		print OUT "    _ret.append(\"\\n\");\n";
		print OUT "    switch (value.discriminator ().value ())\n";
		print OUT "    {\n";
		foreach my $case (@{$node->{list_expr}}) {
			my $elt = $case->{element};
			my $value = $self->_get_defn($elt->{value});
			my $type = $self->_get_defn($elt->{type});
			foreach (@{$case->{list_label}}) {	# default or expression
				if ($_->isa('Default')) {
					print OUT "      default:\n";
				} else {
					print OUT "      case ",$_->{java_literal},":\n";
				}
			}
			print OUT "      {\n";
#			print OUT "        _ret.append(\"",$type->{java_Name}," ",$value->{java_name},"=\");\n";
			print OUT "        _ret.append(",$value->{java_name},"());\n";
			print OUT "        break;\n";
			print OUT "      }\n";
		}
		print OUT "    }\n";
		print OUT "    _ret.append(\"\\n\");\n";
		print OUT "    _ret.append(\"}\");\n";
		print OUT "    return _ret.toString();\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public boolean equals (java.lang.Object o)\n";
		print OUT "  {\n";
		print OUT "    if (this == o) return true;\n";
		print OUT "    if (o == null) return false;\n";
		print OUT "\n";
		print OUT "    if (o instanceof ",$node->{java_name},")\n";
		print OUT "    {\n";
		print OUT "      final ",$node->{java_name}," obj = (",$node->{java_name},")o;\n";
		print OUT "      boolean res = true;\n";
		print OUT "      res = this.__discriminator == obj.__discriminator ||\n";
		print OUT "       (this.__discriminator != null && obj.__discriminator != null && this.__discriminator.equals(obj.__discriminator));\n";
		print OUT "      if (res)\n";
		print OUT "      {\n";
#		print OUT "        res = this._object == obj._object ||\n";
#		print OUT "         (this._object != null && obj._object != null && this._object.equals(obj._object));\n";
		print OUT "      }\n";
		print OUT "      return res;\n";
		print OUT "    }\n";
		print OUT "    else\n";
		print OUT "      return false;\n";
		print OUT "  }\n";
	}
	print OUT "} // class ",$node->{java_name},"\n";
	close OUT;
}

#	3.11.2.3	Constructed Recursive Types and Forward Declarations
#

sub visitForwardStructType {
	# empty
}

sub visitForwardUnionType {
	# empty
}

#	3.11.2.4	Enumerations
#

sub visitEnumType {
	my $self = shift;
	my($node) = @_;
	return unless ($self->{srcname} eq $node->{filename});
	$self->mkdir_stream($node);

	$self->open_stream($node,'Holder.java');
	print OUT "public final class ",$node->{java_name},"Holder implements org.omg.CORBA.portable.Streamable\n";
	print OUT "{\n";
	print OUT "  public ",$node->{java_Name}," value = ",$node->{java_init},";\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder ()\n";
	print OUT "  {\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder (",$node->{java_Name}," initialValue)\n";
	print OUT "  {\n";
	print OUT "    value = initialValue;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    value = ",$node->{java_read},";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _write (org.omg.CORBA.portable.OutputStream os)\n";
	print OUT "  {\n";
	print OUT "    ",$node->{java_write},"value);\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public org.omg.CORBA.TypeCode _type ()\n";
	print OUT "  {\n";
	print OUT "    return ",$node->{java_Name},"Helper.type ();\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'Helper.java');
	print OUT "abstract public class ",$node->{java_name},"Helper\n";
	print OUT "{\n";
	print OUT "  public static void insert (org.omg.CORBA.Any a, ",$node->{java_Name}," that)\n";
	print OUT "  {\n";
	print OUT "    org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();\n";
	print OUT "    a.type (type ());\n";
	print OUT "    write (out, that);\n";
	print OUT "    a.read_value (out.create_input_stream (), type ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," extract (org.omg.CORBA.Any a)\n";
	print OUT "  {\n";
	print OUT "    return read (a.create_input_stream ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  private static org.omg.CORBA.TypeCode __typeCode = null;\n";
	print OUT "  synchronized public static org.omg.CORBA.TypeCode type ()\n";
	print OUT "  {\n";
	print OUT "    if (__typeCode == null)\n";
	print OUT "    {\n";
	print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_enum_tc (",$node->{java_Name},"Helper.id (), \"",$node->{java_name},"\", new String[] { ";
		my $first = 1;
		foreach (@{$node->{list_expr}}) {
			print OUT ", " unless ($first);
			print OUT "\"",$_->{java_name},"\"";
			$first = 0;
		}
		print OUT "} );\n";
	print OUT "    }\n";
	print OUT "    return __typeCode;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static String id ()\n";
	print OUT "  {\n";
	print OUT "    return \"",$node->{repos_id},"\";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    return ",$node->{java_Name},".from_int (is.read_long ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static void write (org.omg.CORBA.portable.OutputStream os, ",$node->{java_Name}," value)\n";
	print OUT "  {\n";
	print OUT "    os.write_long (value.value ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'.java');
	print OUT "public class ",$node->{java_name}," implements org.omg.CORBA.portable.IDLEntity\n";
	print OUT "{\n";
	print OUT "  private        int __value;\n";
	print OUT "  private static int __size = ",scalar(@{$node->{list_expr}}),";\n";
	print OUT "  private static ",$node->{java_Name},"[] __array = new ",$node->{java_Name}," [__size];\n";
	print OUT "\n";
	foreach (@{$node->{list_expr}}) {
		print OUT "  public static final int _",$_->{java_name}," = ",$_->{value},";\n";
		print OUT "  public static final ",$node->{java_Name}," ",$_->{java_name}," = new ",$node->{java_Name},"(_",$_->{java_name},");\n";
	}
	print OUT "\n";
	print OUT "  public int value ()\n";
	print OUT "  {\n";
	print OUT "    return __value;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," from_int (int value)\n";
	print OUT "  {\n";
	print OUT "    if (value >= 0 && value < __size)\n";
	print OUT "      return __array[value];\n";
	print OUT "    else\n";
	print OUT "      throw new org.omg.CORBA.BAD_PARAM ();\n";
	print OUT "  }\n";
	print OUT "\n";
	unless ($self->{nb_deprecated}) {
		print OUT "  protected ",$node->{java_name}," (int value)\n";
		print OUT "  {\n";
		print OUT "    __value = value;\n";
		print OUT "    __array[__value] = this;\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public java.lang.String toString()\n";
		print OUT "  {\n";
		print OUT "    switch (this.__value)\n";
		print OUT "    {\n";
		foreach (@{$node->{list_expr}}) {
			print OUT "      case ",$_->{value},": return \"",$_->{java_name},"\";\n";
		}
		print OUT "      default: throw new org.omg.CORBA.BAD_PARAM();\n";
		print OUT "    }\n";
		print OUT "  }\n";
		print OUT "\n";
		print OUT "  public boolean equals (java.lang.Object o)\n";
		print OUT "  {\n";
		print OUT "    if (this == o) return true;\n";
		print OUT "    if (o == null) return false;\n";
		print OUT "\n";
		print OUT "    return o instanceof ",$node->{java_name},"\n";
		print OUT "      ? this.__value == ((",$node->{java_name},")o).__value\n";
		print OUT "      : false;\n";
		print OUT "  }\n";
		print OUT "\n";
	}
	print OUT "} // class ",$node->{java_name},"\n";
	close OUT;
}

#
#	3.11.3	Template Types
#

sub visitSequenceType {
	my $self = shift;
	my($node) = @_;
	return unless ($self->{srcname} eq $node->{filename});
	return if (exists $self->{done_hash}->{$node->{java_Name}});
	$self->{done_hash}->{$node->{java_Name}} = 1;
	$self->mkdir_stream($node);
	my $type = $self->_get_defn($node->{type});
	my @array = ("[]");
	my @array_max = ();
	if (exists $node->{max}) {
		push @array_max, $node->{max};
	} else {
		push @array_max, undef;
	}
	while ($type->isa('SequenceType')) {
		if (exists $type->{max}) {
			push @array_max, $type->{max};
		} else {
			push @array_max, undef;
		}
		$type = $self->_get_defn($type->{type});
		push @array, "[]";
	}

	$self->open_stream($node,'Holder.java');
	print OUT "public final class ",$node->{java_name},"Holder implements org.omg.CORBA.portable.Streamable\n";
	print OUT "{\n";
	print OUT "  public ",$type->{java_Name}," value",@array," = null;\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder ()\n";
	print OUT "  {\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder (",$type->{java_Name},@array," initialValue)\n";
	print OUT "  {\n";
	print OUT "    value = initialValue;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    value = ",$node->{java_Name},"Helper.read (is);\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _write (org.omg.CORBA.portable.OutputStream os)\n";
	print OUT "  {\n";
	print OUT "    ",$node->{java_Name},"Helper.write (os, value);\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public org.omg.CORBA.TypeCode _type ()\n";
	print OUT "  {\n";
	print OUT "    return ",$node->{java_Name},"Helper.type ();\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'Helper.java');
	print OUT "abstract public class ",$node->{java_name},"Helper\n";
	print OUT "{\n";
	print OUT "  public static void insert (org.omg.CORBA.Any a, ",$type->{java_Name},@array," that)\n";
	print OUT "  {\n";
	print OUT "    org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();\n";
	print OUT "    a.type (type ());\n";
	print OUT "    write (out, that);\n";
	print OUT "    a.read_value (out.create_input_stream (), type ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$type->{java_Name},@array," extract (org.omg.CORBA.Any a)\n";
	print OUT "  {\n";
	print OUT "    return read (a.create_input_stream ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  private static org.omg.CORBA.TypeCode __typeCode = null;\n";
	print OUT "  synchronized public static org.omg.CORBA.TypeCode type ()\n";
	print OUT "  {\n";
	print OUT "    if (__typeCode == null)\n";
	print OUT "    {\n";
	print OUT "      __typeCode = ",$type->{java_type_code},";\n";
	foreach (reverse @array_max) {
		if (defined $_) {
			print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_sequence_tc (",$_->{java_literal},", __typeCode);\n";
		} else {
			print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_sequence_tc (0, __typeCode);\n";
		}
	}
	print OUT "      __typeCode = org.omg.CORBA.ORB.init ().create_alias_tc (",$node->{java_Name},"Helper.id (), \"",$node->{java_name},"\", __typeCode);\n";
	print OUT "    }\n";
	print OUT "    return __typeCode;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static java.lang.String id ()\n";
	print OUT "  {\n";
	print OUT "    return \"",$node->{repos_id},"\";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$type->{java_Name},@array," read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    ",$type->{java_Name}," value",@array," = null;\n";
	my @tab = ("  ");
	my $i = 0;
	my $idx = '';
	my @array1 = @array;
	foreach (@array_max) {
		push @tab, "  ";
		pop @array1;
		print OUT @tab,"int _len",$i," = is.read_long ();\n";
		if (defined $_) {
			print OUT @tab,"if (_len",$i," > (",$_->{java_literal},"))\n";
			print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
		}
		print OUT @tab,"value",$idx," = new ",$type->{java_Name},"[_len",$i,"]",@array1,";\n";
		print OUT @tab,"for (int _o",$i," = 0;_o",$i," < value.length; ++_o",$i,")\n";
		print OUT @tab,"{\n";
		$idx .= "[_o" . $i . "]";
		$i ++;
	}
	print OUT @tab,"  value",$idx," = ",$type->{java_read},";\n";
	if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
		print OUT @tab,"  if (value",$idx,".length () > (",$type->{max}->{java_literal},"))\n";
		print OUT @tab,"    throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
	}
	foreach (@array_max) {
		print OUT @tab,"}\n";
		pop @tab;
	}
	print OUT "    return value;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static void write (org.omg.CORBA.portable.OutputStream os, ",$type->{java_Name},@array," value)\n";
	print OUT "  {\n";
	@tab = ("  ");
	$i = 0;
	$idx = '';
	foreach (@array_max) {
		push @tab, "  ";
		if (defined $_) {
			print OUT @tab,"if (value",$idx,".length > (",$_->{java_literal},"))\n";
			print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
		}
		print OUT @tab,"os.write_long (value",$idx,".length);\n";
		print OUT @tab,"for (int _i",$i," = 0;_i",$i," < value",$idx,".length; ++_i",$i,")\n";
		print OUT @tab,"{\n";
		$idx .= "[_i" . $i . "]";
		$i ++;
	}
	if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
		print OUT @tab,"  if (value",$idx,".length () > (",$type->{max}->{java_literal},"))\n";
		print OUT @tab,"    throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
	}
	print OUT @tab,"  ",$type->{java_write},"value",$idx,");\n";
	foreach (@array_max) {
		print OUT @tab,"}\n";
		pop @tab;
	}
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;
}

sub visitFixedPtType {
	my $self = shift;
	my($node) = @_;
	warn __PACKAGE__,"::visitFixedPtType : TODO.\n";
}

sub visitFixedPtConstType {
	my $self = shift;
	my($node) = @_;
	warn __PACKAGE__,"::visitFixedPtConstType : TODO.\n";
}

#
#	3.12	Exception Declaration
#

sub visitException {
	my $self = shift;
	my($node) = @_;
	return unless ($self->{srcname} eq $node->{filename});
	return if (exists $self->{done_hash}->{$node->{java_Name}});
	$self->{done_hash}->{$node->{java_Name}} = 1;
	$self->mkdir_stream($node);
	foreach (@{$node->{list_expr}}) {
		my $type = $self->_get_defn($_->{type});
		if (	   $type->isa('StructType')
				or $type->isa('UnionType') ) {
			$type->visit($self);
		}
	}
	my $first;

	$self->open_stream($node,'Holder.java');
	print OUT "public final class ",$node->{java_name},"Holder implements org.omg.CORBA.portable.Streamable\n";
	print OUT "{\n";
	print OUT "  public ",$node->{java_Name}," value = ",$node->{java_init},";\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder ()\n";
	print OUT "  {\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public ",$node->{java_name},"Holder (",$node->{java_Name}," initialValue)\n";
	print OUT "  {\n";
	print OUT "    value = initialValue;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    value = ",$node->{java_read},";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public void _write (org.omg.CORBA.portable.OutputStream os)\n";
	print OUT "  {\n";
	print OUT "    ",$node->{java_write},"value);\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public org.omg.CORBA.TypeCode _type ()\n";
	print OUT "  {\n";
	print OUT "    return ",$node->{java_Name},"Helper.type ();\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'Helper.java');
	print OUT "abstract public class ",$node->{java_name},"Helper\n";
	print OUT "{\n";
	print OUT "  public static void insert (org.omg.CORBA.Any a, ",$node->{java_Name}," that)\n";
	print OUT "  {\n";
	print OUT "    org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();\n";
	print OUT "    a.type (type ());\n";
	print OUT "    write (out, that);\n";
	print OUT "    a.read_value (out.create_input_stream (), type ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," extract (org.omg.CORBA.Any a)\n";
	print OUT "  {\n";
	print OUT "    return read (a.create_input_stream ());\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  private static org.omg.CORBA.TypeCode __typeCode = null;\n";
	print OUT "  private static boolean __active = false;\n";
	print OUT "  synchronized public static org.omg.CORBA.TypeCode type ()\n";
	print OUT "  {\n";
	print OUT "    if (__typeCode == null)\n";
	print OUT "    {\n";
	print OUT "      synchronized (org.omg.CORBA.TypeCode.class)\n";
	print OUT "      {\n";
	print OUT "        if (__typeCode == null)\n";
	print OUT "        {\n";
	print OUT "          if (__active)\n";
	print OUT "          {\n";
#	print OUT "            return org.omg.CORBA.ORB.init().create_recursive_tc ( _id );\n";
	print OUT "            return org.omg.CORBA.ORB.init().create_recursive_tc ( ",$node->{java_Name},"Helper.id () );\n";
	print OUT "          }\n";
	print OUT "          __active = true;\n";
	print OUT "          org.omg.CORBA.StructMember[] _members0 = new org.omg.CORBA.StructMember [",scalar(@{$node->{list_value}}),"];\n";
	print OUT "          org.omg.CORBA.TypeCode _tcOf_members0 = null;\n";
	my $i = 0;
	foreach (@{$node->{list_value}}) {
		my $member = $self->_get_defn($_);			# single or array
		my $type = $self->_get_defn($member->{type});
		my @array_max = ();
		while ($type->isa('SequenceType')) {
			if (exists $type->{max}) {
				push @array_max, $type->{max};
			} else {
				push @array_max, undef;
			}
			$type = $self->_get_defn($type->{type});
		}
		print OUT "          _tcOf_members0 = ",$type->{java_type_code},";\n";
		foreach (reverse @array_max) {
			if (defined $_) {
				print OUT "          _tcOf_members0 = org.omg.CORBA.ORB.init ().create_sequence_tc (",$_->{java_literal},", _tcOf_members0);\n";
			} else {
				print OUT "          _tcOf_members0 = org.omg.CORBA.ORB.init ().create_sequence_tc (0, _tcOf_members0);\n";
			}
		}
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				print OUT "          _tcOf_members0 = org.omg.CORBA.ORB.init ().create_array_tc (",$_->{java_literal},", _tcOf_members0 );\n";
			}
		}
		print OUT "          _members0[",$i,"] = new org.omg.CORBA.StructMember (\n";
		print OUT "            \"",$member->{java_name},"\",\n";
		print OUT "            _tcOf_members0,\n";
		print OUT "            null);\n";
		$i ++;
	}
	print OUT "          __typeCode = org.omg.CORBA.ORB.init ().create_exception_tc (",$node->{java_Name},"Helper.id (), \"",$node->{java_name},"\", _members0);\n";
	print OUT "          __active = false;\n";
	print OUT "        }\n";
	print OUT "      }\n";
	print OUT "    }\n";
	print OUT "    return __typeCode;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static String id ()\n";
	print OUT "  {\n";
	print OUT "    return \"",$node->{repos_id},"\";\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static ",$node->{java_Name}," read (org.omg.CORBA.portable.InputStream is)\n";
	print OUT "  {\n";
	print OUT "    ",$node->{java_Name}," value = new ",$node->{java_Name}," ();\n";
	print OUT "    // read and discard the repository ID\n";
	print OUT "    is.read_string ();\n";
	$i = 0;
	foreach (@{$node->{list_value}}) {
		my $member = $self->_get_defn($_);			# single or array
		my $type = $self->_get_defn($member->{type});
		my $name = $member->{java_name};
		my @tab = ("  ");
		my $idx = '';
		my @array1 = ();
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				push @array1, "[]";
			}
		}
		my @array_max = ();
		while ($type->isa('SequenceType')) {
			if (exists $type->{max}) {
				push @array_max, $type->{max};
			} else {
				push @array_max, undef;
			}
			push @array1, "[]";
			$type = $self->_get_defn($type->{type});
		}
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				push @tab, "  ";
				pop @array1;
				print OUT @tab,"value.",$name,$idx," = new ",$type->{java_Name},"[",$_->{java_literal},"]",@array1,";\n";
				print OUT @tab,"for (int _o",$i," = 0;_o",$i," < (",$_->{java_literal},"); ++_o",$i,")\n";
				print OUT @tab,"{\n";
				$idx .= "[_o" . $i . "]";
				$i ++;
			}
		}
		foreach (@array_max) {
			push @tab, "  ";
			pop @array1;
			print OUT @tab,"int _len",$i," = is.read_long ();\n";
			if (defined $_) {
				print OUT @tab,"if (_len",$i," > (",$_->{java_literal},"))\n";
				print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
			}
			print OUT @tab,"value.",$name,$idx," = new ",$type->{java_Name},"[_len",$i,"]",@array1,";\n";
			print OUT @tab,"for (int _o",$i," = 0;_o",$i," < value.",$name,$idx,".length; ++_o",$i,")\n";
			print OUT @tab,"{\n";
			$idx .= "[_o" . $i . "]";
			$i ++;
		}
		print OUT @tab,"  value.",$name,$idx," = ",$type->{java_read},";\n";
		if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
			print OUT @tab,"  if (value.",$name,$idx,".length () > (",$type->{max}->{java_literal},"))\n";
			print OUT @tab,"    throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
		}
		foreach (@array_max) {
			print OUT @tab,"}\n";
			pop @tab;
		}
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				print OUT @tab,"}\n";
				pop @tab;
			}
		}
	}
	print OUT "    return value;\n";
	print OUT "  }\n";
	print OUT "\n";
	print OUT "  public static void write (org.omg.CORBA.portable.OutputStream os, ",$node->{java_Name}," value)\n";
	print OUT "  {\n";
	print OUT "    // write the repository ID\n";
	print OUT "    os.write_string (id ());\n";
	$i = 0;
	foreach (@{$node->{list_value}}) {
		my $member = $self->_get_defn($_);			# single or array
		my $type = $self->_get_defn($member->{type});
		my $name = $member->{java_name};
		my @tab = ("  ");
		my $idx = '';
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				push @tab, "  ";
				print OUT @tab,"if (value.",$name,$idx,".length != (",$_->{java_literal},"))\n";
				print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
				print OUT @tab,"for (int _i",$i," = 0;_i",$i," < (",$_->{java_literal},"); ++_i",$i,")\n";
				print OUT @tab,"{\n";
				$idx .= "[_i" . $i . "]";
				$i ++;
			}
		}
		my @array_max = ();
		while ($type->isa('SequenceType')) {
			if (exists $type->{max}) {
				push @array_max, $type->{max};
			} else {
				push @array_max, undef;
			}
			$type = $self->_get_defn($_->{type});
		}
		foreach (@array_max) {
			push @tab, "  ";
			if (defined $_) {
				print OUT @tab,"if (value.",$name,$idx,".length > (",$_->{java_literal},"))\n";
				print OUT @tab,"  throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
			}
			print OUT @tab,"os.write_long (value.",$name,$idx,".length);\n";
			print OUT @tab,"for (int _i",$i," = 0;_i",$i," < value.",$name,$idx,".length; ++_i",$i,")\n";
			print OUT @tab,"{\n";
			$idx .= "[_i" . $i . "]";
			$i ++;
		}
		if (($type->isa('StringType') or $type->isa('WideStringType')) and exists $type->{max}) {
			print OUT @tab,"  if (value.",$name,$idx,".length () > (",$type->{max}->{java_literal},"))\n";
			print OUT @tab,"    throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);\n";
		}
		print OUT @tab,"  ",$type->{java_write},"value.",$name,$idx,");\n";
		foreach (@array_max) {
			print OUT @tab,"}\n";
			pop @tab;
		}
		if (exists $member->{array_size}) {
			foreach (@{$member->{array_size}}) {
				print OUT @tab,"}\n";
				pop @tab;
			}
		}
	}
	print OUT "  }\n";
	print OUT "\n";
	print OUT "}\n";
	close OUT;

	$self->open_stream($node,'.java');
	print OUT "public final class ",$node->{java_name}," extends org.omg.CORBA.UserException\n";
	print OUT "{\n";
	foreach (@{$node->{list_value}}) {
		my $member = $self->_get_defn($_);			# single or array
		print OUT "  public ",$member->{java_init},";\n";
	}
	print OUT "\n";
	print OUT "  public ",$node->{java_name}," ()\n";
	print OUT "  {\n";
	print OUT "    super(",$node->{java_name},"Helper.id());\n";
	print OUT "  }\n";
	print OUT "\n";
	if (scalar(@{$node->{list_value}})) {
		print OUT "  public ",$node->{java_name}," (";
		$first = 1;
		foreach (@{$node->{list_value}}) {
			my $member = $self->_get_defn($_);			# single or array
			print OUT ", " unless ($first);
			print OUT $member->{java_type}," _",$member->{java_name};
			$first = 0;
		}
		print OUT ")\n";
		print OUT "  {\n";
		print OUT "    super(",$node->{java_name},"Helper.id());\n";
		foreach (@{$node->{list_value}}) {
			my $member = $self->_get_defn($_);			# single or array
			print OUT "    ",$member->{java_name}," = _",$member->{java_name},";\n";
		}
		print OUT "  }\n";
		print OUT "\n";
	}
	if (scalar(@{$node->{list_value}})) {
		print OUT "  public ",$node->{java_name}," (String \$reason";
		foreach (@{$node->{list_value}}) {
			my $member = $self->_get_defn($_);			# single or array
			print OUT ", ",$member->{java_type}," _",$member->{java_name};
		}
		print OUT ")\n";
	} else {
		print OUT "  public ",$node->{java_name}," (String \$reason)\n";
	}
	print OUT "  {\n";
	print OUT "    super(",$node->{java_name},"Helper.id() + \"  \" + \$reason);\n";
	foreach (@{$node->{list_value}}) {
		my $member = $self->_get_defn($_);			# single or array
		print OUT "    ",$member->{java_name}," = _",$member->{java_name},";\n";
	}
	print OUT "  }\n";
	print OUT "\n";
	print OUT "} // class ",$node->{java_name},"\n";
	close OUT;
}

#
#	3.13	Operation Declaration
#

sub visitOperation {
	my $self = shift;
	my($node) = @_;
	my $type = $self->_get_defn($node->{type});
	my $proto = $type->{java_Name} . " " . $node->{java_name} . " (";
	my $first = 1;
	foreach (@{$node->{list_param}}) {
		$type = $self->_get_defn($_->{type});
		$proto .= ", " unless ($first);
		if ($_->{attr} eq 'in') {
			$proto .= $type->{java_Name};
		} else {
			$proto .= $type->{java_holder};
		}
		$proto .= " " . $_->{java_name};
		$first = 0;
	}
	if (exists $node->{list_context}) {
		$proto .= ", " unless ($first);
		$proto .= "org.omg.CORBA.Context context";
	}
	$proto .= ")";
	if (exists $node->{list_raise}) {
		$proto .= " throws ";
		$first = 1;
		foreach (@{$node->{list_raise}}) {		# exception
			my $defn = $self->_get_defn($_);
			$proto .= ", " unless ($first);
			$proto .= $defn->{java_Name};
			$first = 0;
		}
	}

	$self->{methodes} .= "  " . $proto . ";\n";

	$self->{stub} .= "  public " . $proto . "\n";
	$self->{stub} .= "  {\n";
	$self->{stub} .= "     // TODO\n";
#		print OUT "    org.omg.CORBA.portable.InputStream $is = null;\n";
#		print OUT "    try {\n";
#		print OUT "       org.omg.CORBA.portable.OutputStream $os = _request ("length", true);\n";
#		print OUT "       $os.write_string (s);\n";
#		print OUT "       $is = _invoke ($os);\n";
#		print OUT "       int $result = $is.read_long ();\n";
#		print OUT "       return $result;\n";
#		print OUT "    } catch (org.omg.CORBA.portable.ApplicationException $ex) {\n";
#		print OUT "       $is = $ex.getInputStream ();\n";
#		print OUT "       String _id = $ex.getId ();\n";
#		print OUT "       if (_id.equals (\"",$node->{repos_id},"\"))\n";
#		print OUT "          throw Example.AnExceptionHelper.read ($is);\n";
#		print OUT "       else\n";
#		print OUT "            throw new org.omg.CORBA.MARSHAL (_id);\n";
#		print OUT "    } catch (org.omg.CORBA.portable.RemarshalException $rm) {\n";
#		print OUT "       return length (s);\n";
#		print OUT "    } finally {\n";
#		print OUT "        _releaseReply ($is);\n";
#		print OUT "    }\n";
	$self->{stub} .= "  } // " . $node->{java_name} . "\n";
	$self->{stub} .= "\n";
}

#
#	3.14	Attribute Declaration
#

sub visitAttributes {
	my $self = shift;
	my($node) = @_;
	foreach (@{$node->{list_value}}) {
		$_->visit($self);				# attribute
	}
}

sub visitAttribute {
	my $self = shift;
	my($node) = @_;
	$node->{_get}->visit($self);
	$node->{_set}->visit($self) if (exists $node->{_set});
}

#
#	3.15	Repository Identity Related Declarations
#

sub visitTypeId {
	# empty
}

sub visitTypePrefix {
	# empty
}

#
#	3.16	Event Declaration
#

sub visitRegularEvent {
	# JAVA mapping is aligned with CORBA 2.4
	shift->_no_mapping(@_);
}

sub visitAbstractEvent {
	# JAVA mapping is aligned with CORBA 2.4
	shift->_no_mapping(@_);
}

sub visitForwardRegularEvent {
	# JAVA mapping is aligned with CORBA 2.4
	shift->_no_mapping(@_);
}

sub visitForwardAbstractEvent {
	# JAVA mapping is aligned with CORBA 2.4
	shift->_no_mapping(@_);
}

#
#	3.17	Component Declaration
#

sub visitComponent {
	# JAVA mapping is aligned with CORBA 2.4
	shift->_no_mapping(@_);
}

sub visitForwardComponent {
	# JAVA mapping is aligned with CORBA 2.4
	shift->_no_mapping(@_);
}

#
#	3.18	Home Declaration
#

sub visitHome {
	# JAVA mapping is aligned with CORBA 2.4
	shift->_no_mapping(@_);
}

1;

