package WordList::PersonName::PopularBabyNames::US::SSA::1960::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-01'; # DATE
our $DIST = 'WordLists-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contain_nonword_chars",0,"longest_word_len",11,"num_words_contain_unicode",0,"num_words_contains_nonword_chars",0,"num_words_contains_whitespace",0,"avg_word_len",5.626,"num_words",1000,"num_words_contains_unicode",0,"num_words_contain_whitespace",0,"shortest_word_len",2); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 1960 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::PersonName::PopularBabyNames::US::SSA::1960::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 1960 (from Social Security Administration)

=head1 VERSION

This document describes version 0.001 of WordList::PersonName::PopularBabyNames::US::SSA::1960::MaleTop1000 (from Perl distribution WordLists-PersonName-PopularBabyNames-US-SSA), released on 2020-05-01.

=head1 SYNOPSIS

 use WordList::PersonName::PopularBabyNames::US::SSA::1960::MaleTop1000;

 my $wl = WordList::PersonName::PopularBabyNames::US::SSA::1960::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.626 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
David
Michael
James
John
Robert
Mark
William
Richard
Thomas
Steven
Timothy
Joseph
Charles
Jeffrey
Kevin
Kenneth
Daniel
Paul
Donald
Brian
Ronald
Gary
Scott
Gregory
Anthony
Edward
Stephen
Larry
Christopher
Douglas
Dennis
Randy
George
Terry
Keith
Mike
Jerry
Ricky
Bruce
Frank
Craig
Peter
Steve
Eric
Patrick
Raymond
Roger
Danny
Jeff
Alan
Andrew
Tony
Carl
Dale
Jeffery
Russell
Joe
Wayne
Randall
Tim
Matthew
Gerald
Chris
Lawrence
Johnny
Phillip
Billy
Rodney
Jimmy
Walter
Todd
Barry
Bobby
Glenn
Jim
Philip
Martin
Jay
Curtis
Roy
Willie
Arthur
Greg
Henry
Jack
Tom
Ronnie
Bryan
Ralph
Bradley
Samuel
Harold
Albert
Dean
Bill
Darryl
Jon
Allen
Vincent
Rick
Stanley
Eddie
Victor
Darrell
Louis
Micheal
Jose
Howard
Eugene
Joel
Dan
Tommy
Leonard
Frederick
Don
Lee
Fred
Jonathan
Marvin
Ernest
Ray
Dave
Dwayne
Harry
Melvin
Mitchell
Duane
Kelly
Calvin
Kurt
Bob
Norman
Jerome
Brad
Karl
Marc
Tracy
Rickey
Earl
Edwin
Clifford
Kirk
Glen
Reginald
Francis
Perry
Alfred
Kent
Theodore
Jesse
Brett
Bernard
Nicholas
Brent
Benjamin
Darren
Clarence
Kerry
Gordon
Juan
Stuart
Troy
Shawn
Wesley
Warren
Alvin
Carlos
Guy
Kenny
Ron
Lance
Leroy
Vernon
Gene
Gilbert
Herbert
Ken
Aaron
Gregg
Lloyd
Dwight
Doug
Lonnie
Ted
Leslie
Manuel
Dana
Daryl
Leon
Nathan
Tyrone
Timmy
Donnie
Marty
Franklin
Antonio
Allan
Floyd
Neil
Robin
Andy
Sean
Andre
Lewis
Gerard
Clyde
Jackie
Ruben
Luis
Marcus
Maurice
Mario
Ricardo
Lester
Rex
Jimmie
Kelvin
Chuck
Randal
Kyle
Clayton
Charlie
Wade
Bret
Garry
Alex
Freddie
Sam
Joey
Leo
Arnold
Alexander
Byron
Neal
Milton
Derrick
Kim
Nathaniel
Wendell
Roland
Johnnie
Nick
Clinton
Randolph
Oscar
Herman
Derek
Ross
Adam
Nelson
Terrence
Pat
Harvey
Jody
Lynn
Cecil
Ben
Roberto
Jason
Chester
Jessie
Jesus
Fredrick
Clay
Raul
Hugh
Bart
Marshall
Matt
Hector
Clifton
Sammy
Rocky
Sidney
Carlton
Roderick
Claude
Rudy
Miguel
Frankie
Geoffrey
Benny
Wallace
Francisco
Ramon
Cary
Terence
Pete
Jamie
Lyle
Terrance
Curt
Grant
Edgar
Rene
Virgil
Bradford
Max
Angelo
Angel
Pedro
Christian
Loren
Darrel
Felix
Lorenzo
Morris
Ed
Mickey
Jaime
Rory
Everett
Stewart
Phil
Myron
Armando
Clark
Ira
Ivan
Earnest
Teddy
Salvatore
Fernando
Dewayne
Sherman
Adrian
Otis
Drew
Bennie
Jorge
Travis
Malcolm
Rafael
Willard
Marion
Cedric
Shane
Luther
Alton
Jeffry
Rickie
Elmer
Rusty
Edmund
Laurence
Julius
Sylvester
Scot
Alberto
Rod
Julian
Delbert
Jacob
Alfredo
Monty
Javier
Preston
Van
Roosevelt
Clint
Isaac
Erik
Kris
Monte
Alonzo
Lionel
Wilbert
Arturo
Rodger
Robbie
Orlando
Evan
Vance
Kendall
Archie
Rudolph
Dominic
Ernie
Blake
Dexter
Lowell
Gabriel
Gerry
Stevie
Luke
Stephan
Tommie
Horace
Willis
Leland
Stan
Doyle
Jerald
Hal
Hubert
Forrest
Al
Bryant
Darwin
Noel
Sheldon
Bert
Blaine
Dino
Owen
Alfonso
Freddy
Ryan
Toby
Boyd
Oliver
Eduardo
Carey
Jan
Enrique
Denis
Dirk
Damon
Justin
Ellis
Donny
Spencer
Buddy
Grady
Wilbur
Cory
Ernesto
Rob
Dallas
Casey
Dominick
Kirby
Zachary
Julio
Russ
Seth
Mathew
Salvador
Vince
Ervin
Mitch
Miles
Rufus
Darnell
Louie
Ronny
Mack
Darin
Randell
Cornelius
Homer
Rodolfo
Dewey
Joshua
Bryon
Denny
Tod
Corey
Moses
Irvin
Royce
Stacy
Marlon
Abraham
Colin
Sammie
Dane
Jess
Shannon
Cameron
Scotty
Alphonso
Ward
Wilson
Conrad
Sergio
Elliott
Lane
Rolando
Aubrey
Carroll
Edmond
Percy
Michel
Reggie
Barney
Lamar
Elbert
Joesph
Amos
Trent
Garland
Nicky
Chad
Ty
Gilberto
Cliff
Morgan
Ramiro
Blair
Reuben
Abel
Wilfred
Cleveland
Stacey
Lyndon
Norris
Vaughn
Barton
Pierre
Elvis
Ian
Elton
Guadalupe
Shaun
Sterling
Rich
Harlan
Reynaldo
Rocco
Gerardo
Marlin
Pablo
Dwain
Israel
Bernie
Lamont
Will
Mitchel
Donnell
Simon
Ned
Terrell
Lon
Darrin
Galen
Thaddeus
Russel
Eddy
Murray
Brendan
Reed
Andres
Emmett
Ismael
Woodrow
Robby
Marco
Emanuel
Tomas
Alejandro
Austin
Felipe
Hans
Junior
Bennett
Kurtis
Garth
Irving
Kennith
Gus
Lenny
Unknown
Bobbie
Guillermo
Winston
Avery
Dion
Billie
Erwin
Tracey
Bryce
Burton
Dick
Fabian
Art
Brandon
Garrett
Elijah
Norbert
Dannie
Eldon
Jasper
Wilfredo
Levi
Tyler
Rogelio
Carmen
Elvin
Merle
Danial
Harrison
Linwood
Sandy
Domingo
Duncan
Jefferson
Grover
Harley
Lanny
Les
Theron
Elias
Mary
Sanford
Kip
Kermit
Nolan
Thurman
Erich
Erick
Marcos
Antoine
Daren
Jonathon
Kraig
Emil
Vito
Santiago
Shelby
Jeremy
Kenton
Roscoe
Elliot
Jake
Lonny
Hank
Kelley
Orville
Gino
Timmie
Anton
Lindsay
Cesar
Dudley
Jeremiah
Layne
Ulysses
Eli
Shelton
August
Emilio
Errol
Loyd
Winfred
Sonny
Tad
Cornell
Emery
Jean
Frederic
Johnathan
Santos
Coy
Adolph
Britt
Donn
Ignacio
Lindsey
Otto
Roman
Gustavo
Odell
Toney
Carter
Jed
Keven
Noah
Wes
Jordan
Wiley
Charley
Del
Wayde
Brady
Davis
Nicolas
Quintin
Chip
Stefan
Timmothy
Vern
Damian
Wally
Benito
Emory
Ivory
Reid
Efrain
Gale
Lenard
Josh
Hollis
Jerold
Saul
Solomon
Carlo
Jacky
Xavier
Humberto
Mikel
Quentin
Weldon
Marcel
Hiram
Millard
Quinton
Adolfo
Randel
Scottie
Val
Carmine
Len
Butch
Elwood
Bud
Zane
Chet
Noe
Ollie
Thad
Kennedy
Courtney
Myles
Cris
Jackson
Derwin
Blane
Eloy
Basil
Kirt
Merrill
Bradly
Dwaine
Jarvis
Jerrold
Jude
Richie
Fidel
Fredric
Von
Devin
Jacques
Mervin
Riley
Burt
Emmanuel
Bruno
Delmar
Denver
Harris
Keenan
Christophe
Freeman
Merlin
Skip
Wyatt
Leonardo
Sal
Stanford
Dee
Alec
Connie
Rock
Edwardo
Gavin
Armand
Gil
Duke
Isaiah
Mel
Greggory
Raynard
Rolf
Antony
Brooks
Elroy
Everette
Hugo
Kennth
Kimberly
Linda
Omar
Aron
Judson
Lavern
Lemuel
Royal
Douglass
Ethan
Graham
Kenney
Augustine
Clement
Heriberto
Joaquin
Raphael
Taylor
Dalton
Eliot
Fritz
Nickolas
Vicente
Berry
Derick
Dusty
Emerson
Johnie
Ashley
Carson
Curtiss
Forest
Audie
Cody
Donell
Gearld
Hilton
Lupe
Domenic
Alden
Flint
Irwin
Lisa
Roddy
Darius
Desmond
Gregorio
Lincoln
Carol
Kristopher
Rodrick
Anderson
Cruz
Dickie
Tobin
Duwayne
Agustin
Andrea
Robbin
Stanton
Susan
Arnulfo
Artis
Dell
Felton
Haywood
Laverne
Mason
Maynard
Pasquale
Wilton
Benedict
Darold
Demetrius
Dwane
Esteban
Federico
Jefferey
Leigh
Arlen
Donna
Lucas
Silas
Vic
Cyrus
Faron
Leif
Raymon
Rogers
Glynn
Lesley
Marcelino
Moises
Rayford
Cyril
Dante
Debra
Donovan
Kerwin
Kevan
Lennie
Napoleon
Reinaldo
Barrett
Brice
Darrick
Fletcher
Huey
Monroe
Titus
Woody
Micah
Broderick
Cole
Derrell
Karen
Mckinley
Brien
Gonzalo
Hayward
Major
Wardell
Wilmer
Andra
Buford
Darry
Hunter
Patricia
Sebastian
Truman
Wilford
Alvaro
Jame
Jonas
Ricki
Brant
Cynthia
Earle
Gaylon
Mac
Roel
Bernardo
Clair
Quinn
Tab
Yancy
Adan
Barron
Darron
Darryle
Herb
Herschel
Odis
Raymundo
Rhett
Sid
Trevor
Alexis
Booker
Cal
Carmelo
Stephon
Warner
Barbara
Baron
Coleman
Deborah
Isiah
Leonel
Lou
Waymon
Windell
Alfonzo
Benton
Boyce
Brenda
Darryll
Devon
Jamey
Jere
Leander
Paris
Rolland
Willam
Brock
Chaim
Daryle
Ezra
Ferdinand
Hershel
Jared
Lawerence
Lyman
Buck
Dennie
Issac
Kory
Lacy
Lars
Prince
Sandra
Walt
Abe
Aldo
Alva
Arnie
Arnoldo
Artie
Chauncey
Darell
Dorsey
Emmitt
Garret
Montgomery
Quincy
Stevan
Augustus
Burl
Elizabeth
Lauren
