package WordList::PersonName::PopularBabyNames::US::SSA::1960::FemaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-01'; # DATE
our $DIST = 'WordLists-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contains_unicode",0,"num_words_contain_whitespace",0,"num_words",1000,"shortest_word_len",2,"avg_word_len",5.864,"num_words_contains_whitespace",0,"num_words_contains_nonword_chars",0,"num_words_contain_unicode",0,"longest_word_len",10,"num_words_contain_nonword_chars",0); # STATS

1;
# ABSTRACT: Top 1000 most popular names for female babies born in the USA in 1960 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::PersonName::PopularBabyNames::US::SSA::1960::FemaleTop1000 - Top 1000 most popular names for female babies born in the USA in 1960 (from Social Security Administration)

=head1 VERSION

This document describes version 0.001 of WordList::PersonName::PopularBabyNames::US::SSA::1960::FemaleTop1000 (from Perl distribution WordLists-PersonName-PopularBabyNames-US-SSA), released on 2020-05-01.

=head1 SYNOPSIS

 use WordList::PersonName::PopularBabyNames::US::SSA::1960::FemaleTop1000;

 my $wl = WordList::PersonName::PopularBabyNames::US::SSA::1960::FemaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.864 |
 | longest_word_len                 | 10    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Mary
Susan
Linda
Karen
Donna
Lisa
Patricia
Debra
Cynthia
Deborah
Sandra
Barbara
Brenda
Pamela
Nancy
Sharon
Cheryl
Elizabeth
Teresa
Lori
Kathy
Diane
Carol
Laura
Debbie
Kimberly
Kathleen
Julie
Denise
Cindy
Tammy
Janet
Robin
Kim
Theresa
Margaret
Laurie
Rebecca
Michelle
Christine
Janice
Catherine
Carolyn
Rhonda
Cathy
Tina
Connie
Judy
Terri
Angela
Kelly
Ann
Diana
Sherry
Paula
Sheila
Dawn
Joyce
Maria
Beverly
Jennifer
Annette
Wendy
Lynn
Valerie
Wanda
Jane
Betty
Peggy
Shirley
Bonnie
Beth
Vicki
Judith
Darlene
Jill
Amy
Suzanne
Gloria
Joan
Katherine
Kathryn
Martha
Tracy
Jacqueline
Jean
Anita
Anne
Michele
Gail
Stephanie
Leslie
Renee
Ellen
Dorothy
Rita
Ruth
Rose
Joanne
Vickie
Terry
Virginia
Marie
Anna
Regina
Maureen
Colleen
Phyllis
Melissa
Carla
Becky
Elaine
Penny
Victoria
Andrea
Sarah
Marilyn
Helen
Alice
Sue
Sylvia
Julia
Sally
Tamara
Melanie
Sandy
Frances
Gina
Jeanne
Eileen
Joann
Pam
Yvonne
Jo
Lorraine
Sherri
Evelyn
Loretta
Carrie
Dana
Monica
Sheryl
Melinda
Jackie
Patty
Toni
Doris
Charlene
Roberta
Belinda
Charlotte
Joy
Melody
Vanessa
Christina
Glenda
Marcia
Shelly
Jeanette
Dianne
Holly
Norma
Gwendolyn
Lynne
Patti
Jan
Carmen
Veronica
Vicky
Heidi
Teri
Yolanda
Deanna
Audrey
Lois
Tami
Shelia
Marsha
Sheri
Jamie
Rosemary
Shelley
Lynda
Juanita
Tammie
Sara
Irene
Vivian
Crystal
Tracey
April
Kay
Roxanne
Doreen
Shari
Jody
Rosa
Rachel
Louise
Marianne
Constance
Darla
Carole
Eva
Lydia
Karla
Dianna
June
Marlene
Alicia
Arlene
Grace
Jodi
Debora
Ramona
Natalie
Tanya
Lee
Chris
Gayle
Annie
Stacy
Lillian
Geraldine
Bernadette
Yvette
Cheri
Felicia
Ruby
Joni
Janine
Dolores
Esther
Ronda
Jenny
Delores
Marjorie
Nora
Lauren
Sherrie
Maryann
Tonya
Edith
Cassandra
Sonya
Alison
Betsy
Nina
Stacey
Robyn
Emily
Priscilla
Lynette
Caroline
Lora
Susie
Kimberley
Therese
Claudia
Margie
Myra
Christy
Josephine
Erin
Bridget
Ginger
Lucy
Pauline
Terrie
Patsy
Edna
Marla
Janie
Kristine
Mildred
Mona
Allison
Kristi
Jeannie
Miriam
Lorrie
Jacquelyn
Cecilia
Patrice
Francine
Marian
Lorie
Shannon
Bobbie
Kelley
Rosemarie
Angie
Georgia
Sabrina
Emma
Jana
Amanda
Heather
Nadine
Irma
Kelli
Kerry
Cathleen
Sonia
Jeannette
Gretchen
Antoinette
Dora
Clara
Rochelle
Beatrice
Jayne
Rene
Vera
Claire
Bonita
Gwen
Faith
Bernice
Gladys
Janis
Paulette
Bertha
Jeanine
Candace
Thelma
Candy
Eleanor
Joanna
Marion
Lucinda
Jennie
Alma
Laurel
Kellie
Billie
Faye
Iris
Naomi
Lana
Kristin
Leah
Leticia
Leigh
Katrina
Celeste
Jeri
Shawn
Sonja
Pat
Kari
Ella
Della
Rosie
Dena
Florence
Ida
Karin
Luann
Ethel
Molly
Wilma
Trudy
Lauri
Nanette
Lesa
Tara
Kathi
Lorna
Lucille
Traci
Debby
Trina
Cherie
Rosalind
Adrienne
Liz
Jeannine
Gay
Marcella
Monique
Ana
Stella
Polly
Olga
Lillie
Leanne
Katie
Maxine
Lou
Mindy
Willie
Gale
Alisa
Christie
Leann
Hazel
Kris
Madeline
Hope
Suzette
Deirdre
Tamra
Janette
Susanne
Cecelia
Jessica
Velma
Tamera
Dina
Corinne
Jerri
Tracie
Amelia
Celia
Kristen
Dale
Kristy
Valarie
Verna
Desiree
Ladonna
Lorri
Marcy
Tammi
Colette
Jolene
Rosalie
Lena
Marguerite
Rena
Elisa
Dee
Jessie
Jodie
Camille
Laverne
Margarita
Sondra
Barb
Noreen
Olivia
Darcy
Lynnette
Delia
Kerri
Benita
Angelia
Lenora
Harriet
Kathie
Maryellen
Daisy
Robbie
Leona
Hilda
Dixie
Cindi
Ingrid
Cora
Danette
Freda
Mitzi
Robbin
Janelle
Guadalupe
Helene
Deana
Elena
Deloris
Geneva
Viola
Agnes
Deanne
Marybeth
Judi
Kristina
Roseann
Margo
Mattie
Bobbi
Kimberlee
Lola
Randi
Christi
Johnnie
Coleen
Ernestine
Gayla
Luanne
Jeanie
Isabel
Bessie
Tamela
Reba
Rosanne
Maryanne
Elisabeth
Bridgette
Denice
Alberta
Elise
Myrna
Lea
Pearl
Megan
Nellie
Sallie
Debi
Diann
Sandi
Alesia
Annmarie
Ada
Laureen
Minnie
Elsie
Eugenia
Mae
Marta
Tonia
Felecia
Tricia
Mari
Flora
Marina
Deidre
Marisa
Roxann
Maura
Claudette
Ava
Eunice
Saundra
Maggie
Julianne
Greta
Kristie
Clare
Frankie
Rosalyn
Geri
Violet
Carlene
Michael
Tena
Gracie
Malinda
Penelope
Brigitte
Krista
Renita
Danielle
Melodie
Dona
Johanna
Nita
Stacie
Shelby
Sharron
Josie
Katharine
Twila
Lorene
Eve
Renae
Deann
Leisa
Rachelle
Blanca
Rosetta
Roslyn
Daphne
Dinah
Leeann
Danita
Maryjo
Kaye
Lila
Lourdes
James
Suzan
Caren
Hattie
Glenna
Luz
Kendra
Estella
Amber
Pamala
Roxane
Elsa
Fran
Dorothea
Deena
Lorena
Rosalinda
Lisha
Alfreda
Fay
Ilene
Merry
Genevieve
Ivy
Henrietta
Ruthie
Adele
Marcie
Robert
Patrica
Angel
Candice
Gaye
Gena
Vickey
Caryn
Teressa
Libby
Lupe
Jami
Kitty
Bernadine
Sophia
Charmaine
Gigi
Lucia
Allyson
Kirsten
Antonia
Pattie
Simone
Cathryn
Lenore
Melba
Roxanna
Arleen
Bambi
Georgette
Marci
Geralyn
Mamie
Meredith
Rae
Tamie
Sharlene
Lesley
Erma
Nicole
Venita
Wendi
John
Terese
Abby
Karyn
Lula
Jenifer
Sheree
Keri
Angelina
Corrine
Inez
Erica
Janell
Nelda
Cara
Antionette
Juli
Fannie
Ginny
Dorene
Silvia
Abigail
Aileen
Jocelyn
Marylou
Rhoda
Jewel
Debbi
Karol
Annemarie
David
Kyle
Susanna
Valorie
Cherry
Teena
Loraine
Vikki
Avis
Althea
Bethany
Helena
Justine
Lyn
Maritza
Etta
Carmela
Migdalia
Shellie
Earnestine
Gertrude
Misty
Janna
Dori
Louann
Shawna
Cheryle
Kate
Tana
Marietta
Minerva
Bridgett
Clarissa
Alexandra
Lawanda
Lesia
Shauna
Deb
Letitia
Selena
Gerri
Leesa
Mariann
Raquel
Cathie
Nikki
Rebekah
Francis
Gabrielle
Madonna
Delphine
Edwina
Lavonne
Pennie
Karrie
Kathrine
Maribeth
Shelli
Cari
Elva
Elvira
Starla
Cherri
Kandy
Paige
Vonda
Deidra
Eloise
Nannette
Dottie
Katy
Missy
Danna
Dolly
Karon
Bonny
Earlene
Fern
Letha
Venus
Juliana
Lucretia
Meg
Christa
Valeria
Debrah
Aurora
Cyndi
Erika
Collette
Dawna
Myrtle
Susana
Tresa
Bettie
Bettina
Graciela
Rosario
Juliet
Leila
Marva
Mollie
Beverley
Debbra
Jacquline
Lu
Cornelia
Lela
Alexis
Clarice
Esmeralda
Muriel
Nola
Nona
Sherrill
Twyla
Dorinda
Joellen
Selina
Annamarie
Mercedes
Valencia
Blanche
Carmella
Magdalena
Marilee
Nan
Sybil
Treva
Aida
Hilary
William
Cassie
Dayna
Doretha
Juana
Aimee
Annetta
Mable
Milagros
Andra
Roseanne
Sherie
Tori
Winifred
Charla
Ester
Ivette
Jerry
Millie
Ronna
Estelle
Camilla
Chandra
Nanci
Randy
Sadie
Cathi
Darleen
Delois
Fonda
Harriett
Lanette
Mara
Athena
Louisa
Suzanna
Merri
Mimi
Rachael
Angelita
Ina
Melva
Willa
Candi
Mandy
Roxie
Cristina
Bette
Suzy
Georgina
Leisha
Martina
Ollie
Portia
Carolina
Edie
Jewell
Leanna
Rosanna
Lavern
Nettie
Tonja
Aleta
Delilah
Donita
Madelyn
Carleen
Cecile
Janeen
Joanie
Margot
Melisa
Noemi
Reva
Essie
Jacque
Katheryn
Maryjane
May
Adriana
Barbra
Elana
Francesca
Jacki
Carey
Celestine
Gilda
Jannie
Lilly
Lizabeth
Tommie
Esperanza
Iva
Leta
Petra
Romona
Sharla
Zelda
Deedee
Kara
Lita
Liza
Rona
Juliann
Mabel
Mavis
Opal
Ursula
Charles
Daria
Hannah
Jeanna
Mark
Sherryl
Babette
Dara
Eula
Retha
Unknown
Neva
Suzie
Carmel
Cathrine
Kayla
Loriann
Tania
Consuelo
Dedra
Evette
Francisca
Joe
Alana
Cinda
Sydney
Veda
Angelica
Lily
Ruthann
Kerrie
Latanya
Lindy
Shiela
Addie
Earline
Fawn
Loreen
Ora
Risa
Joleen
Mickey
Moira
Richard
Trena
Jerrie
Laurene
Shirlene
Callie
Penni
Adrianne
Alyce
Beckie
Dorthy
Evangeline
Krystal
Sheena
Cherrie
Jannette
Joseph
Thomas
Josefina
Juliette
Leola
Marty
Matilda
Millicent
Velda
Zoe
Caron
Cary
Deeann
Keely
Pearlie
Rosita
Bev
Carlotta
Lissa
Phoebe
Germaine
Lorinda
