package WordList::PersonName::PopularBabyNames::US::SSA::1910::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-01'; # DATE
our $DIST = 'WordLists-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contain_nonword_chars",0,"longest_word_len",11,"num_words_contain_unicode",0,"num_words_contains_nonword_chars",0,"num_words_contains_whitespace",0,"avg_word_len",5.727,"num_words",1000,"num_words_contains_unicode",0,"num_words_contain_whitespace",0,"shortest_word_len",2); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 1910 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::PersonName::PopularBabyNames::US::SSA::1910::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 1910 (from Social Security Administration)

=head1 VERSION

This document describes version 0.001 of WordList::PersonName::PopularBabyNames::US::SSA::1910::MaleTop1000 (from Perl distribution WordLists-PersonName-PopularBabyNames-US-SSA), released on 2020-05-01.

=head1 SYNOPSIS

 use WordList::PersonName::PopularBabyNames::US::SSA::1910::MaleTop1000;

 my $wl = WordList::PersonName::PopularBabyNames::US::SSA::1910::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.727 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
John
James
William
Robert
George
Joseph
Charles
Frank
Edward
Henry
Willie
Thomas
Walter
Albert
Paul
Harry
Arthur
Harold
Raymond
Clarence
Richard
Fred
Jack
Louis
Joe
Carl
Howard
Ralph
Roy
David
Ernest
Samuel
Earl
Charlie
Lawrence
Francis
Anthony
Alfred
Eugene
Sam
Herbert
Andrew
Kenneth
Donald
Michael
Leonard
Stanley
Elmer
Lee
Leroy
Leo
Herman
Daniel
Theodore
Floyd
Peter
Clyde
Russell
Eddie
Jesse
Chester
Bernard
Norman
Lester
Lewis
Clifford
Lloyd
Ray
Frederick
Benjamin
Edwin
Jessie
Oscar
Johnnie
Melvin
Milton
Cecil
Claude
Ben
Edgar
Leon
Tom
Philip
Marvin
Alvin
Martin
Luther
Everett
Harvey
Victor
Morris
Allen
Sidney
Vernon
Julius
Stephen
Glenn
Homer
Vincent
Jim
Alexander
Leslie
Oliver
Wilbur
Gerald
Hubert
Manuel
Marion
Otis
Maurice
Virgil
Hugh
Will
Curtis
Max
Gilbert
Jacob
Irving
Archie
Gordon
Willard
Warren
Horace
Bill
Jimmie
Arnold
Alex
Earnest
Patrick
Isaac
Jerry
Wallace
Guy
Jose
Nathan
Steve
Nicholas
Ira
Nathaniel
Ed
Wayne
Orville
Mike
Roosevelt
Rufus
Bennie
Rudolph
Lonnie
Willis
Mack
Tony
Wesley
Calvin
Edmund
Otto
Sylvester
Johnie
Matthew
Jerome
Percy
Emil
Abraham
Roland
Dan
Glen
Elbert
Charley
Clifton
Dave
Franklin
Roger
Douglas
Johnny
Phillip
Clinton
Felix
Booker
Clayton
Emmett
Antonio
Pete
Adam
Juan
Jake
Ellis
Wilbert
Aaron
August
Nelson
Bert
Don
Irvin
Kermit
Roscoe
Angelo
Dennis
Moses
Simon
Ervin
Mark
Julian
Tommie
Salvatore
Ted
Dale
Marshall
Perry
Amos
Nick
Adolph
Alton
Delbert
Jay
Owen
Ronald
Lyle
Grady
Larry
Laurence
Ollie
Grover
Preston
Wilson
Ivan
Cleveland
Sherman
Gus
Aubrey
Bob
Forrest
Jess
Ross
Austin
Elijah
Merle
Emanuel
Loyd
Mary
Bruce
Buster
Edmond
Leland
Wilfred
Cornelius
Grant
Freddie
Harrison
Louie
Dominick
Elwood
Reuben
Karl
Gene
Alonzo
Troy
Byron
Carlton
Carroll
Harley
Murray
Dewey
Noah
Boyd
Elmo
Malcolm
Ramon
Jeff
Pedro
Ruben
Allan
Carlos
Jasper
Mitchell
Tommy
Solomon
Claud
Monroe
Andy
Millard
Timothy
Wade
Abe
Anton
Garland
Al
Jesus
Sol
Wiley
Cleo
Erwin
Barney
Clark
Lowell
Luke
Mose
Christopher
Dock
Fredrick
Coy
Levi
Wendell
Loren
Steven
Forest
Francisco
Myron
Neal
Randolph
Rex
Silas
Buford
Eli
Lynn
Marcus
Riley
Eldon
Alva
Alfonso
Cyril
Hyman
Alan
Dallas
Reginald
Hiram
Pat
Odell
Orval
Thurman
Alphonse
Isiah
Wilmer
Dwight
Emery
Emory
Joel
Odis
Augustus
Bruno
Earle
Elvin
Fletcher
Isadore
Neil
Spencer
Burton
Conrad
Dean
Dominic
Mathew
Miles
Ora
Stewart
Anderson
Bud
Dick
Emerson
Freeman
Meyer
Clement
Jackson
Jimmy
Maynard
Russel
Ward
Buck
Gerard
Ike
Irwin
Scott
Ambrose
Ferdinand
Lucius
Norris
Sammie
Sanford
Benny
Herschel
King
Mario
Olin
Rocco
Weldon
Basil
Elton
Hollis
Kelly
Lorenzo
Major
Pasquale
Sterling
Morgan
Ned
Taft
Van
Woodrow
Dewitt
Elliott
Ellsworth
Frederic
Jean
Joshua
Napoleon
Noble
Noel
Roman
Royal
Billy
Emile
Garfield
Isidore
Keith
Tomas
Ulysses
Wilburn
Adrian
Ezra
Foster
Junius
Saul
Sydney
Carmen
Columbus
Doyle
Eric
Gabriel
Harlan
Houston
Linwood
Maxwell
Billie
Buddy
Christian
Coleman
Davis
Morton
Newton
Porter
Rubin
Stuart
Hugo
Isaiah
Luis
Merrill
Norbert
Truman
Wilford
Armand
Frances
Guadalupe
Omer
Prince
Theron
Walker
Burl
Judge
Dudley
Enoch
Junior
Lincoln
Waldo
Alfredo
Alphonso
Arther
Clair
Dee
Jeremiah
Jules
Rosevelt
Ruth
Sandy
Taylor
Theo
Wilber
Elias
Everette
Lamar
Rodney
Tim
Vern
Abner
Bertram
Early
Edd
Ethel
Gustave
Harris
Haywood
Lacy
Lionel
Milford
Rupert
Chauncey
Chris
General
Lenard
Lucious
Miguel
Oren
Phil
Wm
Delmar
Elmore
Evan
Hal
Jewell
Judson
Lyman
Margaret
Nolan
Otho
Travis
Asa
Cleve
Elzie
Emmitt
Haskell
Helen
Milo
Reed
Smith
Terry
Valentine
Vance
Aloysius
Benedict
Darrell
Israel
Lemuel
Louise
Oswald
Pablo
Rafael
Rene
Shelby
Thaddeus
Turner
Adolphus
Aron
Bernice
Clay
Cletus
Harmon
Hazel
Otha
Santiago
Bryant
Cyrus
Hans
Ivory
Mason
Matt
Maxie
Mckinley
Vernie
Winfield
Abram
Carter
Duane
Graham
Hardy
Hoyt
Laverne
Orlando
Patsy
Reese
Rudy
Shelton
Washington
Annie
Carey
Elisha
Gail
Gregory
Hershel
Jefferson
Lonzo
Micheal
Palmer
Quincy
Seymour
Watson
Carson
Clint
Domingo
Dorothy
Ennis
Evans
Fay
Felton
Granville
Jason
Johnson
Mervin
Olen
Salvador
Shirley
Sigmund
Arlie
Arturo
Benito
Carmine
Cary
Clem
Denver
Fernando
Florence
Gaston
Ivy
Jewel
Josh
Lindsey
Merlin
Obie
Pearl
Romeo
Ruby
Sammy
Santos
Teddy
Walton
Allie
Antone
Artie
Bennett
Bernie
Connie
Dalton
Eino
Gustav
Lucien
Melton
Oral
Raleigh
Adelbert
Andres
Anna
Avery
Berry
Brady
Chas
Emilio
Enrique
Golden
Hilton
Hosea
Jodie
Loyal
Miller
Odie
Randall
Raymon
Vito
Wilton
Alberto
Angus
Blaine
Burt
Clarance
Cliff
Crawford
Ezekiel
Gaetano
Gladys
Green
Ignacio
Ignatius
Issac
Myles
Nat
Ottis
Sanders
Sherwood
Stanford
Thornton
Tillman
Winston
Alonza
Armando
Arvid
Bobbie
Casey
Casimer
Dana
Emmet
Ernie
Ester
Felipe
Gregorio
Henderson
Hermon
Hobert
Hoke
Jonathan
Levy
Marie
Ocie
Oran
Orrin
Osborne
Raphael
Roberto
Rogers
Verne
Warner
Webster
West
Albin
Alec
Alford
Augustine
Benton
Bonnie
Clare
Darwin
Delmer
Elvis
Hayward
Hector
Hobart
Jonas
Justin
Llewellyn
Lou
Mildred
Ossie
Rollin
Rowland
Winfred
Archibald
Arden
Bradley
Casimir
Edison
Eldred
Elizabeth
Elliot
Elroy
Emma
Gardner
Garrett
Joesph
Lavern
Logan
Lucian
Mahlon
Marcellus
Mickey
Rolland
Rollie
Rosario
Thelma
Vaughn
Vicente
Wylie
Alois
Author
Beverly
Carlo
Earlie
Edna
Eldridge
Elsie
Elwin
Florian
Ford
Gary
Huey
Hunter
Jonnie
Leander
Ludwig
Mac
Merton
Murry
Orin
Raul
Richmond
Rose
Thurston
Tobe
Vivian
Alice
Alvie
Artis
Audrey
Barry
Caleb
Dayton
Domenick
Dorsey
Elgin
Elige
Estel
Evert
Finis
Franklyn
Fulton
Garnett
Gussie
Harland
Hollie
Isom
Kyle
Lafayette
Lawson
Lillian
Lois
Madison
Manley
Mattie
Opal
Parker
Ransom
Reynold
Seth
Sheldon
Sid
Son
Tracy
Vester
Williams
Americo
Boyce
Carol
Casper
Claudie
Clemens
Cornell
Drew
Duncan
Edith
Eligah
Evelyn
Ewing
Farris
Federico
Finley
Fritz
Gust
Hezekiah
Lem
Leopold
Lon
Margarito
Marlin
Meredith
Merritt
Murphy
Nicolas
Olaf
Pascal
Price
Regis
Roderick
Sebastian
Virgle
Wayman
Wyatt
Adolfo
Agnes
Alden
Angel
Arch
Arlington
Arlo
Arnie
Arvil
Audie
Beatrice
Benjiman
Bertha
Brooks
Brown
Buddie
Burnett
Carleton
Carrol
Clara
Clovis
Dante
Dell
Domenico
Duke
Elden
Ellwood
Enos
Frankie
Furman
Garner
Garnet
Gaylord
Geo
Giles
Guido
Guillermo
Hallie
Hamilton
Hamp
Howell
Jones
Jordan
Julio
Kirby
Kirk
Lawyer
Lennie
Leona
Lessie
Loran
Loy
Malcom
Mariano
Martha
Melville
Newell
Oakley
Omar
Pauline
Prentice
Quentin
Stanton
Stephan
Sumner
Unknown
Urban
Weston
Zack
Addison
Alfonzo
Algie
Ann
Antoine
Art
Arvel
Axel
Bessie
Bryan
Chesley
Claire
Collie
Conley
Creed
Dempsey
Dexter
Doris
Eddy
Ernesto
Gale
Galen
Guss
Halley
Hayden
Hayes
Hilario
Hoy
Irene
Ivey
Jarvis
Johney
Julious
June
Lauren
Leamon
Lemon
Leonardo
Lesley
Lige
Lindsay
Lyndon
Malachi
Merl
Orie
Oris
Reino
Sampson
Silvester
Spurgeon
Titus
Toivo
Werner
Abel
Adolf
Allison
Auther
Bart
Bartholomew
Bascom
Bishop
Carlyle
Cicero
Cloyd
Constantine
Courtney
Curley
Dawson
Donnie
Durward
Elder
Elex
Ellie
