package WordList::ID::Common::Wikipedia5000;

our $DATE = '2017-12-31'; # DATE
our $VERSION = '0.002'; # VERSION

use WordList;
our @ISA = qw(WordList);

our %STATS = ("num_words_contains_nonword_chars",0,"avg_word_len",7.444,"shortest_word_len",2,"num_words",5000,"num_words_contains_whitespace",0,"longest_word_len",18,"num_words_contains_unicode",0); # STATS

1;
# ABSTRACT: Top 5000 words from Wikipedia Indonesia pages

=pod

=encoding UTF-8

=head1 NAME

WordList::ID::Common::Wikipedia5000 - Top 5000 words from Wikipedia Indonesia pages

=head1 VERSION

This document describes version 0.002 of WordList::ID::Common::Wikipedia5000 (from Perl distribution WordLists-ID-Common), released on 2017-12-31.

=head1 SYNOPSIS

 use WordList::ID::Common::Wikipedia5000;

 my $wl = WordList::ID::Common::Wikipedia5000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

This module contains 5000 most frequently used Indonesian words in Wikipedia
Indonesian pages.

Here's how the list is produced: First the Wikipedia Indonesia's XML.bz2 [1] was
downloaded (last downloaded: Dec 30, 2017). Then a couple of ad-hoc, rather
simplistic Perl scripts were used to process this large file: one script to
split the file to a per-page basis, and the other to strip Wikimedia markup.
All-lowercase words were then extracted from these files and merged to become a
single file. Then the list is curated to get the final {1000,2500,5000} top
words (false positives, misspellings removed).

Note that Wikipedia article pages do not represent general Indonesian text, some
words are overrepresented e.g. "lagu" (in articles about particular songs) or
"filum".

Some words are derivative forms (not-root words), e.g. "makanannya" or
"berdasarkan".

The order of the words in this wordlist is asciibetical, as required by the
L<WordList> convention. If you want to know the ranks of words by frequency, as
well as the scripts used to generate the result, see the C<devscripts/> and
C<work/> directories in the Git repository.

[1] https://id.wikipedia.org/wiki/Wikipedia:Wikipedia_bahasa_Indonesia_versi_luring

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 7.444 |
 | longest_word_len                 | 18    |
 | num_words                        | 5000  |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-ID-Common>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-ID-Common>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-ID-Common>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Islam
abad
abadi
abjad
abu
acak
acara
acuan
ada
adalah
adanya
adaptasi
adat
adegan
adik
adiknya
adil
adipati
administrasi
administratif
adu
agak
agama
agar
agen
agenda
agensi
agregat
agresif
agung
ah
ahli
air
airnya
aja
ajaib
ajang
ajaran
akademi
akademik
akademis
akademisi
akal
akan
akar
akhir
akhirnya
akibat
akibatnya
akrab
akreditasi
aksara
akses
aksi
aktif
akting
aktivis
aktivitas
aktor
aktris
aktual
aku
akun
akurat
ala
alam
alamat
alami
alasan
alat
album
albumnya
aliansi
alias
alih
aliran
alkitab
alkohol
almarhum
altar
alternatif
aluminium
alumni
alun
alur
amal
aman
amanat
amat
amatir
ambil
anak
anaknya
analisis
analog
ancaman
ancient
anda
andalan
aneh
aneka
anggap
anggaran
anggota
anggotanya
anggur
angin
angka
angkasa
angkat
angkatan
angkut
angkutan
animasi
anjing
anonim
antar
antara
antaranya
antarmuka
antena
anti
anugerah
apa
apabila
apakah
apalagi
apapun
aparat
apartemen
api
aplikasi
arah
arahan
aransemen
arca
area
areal
arena
argumen
arkeologi
armada
aroma
arsip
arsitek
arsitektur
artefak
arti
artikel
artikelnya
artileri
artinya
artis
artistik
arus
arwah
asa
asal
asalnya
asam
asap
asas
asasi
aset
asin
asing
asisten
asli
aslinya
asosiasi
aspek
asrama
asteroid
astronom
astronomi
asuhan
asumsi
asuransi
atap
atas
atasnya
atau
ataupun
atlet
atmosfer
atom
atribut
aturan
audio
audisi
auto
awak
awal
awalnya
awam
awan
ayah
ayahandanya
ayahnya
ayam
ayat
bab
babak
babi
baca
bacaan
badai
badan
badannya
bagaimana
bagaimanapun
bagi
bagian
baginya
bagus
bah
bahagia
bahan
bahasa
bahaya
bahkan
bahu
bahwa
baik
baiknya
bait
baja
bajak
baju
bakal
bakar
bakat
bakteri
bakti
baku
bala
balai
balap
balapan
balas
balasan
balik
baling
bambu
ban
band
bandar
bandara
banding
bandingkan
bangkit
bangku
bangsa
bangsawan
bangun
bangunan
banjar
banjir
bank
bantu
bantuan
banyak
banyaknya
bapak
bar
bara
barang
barat
baris
barisan
baru
barunya
basa
basah
basis
basket
bata
batang
batas
batasan
baterai
batik
batin
batu
batuan
bau
bawah
bawahan
bawahnya
bawang
bayangan
bayaran
bayi
beasiswa
beban
bebas
beberapa
beda
bedah
begitu
bekas
bekerja
bekerjasama
beku
bela
belah
belahan
belajar
belakang
belakangan
belakangnya
belanja
belas
beli
beliau
belum
benang
benar
bencana
benda
bendera
benih
bensin
benteng
bentuk
bentuknya
benua
bepergian
berabad
beracun
berada
berafiliasi
beragam
beragama
berakhir
berakhirnya
berakibat
beralamat
beralih
beraliran
beranggotakan
berangkat
berani
berapa
berapi
berarti
beras
berasal
berat
berawal
berbagai
berbagi
berbahan
berbahasa
berbahaya
berbakat
berbalik
berbasis
berbatasan
berbau
berbeda
berbentuk
berbicara
berbuat
berbunyi
berburu
bercampur
bercerai
bercerita
berdagang
berdampak
berdampingan
berdarah
berdasar
berdasarkan
berdaulat
berdekatan
berdiri
berdirinya
berdoa
berdosa
berdua
berdurasi
bereaksi
beredar
berenang
berencana
berevolusi
berfokus
berfungsi
bergabung
berganti
bergantian
bergantung
bergaya
bergelar
bergengsi
bergenre
bergerak
berguna
berhadapan
berhak
berhala
berharap
berharga
berhasil
berhenti
berhubungan
beri
berikan
berikut
berikutnya
beriman
berinteraksi
berisi
berisikan
beristirahat
berita
berjalan
berjalannya
berjanji
berjarak
berjasa
berjenis
berjuang
berjudul
berjumlah
berkaitan
berkala
berkali
berkantor
berkapasitas
berkarier
berkarya
berkas
berkat
berkata
berkebangsaan
berkedudukan
berkekuatan
berkelanjutan
berkeliling
berkembang
berkembangnya
berkenaan
berkewarganegaraan
berkisah
berkisar
berkolaborasi
berkomentar
berkompetisi
berkomunikasi
berkonsentrasi
berkontribusi
berkualitas
berkuasa
berkulit
berkumpul
berkunjung
berkurang
berlaga
berlaku
berlalu
berlangsung
berlanjut
berlari
berlatar
berlatih
berlawanan
berlayar
berlebihan
berlokasi
bermacam
bermain
bermakna
bermaksud
bermanfaat
bermarkas
bermasalah
bermata
bermatapencaharian
bermesin
bermigrasi
bermotor
bermuatan
bermukim
bermula
bermunculan
bernama
berniat
bernilai
bernomor
bernyanyi
beroperasi
berorientasi
berpakaian
berpangkat
berpartisipasi
berpasangan
berpendapat
berpenduduk
berpengalaman
berpengaruh
berperan
berperang
berpikir
berpindah
berpisah
berpori
berposisi
berpotensi
berprofesi
berpusat
berputar
bersahabat
bersaing
bersalah
bersama
bersamaan
bersamanya
bersambung
bersangkutan
bersatu
bersaudara
bersedia
bersejarah
bersekolah
bersekutu
bersembunyi
bersenjata
bersiap
bersifat
bersih
bersikap
berskala
berstatus
bersuku
bersumber
bersumpah
bertahan
bertahap
bertahun
bertajuk
bertambah
bertanding
bertanggung
bertani
bertanya
bertarung
bertekad
bertelur
bertema
berteman
bertempat
bertempur
bertemu
bertenaga
bertentangan
bertepatan
berteriak
bertindak
bertingkat
bertopik
bertugas
bertujuan
bertuliskan
berturut
berubah
berujung
berukuran
berulang
berumur
berupa
berupaya
berusaha
berusia
bervariasi
berwarna
berwenang
berwujud
besar
besaran
besarnya
beserta
besi
beta
betapa
betina
beton
betul
biara
biarawan
biasa
biasanya
biaya
bibir
bible
bicara
bidang
bijaksana
biji
bikin
bila
bilang
bilangan
bimbingan
binatang
bingung
bintang
binti
bintik
biografi
biola
biologi
biologis
bioskop
biru
bisa
bisnis
bit
bita
blok
blokir
bola
boleh
bom
boneka
bonus
botol
buah
buahan
buahnya
buang
buat
buatan
buatannya
bubar
bubuk
budak
budaya
budi
budidaya
buka
bukan
bukanlah
bukannya
bukit
bukti
buku
bukunya
bulan
bulanan
bulat
bulu
bumbu
bumi
bundar
bunga
bungsu
bunuh
bunyi
bupati
bursa
buruh
buruk
burung
bus
busana
busur
buta
butir
butuh
cabang
cacat
cadangan
cahaya
cair
cairan
cakram
cakupan
calon
campur
campuran
candi
canggih
cantik
cara
caranya
cari
cat
catatan
cedera
celah
celana
cendekiawan
cenderung
cepat
cerah
cerdas
cerita
ceritanya
cermin
cerpen
cetak
cetakan
cikal
cilik
cincin
cinta
cipta
ciptaan
ciri
cita
citra
coba
cocok
cokelat
coklat
contoh
contohnya
corak
cuaca
cucu
cukup
cuma
curah
dada
daerah
daerahnya
daftar
dagang
daging
dahulu
dakwah
dalam
dalamnya
dalang
damai
dampak
dan
dana
danau
dangdut
dangkal
dapat
dapur
darah
darat
daratan
dari
daring
darinya
daripada
darurat
dasar
dasarnya
dasawarsa
data
datang
datangnya
datar
dataran
daun
daur
daya
debat
debu
debut
debutnya
definisi
degradasi
dekade
dekat
dekatnya
delapan
delegasi
demam
demi
demikian
demo
demokrasi
demokratis
demonstrasi
den
dendam
dengan
dengannya
denominasi
depan
depannya
departemen
depresi
derajat
desa
desain
desainer
deskripsi
destinasi
detail
detik
dewa
dewan
dewasa
dewi
di
dia
diabadikan
diabaikan
diadakan
diadaptasi
diadopsi
diagram
diajak
diajarkan
diajukan
diakhiri
diakibatkan
diakses
diakui
dialami
dialek
dialihkan
dialog
diam
diamati
diambil
diameter
dianggap
diangkat
diangkut
dianjurkan
dianugerahi
dianut
diarahkan
diartikan
diasingkan
diatur
diawali
dibaca
dibagi
dibahas
dibakar
dibanding
dibandingkan
dibangun
dibantu
dibaptis
dibatalkan
dibatasi
dibawa
dibawakan
dibayar
dibebaskan
dibedakan
dibeli
dibentuk
diberhentikan
diberi
diberikan
diberlakukan
dibesarkan
dibiarkan
dibilang
dibintangi
diblokir
dibuang
dibuat
dibubarkan
dibuka
dibuktikan
dibunuh
dibutuhkan
dicabut
dicampur
dicantumkan
dicapai
dicari
dicatat
diceritakan
dicetak
diciptakan
diculik
didaftarkan
didampingi
didapat
didapati
didapatkan
didasarkan
didedikasikan
didefinisikan
didesain
dideskripsikan
dididik
didik
didirikan
didirikannya
didistribusikan
didominasi
didorong
diduduki
diduga
didukung
dieja
dieksekusi
diesel
difilmkan
digabung
digabungkan
digambarkan
diganti
digantikan
digelar
digit
digital
digolongkan
digunakan
dihadapi
dihadiri
dihancurkan
dihapus
dihapuskan
diharapkan
dihargai
diharuskan
dihasilkan
dihentikan
dihiasi
dihilangkan
dihitung
dihormati
dihubungkan
dihukum
dihuni
diidentifikasi
diikuti
diingat
diinginkan
diiringi
diisi
diizinkan
dijabat
dijadikan
dijadwalkan
dijaga
dijalankan
dijelaskan
dijual
dijuluki
dijumpai
dikabarkan
dikaitkan
dikalahkan
dikarenakan
dikaruniai
dikatakan
dikategorikan
dikelilingi
dikelola
dikelompokkan
dikeluarkan
dikembalikan
dikembangkan
dikemukakan
dikenakan
dikenal
dikenali
dikendalikan
dikepalai
dikerjakan
diketahui
diketuai
dikirim
dikirimkan
dikisahkan
diklaim
diklasifikasikan
dikonfirmasi
dikonsumsi
dikritik
dikuasai
dikumpulkan
dikunjungi
dikurangi
dikutip
dilahirkan
dilaksanakan
dilakukan
dilakukannya
dilalui
dilancarkan
dilangsungkan
dilanjutkan
dilantik
dilapisi
dilaporkan
dilarang
dilatih
dilayani
dilengkapi
dilepas
dilepaskan
diletakkan
dilewati
dilihat
dilindungi
diluncurkan
dimainkan
dimakamkan
dimakan
dimaksud
dimaksudkan
dimana
dimanfaatkan
dimasak
dimasukkan
dimekarkan
dimenangkan
dimengerti
dimensi
dimiliki
dimilikinya
diminta
dimodifikasi
dimuat
dimulai
dimulainya
dimungkinkan
dinamai
dinamakan
dinamika
dinamis
dinas
dinasti
dinding
dingin
dini
dinikmati
dinilai
dinobatkan
dinominasikan
dinyanyikan
dinyatakan
diolah
dioperasikan
dipahami
dipakai
dipaksa
dipamerkan
dipandang
dipanggil
dipasang
dipasarkan
dipastikan
dipecat
dipegang
dipelajari
dipengaruhi
dipenjara
dipentaskan
dipenuhi
diperankan
diperbaiki
diperbarui
diperbolehkan
dipercaya
diperdagangkan
diperdebatkan
dipergunakan
diperhatikan
diperiksa
diperingati
diperintah
diperintahkan
diperkenalkan
diperkirakan
diperkuat
diperlakukan
diperlihatkan
diperluas
diperlukan
diperoleh
diperpanjang
dipersembahkan
dipersiapkan
dipertahankan
dipertimbangkan
diperuntukkan
dipilih
dipimpin
dipindahkan
dipinjamkan
dipisahkan
diplomat
diplomatik
dipopulerkan
dipotong
diproduksi
diproduseri
dipromosikan
diproses
dipublikasikan
diputar
diputuskan
diragukan
diraih
dirancang
dirasakan
dirawat
dirayakan
direbut
direkam
direkrut
direktori
direktur
direncanakan
diresmikan
diri
dirilis
dirimu
dirintis
dirinya
disahkan
disajikan
disaksikan
disamakan
disambut
disampaikan
disarankan
disatukan
disebabkan
disebut
disebutkan
disediakan
disekitar
diselamatkan
diselenggarakan
diselesaikan
disepakati
diserahkan
diserang
diserap
disertai
disertakan
disesuaikan
disetujui
disiapkan
disiarkan
disimpan
disingkat
disiplin
diskusi
disponsori
distribusi
distributor
distrik
disukai
disunting
disusul
disusun
disutradarai
ditahan
ditahbiskan
ditaklukkan
ditambah
ditambahkan
ditampilkan
ditanam
ditandai
ditandatangani
ditangani
ditangkap
ditarik
ditawarkan
ditayangkan
ditebang
ditembak
ditempati
ditempatkan
ditempuh
ditemui
ditemukan
ditentang
ditentukan
diterapkan
diterbitkan
diterima
diterjemahkan
diteruskan
ditetapkan
ditimbulkan
ditinggalkan
ditingkatkan
ditinjau
ditolak
ditonton
dituduh
ditugaskan
ditujukan
ditulis
dituliskan
ditunda
ditunjuk
ditunjukkan
diturunkan
ditutup
ditutupi
dituturkan
diubah
diucapkan
diuji
diukur
diumumkan
diundang
diungkapkan
diusir
diusulkan
diutus
divisi
diwajibkan
diwakili
diwariskan
diyakini
doa
dokter
doktor
doktrin
dokumen
dokumentasi
dokumenter
dolar
domain
domba
domestik
dominan
dominasi
dong
dorongan
dosa
dosen
dot
drama
dramatis
drastis
drum
dua
duduk
duet
dugaan
dukuh
dukungan
dulu
dulunya
dunia
duri
dusun
duta
edisi
edit
editor
efek
efektif
efisien
efisiensi
ejaan
ekonomi
ekor
ekosistem
eks
eksekusi
eksekutif
eksklusif
ekspansi
ekspedisi
eksperimen
eksplisit
ekspor
ekspresi
eksternal
ekstra
ekstrakurikuler
ekstrem
elektrik
elektron
elektronik
elemen
elit
email
emas
emisi
emosi
emosional
empat
enak
enam
energi
enggan
engkau
ensiklopedi
ensiklopedia
entah
entitas
entri
enzim
episode
era
erat
esai
etanol
etika
etnis
evaluasi
even
evolusi
faksi
fakta
faktor
fakultas
famili
fase
fasilitas
fauna
favorit
featuring
federal
fenomena
festival
figur
fiksi
film
filmnya
filmografi
filosofi
filsafat
filsuf
filter
filum
final
finalis
finansial
firman
fisik
fisika
fisikawan
fitur
fleksibel
flight
fokus
form
formal
formasi
format
formula
forum
fosil
foto
fotografer
fotografi
fragmen
fraksi
frasa
frekuensi
fungsi
fungsinya
fungsional
gabungan
gadis
gagal
gagasan
gajah
gaji
galaksi
galeri
gambar
gambaran
gamelan
ganda
gandum
gangguan
ganti
gantinya
garam
garis
gas
gawang
gaya
gedung
gejala
gelap
gelar
gelombang
gembira
gempa
gen
gencatan
gender
general
generasi
genetik
geng
genggam
genre
genus
geografi
geografis
geologi
gerak
gerakan
gerbang
gerbong
gereja
gigi
gila
ginjal
gitar
gitaris
gizi
global
gol
golongan
goreng
grafik
grafis
gram
gratis
gravitasi
grup
gua
gubernur
gudang
gugur
gugus
guitar
gula
gulungan
guna
gunakan
gunung
guru
gurun
gurunya
habis
habitat
habitatnya
hadapan
hadiah
hadir
hadis
hadits
haji
hak
hakim
hal
halaman
halamannya
halnya
halus
hama
hamba
hambatan
hamil
hampir
hancur
handal
hangat
hantu
hanya
hanyalah
hapus
harapan
harfiah
harga
hari
harian
harimau
harinya
harta
harus
haruslah
hasil
hasilnya
hati
hatinya
hebat
hektar
helikopter
hendak
heran
hewan
hias
hiasan
hiburan
hidangan
hidrogen
hidung
hidup
hidupnya
hijau
hijrah
hilang
hilangnya
hilir
himpunan
hingga
hipotesis
historis
hitam
hiu
hobi
horizontal
hormat
hormon
horor
hotel
however
hubungan
hubungannya
hujan
hukum
hukuman
hulu
huruf
hutan
hutang
ia
ialah
ibadah
ibu
ibukota
ibunya
ide
ideal
identifikasi
identik
identitas
ideologi
idola
ikan
ikatan
iklan
iklim
ikon
ikut
ilahi
ilegal
ilmiah
ilmu
ilmuwan
ilustrasi
imam
iman
imbang
imigran
implementasi
impor
inci
indah
indeks
independen
indikator
individu
individual
indonesia
induk
industri
infeksi
informal
informasi
infrastruktur
ingat
ingatan
inggris
ingin
ini
inilah
inisiatif
inovasi
insiden
insinyur
inspirasi
instalasi
instansi
insting
institusi
instruksi
instrumen
instrumental
integrasi
intelektual
intelijen
intensif
intensitas
interaksi
interaktif
interior
internal
internasional
internet
interpretasi
intervensi
interview
inti
invasi
investasi
investigasi
investor
ion
irama
irigasi
isi
isinya
istana
isteri
istiadat
istilah
istimewa
istirahat
istri
istrinya
isu
isyarat
item
itu
itulah
izin
jabatan
jabatannya
jadi
jadwal
jagung
jahat
jajahan
jajaran
jalan
jalanan
jalannya
jalur
jam
jamaah
jamak
jaman
jaminan
jamur
janda
jangan
janganlah
jangka
jangkauan
janji
jantan
jantung
jarak
jarang
jari
jaringan
jarum
jasa
jasanya
jati
jatuh
jatuhnya
jauh
jawa
jawab
jawaban
jejak
jejaring
jelas
jemaat
jembatan
jenazah
jendela
jenderal
jenis
jenjang
jeruk
jet
jika
jilid
jin
jiwa
jual
juara
judul
juga
jujur
julukan
jumlah
jumlahnya
junior
juniornya
juri
jurnal
jurnalis
juru
jurus
jurusan
justru
juta
jutaan
kabar
kabel
kabin
kabinet
kabupaten
kabur
kaca
kacang
kadang
kadar
kader
kafir
kain
kaisar
kaitannya
kajian
kakak
kakaknya
kakek
kakeknya
kaki
kakinya
kaku
kala
kalah
kalangan
kalau
kalender
kali
kalian
kaliber
kalimat
kalinya
kalo
kamar
kambing
kamera
kami
kamp
kampanye
kampung
kampus
kamu
kamus
kan
kanak
kanal
kanan
kandang
kandangnya
kandidat
kandung
kandungan
kanker
kanon
kantong
kantor
kapal
kapan
kapasitas
kapten
karakter
karakteristik
karang
karangan
karbon
karena
karenanya
karet
kargo
karier
kariernya
kartu
kartun
karunia
karya
karyanya
karyawan
kasar
kaset
kasih
kastil
kasus
kata
katalog
katanya
kategori
kau
kaum
kawah
kawan
kawasan
kawat
kawin
kaya
kayu
ke
keadaan
keadilan
keagamaan
keahlian
keamanan
keanggotaan
kebahagiaan
kebaikan
kebakaran
kebanggaan
kebangkitan
kebangsaan
kebanyakan
kebebasan
kebenaran
keberadaan
keberadaannya
keberangkatan
keberanian
keberatan
keberhasilan
kebetulan
kebiasaan
kebijakan
kebijaksanaan
kebingungan
kebudayaan
kebun
kebutuhan
kecamatan
kecantikan
kecelakaan
kecenderungan
kecepatan
kecerdasan
kecewa
kecil
kecilnya
kecuali
kedalaman
kedatangan
kedaulatan
kedelapan
kediaman
kedokteran
kedua
keduanya
kedudukan
kedutaan
keemasan
keempat
keenam
keesokan
kegagalan
kegelapan
kegiatan
kegunaan
kehadiran
kehamilan
kehancuran
kehendak
kehidupan
kehidupannya
kehilangan
kehormatan
keilmuan
keindahan
keinginan
keinginannya
kejadian
kejahatan
kejam
kejatuhan
kejayaan
keju
kejuaraan
kekacauan
kekaisaran
kekal
kekalahan
kekasih
kekasihnya
kekayaan
kekerasan
kekhawatiran
kekuasaan
kekuasaannya
kekuatan
kekuatannya
kekurangan
kelahiran
kelahirannya
kelainan
kelak
kelamin
kelanjutan
kelapa
kelaparan
kelas
kelayakan
kelebihan
kelemahan
kelenjar
kelihatan
keliling
kelima
keliru
kelompok
keluar
keluaran
keluarga
keluarganya
kelurahan
kemajuan
kemakmuran
kemampuan
kemampuannya
kemanusiaan
kemarahan
kemarau
kemasan
kemasyarakatan
kematian
kematiannya
kembali
kembalinya
kembang
kembar
kemenangan
kementerian
kemerahan
kemerdekaan
kemiripan
kemiskinan
kemudahan
kemudian
kemunculan
kemungkinan
kenaikan
kenal
kenangan
kenapa
kendali
kendaraan
kental
kenyataan
kenyataannya
kepada
kepadamu
kepadanya
kepadatan
kepala
kepalanya
kepausan
kepemilikan
kepemimpinan
kepemimpinannya
kepengurusan
kepentingan
kepercayaan
keperluan
keping
kepolisian
keponakan
keponakannya
kepribadian
kepulauan
keputusan
kerabat
kerajaan
kerajaannya
kerajinan
keramik
kerangka
kerap
keras
keraton
kerbau
kereta
kering
keris
kerja
kerjanya
kerjasama
kertas
kerugian
kerusakan
kerusuhan
kesadaran
kesaksian
kesal
kesalahan
kesamaan
kesan
kesatuan
kesehatan
keseimbangan
kesejahteraan
keselamatan
keseluruhan
kesembilan
kesempatan
kesenian
kesepakatan
kesepuluh
kesetiaan
kesimpulan
kesuksesan
kesulitan
kesultanan
ketakutan
ketat
ketegangan
ketentuan
keterampilan
keterangan
keterbatasan
keterlibatan
ketertarikan
ketiga
ketiganya
ketika
ketimbang
ketinggian
ketua
ketujuh
keturunan
keturunannya
keuangan
keunggulan
keuntungan
keuskupan
kewajiban
kewarganegaraan
kewenangan
keyakinan
khalayak
khalifah
khas
khawatir
khusus
khususnya
kian
kilometer
kimia
kinerja
kini
kira
kiri
kisah
kisaran
kita
kitab
klaim
klan
klasemen
klasifikasi
klasik
klien
klik
klinik
klip
klub
koalisi
kode
koin
kok
kokoh
kolaborasi
kolam
koleksi
kolektif
kolom
koloni
kolonial
komandan
komando
kombinasi
komedi
komentar
komentator
komersial
komik
komisi
komite
komitmen
komoditas
kompas
kompetensi
kompetisi
kompetitif
kompilasi
komplek
kompleks
komponen
komponis
komposer
komposisi
komputer
komune
komunikasi
komunis
komunitas
kondisi
koneksi
konferensi
konfigurasi
konflik
kongres
konon
konsekuensi
konsensus
konsentrasi
konsep
konser
konservasi
konservatif
konsisten
konsonan
konstan
konstitusi
konstitusional
konstruksi
konsultan
konsumen
konsumsi
kontak
konteks
kontemporer
konten
kontes
kontestan
kontrak
kontribusi
kontributor
kontrol
kontroversi
kontroversial
konvensi
konvensional
konversi
koordinasi
koordinat
kopi
koran
korban
korupsi
kosakata
kosong
kostum
kota
kotak
kotamadya
kotanya
kotor
kotoran
kreatif
kredit
krim
kriminal
krisis
kristal
kriteria
kritik
kritikus
kritis
kru
ksatria
ku
kualifikasi
kualitas
kuantitas
kuantum
kuasa
kuat
kubah
kubu
kuburan
kucing
kuda
kudeta
kudus
kue
kuil
kuliah
kuliner
kulit
kultur
kumbang
kumpulan
kunci
kuning
kunjungan
kuno
kupu
kura
kurang
kurangnya
kurikulum
kursi
kursus
kurun
kutipan
kutub
kutukan
laba
label
laboratorium
ladang
laga
lagi
lagu
lagunya
lah
lahan
lahir
lahirnya
lain
lainnya
laju
laki
lakinya
laku
lakukan
lalat
lalu
lama
lamanya
lambang
lambat
lambung
lampau
lampu
lancar
landas
landasan
langit
langka
langkah
langsung
lanjut
lanjutan
lantai
lantas
lap
lapangan
lapis
lapisan
laporan
larangan
lari
laris
larut
larutan
larva
las
laser
latar
latihan
latin
laut
lautan
lawan
lawannya
layak
layaknya
layanan
layang
layar
layer
lazim
lebar
lebat
lebih
ledakan
legal
legenda
legendaris
legislatif
leher
lelaki
leluhur
lemah
lemak
lembab
lembaga
lembah
lembap
lembar
lembaran
lembut
lempeng
lengan
lengkap
lengkapnya
lensa
lepas
lereng
les
letak
letaknya
letusan
level
lewat
liar
liat
liberal
libur
liburan
lidah
liga
lihat
lilin
lima
limbah
linear
lingkaran
lingkungan
lingkup
linguistik
links
lintas
lintasan
lipat
lirik
lisan
lisensi
listrik
liter
literatur
liturgi
location
log
logam
logika
logistik
logo
lokal
lokasi
lokasinya
lokomotif
lolos
lomba
luar
luas
luasnya
lubang
lucu
luka
lukisan
lulus
lulusan
lumpur
lunak
lupa
lurus
maaf
mabuk
macam
madrasah
madu
magnet
mahal
mahasiswa
mahir
mahkota
main
mainan
majalah
majelis
maju
maka
makalah
makam
makan
makanan
makanannya
makhluk
makin
makmur
makna
maksimal
maksimum
maksud
maksudnya
malah
malaikat
malam
malu
mamalia
mampu
mana
manajemen
manajer
manapun
mancanegara
mandi
mandiri
manfaat
manga
manis
mantan
mantra
manual
manufaktur
manusia
manuskrip
map
marah
marga
markas
market
mas
masa
masak
masakan
masalah
masanya
masih
masing
masjid
maskapai
massa
massal
master
masuk
masukan
masuknya
masyarakat
masyarakatnya
mata
matahari
matang
matanya
matematika
materi
material
mati
mau
maupun
maya
mayat
mayor
mayoritas
mazhab
medali
medan
media
medis
medium
megah
meja
mekanik
mekanisme
melahirkan
melainkan
melaju
melaksanakan
melakukan
melakukannya
melalui
melambangkan
melampaui
melancarkan
melanda
melanggar
melanjutkan
melaporkan
melarang
melarikan
melatih
melawan
melayani
melebihi
meledak
melekat
melengkapi
melengkung
melepas
melepaskan
melestarikan
meletakkan
meletus
melewati
melibatkan
melihat
melihatnya
melimpah
melindungi
melingkar
melintas
melintasi
meliputi
melompat
meluas
melukai
melukis
meluncurkan
melupakan
memadai
memahami
memainkan
memajukan
memakai
memakan
memaksa
memancing
memandang
memanfaatkan
memang
memanggil
memanjang
memantau
memasak
memasang
memastikan
memasuki
memasukkan
mematikan
membaca
membagi
membahas
membahayakan
membakar
membalas
membandingkan
membangkitkan
membangun
membantah
membantu
membantunya
membatalkan
membatasi
membawa
membawahi
membawakan
membawanya
membayar
membebaskan
membedakan
membela
membeli
membenci
membentang
membentuk
memberi
memberikan
memberikannya
memberinya
memberitahu
memberitahukan
memberontak
membersihkan
membiarkan
membiayai
membicarakan
membina
membintangi
membran
membuang
membuat
membuatnya
membubarkan
membujuk
membuka
membuktikan
membunuh
membunuhnya
memburuk
membutuhkan
memecah
memecahkan
memegang
memelihara
memeluk
memenangi
memenangkan
memengaruhi
memenuhi
memerangi
memerankan
memeriksa
memerintah
memerintahkan
memerlukan
memfasilitasi
memicu
memikirkan
memilih
memiliki
memimpin
memindahkan
meminta
memisahkan
memohon
memori
memotong
mempekerjakan
mempelajari
mempengaruhi
memperbaiki
memperbolehkan
mempercayai
mempercepat
memperebutkan
memperhatikan
memperingati
memperingatkan
memperjuangkan
memperkenalkan
memperkirakan
memperkuat
memperlihatkan
memperluas
mempermudah
memperoleh
memperpanjang
mempersembahkan
mempersiapkan
mempertahankan
mempertanyakan
mempertimbangkan
memproduksi
mempromosikan
mempublikasikan
mempunyai
memuaskan
memuat
memudahkan
memuji
memukul
memulai
memulihkan
memuncak
memunculkan
memungkinkan
memutar
memutuskan
menabrak
menahan
menaiki
menaikkan
menaklukkan
menamai
menamakan
menamatkan
menambah
menambahkan
menampilkan
menampung
menanam
menandai
menandakan
menandatangani
menang
menangani
menanggapi
menangis
menangkap
menantang
menanyakan
menara
menari
menarik
menaruh
menawarkan
menayangkan
mencabut
mencakup
mencalonkan
mencantumkan
mencapai
mencari
mencatat
mencegah
menceritakan
mencerminkan
mencetak
mencintai
menciptakan
mencoba
mencolok
mencuri
mendadak
mendaftar
mendaftarkan
mendalam
mendampingi
mendapat
mendapati
mendapatkan
mendarat
mendasar
mendatang
mendatangi
mendatangkan
mendefinisikan
mendekati
mendeklarasikan
mendengar
mendengarkan
menderita
mendesak
mendeskripsikan
mendeteksi
mendiami
mendidik
mendirikan
mendominasi
mendorong
menduduki
menduga
mendukung
menegakkan
menegaskan
menekan
menekankan
menelan
meneliti
menemani
menembak
menembus
menempati
menempatkan
menempel
menempuh
menemui
menemukan
menengah
menentang
menentukan
menerapkan
menerbitkan
menerima
menerjemahkan
menerus
meneruskan
menetap
menetapkan
menewaskan
mengabaikan
mengabdi
mengacu
mengadakan
mengadopsi
mengajak
mengajar
mengajarkan
mengajukan
mengakhiri
mengakibatkan
mengakses
mengaku
mengakui
mengakuisisi
mengalahkan
mengalami
mengalihkan
mengalir
mengamankan
mengamati
mengambil
menganalisis
mengancam
mengandalkan
mengandung
menganggap
menganggapnya
mengangkat
mengangkut
menganjurkan
mengantarkan
menganut
mengapa
mengarah
mengarahkan
mengatakan
mengatasi
mengatur
mengawali
mengawasi
mengebor
mengejar
mengejutkan
mengekspresikan
mengelilingi
mengelola
mengeluarkan
mengembalikan
mengemban
mengembangkan
mengemukakan
mengenai
mengenakan
mengenal
mengenali
mengenang
mengendalikan
mengendarai
mengerikan
mengerjakan
mengerti
mengetahui
menggabungkan
menggali
menggambar
menggambarkan
mengganggu
mengganti
menggantikan
menggantikannya
menggelar
menggerakkan
menggulingkan
menggunakan
menggunakannya
menghabiskan
menghadap
menghadapi
menghadiri
menghadirkan
menghalangi
menghambat
menghancurkan
menghapus
mengharapkan
menghargai
mengharuskan
menghasilkan
menghentikan
menghibur
menghidupkan
menghilang
menghilangkan
menghindari
menghitung
menghormati
menghubungi
menghubungkan
menghukum
menghuni
mengidentifikasi
mengikat
mengikuti
mengindikasikan
mengingat
mengingatkan
menginginkan
mengira
mengirim
mengirimkan
mengisahkan
mengisi
mengizinkan
mengkhususkan
mengklaim
mengkritik
mengobati
mengolah
mengontrol
mengoperasikan
mengorbankan
mengorbit
menguasai
mengubah
mengucapkan
mengudara
menguji
mengukur
mengumpulkan
mengumumkan
mengundang
mengundurkan
mengungkapkan
mengungsi
mengunjungi
menguntungkan
mengurangi
mengurus
mengurusi
mengusir
mengusulkan
mengusung
mengutamakan
mengutip
mengutuk
mengutus
menikah
menikahi
menikmati
menilai
menimbulkan
menimpa
meninggal
meninggalkan
meningkat
meningkatkan
meningkatnya
meniru
menit
menjabat
menjadi
menjadikan
menjadikannya
menjaga
menjalani
menjalankan
menjalin
menjamin
menjangkau
menjanjikan
menjatuhkan
menjawab
menjelang
menjelaskan
menjual
menjuarai
menolak
menolong
menonjol
menonton
mentah
mental
menteri
menu
menuai
menuduh
menuju
menulis
menuliskan
menumbuhkan
menunda
menunggu
menunjang
menunjuk
menunjukkan
menuntut
menurun
menurunkan
menurut
menurutnya
menutup
menutupi
menuturkan
menyadari
menyajikan
menyaksikan
menyamar
menyambut
menyampaikan
menyandang
menyangkal
menyangkut
menyanyi
menyanyikan
menyarankan
menyatakan
menyatu
menyatukan
menyebabkan
menyebar
menyebarkan
menyeberangi
menyebut
menyebutkan
menyebutnya
menyediakan
menyelamatkan
menyelenggarakan
menyelesaikan
menyelidiki
menyeluruh
menyembah
menyembuhkan
menyembunyikan
menyenangkan
menyentuh
menyerah
menyerahkan
menyerang
menyerap
menyerbu
menyertakan
menyerukan
menyerupai
menyesuaikan
menyetujui
menyewa
menyiapkan
menyiarkan
menyimpan
menyimpulkan
menyingkirkan
menyukai
menyumbang
menyumbangkan
menyunting
menyuruh
menyusul
menyusun
menyutradarai
merah
meraih
merancang
merangkap
merantau
merasa
merasakan
merata
merawat
merayakan
merdeka
merebut
merek
mereka
merekam
merekrut
merencanakan
merger
meriam
merilis
merintis
merugikan
merujuk
merumuskan
merupakan
merusak
mesin
meski
meskipun
meta
metadata
metal
meter
metode
metro
metropolitan
mewah
mewakili
mewarisi
mewujudkan
meyakini
meyakinkan
migrasi
mikro
mil
miliar
milik
miliki
miliknya
militan
militer
mimpi
minat
mineral
minggu
mingguan
mini
minimal
minimum
minor
minoritas
minta
minum
minuman
minyak
miring
mirip
misal
misalnya
misi
misionaris
miskin
misteri
misterius
mitologi
mitos
mitra
mobil
modal
mode
model
modern
modifikasi
modul
mohon
mol
molekul
momen
monarki
monster
monumen
monyet
moral
motif
motivasi
motor
motto
moyang
mu
muara
muatan
muda
mudah
mudanya
muka
mula
mulai
mulanya
mulia
multi
multimedia
mulut
muncul
munculnya
mundur
mungkin
munisipalitas
murah
murid
muridnya
murni
museum
musik
musikal
musiknya
musim
musisi
muslim
musuh
musuhnya
musyawarah
mutasi
mutlak
mutu
nabi
nada
nafsu
naga
nagari
naik
nama
namanya
namun
nan
nanti
nantinya
napas
narkoba
nasa
nasi
nasib
nasihat
nasional
nasionalis
naskah
natural
naungan
navigasi
nebula
negara
negaranya
negatif
negeri
negosiasi
nelayan
nenek
netral
newspaper
niat
nih
nilai
nitrogen
nol
nominasi
nomor
norma
normal
novel
nuklir
nusa
nusantara
nutrisi
nyaman
nyanyian
nyaris
nyata
nyawa
obat
obatan
objek
oksida
oksidasi
oksigen
olah
olahraga
oleh
olehnya
open
opera
operasi
operasional
operator
opini
oposisi
opsi
optik
optimal
orang
orangtua
orangtuanya
orbit
orbital
order
ordo
organ
organik
organisasi
organisme
orientasi
original
orkestra
otak
otomatis
otomotif
otonom
otonomi
otoritas
otot
pabrik
pacar
pacarnya
pacu
pada
padahal
padang
padanya
padat
padi
paduan
pagar
pagi
paham
pahlawan
pajak
pakai
pakaian
pakar
paket
paksa
paku
paling
palsu
paman
pamannya
pameran
panah
panas
pandai
pandang
pandangan
panduan
panel
panen
pangan
pangeran
panggilan
panggung
pangkal
pangkalan
pangkat
panglima
panitia
panjang
panjangnya
panorama
pantai
pantas
papan
par
para
parah
paralel
parameter
params
parasit
parit
pariwisata
parkir
parlemen
paroki
partai
partikel
partisipasi
party
paru
paruh
pas
pasal
pasang
pasangan
pasar
pasaran
pasca
pasien
pasir
pasokan
pasti
pastor
pasukan
pasukannya
patah
paten
patroli
patung
patut
paus
payung
pecah
pecahan
pecinta
pedagang
pedalaman
pedang
pedas
pedesaan
pedoman
peduli
pegawai
pegulat
pegunungan
pejabat
pejuang
pekan
pekerja
pekerjaan
pekerjaannya
pelabuhan
pelajar
pelajaran
pelaksana
pelaksanaan
pelaku
pelanggan
pelanggaran
pelarut
pelatih
pelatihan
pelaut
pelawak
pelayan
pelayanan
pelayaran
peliharaan
pelindung
pelindungan
pelopor
peluang
pelukis
peluncuran
peluru
pemahaman
pemain
pemainnya
pemakai
pemakaian
pemakaman
pemanasan
pemancar
pemandangan
pemanfaatan
pemasangan
pemasaran
pembaca
pembacaan
pembagian
pembahasan
pembakaran
pembalap
pembangkit
pembangunan
pembantaian
pembantu
pembaruan
pembatasan
pembawa
pembayaran
pembebasan
pembelajaran
pembeli
pembelian
pembentukan
pemberi
pemberian
pemberontak
pemberontakan
pembicara
pembicaraan
pembinaan
pemblokiran
pembuangan
pembuat
pembuatan
pembuka
pembukaan
pembuluh
pembunuh
pembunuhan
pemburu
pemegang
pemekaran
pemeliharaan
pemenang
pementasan
pemeran
pemeriksaan
pemerintah
pemerintahan
pemerintahannya
pemikiran
pemilih
pemilihan
pemilik
pemilu
pemimpin
pemindahan
pemirsa
pemisahan
pemrograman
pemuda
pemujaan
pemukiman
pemulihan
pemungutan
pemusik
penafsiran
penaklukan
penalti
penamaan
penambahan
penampilan
penampilannya
penanaman
penanda
penanganan
penangkapan
penari
penasihat
penataan
penawaran
penayangan
pencaharian
pencapaian
pencari
pencarian
pencegahan
pencipta
penciptaan
pendaftaran
pendahulu
pendahulunya
pendanaan
pendapat
pendapatan
pendaratan
pendatang
pendek
pendekatan
pendengar
penderita
penderitaan
pendeta
pendidik
pendidikan
pendidikannya
pendiri
pendirian
penduduk
pendudukan
penduduknya
pendukung
pendukungnya
penekanan
peneliti
penelitian
penempatan
penemu
penemuan
penentuan
penerangan
penerapan
penerbang
penerbangan
penerbit
penerbitan
penerima
penerimaan
penerjemah
penerjemahan
penerus
penetapan
pengabdian
pengacara
pengadaan
pengadilan
pengajar
pengajaran
pengakuan
pengalaman
pengalihan
pengamat
pengamatan
pengambilan
pengangkatan
penganiayaan
pengantar
pengantin
penganut
pengarang
pengaruh
pengaruhnya
pengasingan
pengaturan
pengawal
pengawas
pengawasan
pengeboman
pengecualian
pengelola
pengelolaan
pengeluaran
pengembang
pengembangan
pengenalan
pengendali
pengendalian
pengepungan
pengertian
pengetahuan
penggabungan
penggalian
penggambaran
pengganti
penggantian
penggantinya
penggemar
penggerak
pengguna
penggunaan
penggunaannya
penggunanya
penghapusan
penghargaan
penghasil
penghasilan
penghormatan
penghubung
penghuni
pengikut
pengikutnya
pengiriman
pengisi
pengisian
penglihatan
pengobatan
pengolahan
penguasa
penguasaan
pengucapan
pengujian
pengukuran
pengumpulan
pengumuman
pengundian
pengunduran
pengungsi
pengunjung
pengurangan
pengurus
pengusaha
penilaian
penindasan
peninggalan
peningkatan
penjaga
penjahat
penjajah
penjajahan
penjara
penjelajah
penjelasan
penjual
penjualan
penjuru
penolakan
penonton
pensiun
pentas
penting
pentingnya
penuh
penulis
penulisan
penumpang
penunjang
penurunan
penutup
penutupan
penutur
penyair
penyajian
penyakit
penyanyi
penyatuan
penyebab
penyebaran
penyedia
penyediaan
penyelamatan
penyelenggara
penyelenggaraan
penyelesaian
penyelidikan
penyembuhan
penyerahan
penyerang
penyerangan
penyiar
penyiaran
penyihir
penyimpanan
penyisihan
penyunting
penyuntingan
penyusunan
peperangan
peradaban
peradilan
perahu
peraih
perairan
perak
peralatan
peralihan
peran
peranan
perancang
perang
perangkat
perannya
perantara
perasaan
peraturan
perawatan
perayaan
perbaikan
perbandingan
perbankan
perbatasan
perbedaan
perbelanjaan
perbuatan
perbudakan
perbukitan
percakapan
percaya
percobaan
perdagangan
perdamaian
perdana
perdananya
perdebatan
perebutan
perekonomian
perempat
perempuan
perempuannya
perencanaan
perfilman
performa
performance
pergantian
pergerakan
pergi
perguruan
perhatian
perhiasan
perhitungan
peri
perikanan
perilaku
perilisan
peringatan
peringkat
perintah
perintis
periode
periodik
perisai
peristiwa
perjalanan
perjalanannya
perjanjian
perjuangan
perkampungan
perkantoran
perkara
perkataan
perkawinan
perkebunan
perkelahian
perkemahan
perkembangan
perkembangannya
perkiraan
perkotaan
perkumpulan
perlahan
perlakuan
perlawanan
perlengkapan
perlindungan
perlombaan
perlu
perluasan
permainan
permaisuri
permanen
permasalahan
permintaan
permohonan
permukaan
permukiman
permulaan
pernah
pernikahan
pernikahannya
pernyataan
perolehan
perorangan
perpaduan
perpanjangan
perpecahan
perpindahan
perpustakaan
pers
persahabatan
persaingan
persamaan
persatuan
persawahan
persediaan
persegi
persekutuan
perselisihan
persembahan
persen
persenjataan
persentase
persepsi
persetujuan
persiapan
persilangan
persimpangan
persis
persoalan
person
personal
personel
personil
perspektif
persyaratan
pertahanan
pertama
pertamanya
pertambangan
pertandingan
pertanian
pertanyaan
pertarungan
pertempuran
pertemuan
pertengahan
pertimbangan
pertolongan
pertukaran
pertumbuhan
pertunjukan
perubahan
perumahan
perundingan
perunggu
perusahaan
perusak
perut
perwakilan
perwira
perwujudan
pesan
pesanan
pesantren
pesat
pesawat
pesepak
peserta
pesisir
pesta
peta
petani
peternakan
peti
petualangan
petugas
petunjuk
pewaris
pewarna
pi
piala
piano
pidana
pidato
pihak
pikir
pikiran
pilar
pilih
pilihan
pilot
pimpin
pimpinan
pindah
pinggir
pinggiran
pinjaman
pintar
pintu
pipa
piringan
pisang
pisau
pistol
pita
planet
plasma
plastik
plat
platform
play
plot
plus
pohon
poin
pokok
pola
polisi
politik
politiknya
politikus
politis
politisi
pon
pondok
ponsel
pop
popular
popularitas
populasi
populer
poros
portal
pos
posisi
posisinya
positif
potensi
potensial
potong
potongan
potret
prajurit
praktik
praktis
praktisi
pranala
prasarana
prasasti
predator
predikat
presenter
presiden
prestasi
pria
pribadi
pribadinya
pribumi
primer
primordial
prinsip
prioritas
pro
problem
producer
produk
produksi
produksinya
produktif
produsen
produser
profesi
profesional
profesor
profil
program
promosi
propaganda
properti
propinsi
proposal
prosedur
proses
prosesor
protein
protes
protokol
proton
prototipe
provinsi
proyek
psikologi
psikologis
puas
puasa
public
publik
publikasi
pucat
puisi
pujian
pukul
pukulan
pula
pulang
pulau
pulih
puluh
puluhan
pun
punah
puncak
puncaknya
punggung
punya
pupuk
pura
purba
pusaka
pusat
pustaka
putaran
putera
puteri
putih
putra
putranya
putri
putrinya
putus
putusan
racun
radar
radiasi
radikal
radio
radius
ragam
ragu
rahasia
raja
raksasa
rakyat
rakyatnya
ramah
ramai
rambut
ranah
rancangan
rangka
rangkaian
rantai
ranting
rapat
rapi
ras
rasa
rasanya
rasi
rasio
rasul
rata
rating
ratu
ratus
ratusan
rawa
rawan
raya
reaksi
reaktor
real
realitas
redaksi
referendum
referensi
reformasi
region
regional
registrasi
regular
regulasi
reguler
rekaman
rekan
rekannya
rekayasa
rekomendasi
rekor
rekreasi
rektor
rel
rela
relasi
relatif
relevan
relief
religius
remaja
rempah
renang
rencana
rencananya
rendah
renovasi
rentan
rentang
reporter
representasi
reproduksi
republik
republika
reputasi
reruntuhan
resep
resmi
resminya
resolusi
respon
restoran
review
revisi
revolusi
revolusioner
rezim
ribu
ribuan
rilis
rinci
rincian
ringan
rintisan
riset
risiko
ritual
rival
riwayat
robot
roda
roh
rohani
roket
rokok
roman
romantis
rombongan
ronde
rongga
rotasi
roti
ruang
ruangan
ruas
rudal
rujukan
rumah
rumahnya
rumit
rumpun
rumput
rumus
runtuh
rupa
rupanya
rupiah
rusak
rute
rutin
saat
sabda
sabuk
sadar
sah
sahabat
sahabatnya
saham
saingan
sains
saja
sajak
sakit
saksi
sakti
salah
salam
salat
salib
salinan
saling
salju
saluran
sama
sambil
sambutan
sampah
sampai
sampel
samping
sampul
samurai
sana
sandi
sandiwara
sang
sangat
sangatlah
sanggup
sanksi
santri
sapi
saraf
saran
sarana
sarang
sari
sarjana
sasaran
sastra
sastrawan
satelit
satu
satuan
satunya
satupun
saudara
saudaranya
saudari
saus
sawah
sawit
saya
sayang
sayangnya
sayap
sayur
sayuran
seakan
sebab
sebagai
sebagaimana
sebagainya
sebagian
sebaiknya
sebaliknya
sebanding
sebanyak
sebelah
sebelas
sebelum
sebelumnya
sebenarnya
sebentar
seberang
seberapa
sebesar
sebuah
sebulan
sebut
sebutan
secara
sedang
sedangkan
sedemikian
sederajat
sederhana
sedih
sedikit
sedikitnya
sedimen
seekor
segala
segar
segenap
segera
segi
segitiga
segmen
seharga
sehari
seharusnya
sehat
sehingga
sehubungan
seimbang
seiring
sejajar
sejak
sejalan
sejarah
sejarahnya
sejarawan
sejati
sejauh
sejenis
sejuk
sejumlah
sekadar
sekali
sekaligus
sekalipun
sekarang
sekeliling
sekelompok
sekian
sekitar
sekitarnya
sekolah
sekolahnya
sekretaris
seks
seksi
seksual
sekte
sektor
sekuel
sekuler
sekumpulan
sekunder
sekutu
sel
selain
selaku
selalu
selam
selama
selamanya
selamat
selanjutnya
selatan
selebriti
seleksi
selesai
seluas
seluler
seluruh
seluruhnya
semacam
semak
semakin
semangat
semasa
semata
sembilan
sembuh
semen
semenanjung
semenjak
sementara
semesta
semester
semi
semifinal
seminar
seminggu
semiperairan
sempat
sempit
sempurna
semua
semuanya
semula
senang
senantiasa
senapan
sendiri
sendirian
sengaja
sengit
sengketa
seni
senilai
seniman
senior
seniornya
senjata
sensitif
sensor
sensus
sentral
senyawa
seolah
seorang
sepak
sepakat
sepanjang
separuh
sepasang
sepatu
sepeda
sepenuhnya
seperti
sepertiga
sepertinya
sepuluh
sepupu
sepupunya
seputar
seragam
serangan
serangga
serangkaian
serat
seratus
serba
seri
serial
seribu
serikat
sering
seringkali
serius
serta
sertifikasi
sertifikat
serupa
server
sesaat
sesama
seseorang
sesi
sesuai
sesuatu
sesudah
sesungguhnya
set
setahun
setan
setara
setelah
setelahnya
setempat
setengah
seterusnya
setia
setiap
setidaknya
setinggi
setingkat
setuju
seumur
sewa
sewaktu
shift
si
sia
siang
siap
siapa
siapapun
siaran
sibuk
sidang
sifat
sifatnya
signifikan
sih
sihir
sikap
siklus
silakan
silang
silat
silinder
silsilah
simbol
sinar
sinema
sinetron
singa
singel
singgah
singkat
singkatan
sini
sintesis
sinyal
sipil
sirip
sirkuit
sisa
sisanya
sisi
sisik
sistem
sistematis
siswa
siswi
situ
situasi
situs
skala
skandal
skema
skenario
ski
skor
slogan
slot
soal
solo
solusi
sopan
sore
sosial
sosialis
sosok
spektrum
spesial
spesialis
spesies
spesifik
spesifikasi
spesimen
spiritual
spons
sponsor
sport
stabil
stabilitas
stadion
staf
standar
star
start
stasiun
statistik
status
statusnya
stop
strategi
strategis
string
strip
struktur
struktural
studi
studinya
studio
suami
suaminya
suara
suaranya
suasana
suatu
subjek
subspesies
subur
subyek
suci
sudah
sudut
suhu
suka
sukarela
sukses
suksesi
suku
sulit
sultan
sulung
sumbangan
sumber
sumbu
sumpah
sumur
sungai
sungguh
sunting
suntingan
supaya
super
support
surah
surat
surel
surga
surut
survei
surya
susah
susu
susunan
sutra
sutradara
swasta
syair
syarat
syuting
taat
tabel
tablet
tabung
tadi
tahan
tahanan
tahap
tahapan
tahta
tahu
tahun
tahunan
tahunnya
tajam
tak
takhta
taksi
taktik
takut
tali
taman
tamat
tambah
tambahan
tambahkan
tambang
tampak
tampaknya
tampil
tampilan
tamu
tanah
tanam
tanaman
tanda
tandang
tanduk
tangan
tangannya
tangga
tanggal
tanggapan
tanggung
tangkai
tangki
tangkis
tani
tank
tanpa
tantangan
tanya
tapi
target
tari
tarian
tarif
tarik
tas
tata
tatanan
tau
tawanan
tawar
tawaran
tayang
tayangan
teater
tebal
tebing
tegak
tegangan
tegas
teguh
teh
tekanan
teknik
teknis
teknisi
teknologi
teks
telah
telanjang
telekomunikasi
telepon
teleskop
televisi
telinga
teluk
telur
tema
teman
temannya
tembaga
tembak
tembakan
tembakau
tembok
tempat
tempatnya
temperatur
templat
tempo
tempuh
tempur
temuan
temurun
tenaga
tenang
tendangan
tengah
tenggara
tenggelam
tenis
tentang
tentara
tentu
tentunya
teolog
teologi
teologis
teoretis
teori
tepat
tepatnya
tepi
tepung
terakhir
terakhirnya
terancam
terang
terapi
terasa
teratas
teratur
terbagi
terbaik
terbakar
terbalik
terbang
terbanyak
terbaru
terbatas
terbentang
terbentuk
terbentuknya
terbesar
terbilang
terbit
terbitan
terbuat
terbuka
terbukti
terbunuh
terburuk
tercantum
tercapai
tercatat
tercepat
tercipta
terdaftar
terdahulu
terdapat
terdekat
terdengar
terdiri
terendah
tergabung
terganggu
tergantung
tergolong
terhadap
terhenti
terhitung
terhormat
terhubung
terikat
terima
terinfeksi
terinspirasi
terintegrasi
teritori
teritorial
terjadi
terjadinya
terjatuh
terjebak
terjemahan
terjual
terjun
terkadang
terkait
terkandung
terkaya
terkecil
terkejut
terkemuka
terkena
terkenal
terkesan
terkini
terkuat
terlahir
terlalu
terlambat
terlarang
terlaris
terlebih
terlepas
terlestarikan
terletak
terlibat
terlihat
terluka
termasuk
terminal
termuda
ternak
ternama
ternyata
teroris
terowongan
terpadu
terpaksa
terpanjang
terpasang
terpecah
terpencil
terpengaruh
terpenting
terpenuhi
terpilih
terpisah
terpusat
terputus
tersangka
tersebar
tersebut
tersedia
tersembunyi
tersendiri
tersimpan
tersisa
tersusun
tertanggal
tertangkap
tertarik
tertentu
tertinggal
tertinggi
tertua
tertulis
tertunda
tertutup
terungkap
terus
terutama
terwujud
tes
tetangga
tetangganya
tetap
tetapi
tewas
tiada
tiang
tiap
tiba
tidak
tidaklah
tidur
tiga
tiket
tikus
tim
timbal
timbul
timnya
timur
tindak
tindakan
tinggal
tinggi
tingginya
tingkah
tingkat
tingkatan
tipe
tipis
tiri
tirinya
titik
toko
tokoh
tol
tolong
tombak
tombol
ton
tongkat
topeng
topi
topik
total
tradisi
tradisional
tragedi
trans
transaksi
transfer
transformasi
transisi
transmisi
transportasi
travel
trek
tren
triliun
tropis
truk
tsunami
tua
tuan
tuanya
tubuh
tubuhnya
tuduhan
tugas
tugasnya
tugu
tujuan
tujuannya
tujuh
tukang
tukar
tulang
tulis
tulisan
tulisannya
tumbuh
tumbuhan
tunai
tunduk
tunggal
tunggu
tuntutan
tur
turbin
turis
turnamen
turun
turunan
turut
tutup
uang
uap
ubah
ucapan
udang
udara
uji
ujian
ujung
ujungnya
ukiran
ukuran
ukurannya
ulama
ulang
ular
ulasan
umat
umpan
umum
umumnya
umur
undang
undangan
unggul
unggulan
ungkapan
ungu
uni
unik
unit
universal
universitas
unsur
untuk
untuknya
upacara
upah
upaya
upeti
urban
urusan
urutan
usaha
usahanya
usai
usia
usianya
uskup
usul
usulan
usus
utama
utamanya
utang
utara
utuh
utusan
vakum
valid
vandalisme
variabel
varian
variasi
varietas
vektor
versi
vertikal
veteran
via
video
virtual
virus
visi
visual
vitamin
vocal
vokal
vokalis
volume
wabah
wadah
wafat
wafatnya
wahana
wajah
wajahnya
wajar
wajib
wakil
waktu
waktunya
walau
walaupun
wali
wangsa
wanita
waralaba
warga
waris
warisan
warna
wartawan
warung
wasit
wawancara
wawasan
wayang
web
wewenang
wilayah
wilayahnya
wisata
wisatawan
wujud
ya
yaitu
yakin
yakni
yang
yatim
yayasan
zaman
zat
zona
