package WordList::EN::PersonName::PopularBabyNames::US::SSA::2010::FemaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-04'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.002'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("shortest_word_len",3,"num_words_contain_nonword_chars",0,"num_words_contains_nonword_chars",0,"longest_word_len",10,"num_words_contains_unicode",0,"num_words_contains_whitespace",0,"num_words_contain_whitespace",0,"avg_word_len",6.044,"num_words",1000,"num_words_contain_unicode",0); # STATS

1;
# ABSTRACT: Top 1000 most popular names for female babies born in the USA in 2010 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyNames::US::SSA::2010::FemaleTop1000 - Top 1000 most popular names for female babies born in the USA in 2010 (from Social Security Administration)

=head1 VERSION

This document describes version 0.002 of WordList::EN::PersonName::PopularBabyNames::US::SSA::2010::FemaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyNames-US-SSA), released on 2020-05-04.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyNames::US::SSA::2010::FemaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyNames::US::SSA::2010::FemaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 6.044 |
 | longest_word_len                 | 10    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 3     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Isabella
Sophia
Emma
Olivia
Ava
Emily
Abigail
Madison
Chloe
Mia
Addison
Elizabeth
Ella
Natalie
Samantha
Alexis
Lily
Grace
Hailey
Alyssa
Hannah
Lillian
Avery
Leah
Nevaeh
Anna
Sarah
Sofia
Ashley
Brianna
Zoe
Victoria
Gabriella
Brooklyn
Kaylee
Taylor
Layla
Allison
Evelyn
Riley
Amelia
Khloe
Makayla
Savannah
Aubrey
Charlotte
Zoey
Bella
Kayla
Alexa
Peyton
Audrey
Claire
Arianna
Julia
Aaliyah
Kylie
Lauren
Sophie
Sydney
Camila
Jasmine
Morgan
Alexandra
Jocelyn
Maya
Gianna
Mackenzie
Kimberly
Katherine
Destiny
Brooke
Trinity
Faith
Lucy
Madelyn
Madeline
Bailey
Payton
Andrea
Autumn
Melanie
Serenity
Ariana
Stella
Maria
Molly
Caroline
Genesis
Kaitlyn
Eva
Jessica
Angelina
Gabrielle
Naomi
Valeria
Mariah
Natalia
Rachel
Paige
Mya
Rylee
Katelyn
Ellie
Isabelle
Lilly
Vanessa
London
Mary
Kennedy
Lydia
Jordyn
Ruby
Jade
Scarlett
Isabel
Annabelle
Harper
Sadie
Sara
Jennifer
Nicole
Violet
Liliana
Michelle
Stephanie
Reagan
Jada
Adriana
Gracie
Megan
Jayla
Kendall
Rebecca
Lyla
Amy
Reese
Izabella
Kylee
Laila
Jenna
Brooklynn
Aliyah
Piper
Mckenzie
Juliana
Giselle
Gabriela
Valerie
Daniela
Daisy
Valentina
Makenzie
Haley
Lila
Melissa
Ashlyn
Vivian
Nora
Angela
Katie
Hayden
Elena
Summer
Keira
Eleanor
Clara
Eliana
Alana
Jillian
Jacqueline
Alice
Adrianna
Miranda
Alivia
Julianna
Aniyah
Jordan
Eden
Mikayla
Skylar
Margaret
Briana
Shelby
Josephine
Ryleigh
Delilah
Amanda
Allie
Diana
Addyson
Brielle
Catherine
Angel
Danielle
Elise
Ana
Melody
Leslie
Penelope
Makenna
Marissa
Aurora
Alexandria
Leila
Alaina
Kendra
Kate
Delaney
Sienna
Lola
Jayden
Ariel
Sierra
Erin
Miley
Carly
Hadley
Sabrina
Alicia
Tessa
Chelsea
Amber
Aubree
Maggie
Amaya
Cadence
Mckenna
Cheyenne
Kathryn
Maci
Kinley
Kelsey
Marley
Alayna
Jayda
Ashlynn
Paisley
Callie
Lexi
Hope
Eliza
Teagan
Alexia
Kayleigh
Harmony
Nadia
Cassidy
Karen
Christina
Jazmin
Breanna
Kyla
Alondra
Quinn
Adalyn
Kaydence
Fiona
Allyson
Esther
Josie
Mariana
Haylee
Hazel
Alina
Lucia
Danna
Leilani
Alison
Camille
Fatima
Jazmine
Ximena
Laura
Cora
Presley
Cecilia
Genevieve
Alejandra
Bianca
Mallory
Camryn
Esmeralda
Abby
Dakota
Juliet
Brynn
Maddison
Londyn
Willow
Macy
Kara
Karina
Kyleigh
Veronica
Daniella
Isla
Norah
Ivy
Miriam
Malia
Caitlyn
Heidi
Kamryn
Joanna
Kelly
Kinsley
Phoebe
Kira
Annabella
Tiffany
Katelynn
Emery
Carmen
Iris
Emerson
Crystal
Nina
Emely
Rylie
Madeleine
Heaven
Adeline
Georgia
Karla
Kiara
Paris
Selena
Cassandra
Guadalupe
Tiana
Evangeline
Tatum
Madilyn
Lilah
Rose
Aniya
Madisyn
Kaelyn
Caitlin
Sasha
Luna
Audrina
Fernanda
Angelica
Ruth
Kyra
Emilia
Jasmin
Lilliana
Ayla
Janiyah
Aria
Courtney
Ainsley
Lia
Yaretzi
Maliyah
Raegan
Monica
Tatiana
Madalyn
Athena
Mila
Noelle
Anastasia
Julissa
Jaelyn
Bethany
Imani
Juliette
Kenzie
Macie
Savanna
Jamie
April
Giuliana
Kiley
Lena
Adelyn
Joselyn
Arabella
Cynthia
Jane
Kailey
Alessandra
Carolina
Nayeli
Julie
Gia
Janelle
Michaela
Kaylie
Annie
Elaina
Kaylin
Amiyah
Madelynn
Lyric
Addisyn
Baylee
Lindsey
Jimena
Rebekah
Nyla
Anya
Jazlyn
Finley
Holly
Dulce
Melany
Talia
Itzel
Scarlet
Kiera
Cali
Cameron
Angie
Journey
Elle
Elliana
Estrella
Erica
Sarai
Danica
Brenda
Vivienne
Brittany
Erika
Hayley
Mikaela
Harley
Kamila
Adelaide
Brylee
Lacey
Aubrie
Helen
Ciara
Johanna
Kadence
Nataly
Kailyn
Madyson
Shayla
Adalynn
Bridget
Janiya
Serena
Gemma
Lillie
Aleah
Lilian
Paola
Jayleen
Celeste
Natasha
Braelyn
Tenley
Charlie
Kassidy
Amari
Dana
Brisa
Parker
Annika
Lexie
Aileen
Brenna
Nia
Sage
Desiree
Skyler
Emilee
Jaliyah
Lucille
Anabelle
Joy
Anahi
Lana
Kayden
Anaya
Lilyana
Dayana
Viviana
Logan
Priscilla
Denise
Daphne
Kennedi
Zariah
Skye
Rowan
Francesca
Amira
Elisa
Kimora
Jaylynn
Kenley
Lizbeth
Liberty
Jaelynn
Lauryn
Melina
Myla
Abbigail
Arielle
Camilla
Gloria
Alyson
Brynlee
Alissa
Claudia
Marlee
Sandra
Danika
Hanna
Alanna
Nancy
Miracle
Hailee
Caylee
Jaycee
Gracelyn
Annalise
Liana
Eloise
Yareli
Bailee
Cindy
Marisol
Asia
Helena
Justice
Lorelei
Maeve
Kali
Jaida
Aiyana
Anika
Natalee
Olive
Whitney
Ada
Laney
Kassandra
Kaia
Aryanna
Marilyn
Clarissa
Farrah
Halle
Amani
Janessa
Mckinley
Sylvia
Charlee
Skyla
Aleena
Madilynn
Gwendolyn
Marie
Bristol
Meghan
Rosa
Tori
Giana
Shaniya
Lea
Isabela
Kaliyah
Kaylynn
Averie
Hallie
Aylin
Dylan
Kristen
Madalynn
Zoie
Saniyah
Lesly
Kiana
Yasmin
Kaleigh
Regina
Rihanna
Kristina
Wendy
Anabella
Elisabeth
Rosalie
Sloane
Eve
June
Amya
Kathleen
Lindsay
Saniya
Virginia
Aspen
Elsa
Samara
Meredith
Raven
Nylah
Perla
Raquel
Siena
Anne
Casey
Ayanna
Mckayla
Jaylee
Jaylin
Patricia
Shiloh
Linda
Maia
Mariam
Aimee
Lainey
Maleah
Nathalie
Sherlyn
Isis
Angelique
Jazlynn
Raelynn
Annabel
Paityn
Ryan
Tabitha
Diamond
Marina
Myah
Bryanna
Ansley
Elyse
Joslyn
Adelynn
Cara
Haleigh
Jadyn
Selah
Kourtney
Elsie
Dahlia
Haven
Lailah
Leighton
Sariah
Aliya
Jaylene
Amara
Briley
Arely
Jaylah
Karlee
Brinley
Taryn
America
Kaitlin
Amiya
Kailee
Milan
Phoenix
Mercedes
Lilianna
Christine
Sidney
Greta
Simone
Vera
Ellen
Mollie
Alisson
Amelie
Kallie
Noemi
Taraji
Clare
Heather
Keyla
Jessie
Ally
Aisha
Catalina
Shannon
Jordynn
Taliyah
Zion
Luciana
Miah
Irene
Martha
Teresa
Adrienne
Rachael
Paloma
Yesenia
Barbara
Janae
Jolie
Leanna
Jaiden
Jaqueline
Amina
Evie
Macey
Destinee
Abril
Lisa
Deanna
Kenya
Rosemary
Alani
Jocelynn
Zara
Kaitlynn
Krystal
Sonia
Paulina
Regan
Ali
Evelynn
Elin
Ariella
Alena
Alia
Chaya
Jazmyn
Raelyn
Corinne
Emilie
Jayde
Carolyn
Karissa
Jakayla
Laylah
Mariyah
Cecelia
Cheyanne
Zaniyah
Celia
Emmalyn
Luz
Kaiya
Iliana
Lorelai
Leyla
Giovanna
Cherish
Giada
Carla
Larissa
Jaden
Adyson
Campbell
Carlee
Carley
Gisselle
Julianne
Lylah
Felicity
Aryana
Natalya
Frances
Ivanna
Kaya
Reyna
Tamia
Kaylyn
Moriah
Bria
Deborah
Harlow
Ingrid
Tara
Susan
Yoselin
Alisha
Carlie
Ayana
Haylie
Cristina
Jenny
Sawyer
Maryam
Sanaa
Rylan
Emmalee
Jaidyn
Libby
Yaritza
Allisson
Kasey
Elaine
Matilda
Tianna
Kaylen
Sharon
Patience
Aliana
Maritza
Karlie
Nathaly
Analia
Emelia
Heidy
Chana
Tess
Yazmin
Chanel
Karsyn
Paula
Armani
Marisa
Abbie
Amirah
Araceli
Alyvia
Azul
Edith
Ember
Aliza
Zaria
Carissa
Charley
Livia
Hadassah
Ireland
Isabell
Leia
Cailyn
Beatrice
Hayleigh
Akira
Avah
Eileen
Kiersten
Micah
Gracelynn
Kenna
Kirsten
Malaya
Alayah
Alma
Hana
Mira
Demi
Jemma
Kelsie
Charity
Lillianna
Lina
Angeline
Ayleen
Katrina
Nola
Ashlee
Millie
Raina
Jaylyn
Renee
Belinda
Jacquelyn
Mara
Bree
Lilyanna
Mayra
Zariyah
Belen
Lilia
Joyce
Judith
Meadow
Rubi
Shyla
Ryann
Kyndall
Lara
Neveah
Elianna
Salma
Tania
Abbey
Kendal
Kynlee
Janet
Rayne
Braelynn
Saige
Briella
Karma
Laniyah
Princess
Rayna
Sarahi
Makena
Stacy
Lizeth
Marlene
Azaria
Britney
Riya
Dominique
Jaylen
Karly
Adele
Adelina
Kaelynn
Abigale
Ann
Janiah
Charli
Emersyn
Kayleen
Marianna
Caydence
Abagail
Dixie
Diya
Esme
Jewel
Payten
Theresa
Carleigh
Maliah
Roselyn
Alisa
Shyanne
Karli
Nathalia
Yamilet
Aiyanna
Averi
Journee
Mattie
Mylee
Tegan
Damaris
Arya
Yamileth
Audriana
Emmy
Kylah
Thalia
Carina
Esperanza
Anabel
Jamya
Willa
Kai
Kierra
Kinsey
Shania
Sydnee
Micaela
Pearl
Ivana
Kairi
Precious
Kloe
Mina
Myra
Shaylee
Azariah
Addilyn
Jolene
Kimber
Lorena
Alannah
River
Alexus
Dalia
India
Jaslene
Reina
Mae
Milagros
Stephany
Zuri
Pamela
Xiomara
Ariah
Donna
Evelin
Leona
Tia
Aracely
Amiah
Bryleigh
Devyn
Lilith
Charleigh
Alaysia
Aleigha
Savanah
Dania
Karley
