package WordList::EN::PersonName::PopularBabyNames::US::SSA::1910::FemaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-04'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.002'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contains_unicode",0,"longest_word_len",10,"num_words_contains_nonword_chars",0,"num_words_contain_nonword_chars",0,"shortest_word_len",2,"num_words_contain_unicode",0,"num_words",1000,"num_words_contains_whitespace",0,"num_words_contain_whitespace",0,"avg_word_len",5.834); # STATS

1;
# ABSTRACT: Top 1000 most popular names for female babies born in the USA in 1910 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyNames::US::SSA::1910::FemaleTop1000 - Top 1000 most popular names for female babies born in the USA in 1910 (from Social Security Administration)

=head1 VERSION

This document describes version 0.002 of WordList::EN::PersonName::PopularBabyNames::US::SSA::1910::FemaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyNames-US-SSA), released on 2020-05-04.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyNames::US::SSA::1910::FemaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyNames::US::SSA::1910::FemaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.834 |
 | longest_word_len                 | 10    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Mary
Helen
Margaret
Dorothy
Ruth
Anna
Elizabeth
Mildred
Marie
Alice
Frances
Florence
Ethel
Lillian
Gladys
Rose
Evelyn
Edna
Annie
Louise
Irene
Catherine
Grace
Hazel
Thelma
Gertrude
Ruby
Martha
Virginia
Josephine
Lucille
Clara
Bertha
Emma
Edith
Beatrice
Bessie
Esther
Pearl
Sarah
Agnes
Pauline
Myrtle
Elsie
Eva
Mabel
Ida
Viola
Julia
Minnie
Nellie
Ann
Laura
Lillie
Eleanor
Willie
Katherine
Bernice
Marion
Mattie
Alma
Ella
Jessie
Doris
Mae
Lena
Anne
Marjorie
Betty
Carrie
Vera
Stella
Hattie
Blanche
Lucy
Lois
Jean
Fannie
Leona
Kathryn
Jennie
Beulah
Rosa
Marguerite
Cora
Mamie
Opal
Ellen
Violet
Velma
Georgia
Sylvia
Lula
Ada
Maggie
Theresa
Inez
Genevieve
Charlotte
Sadie
Daisy
Susie
Dora
Alberta
Nancy
Marian
Vivian
Flora
Hilda
Emily
Nora
Estelle
Eunice
Rosie
Juanita
Jane
Geneva
Lucile
Wilma
Lola
Mable
Katie
Christine
Loretta
Olive
Harriet
Lottie
Sara
Nettie
Verna
Kathleen
Maria
Sophie
Essie
Eula
Barbara
Della
May
Goldie
Erma
Maude
Victoria
Effie
Sallie
Madeline
Caroline
Sally
Geraldine
Irma
Ollie
Rachel
Lydia
Henrietta
Rebecca
Lizzie
Naomi
Addie
Ora
Norma
Nina
Lela
Audrey
Amelia
Roberta
Etta
Leola
Ola
Iva
Celia
Mollie
Maxine
Adeline
Susan
Fern
Phyllis
Isabel
Isabelle
Flossie
Jeanette
Olga
Estella
Janie
Bonnie
Luella
Winifred
Miriam
Muriel
Jewell
Regina
Cleo
Alta
Jeannette
Freda
Elva
Anita
Cecelia
Nannie
Rita
Carolyn
Antoinette
Frieda
Jewel
Nell
Shirley
Fay
Patricia
Veronica
Faye
Lila
Lorraine
Wanda
Dorothea
Hannah
Margie
Johnnie
Ina
Janet
June
Marcella
Dolores
Selma
Virgie
Lorene
Adele
Amy
Cecilia
Matilda
Rosalie
Amanda
Dollie
Sue
Angeline
Claire
Eliza
Elma
Eloise
Sophia
Constance
Angela
Eileen
Rena
Josie
Angelina
Winnie
Millie
Gracie
Callie
Elnora
Gussie
Allie
Reba
Hallie
Annette
Francis
Helene
Lee
Jeanne
Teresa
Zelma
Tillie
Madge
Lenora
Elvira
Hester
Lorena
Olivia
Lessie
Arlene
Leah
Adelaide
Kate
Peggy
Cornelia
Letha
Ila
Maudie
Joan
Bertie
Elaine
Odessa
Belle
Edythe
Birdie
Cecile
Carol
Ernestine
Clarice
Augusta
Carmen
Harriett
Pearlie
Rosetta
Helena
Iola
Lora
Rhoda
Ophelia
Roxie
Eugenia
Bettie
Frankie
Billie
Dessie
Leila
Melba
Nola
Katharine
Corine
Myra
Lily
Gwendolyn
Isabella
Zella
Delia
Corinne
Molly
Eleanore
Lou
Iris
Maud
Wilhelmina
Jannie
Mayme
Priscilla
Aline
Alyce
Johanna
Neva
Rosemary
Carmela
Lenore
Catharine
Lelia
Merle
Claudia
Linda
Natalie
Joyce
Nona
Laverne
Oma
Willa
Dolly
Elinor
Gertie
Yvonne
Cecil
Christina
Jimmie
Connie
Isabell
Lilly
Pansy
Berniece
Eddie
Iona
Aileen
Lucinda
Rosella
Maurine
Annabelle
Erna
Tessie
Louella
Dovie
Gloria
Verda
Lulu
Ione
Loraine
Florine
Lona
Polly
Vesta
Blanch
Cassie
Leota
Donna
Hettie
Vada
Georgie
Kay
Maybelle
Sybil
Alvina
Estell
Arline
Floy
Leora
Elisabeth
Fanny
Hortense
Lettie
Mona
Artie
Minerva
Mittie
Imogene
Leone
Bernadine
Leta
Bernadette
Gretchen
Lura
Mathilda
Alpha
Clare
Concetta
Ona
Earline
Ester
Althea
Beryl
Era
Reva
Nadine
Phoebe
Carmella
Janice
Paula
Bess
John
Stephanie
Angie
Rae
Adell
Allene
Cynthia
Dixie
Lauretta
Zelda
Linnie
Magnolia
Louisa
Mozelle
Ramona
Rubye
Orpha
Tommie
Avis
Corrine
Mercedes
Idella
Philomena
Alva
Elsa
Mazie
Queen
Abbie
Agatha
Ava
Golda
Harriette
Monica
Zola
Yetta
Wilda
Evangeline
Eve
Tressie
Cordelia
Hulda
Evie
Garnet
Idell
Antonia
Bella
Elda
Ocie
Patsy
Robbie
Almeda
Belva
Celeste
Ivy
Julie
Mandy
Odell
Retha
Clementine
Lovie
Melva
Mina
Myrtis
Una
Vergie
Filomena
Lue
Zula
Aurelia
Camille
Guadalupe
Ferne
Lina
Dorthy
Easter
Johnie
Judith
Margret
Glenna
Lorine
Margery
Bennie
Charlie
Elena
Ethelyn
Madelyn
Nelle
Octavia
Petra
Veda
Vida
Winona
Dorotha
Lucia
Pinkie
Beth
James
Elise
Hope
Kattie
Aurora
Delma
Leatha
Manuela
Marietta
Sudie
Albina
Crystal
Margarita
Rhea
Savannah
Valeria
Alene
Ruthie
George
Suzanne
Tina
Freida
Marcia
Rosia
Zora
Beverly
Claudie
Hellen
Jacqueline
Ray
Rubie
Velva
Adela
Bulah
Clyde
Diana
Lyda
Myrtie
Oleta
Rosalind
Rowena
Ursula
Elvera
Magdalene
Millicent
Reta
Corene
Edwina
Eleanora
Georgiana
Nan
Verla
Celestine
Delphine
Elna
Lavina
Leslie
Madeleine
Albertha
Claudine
Emilie
Freddie
Lorna
Macie
Myrtice
Queenie
Bell
Bobbie
Chloe
Delores
Delphia
Ellie
Ima
Lennie
Melvina
Donnie
Dorris
Esta
Joanna
Leonora
Marianne
Marvel
Nita
Novella
Rosamond
Vernice
Berta
Joy
Juliette
Malinda
Meta
Zona
Anastasia
Elmira
Lida
Lupe
Melissa
Pattie
Roma
Velda
Vernie
Winnifred
Altha
Camilla
Emmie
Francisca
Katheryn
Kitty
Madie
Mallie
Rosalee
Tennie
Annabel
Cathrine
Germaine
Ira
Rachael
Susanna
Therese
Valerie
Verdie
Vina
Alda
Charity
Earnestine
Lonnie
Audra
Birtha
Carolina
Eldora
Florida
Hedwig
Jackie
Luvenia
Mabelle
Marjory
Ossie
Pearle
Pearline
Verona
Joe
Kathrine
Liza
Maxie
Rosina
Adelia
Adrienne
Dona
Emilia
Goldia
Hilma
Jenny
Maybell
Mozell
Bethel
Carmel
Georgianna
Grayce
Jo
Margarette
Theodora
Arvilla
Berneice
Bonita
Cathryn
Hazle
Hildegarde
Jettie
Juana
Lilla
Ludie
Vallie
Yolanda
Aletha
Consuelo
Eulalia
Evalyn
Garnett
Luna
Versie
Annabell
Dortha
Martina
Mavis
Sofia
Thora
William
Betsy
Bridget
Magdalena
Rosanna
Treva
Antonette
Corrie
Faith
Josefa
Justine
Lera
Libby
Maryann
Onie
Renee
Verlie
Viva
Zada
Clemmie
Cordie
Dorcas
Elisa
Elouise
Emmer
Enid
Ethyl
Felicia
Gilda
Lilyan
Nella
Norene
Zoe
Adella
Annis
Audie
Deborah
Diane
Elenora
Gail
Hermine
Ilene
Jerry
Lilian
Lucie
Minna
Palma
Tiny
Violette
Alverta
Amie
Berenice
Charlene
Charles
Concepcion
Gene
Icie
Irine
Ivory
Josefina
Maye
Nova
Ressie
Sibyl
Willia
Alfreda
Alicia
Amalia
Bettye
Eda
Fae
Kathryne
Mellie
Norine
Ouida
Serena
Signe
Delilah
Dell
Dena
Emelia
Eveline
Hanna
Letitia
Lonie
Magdalen
Marianna
Rosalia
Sammie
Trudie
Adelina
Adelle
Annetta
Beaulah
Elvie
Elvina
Fairy
Inga
Joseph
Judy
Lavada
Louie
Louvenia
Lucretia
Nelda
Robert
Theo
Vincenza
Alida
Amber
Elizebeth
Ena
Glennie
Greta
Henry
Hildred
Jaunita
Jessica
Joanne
Lavinia
Louis
Mammie
Myrna
Naoma
Osie
Ozella
Vena
Alvera
Andrea
Cathleen
Clarissa
Exie
Flo
Georgina
Hertha
Jonnie
Myrle
Odelia
Omie
Theola
Vinnie
Almeta
Arlie
Delta
Drusilla
Gay
Janette
Jossie
Lacy
Loree
Meda
Rossie
Sadye
Vivien
Zadie
Adaline
Augustine
Ceola
Coletta
Eulah
Golden
Hassie
Izora
Lelah
Leo
Luetta
Madaline
Manda
Mariah
Nedra
Reatha
Rilla
Syble
Arie
Buelah
Dale
Dola
Gwen
Hermina
Ines
Juliet
Larue
Lexie
Luisa
Margarett
Mathilde
Meredith
Missouri
Mozella
Neoma
Odie
Ottie
Ara
Bernardine
Elberta
Eloisa
Erie
Ether
Florrie
Izetta
Lea
Lenna
Lilie
Lynn
Marcelle
Myrl
Nevada
Olevia
Tena
Zetta
Adline
Alba
Albertine
Anner
Ardella
Buna
Clarabelle
Elease
Elenor
Enola
Eugenie
Freeda
Gertha
Hessie
Lannie
Laverna
Leonor
Lossie
Malissa
Nathalie
Oda
Retta
Tempie
Ula
Vella
Vertie
Vonnie
Angelita
Ardis
Bette
Classie
Corean
Dana
Delfina
Doretha
Ettie
Euna
Eura
Evaline
Florene
Frank
Lassie
Lurline
Lyla
Maebelle
Margaretta
Neta
Nila
Ova
Pennie
Rosemarie
Roslyn
Rozella
Selena
Stephania
Zena
Adah
Aili
Alvena
Arlena
Bea
Beula
Blossom
Clifford
Dallas
Deloris
Emogene
Evelena
Florance
Fronie
Gennie
Helga
Joann
Lavon
Leanna
Libbie
Madalyn
Mossie
Ozell
Sonia
Tomasa
Trula
Veva
Allean
Alys
Antonetta
Arietta
