package Dist::Zilla::Plugin::Module::Features;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-02-26'; # DATE
our $DIST = 'Dist-Zilla-Plugin-Module-Features'; # DIST
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

use Moose;
with 'Dist::Zilla::Role::AfterBuild';
with 'Dist::Zilla::Role::FileGatherer';
with 'Dist::Zilla::Role::PrereqSource';
#with 'Dist::Zilla::Role::ModuleFeatures::CheckDefinesOrDeclaresFeatures';
use namespace::autoclean;

use PMVersions::Util qw(version_from_pmversions);

sub register_prereqs {
    my ($self) = @_;

    #return unless $self->check_dist_defines_module_features;

    $self->zilla->register_prereqs(
        {
            type  => 'requires',
            phase => 'develop',
        },
        'Test::Module::Features' => version_from_pmversions('Test::Module::Features') // '0.001',
    );
}

sub gather_files {
    my ($self) = @_;

    #return unless $self->check_dist_defines_module_features;

    my $filename = "xt/release/module-features.t";
    my $filecontent = <<_;
#!perl

# This file was automatically generated by ${\(__PACKAGE__)}.

use Test::More;

eval "use Test::Module::Features 0.001";
plan skip_all => "Test::Module::Features 0.001+ required for testing module features"
  if \$@;

module_features_in_all_modules_ok();
_

    $self->log(["Adding %s ...", $filename]);
    require Dist::Zilla::File::InMemory;
    $self->add_file(
        Dist::Zilla::File::InMemory->new({
            name => $filename,
            content => $filecontent,
        })
      );
}

sub after_build {
    my $self = shift;

    my $prereqs_hash = $self->zilla->prereqs->as_string_hash;

    # XXX only require spec prereq to Module::Features when there's a module
    # that has feature set specification or features declaration

    # check that Module::Features is mentioned phase=develop rel=x_spec
    unless (exists $prereqs_hash->{develop}{x_spec}{'Module::Features'}) {
        unless (-f "lib/Module/Features.pm") { # exception for Module-Features dist
            $self->log_fatal(["Module::Features not specified as prerequisite (phase=develop, rel=x_spec)"]);
        }
    }
}

__PACKAGE__->meta->make_immutable;
1;
# ABSTRACT: Plugin to use when building Module::Features::* distribution

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::Module::Features - Plugin to use when building Module::Features::* distribution

=head1 VERSION

This document describes version 0.002 of Dist::Zilla::Plugin::Module::Features (from Perl distribution Dist-Zilla-Plugin-Module-Features), released on 2021-02-26.

=head1 SYNOPSIS

In F<dist.ini>:

 [Module::Features]

=head1 DESCRIPTION

This plugin is to be used when building C<Module::Features::*> distribution as
well as distribution that has a module that declares features. It currently does
the following:

=over

=item * Create C<xt/release/module-features.t> test file which uses L<Test::Module::Features> to test your features declarations or feature set specifications

=item * Make sure that L<Module::Features> is added as a (phase=develop, rel=x_spec) prerequisite

This is a way to express that the module I<follows the specification> specified
in L<Module::Features>.

=back

=for Pod::Coverage .+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Dist-Zilla-Plugin-Module-Features>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Dist-Zilla-Plugin-Module-Features>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://github.com/perlancar/perl-Dist-Zilla-Plugin-Module-Features/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Module::Features>

L<Pod::Weaver::Plugin::Module::Features>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
