package Data::Sah::CoerceCommon;

our $DATE = '2016-05-21'; # DATE
our $VERSION = '0.008'; # VERSION

our $gen_coercer_meta = {
    v => 1.1,
    summary => 'Generate coercer code',
    description => <<'_',

This is mostly for testing. Normally the coercion rules will be used from
`Data::Sah`.

_
    args => {
        type => {
            schema => 'str*', # XXX sah::typename
            req => 1,
            pos => 0,
        },
        coerce_to => {
            schema => 'str*',
        },
        coerce_from => {
            schema => ['array*', of=>'str*'],
        },
        dont_coerce_from => {
            schema => ['array*', of=>'str*'],
        },
        return_type => {
            schema => ['str*', in=>[qw/val bool+val/]],
            default => 'val',
            description => <<'_',

`val` returns the value (possibly) coerced. `bool+val` returns a 2-element array
where the first element is a bool value of whether the value has been coerced,
and the second element is the (possibly) coerced value.

_
        },
        source => {
            summary => 'If set to true, will return coercer source code string'.
                ' instead of compiled code',
            schema => 'bool',
        },
    },
    result_naked => 1,
};

1;
# ABSTRACT: Common stuffs for Data::Sah::Coerce and Data::Sah::CoerceJS

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Sah::CoerceCommon - Common stuffs for Data::Sah::Coerce and Data::Sah::CoerceJS

=head1 VERSION

This document describes version 0.008 of Data::Sah::CoerceCommon (from Perl distribution Data-Sah-Coerce), released on 2016-05-21.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Data-Sah-Coerce>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Data-Sah-Coerce>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Data-Sah-Coerce>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
