package Bencher::Scenario::SortSub::naturally;

our $DATE = '2017-02-02'; # DATE
our $VERSION = '0.004'; # VERSION

use strict;
use warnings;

use List::Util qw(shuffle);
use Sort::Sub qw($naturally);

our $scenario = {
    summary => 'Benchmark natural sorting',
    modules => {
        'Sort::Sub' => {version=>'0.05'},
    },
    participants => [
        {
            name => 'Sort::Sub::naturally',
            module => 'Sort::Sub',
            code_template => 'sort $Bencher::Scenario::SortSub::naturally::naturally @{<data>}',
            result_is_list => 1,
        },
        {
            fcall_template => 'Sort::Naturally::nsort(@{<data>})',
            result_is_list => 1,
        },
        {
            name => 'Sort::Naturally::ncmp',
            module => 'Sort::Naturally',
            code_template => 'sort {Sort::Naturally::ncmp($a, $b)} @{<data>}',
            result_is_list => 1,
        },
        {
            fcall_template => 'Sort::Naturally::XS::nsort(@{<data>})',
            result_is_list => 1,
        },
        {
            name => 'Sort::Naturally::XS::ncmp',
            module => 'Sort::Naturally::XS',
            code_template => 'sort {Sort::Naturally::XS::ncmp($a, $b)} @{<data>}',
            result_is_list => 1,
        },
        {
            fcall_template => 'Sort::Key::Natural::natsort(@{<data>})',
            result_is_list => 1,
        },
    ],
    datasets => [
        { name=>'10items' , args=>{data=>[shuffle map { "track$_.mp3" } 1..10 ]} },
        { name=>'100items', args=>{data=>[shuffle map { "track$_.mp3" } 1..100]} },
    ],
};

1;
# ABSTRACT: Benchmark natural sorting

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::SortSub::naturally - Benchmark natural sorting

=head1 VERSION

This document describes version 0.004 of Bencher::Scenario::SortSub::naturally (from Perl distribution Bencher-Scenarios-SortSub), released on 2017-02-02.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m SortSub::naturally

To run module startup overhead benchmark:

 % bencher --module-startup -m SortSub::naturally

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Sort::Key::Natural> 0.04

L<Sort::Naturally> 1.03

L<Sort::Naturally::XS> 0.7.3

L<Sort::Sub> 0.10

=head1 BENCHMARK PARTICIPANTS

=over

=item * Sort::Sub::naturally (perl_code)

Code template:

 sort $Bencher::Scenario::SortSub::naturally::naturally @{<data>}



=item * Sort::Naturally::nsort (perl_code)

Function call template:

 Sort::Naturally::nsort(@{<data>})



=item * Sort::Naturally::ncmp (perl_code)

Code template:

 sort {Sort::Naturally::ncmp($a, $b)} @{<data>}



=item * Sort::Naturally::XS::nsort (perl_code)

Function call template:

 Sort::Naturally::XS::nsort(@{<data>})



=item * Sort::Naturally::XS::ncmp (perl_code)

Code template:

 sort {Sort::Naturally::XS::ncmp($a, $b)} @{<data>}



=item * Sort::Key::Natural::natsort (perl_code)

Function call template:

 Sort::Key::Natural::natsort(@{<data>})



=back

=head1 BENCHMARK DATASETS

=over

=item * 10items

=item * 100items

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m SortSub::naturally >>):

 #table1#
 {dataset=>"100items"}
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | participant                 | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | Sort::Naturally::nsort      |       644 | 1.55      |       1    | 4.3e-07 |      20 |
 | Sort::Key::Natural::natsort |      2070 | 0.483     |       3.21 | 2.1e-07 |      20 |
 | Sort::Naturally::XS::nsort  |      6000 | 0.2       |       9    | 6.7e-06 |      20 |
 | Sort::Sub::naturally        |    231720 | 0.0043156 |     359.54 | 1.2e-11 |      20 |
 | Sort::Naturally::ncmp       |    234000 | 0.00427   |     363    | 1.5e-09 |      24 |
 | Sort::Naturally::XS::ncmp   |    236000 | 0.00424   |     366    | 1.5e-09 |      24 |
 +-----------------------------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"10items"}
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | participant                 | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | Sort::Naturally::nsort      |   14336.6 | 69.7516   |     1      |   0     |      21 |
 | Sort::Key::Natural::natsort |   20700   | 48.4      |     1.44   | 1.3e-08 |      20 |
 | Sort::Naturally::XS::nsort  |  175698   |  5.69157  |    12.2553 |   0     |      21 |
 | Sort::Sub::naturally        | 1780320   |  0.561697 |   124.18   |   0     |      20 |
 | Sort::Naturally::ncmp       | 1780610   |  0.561605 |   124.201  |   0     |      20 |
 | Sort::Naturally::XS::ncmp   | 1793190   |  0.557666 |   125.078  |   0     |      20 |
 +-----------------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m SortSub::naturally --module-startup >>):

 #table3#
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+-----------+---------+
 | participant         | proc_private_dirty_size (MB) | proc_rss_size (MB) | proc_size (MB) | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors   | samples |
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+-----------+---------+
 | Sort::Key::Natural  | 1.4                          | 4.9                | 19             |      28   |                   22.1 |        1   | 6.6e-05   |      21 |
 | Sort::Naturally::XS | 1.4                          | 4.8                | 19             |      13   |                    7.1 |        2.2 | 3.5e-05   |      20 |
 | Sort::Naturally     | 1.2                          | 4.7                | 16             |      12   |                    6.1 |        2.3 |   0.00012 |      20 |
 | Sort::Sub           | 1.2                          | 4.7                | 16             |       8.4 |                    2.5 |        3.3 |   3e-05   |      20 |
 | perl -e1 (baseline) | 0.87                         | 4.2                | 16             |       5.9 |                    0   |        4.7 | 1.2e-05   |      21 |
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+-----------+---------+


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-SortSub>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-SortSub>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-SortSub>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
