package Bencher::Scenario::RegexpCommonVsRegexpPattern::Startup;

our $DATE = '2016-09-13'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark module startup overhead of Regexp::Common vs Regexp::Pattern',

    participants => [
        {name=>'RC_defaults'  , perl_cmdline => ['-MRegexp::Common', '-e1']},
        {name=>'RC_nodefaults', perl_cmdline => ['-MRegexp::Common=no_defaults', '-e1']},
        {name=>'RP'           , perl_cmdline => ['-MRegexp::Pattern', '-e1']},
        {name=>'baseline'     , perl_cmdline => ['-e1']},
    ],
};

1;
# ABSTRACT: Benchmark module startup overhead of Regexp::Common vs Regexp::Pattern

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::RegexpCommonVsRegexpPattern::Startup - Benchmark module startup overhead of Regexp::Common vs Regexp::Pattern

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::RegexpCommonVsRegexpPattern::Startup (from Perl distribution Bencher-Scenarios-RegexpCommonVsRegexpPattern), released on 2016-09-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m RegexpCommonVsRegexpPattern::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * RC_defaults (command)



=item * RC_nodefaults (command)



=item * RP (command)



=item * baseline (command)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m RegexpCommonVsRegexpPattern::Startup >>):

 #table1#
 +---------------+-----------+-----------+------------+---------+---------+
 | participant   | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------+-----------+-----------+------------+---------+---------+
 | RC_defaults   |      12.6 |      79.2 |          1 | 6.2e-05 |      20 |
 | RC_nodefaults |     100   |       9.9 |          8 | 2.2e-05 |      20 |
 | RP            |     150   |       6.6 |         12 |   2e-05 |      20 |
 | baseline      |     190   |       5.1 |         15 | 1.2e-05 |      20 |
 +---------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Loading L<Regexp::Common> with C<no_defaults> (i.e. C<use Regexp::Common
'no_defaults>) actually incurs only a little overhead, compared to just C<use
Regexp::Common>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-RegexpCommonVsRegexpPattern>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-RegexpCommonVsRegexpPattern>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-RegexpCommonVsRegexpPattern>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
