package Bencher::Scenario::PERLANCARModuleList::ReturnPathOption;

our $DATE = '2016-01-20'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark the benefit of return_path option',

    description => <<'_',

When we want to get the paths of all installed modules, PERLANCAR::Module::List
can do this in one step using the `return_path` option.

With Module::List, we need to get the paths in an extra step.

_
    participants => [
        {
            module => 'PERLANCAR::Module::List',
            code_template => q!
                PERLANCAR::Module::List::list_modules(<prefix>, {list_modules=>1, recurse=><recurse>, return_path=>1});
            !,
        },
        {
            module => 'Module::List',
            code_template => q!
                require Module::Path;
                my $mods = Module::List::list_modules(<prefix>, {list_modules=>1, recurse=><recurse>});
                for my $mod (keys %$mods) {
                    $mods->{$mod} = Module::Path::module_path($mod);
                }
                $mods;
            !,
        },
    ],

    datasets => [
        {name=>"IPC", args=>{prefix=>"IPC::", recurse=>0}},
        {name=>"Module", args=>{prefix=>"Module::", recurse=>1}},
        {name=>"all", args=>{prefix=>"", recurse=>1}, include_by_default=>0},
    ],
};

1;
# ABSTRACT: Benchmark the benefit of return_path option

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCARModuleList::ReturnPathOption - Benchmark the benefit of return_path option

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::PERLANCARModuleList::ReturnPathOption (from Perl distribution Bencher-Scenarios-PERLANCARModuleList), released on 2016-01-20.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCARModuleList::ReturnPathOption

To run module startup overhead benchmark:

 % bencher --module-startup -m PERLANCARModuleList::ReturnPathOption

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when getting the L</"SAMPLE BENCHMARK RESULTS">.

L<PERLANCAR::Module::List> 0.003002

L<Module::List> 0.003

=head1 BENCHMARK PARTICIPANTS

=over

=item * PERLANCAR::Module::List (perl_code)

Code template:

 
                 PERLANCAR::Module::List::list_modules(<prefix>, {list_modules=>1, recurse=><recurse>, return_path=>1});
             



=item * Module::List (perl_code)

Code template:

 
                 require Module::Path;
                 my $mods = Module::List::list_modules(<prefix>, {list_modules=>1, recurse=><recurse>});
                 for my $mod (keys %$mods) {
                     $mods->{$mod} = Module::Path::module_path($mod);
                 }
                 $mods;
             



=back

=head1 BENCHMARK DATASETS

=over

=item * IPC

=item * Module

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCARModuleList::ReturnPathOption >>):

 +-------------------------+---------+-----------+-----------+---------+---------+
 | participant             | dataset | rate (/s) | time (ms) | errors  | samples |
 +-------------------------+---------+-----------+-----------+---------+---------+
 | Module::List            | Module  | 2.3e+02   | 4.4       | 1.8e-05 | 21      |
 | PERLANCAR::Module::List | Module  | 628       | 1.59      | 4.5e-06 | 20      |
 | Module::List            | IPC     | 1.05e+03  | 0.949     | 2.5e-06 | 20      |
 | PERLANCAR::Module::List | IPC     | 3.3e+03   | 0.31      | 2.7e-06 | 20      |
 +-------------------------+---------+-----------+-----------+---------+---------+


Benchmark module startup overhead (C<< bencher -m PERLANCARModuleList::ReturnPathOption --module-startup >>):

 +-------------------------+-----------+------------------------+---------+---------+
 | participant             | time (ms) | mod_overhead_time (ms) | errors  | samples |
 +-------------------------+-----------+------------------------+---------+---------+
 | Module::List            | 26        | 21.85                  | 0.00011 | 20      |
 | PERLANCAR::Module::List | 4.9       | 0.75                   | 2.2e-05 | 20      |
 | perl -e1 (baseline)     | 4.15      | 0                      | 8.7e-06 | 20      |
 +-------------------------+-----------+------------------------+---------+---------+

=head1 DESCRIPTION

When we want to get the paths of all installed modules, PERLANCAR::Module::List
can do this in one step using the C<return_path> option.

With Module::List, we need to get the paths in an extra step.


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCARModuleList>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-PERLANCARModuleList>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCARModuleList>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
