package Bencher::Scenario::DataSah::Coerce;

our $DATE = '2016-05-20'; # DATE
our $VERSION = '0.06'; # VERSION

require Data::Sah::Coerce;
require DateTime;
require Time::Moment;

my $return_types = ['bool', 'str', 'full'];

our $scenario = {
    summary => 'Benchmark coercion',
    participants => [
        {
            name => 'gen_coercer',
            code_template => 'state $c = Data::Sah::Coerce::gen_coercer(type => <type>, coerce_to => <coerce_to>); $c->(<data>)',
        },
    ],
    datasets => [
        {
            name => 'date (coerce to float(epoch))',
            args => {
                type => 'date',
                coerce_to => 'float(epoch)',
                'data@' => [undef, "abc", 123, [], 1463373166, "2016-05-16"],
            },
        },
        # XXX date (coerce to DateTime)
        # XXX date (coerce to Time::Moment)
    ],
};

1;
# ABSTRACT: Benchmark coercion

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::Coerce - Benchmark coercion

=head1 VERSION

This document describes version 0.06 of Bencher::Scenario::DataSah::Coerce (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-05-20.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::Coerce

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_coercer (perl_code)

Code template:

 state $c = Data::Sah::Coerce::gen_coercer(type => <type>, coerce_to => <coerce_to>); $c->(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * date (coerce to float(epoch))

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSah::Coerce >>):

 [
    200,
    "OK",
    [
       {
          "arg_data" : "2016-05-16",
          "errors" : "2.6e-08",
          "rate" : "5.8e+04",
          "samples" : 21,
          "time" : "17",
          "vs_slowest" : "1"
       },
       {
          "arg_data" : 1463373166,
          "errors" : "3.3e-09",
          "rate" : "8.6e+05",
          "samples" : 20,
          "time" : "1.2",
          "vs_slowest" : "15"
       },
       {
          "arg_data" : [],
          "errors" : "2.1e-10",
          "rate" : "1.78e+06",
          "samples" : 20,
          "time" : "0.562",
          "vs_slowest" : "30.7"
       },
       {
          "arg_data" : "abc",
          "errors" : "2.2e-10",
          "rate" : "1.82e+06",
          "samples" : 20,
          "time" : "0.55",
          "vs_slowest" : "31.3"
       },
       {
          "arg_data" : 123,
          "errors" : "6.2e-10",
          "rate" : "1.8e+06",
          "samples" : 20,
          "time" : "0.54",
          "vs_slowest" : "32"
       },
       {
          "arg_data" : null,
          "errors" : "1e-10",
          "rate" : "4.05e+06",
          "samples" : 20,
          "time" : "0.247",
          "vs_slowest" : "69.7"
       }
    ],
    {
       "func.bencher_args" : {
          "action" : "bench",
          "note" : "Run by Pod::Weaver::Plugin::Bencher::Scenario",
          "scenario_module" : "DataSah::Coerce"
       },
       "func.bencher_version" : null,
       "func.cpu_info" : [
          {
             "L2_cache" : {
                "max_cache_size" : "6144 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "lahf_lm",
                "ida",
                "arat",
                "epb",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "42",
             "name" : "Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 4,
             "processor_id" : "0",
             "speed" : "3250.882",
             "stepping" : "7"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "6144 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "lahf_lm",
                "ida",
                "arat",
                "epb",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "42",
             "name" : "Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 4,
             "processor_id" : "1",
             "speed" : "3244.222",
             "stepping" : "7"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "6144 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "lahf_lm",
                "ida",
                "arat",
                "epb",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "42",
             "name" : "Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 4,
             "processor_id" : "2",
             "speed" : "3231.628",
             "stepping" : "7"
          },
          {
             "L2_cache" : {
                "max_cache_size" : "6144 KB"
             },
             "address_width" : "64",
             "architecture" : "AMD-64",
             "bus_speed" : null,
             "data_width" : "64",
             "family" : "6",
             "flags" : [
                "fpu",
                "vme",
                "de",
                "pse",
                "tsc",
                "msr",
                "pae",
                "mce",
                "cx8",
                "apic",
                "sep",
                "mtrr",
                "pge",
                "mca",
                "cmov",
                "pat",
                "pse36",
                "clflush",
                "dts",
                "acpi",
                "mmx",
                "fxsr",
                "sse",
                "sse2",
                "ss",
                "ht",
                "tm",
                "pbe",
                "syscall",
                "nx",
                "rdtscp",
                "lm",
                "constant_tsc",
                "arch_perfmon",
                "pebs",
                "bts",
                "rep_good",
                "nopl",
                "xtopology",
                "nonstop_tsc",
                "aperfmperf",
                "eagerfpu",
                "pni",
                "pclmulqdq",
                "dtes64",
                "monitor",
                "ds_cpl",
                "vmx",
                "smx",
                "est",
                "tm2",
                "ssse3",
                "cx16",
                "xtpr",
                "pdcm",
                "pcid",
                "sse4_1",
                "sse4_2",
                "x2apic",
                "popcnt",
                "tsc_deadline_timer",
                "aes",
                "xsave",
                "avx",
                "lahf_lm",
                "ida",
                "arat",
                "epb",
                "xsaveopt",
                "pln",
                "pts",
                "dtherm",
                "tpr_shadow",
                "vnmi",
                "flexpriority",
                "ept",
                "vpid"
             ],
             "manufacturer" : "GenuineIntel",
             "model" : "42",
             "name" : "Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz",
             "number_of_cores" : "4",
             "number_of_logical_processors" : 4,
             "processor_id" : "3",
             "speed" : "3143.714",
             "stepping" : "7"
          }
       ],
       "func.elapsed_time" : 0.21452808380127,
       "func.module_startup" : null,
       "func.module_versions" : {
          "Bencher::Scenario::DataSah::Coerce" : null,
          "Benchmark::Dumb" : "0.10",
          "Devel::Platform::Info" : "0.15",
          "Sys::Info" : "0.78",
          "Sys::Load" : "0.2",
          "perl" : "v5.22.1"
       },
       "func.note" : "Run by Pod::Weaver::Plugin::Bencher::Scenario",
       "func.platform_info" : {
          "archname" : "x86_64",
          "codename" : "jessie",
          "is32bit" : 0,
          "is64bit" : 1,
          "kernel" : "linux-3.16.0-4-amd64",
          "kname" : "Linux",
          "kvers" : "3.16.0-4-amd64",
          "osflag" : "linux",
          "oslabel" : "Debian",
          "osname" : "GNU/Linux",
          "osvers" : "8.0",
          "source" : {
             "cat /etc/.issue" : "",
             "cat /etc/issue" : "Debian GNU/Linux 8 \\n \\l",
             "lsb_release -a" : "Distributor ID:\tDebian\nDescription:\tDebian GNU/Linux 8.0 (jessie)\nRelease:\t8.0\nCodename:\tjessie",
             "uname -a" : "Linux builder 3.16.0-4-amd64 #1 SMP Debian 3.16.7-ckt7-1 (2015-03-01) x86_64 GNU/Linux",
             "uname -m" : "x86_64",
             "uname -o" : "GNU/Linux",
             "uname -r" : "3.16.0-4-amd64",
             "uname -s" : "Linux"
          }
       },
       "func.precision" : 0,
       "func.scenario_module" : "Bencher::Scenario::DataSah::Coerce",
       "func.sysload_after" : [
          1.69,
          1.15,
          0.92
       ],
       "func.sysload_before" : [
          1.69,
          1.15,
          0.92
       ],
       "func.time_end" : 1463736596.40126,
       "func.time_start" : 1463736596.18673,
       "table.field_units" : [
          null,
          null,
          null,
          null,
          "/s",
          "μs"
       ],
       "table.fields" : [
          "participant",
          "dataset",
          "arg_data",
          "perl",
          "rate",
          "time",
          "vs_slowest",
          "errors",
          "samples"
       ]
    }
 ]

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
