package Bencher::Scenario::DataSah::gen_validator;

our $DATE = '2016-05-16'; # DATE
our $VERSION = '0.05'; # VERSION

my $return_types = ['bool', 'str', 'full'];

our $scenario = {
    summary => 'Benchmark validator generation',
    participants => [
        {
            name => 'gen_validator',
            fcall_template => 'Data::Sah::gen_validator(<schema>, {return_type=> <return_type>})',
        },
    ],
    datasets => [
        {args => {'return_type@' => $return_types, schema => 'str'}},
        {args => {'return_type@' => $return_types, schema => 'str*'}},
        {args => {'return_type@' => $return_types, schema => ['str', len=>8]}},
        {args => {'return_type@' => $return_types, schema => ['str', min_len=>1, max_len=>10]}},
        {args => {'return_type@' => $return_types, schema => 'date'}},
        {args => {'return_type@' => $return_types, schema => ['array', of=>['str', min_len=>1, max_len=>10]]}},
        {args => {'return_type@' => $return_types, schema => ['array', elems=>['int*', 'str*', 'float*', 're*']]}},
    ],
};

1;
# ABSTRACT: Benchmark validator generation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::gen_validator - Benchmark validator generation

=head1 VERSION

This document describes version 0.05 of Bencher::Scenario::DataSah::gen_validator (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-05-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::gen_validator

To run module startup overhead benchmark:

 % bencher --module-startup -m DataSah::gen_validator

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::Sah> 0.76

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_validator (perl_code)

Function call template:

 Data::Sah::gen_validator(<schema>, {return_type=> <return_type>})



=back

=head1 BENCHMARK DATASETS

=over

=item * str

=item * str*

=item * ["str","len",8]

=item * ["str","min_len",1,"max_len",10]

=item * date

=item * ["array","of",["str","min_len",1,"max_len",10]]

=item * ["array","elems",["int*","str*","float*","re*"]]

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSah::gen_validator >>):

 +--------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+
 | dataset                                          | arg_return_type | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +--------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+
 | ["array","elems",["int*","str*","float*","re*"]] | full            | 307       | 3.25      | 1          | 1.1e-06 | 20      |
 | ["array","elems",["int*","str*","float*","re*"]] | str             | 314       | 3.19      | 1.02       | 6.4e-07 | 20      |
 | ["array","elems",["int*","str*","float*","re*"]] | bool            | 347       | 2.88      | 1.13       | 9.6e-07 | 20      |
 | ["array","of",["str","min_len",1,"max_len",10]]  | full            | 593       | 1.69      | 1.93       | 9.1e-07 | 20      |
 | ["array","of",["str","min_len",1,"max_len",10]]  | str             | 604       | 1.65      | 1.97       | 8.8e-07 | 21      |
 | ["array","of",["str","min_len",1,"max_len",10]]  | bool            | 669       | 1.5       | 2.18       | 1.2e-06 | 20      |
 | ["str","min_len",1,"max_len",10]                 | full            | 1.04e+03  | 0.965     | 3.37       | 8.5e-07 | 20      |
 | ["str","min_len",1,"max_len",10]                 | str             | 1.06e+03  | 0.947     | 3.44       | 4.8e-07 | 20      |
 | ["str","min_len",1,"max_len",10]                 | bool            | 1.17e+03  | 0.858     | 3.79       | 6.4e-07 | 20      |
 | ["str","len",8]                                  | full            | 1.24e+03  | 0.809     | 4.02       | 2.1e-07 | 20      |
 | ["str","len",8]                                  | str             | 1.25e+03  | 0.797     | 4.08       | 6.4e-07 | 20      |
 | date                                             | full            | 1.31e+03  | 0.766     | 4.25       | 6.4e-07 | 20      |
 | date                                             | str             | 1.33e+03  | 0.754     | 4.32       | 4.3e-07 | 20      |
 | ["str","len",8]                                  | bool            | 1.38e+03  | 0.722     | 4.51       | 4.8e-07 | 20      |
 | date                                             | bool            | 1.42e+03  | 0.706     | 4.61       | 2.1e-07 | 20      |
 | str*                                             | full            | 1.43e+03  | 0.701     | 4.65       | 4.3e-07 | 20      |
 | str*                                             | str             | 1.46e+03  | 0.686     | 4.75       | 4.3e-07 | 20      |
 | str*                                             | bool            | 1.62e+03  | 0.619     | 5.26       | 2.1e-07 | 20      |
 | str                                              | full            | 1.62e+03  | 0.617     | 5.27       | 4.3e-07 | 20      |
 | str                                              | str             | 1.65e+03  | 0.605     | 5.38       | 4.2e-07 | 21      |
 | str                                              | bool            | 1.8e+03   | 0.56      | 5.9        | 6.2e-07 | 21      |
 +--------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DataSah::gen_validator --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Data::Sah           | 7.1       | 4.5                    | 1          | 1.7e-05 | 20      |
 | perl -e1 (baseline) | 2.6       | 0                      | 2.7        | 5.2e-06 | 20      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
