package Bencher::Scenario::DataSah::gen_validator;

our $DATE = '2016-05-15'; # DATE
our $VERSION = '0.04'; # VERSION

my $return_types = ['bool', 'str', 'full'];

our $scenario = {
    summary => 'Benchmark validator generation',
    participants => [
        {
            name => 'gen_validator',
            fcall_template => 'Data::Sah::gen_validator(<schema>, {return_type=> <return_type>})',
        },
    ],
    datasets => [
        {args => {'return_type@' => $return_types, schema => 'str'}},
        {args => {'return_type@' => $return_types, schema => 'str*'}},
        {args => {'return_type@' => $return_types, schema => ['str', len=>8]}},
        {args => {'return_type@' => $return_types, schema => ['str', min_len=>1, max_len=>10]}},
        {args => {'return_type@' => $return_types, schema => 'date'}},
        {args => {'return_type@' => $return_types, schema => ['array', of=>['str', min_len=>1, max_len=>10]]}},
        {args => {'return_type@' => $return_types, schema => ['array', elems=>['int*', 'str*', 'float*', 're*']]}},
    ],
};

1;
# ABSTRACT: Benchmark validator generation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::gen_validator - Benchmark validator generation

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::DataSah::gen_validator (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-05-15.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::gen_validator

To run module startup overhead benchmark:

 % bencher --module-startup -m DataSah::gen_validator

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::Sah> 0.76

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_validator (perl_code)

Function call template:

 Data::Sah::gen_validator(<schema>, {return_type=> <return_type>})



=back

=head1 BENCHMARK DATASETS

=over

=item * str

=item * str*

=item * ["str","len",8]

=item * ["str","min_len",1,"max_len",10]

=item * date

=item * ["array","of",["str","min_len",1,"max_len",10]]

=item * ["array","elems",["int*","str*","float*","re*"]]

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSah::gen_validator >>):

 +--------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+
 | dataset                                          | arg_return_type | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +--------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+
 | ["array","elems",["int*","str*","float*","re*"]] | str             | 3.1e+02   | 3.2       | 1          | 9.6e-06 | 20      |
 | ["array","elems",["int*","str*","float*","re*"]] | full            | 3.1e+02   | 3.2       | 1          | 3.4e-06 | 20      |
 | ["array","elems",["int*","str*","float*","re*"]] | bool            | 3.4e+02   | 2.9       | 1.1        | 1.3e-05 | 21      |
 | ["array","of",["str","min_len",1,"max_len",10]]  | full            | 593       | 1.69      | 1.91       | 1.7e-06 | 20      |
 | ["array","of",["str","min_len",1,"max_len",10]]  | str             | 6.1e+02   | 1.6       | 2          | 3.1e-06 | 20      |
 | ["array","of",["str","min_len",1,"max_len",10]]  | bool            | 6.7e+02   | 1.5       | 2.2        | 4.2e-06 | 20      |
 | ["str","min_len",1,"max_len",10]                 | str             | 1e+03     | 0.96      | 3.4        | 2e-06   | 20      |
 | ["str","min_len",1,"max_len",10]                 | full            | 1.06e+03  | 0.945     | 3.41       | 4.3e-07 | 20      |
 | ["str","min_len",1,"max_len",10]                 | bool            | 1.1e+03   | 0.88      | 3.7        | 2.5e-06 | 20      |
 | ["str","len",8]                                  | full            | 1.2e+03   | 0.83      | 3.9        | 1.1e-06 | 22      |
 | ["str","len",8]                                  | str             | 1.25e+03  | 0.801     | 4.03       | 4.3e-07 | 20      |
 | date                                             | full            | 1.3e+03   | 0.77      | 4.2        | 9.1e-07 | 20      |
 | date                                             | str             | 1.36e+03  | 0.737     | 4.38       | 4.3e-07 | 20      |
 | ["str","len",8]                                  | bool            | 1.37e+03  | 0.731     | 4.41       | 6.4e-07 | 20      |
 | date                                             | bool            | 1.4e+03   | 0.71      | 4.5        | 2e-06   | 20      |
 | str*                                             | str             | 1.4e+03   | 0.7       | 4.6        | 4e-06   | 20      |
 | str*                                             | full            | 1.45e+03  | 0.688     | 4.69       | 2.1e-07 | 20      |
 | str*                                             | bool            | 1.6e+03   | 0.61      | 5.3        | 8.5e-07 | 20      |
 | str                                              | str             | 1.64e+03  | 0.61      | 5.29       | 4.3e-07 | 20      |
 | str                                              | full            | 1.66e+03  | 0.604     | 5.34       | 4.3e-07 | 20      |
 | str                                              | bool            | 1.7e+03   | 0.59      | 5.5        | 2.7e-06 | 20      |
 +--------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DataSah::gen_validator --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Data::Sah           | 7.1       | 4.6                    | 1          | 2e-05   | 20      |
 | perl -e1 (baseline) | 2.5       | 0                      | 2.9        | 9.8e-06 | 21      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
