package Bencher::Scenario::DataCSel::Selection;

our $DATE = '2016-04-01'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

use Bencher::ScenarioUtil::DataCSel;
use PERLANCAR::Tree::Examples qw(gen_sample_tree);

my @exprs = (
    'Sub4',
    'Sub4:first-child',
);

my @datasets = do {
    my @res = @Bencher::ScenarioUtil::DataCSel::datasets;
    for (@res) {
        $_->{args}{'expr@'} = \@exprs;
    }
    @res;
};

our $scenario = {
    summary => 'Benchmark selector',
    description => <<'_',

Sample documents from `PERLANCAR::HTML::Tree::Examples` are used.

_
    before_gen_items => sub {
        # prepare trees
        %main::trees = ();
        for (@Bencher::ScenarioUtil::DataCSel::datasets) {
            $_->{name} =~ /(.+)-(.+)/ or die;
            $main::trees{$_->{name}} = gen_sample_tree(size=>$1, backend=>$2);
        }
    },
    modules => {
        'Data::CSel' => {version=>0.04},
    },
    participants => [
        {
            module => 'Data::CSel',
            fcall_template => 'my @res = Data::CSel::csel({class_prefixes=>["Tree::Example::HashNode", "Tree::Example::ArrayNode"]}, <expr>, $main::trees{<tree>}); scalar @res',
        },
    ],
    datasets => \@datasets,
    extra_modules => \@Bencher::ScenarioUtil::DataCSel::extra_modules,
};

1;
# ABSTRACT: Benchmark selector

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataCSel::Selection - Benchmark selector

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::DataCSel::Selection (from Perl distribution Bencher-Scenarios-DataCSel), released on 2016-04-01.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataCSel::Selection

To run module startup overhead benchmark:

 % bencher --module-startup -m DataCSel::Selection

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::CSel> 0.04

=head1 BENCHMARK PARTICIPANTS

=over

=item * Data::CSel (perl_code)

Function call template:

 my @res = Data::CSel::csel({class_prefixes=>["Tree::Example::HashNode", "Tree::Example::ArrayNode"]}, <expr>, $main::trees{<tree>}); scalar @res



=back

=head1 BENCHMARK DATASETS

=over

=item * small1-hash

16 elements, 4 levels (hash-based nodes)

=item * small1-array

16 elements, 4 levels (array-based nodes)

=item * medium1-hash

20k elements, 7 levels (hash-based nodes)

=item * medium1-array

20k elements, 7 levels (array-based nodes)

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2557M CPU @ 1.70GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17 >>, OS kernel: I<< Linux version 3.13.0-32-generic >>.

Benchmark with default options (C<< bencher -m DataCSel::Selection >>):

 +---------------+------------------+-----------+-----------+------------+---------+---------+
 | dataset       | arg_expr         | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +---------------+------------------+-----------+-----------+------------+---------+---------+
 | medium1-array | Sub4:first-child | 8.54      | 117       | 1          | 2.7e-05 | 20      |
 | medium1-hash  | Sub4:first-child | 9.62      | 104       | 1.13       | 2.6e-05 | 22      |
 | medium1-array | Sub4             | 10.9      | 91.9      | 1.27       | 1.7e-05 | 20      |
 | medium1-hash  | Sub4             | 12        | 83        | 1.41       | 2.6e-05 | 21      |
 | small1-array  | Sub4:first-child | 8094.47   | 0.123541  | 947.929    | 2.1e-11 | 20      |
 | small1-hash   | Sub4:first-child | 9.1e+03   | 0.11      | 1.1e+03    | 1.5e-07 | 23      |
 | small1-array  | Sub4             | 9.8e+03   | 0.1       | 1.2e+03    | 2.1e-07 | 20      |
 | small1-hash   | Sub4             | 1.1e+04   | 0.088     | 1.3e+03    | 1.1e-07 | 20      |
 +---------------+------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DataCSel::Selection --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Data::CSel          | 3e+01     | 20                     | 1          | 0.0012  | 21      |
 | perl -e1 (baseline) | 1e+01     | 0                      | 2          | 0.00024 | 20      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Sample documents from C<PERLANCAR::HTML::Tree::Examples> are used.


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataCSel>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DataCSel>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataCSel>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
