package Bencher::Scenario::SortBySpec;

our $DATE = '2016-06-26'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Sort::BySpec (e.g. against Sort::ByExample, etc)',
    participants => [
        {
            name => 'gen_sorter-sbe',
            tags => ['gen_sorter', 'sbe'],
            module => 'Sort::ByExample',
            code_template => 'Sort::ByExample::sbe(<spec>)',
        },
        {
            name => 'gen_sorter-sbs',
            tags => ['gen_sorter', 'sbs'],
            module => 'Sort::BySpec',
            code_template => 'Sort::BySpec::sort_by_spec(spec => <spec>)',
        },

        {
            name => 'sort-sbe',
            tags => ['sort', 'sbe'],
            module => 'Sort::ByExample',
            code_template => 'state $sorter = Sort::ByExample::sbe(<spec>); [$sorter->(@{<list>})]',
        },
        {
            name => 'sort-sbs',
            tags => ['sort', 'sbs'],
            module => 'Sort::BySpec',
            code_template => 'state $sorter = Sort::BySpec::sort_by_spec(spec => <spec>); [$sorter->(@{<list>})]',
        },
    ],

    datasets => [
        {
            name => 'eg-num5-list10',
            args => {
                spec => [5,4,3,2,1],
                # currently unwieldy, need to use hash
                #'list@' => [
                #    [1..10],  # 10-elem
                #    [1..100], # 100-elem
                #],
                'list' => [1..10],
            },
        },
        {
            name => 'eg-num5-list100',
            args => {
                spec => [5,4,3,2,1],
                'list' => [1..100],
            },
        },
        {
            name => 'eg-num5-list1000',
            args => {
                spec => [5,4,3,2,1],
                'list' => [1..1000],
            },
        },
    ],
};

1;
# ABSTRACT: Benchmark Sort::BySpec (e.g. against Sort::ByExample, etc)

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::SortBySpec - Benchmark Sort::BySpec (e.g. against Sort::ByExample, etc)

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::SortBySpec (from Perl distribution Bencher-Scenario-SortBySpec), released on 2016-06-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m SortBySpec

To run module startup overhead benchmark:

 % bencher --module-startup -m SortBySpec

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Sort::ByExample> 0.007

L<Sort::BySpec> 0.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_sorter-sbe (perl_code) [gen_sorter, sbe]

Code template:

 Sort::ByExample::sbe(<spec>)



=item * gen_sorter-sbs (perl_code) [gen_sorter, sbs]

Code template:

 Sort::BySpec::sort_by_spec(spec => <spec>)



=item * sort-sbe (perl_code) [sort, sbe]

Code template:

 state $sorter = Sort::ByExample::sbe(<spec>); [$sorter->(@{<list>})]



=item * sort-sbs (perl_code) [sort, sbs]

Code template:

 state $sorter = Sort::BySpec::sort_by_spec(spec => <spec>); [$sorter->(@{<list>})]



=back

=head1 BENCHMARK DATASETS

=over

=item * eg-num5-list10

=item * eg-num5-list100

=item * eg-num5-list1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m SortBySpec >>):

 +----------------+------------------+-----------+------------+------------+---------+---------+
 | participant    | dataset          | rate (/s) |  time (ms) | vs_slowest |  errors | samples |
 +----------------+------------------+-----------+------------+------------+---------+---------+
 | sort-sbs       | eg-num5-list1000 |     302   | 3.32       |      1     | 4.8e-07 |      20 |
 | sort-sbe       | eg-num5-list1000 |    2900   | 0.344      |      9.63  | 5.3e-08 |      20 |
 | sort-sbs       | eg-num5-list100  |    3110   | 0.322      |     10.3   | 1.6e-07 |      21 |
 | sort-sbe       | eg-num5-list100  |   27600   | 0.0363     |     91.4   | 9.7e-09 |      38 |
 | sort-sbs       | eg-num5-list10   |   41930.8 | 0.0238488  |    139.048 |   0     |      21 |
 | sort-sbe       | eg-num5-list10   |  140000   | 0.0074     |    450     | 1.3e-08 |      20 |
 | gen_sorter-sbe | eg-num5-list1000 |  249859   | 0.00400225 |    828.567 |   0     |      22 |
 | gen_sorter-sbe | eg-num5-list100  |  249900   | 0.004002   |    828.7   | 8.7e-11 |      21 |
 | gen_sorter-sbe | eg-num5-list10   |  250000   | 0.004      |    830     | 5.5e-09 |      29 |
 | gen_sorter-sbs | eg-num5-list100  |  252185   | 0.00396534 |    836.28  |   0     |      20 |
 | gen_sorter-sbs | eg-num5-list1000 |  253000   | 0.00396    |    837     | 1.3e-09 |      32 |
 | gen_sorter-sbs | eg-num5-list10   |  250000   | 0.004      |    840     | 5.7e-09 |      27 |
 +----------------+------------------+-----------+------------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m SortBySpec --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Sort::ByExample     |      14   |                   11.5 |        1   | 5.3e-05 |      22 |
 | Sort::BySpec        |       5   |                    2.5 |        2.7 | 2.8e-05 |      20 |
 | perl -e1 (baseline) |       2.5 |                    0   |        5.5 | 4.5e-06 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-SortBySpec>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-SortBySpec>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-SortBySpec>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
